/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.interceptor;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.AfterBegin;
import javax.ejb.AfterCompletion;
import javax.ejb.BeforeCompletion;
import javax.ejb.PostActivate;
import javax.ejb.PrePassivate;
import javax.interceptor.AroundInvoke;
import javax.interceptor.AroundTimeout;
import org.apache.openejb.core.Operation;
import org.apache.openejb.util.SetAccessible;
import org.apache.xbean.finder.ClassFinder;

public class InterceptorData {
    private Class clazz;
    private final Set<Method> aroundInvoke = new LinkedHashSet<Method>();
    private final Set<Method> postConstruct = new LinkedHashSet<Method>();
    private final Set<Method> preDestroy = new LinkedHashSet<Method>();
    private final Set<Method> postActivate = new LinkedHashSet<Method>();
    private final Set<Method> prePassivate = new LinkedHashSet<Method>();
    private final Set<Method> afterBegin = new LinkedHashSet<Method>();
    private final Set<Method> beforeCompletion = new LinkedHashSet<Method>();
    private final Set<Method> afterCompletion = new LinkedHashSet<Method>();
    private final Set<Method> aroundTimeout = new LinkedHashSet<Method>();

    public InterceptorData(Class clazz) {
        this.clazz = clazz;
    }

    public Class getInterceptorClass() {
        return this.clazz;
    }

    public Set<Method> getAroundInvoke() {
        return this.aroundInvoke;
    }

    public Set<Method> getPostConstruct() {
        return this.postConstruct;
    }

    public Set<Method> getPreDestroy() {
        return this.preDestroy;
    }

    public Set<Method> getPostActivate() {
        return this.postActivate;
    }

    public Set<Method> getPrePassivate() {
        return this.prePassivate;
    }

    public Set<Method> getAfterBegin() {
        return this.afterBegin;
    }

    public Set<Method> getBeforeCompletion() {
        return this.beforeCompletion;
    }

    public Set<Method> getAfterCompletion() {
        return this.afterCompletion;
    }

    public Set<Method> getAroundTimeout() {
        return this.aroundTimeout;
    }

    public Set<Method> getMethods(Operation operation) {
        switch (operation) {
            case BUSINESS: {
                return this.getAroundInvoke();
            }
            case BUSINESS_WS: {
                return this.getAroundInvoke();
            }
            case REMOVE: {
                return this.getAroundInvoke();
            }
            case POST_CONSTRUCT: {
                return this.getPostConstruct();
            }
            case PRE_DESTROY: {
                return this.getPreDestroy();
            }
            case ACTIVATE: {
                return this.getPostActivate();
            }
            case PASSIVATE: {
                return this.getPrePassivate();
            }
            case AFTER_BEGIN: {
                return this.getAfterBegin();
            }
            case AFTER_COMPLETION: {
                return this.getAfterCompletion();
            }
            case BEFORE_COMPLETION: {
                return this.getBeforeCompletion();
            }
            case TIMEOUT: {
                return this.getAroundTimeout();
            }
        }
        return Collections.EMPTY_SET;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InterceptorData that = (InterceptorData)o;
        return !(this.clazz != null ? !this.clazz.equals(that.clazz) : that.clazz != null);
    }

    public int hashCode() {
        return this.clazz != null ? this.clazz.hashCode() : 0;
    }

    public static InterceptorData scan(Class<?> clazz) {
        ClassFinder finder = new ClassFinder(clazz);
        InterceptorData data = new InterceptorData(clazz);
        InterceptorData.add(finder, data.aroundInvoke, AroundInvoke.class);
        InterceptorData.add(finder, data.postConstruct, PostConstruct.class);
        InterceptorData.add(finder, data.preDestroy, PreDestroy.class);
        InterceptorData.add(finder, data.postActivate, PostActivate.class);
        InterceptorData.add(finder, data.prePassivate, PrePassivate.class);
        InterceptorData.add(finder, data.afterBegin, AfterBegin.class);
        InterceptorData.add(finder, data.beforeCompletion, BeforeCompletion.class);
        InterceptorData.add(finder, data.afterCompletion, AfterCompletion.class);
        InterceptorData.add(finder, data.aroundTimeout, AroundTimeout.class);
        return data;
    }

    private static void add(ClassFinder finder, Set<Method> methods, Class<? extends Annotation> annotation) {
        List<Method> annotatedMethods = finder.findAnnotatedMethods(annotation);
        for (Method method : annotatedMethods) {
            SetAccessible.on(method);
            methods.add(method);
        }
    }

    public String toString() {
        return "InterceptorData{clazz=" + this.clazz.getSimpleName() + '}';
    }
}

