/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.openejb.util.PropertyPlaceHolderHelper;

public final class SimpleJSonParser {
    public static Object read(InputStream is) throws IOException {
        int read;
        HashMap<String, Object> json = null;
        ArrayList<Object> array = null;
        while ((read = is.read()) != -1) {
            String value;
            StringBuilder b;
            char current = (char)read;
            if (current == '{') {
                json = new HashMap<String, Object>();
                continue;
            }
            if (current == '}') {
                return json;
            }
            if (current == '[') {
                array = new ArrayList<Object>();
                continue;
            }
            if (current == ']') {
                return array;
            }
            if (current == '\"') {
                b = new StringBuilder();
                do {
                    read = is.read();
                    current = (char)read;
                    b.append(current);
                } while (current != '\uffffffff' && current != '\"');
                if (current == '\uffffffff') {
                    throw new IllegalArgumentException("String should be between \"");
                }
                value = PropertyPlaceHolderHelper.simpleValue(b.substring(0, b.length() - 1));
                if (!SimpleJSonParser.valueRead(is, json, array, value)) continue;
                return value;
            }
            if (current == ':' || current == '=' || current == ',' || SimpleJSonParser.isWhiteSpace(current)) continue;
            b = new StringBuilder().append(current);
            do {
                read = is.read();
                current = (char)read;
                b.append(current);
            } while (current != '\uffffffff' && !SimpleJSonParser.isWhiteSpace(current) && current != ',');
            value = PropertyPlaceHolderHelper.simpleValue(b.substring(0, b.length() - 1));
            if (!SimpleJSonParser.valueRead(is, json, array, value)) continue;
            return value;
        }
        throw new IllegalArgumentException("Please check input, a } is probably missing");
    }

    private static boolean valueRead(InputStream is, Map<String, Object> json, Collection<Object> array, String value) throws IOException {
        int read;
        char c;
        while ((c = (char)(read = is.read())) != '\uffffffff' && c != ':' && c != '=' && (c == ',' || c == '\n' || c == '\r')) {
        }
        if (json != null) {
            json.put(value, SimpleJSonParser.read(is));
        } else if (array != null) {
            array.add(value);
        } else {
            return true;
        }
        return false;
    }

    private static boolean isWhiteSpace(char current) {
        return current == ' ' || current == '\n' || current == '\r' || current == '\t';
    }

    private SimpleJSonParser() {
    }
}

