/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.entity;

import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import javax.ejb.EJBContext;
import javax.ejb.EntityBean;
import javax.ejb.NoSuchEntityException;
import org.apache.openejb.ApplicationException;
import org.apache.openejb.BeanContext;
import org.apache.openejb.InvalidateReferenceException;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.SystemException;
import org.apache.openejb.core.NoSuchObjectException;
import org.apache.openejb.core.Operation;
import org.apache.openejb.core.ThreadContext;
import org.apache.openejb.core.entity.EntityContainer;
import org.apache.openejb.core.entity.EntityContext;
import org.apache.openejb.core.transaction.TransactionPolicy;
import org.apache.openejb.core.transaction.TransactionRolledbackException;
import org.apache.openejb.spi.SecurityService;
import org.apache.openejb.util.LinkedListStack;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.Stack;

public class EntityInstanceManager {
    private static final Logger logger = Logger.getInstance(LogCategory.OPENEJB, "org.apache.openejb.util.resources");
    private int poolsize;
    private Map<Object, LinkedListStack> poolMap;
    private SecurityService securityService;

    public EntityInstanceManager(EntityContainer container, SecurityService securityService, int poolSize) {
        BeanContext[] beanContexts;
        this.securityService = securityService;
        this.poolsize = poolSize;
        this.poolMap = new HashMap<Object, LinkedListStack>();
        for (BeanContext beanContext : beanContexts = container.getBeanContexts()) {
            this.deploy(beanContext);
        }
    }

    public void deploy(BeanContext beanContext) {
        this.poolMap.put(beanContext.getDeploymentID(), new LinkedListStack(this.poolsize / 2));
        beanContext.set(EJBContext.class, this.createEntityContext());
    }

    public void undeploy(BeanContext beanContext) {
        this.poolMap.remove(beanContext.getDeploymentID());
    }

    public EntityBean obtainInstance(ThreadContext callContext) throws OpenEJBException {
        Object primaryKey = callContext.getPrimaryKey();
        TransactionPolicy txPolicy = callContext.getTransactionPolicy();
        if (callContext.getPrimaryKey() != null && txPolicy != null && txPolicy.isTransactionActive()) {
            Key key = new Key(callContext.getBeanContext().getDeploymentID(), primaryKey);
            SynchronizationWrapper wrapper = (SynchronizationWrapper)txPolicy.getResource(key);
            if (wrapper != null) {
                if (!wrapper.isAssociated()) {
                    throw new InvalidateReferenceException(new NoSuchObjectException("Entity not found: " + primaryKey));
                }
                if (callContext.getCurrentOperation() == Operation.REMOVE) {
                    wrapper.disassociate();
                }
                if (wrapper.isAvailable() || wrapper.primaryKey.equals(primaryKey)) {
                    return wrapper.getEntityBean();
                }
                return wrapper.getEntityBean();
            }
            EntityBean bean = this.getPooledInstance(callContext);
            wrapper = new SynchronizationWrapper(callContext.getBeanContext(), primaryKey, bean, false, key, txPolicy);
            if (callContext.getCurrentOperation() == Operation.REMOVE) {
                wrapper.disassociate();
            }
            txPolicy.registerSynchronization(wrapper);
            this.loadingBean(bean, callContext);
            Operation orginalOperation = callContext.getCurrentOperation();
            callContext.setCurrentOperation(Operation.LOAD);
            try {
                bean.ejbLoad();
            }
            catch (NoSuchEntityException e) {
                wrapper.disassociate();
                throw new InvalidateReferenceException(new NoSuchObjectException("Entity not found: " + primaryKey, e));
            }
            catch (Exception e) {
                logger.error("Exception encountered during ejbLoad():", e);
                wrapper.disassociate();
                throw new OpenEJBException(e);
            }
            finally {
                callContext.setCurrentOperation(orginalOperation);
            }
            txPolicy.putResource(key, wrapper);
            return bean;
        }
        return this.getPooledInstance(callContext);
    }

    protected void loadingBean(EntityBean bean, ThreadContext callContext) throws OpenEJBException {
    }

    protected void reusingBean(EntityBean bean, ThreadContext callContext) throws OpenEJBException {
    }

    protected EntityBean getPooledInstance(ThreadContext callContext) throws OpenEJBException {
        Operation currentOp;
        BeanContext beanContext = callContext.getBeanContext();
        Stack methodReadyPool = this.poolMap.get(beanContext.getDeploymentID());
        if (methodReadyPool == null) {
            throw new SystemException("Invalid deployment id " + beanContext.getDeploymentID() + " for this container");
        }
        EntityBean bean = (EntityBean)methodReadyPool.pop();
        if (bean == null) {
            try {
                bean = (EntityBean)beanContext.getBeanClass().newInstance();
            }
            catch (Exception e) {
                logger.error("Bean instantiation failed for class " + beanContext.getBeanClass(), e);
                throw new SystemException(e);
            }
            currentOp = callContext.getCurrentOperation();
            callContext.setCurrentOperation(Operation.SET_CONTEXT);
            try {
                bean.setEntityContext((javax.ejb.EntityContext)this.createEntityContext());
            }
            catch (Exception e) {
                logger.error("Bean callback method failed ", e);
                throw new ApplicationException(e);
            }
            finally {
                callContext.setCurrentOperation(currentOp);
            }
        }
        this.reusingBean(bean, callContext);
        if (callContext.getCurrentOperation() == Operation.BUSINESS || callContext.getCurrentOperation() == Operation.REMOVE) {
            currentOp = callContext.getCurrentOperation();
            callContext.setCurrentOperation(Operation.ACTIVATE);
            try {
                bean.ejbActivate();
            }
            catch (Throwable e) {
                logger.error("Encountered exception during call to ejbActivate()", e);
                TransactionPolicy txPolicy = callContext.getTransactionPolicy();
                if (txPolicy != null && txPolicy.isTransactionActive()) {
                    txPolicy.setRollbackOnly(e);
                    throw new ApplicationException((Exception)((Object)new TransactionRolledbackException("Reflection exception thrown while attempting to call ejbActivate() on the instance", e)));
                }
                throw new ApplicationException(new RemoteException("Exception thrown while attempting to call ejbActivate() on the instance. Exception message = " + e.getMessage(), e));
            }
            finally {
                callContext.setCurrentOperation(currentOp);
            }
        }
        return bean;
    }

    private EntityContext createEntityContext() {
        return new EntityContext(this.securityService);
    }

    public void poolInstance(ThreadContext callContext, EntityBean bean, Object primaryKey) throws OpenEJBException {
        if (bean == null) {
            return;
        }
        TransactionPolicy txPolicy = callContext.getTransactionPolicy();
        if (primaryKey != null && txPolicy != null && txPolicy.isTransactionActive()) {
            Key key = new Key(callContext.getBeanContext().getDeploymentID(), primaryKey);
            SynchronizationWrapper wrapper = (SynchronizationWrapper)txPolicy.getResource(key);
            if (wrapper != null) {
                if (callContext.getCurrentOperation() == Operation.REMOVE) {
                    wrapper.disassociate();
                    Stack methodReadyPool = this.poolMap.get(callContext.getBeanContext().getDeploymentID());
                    methodReadyPool.push(bean);
                } else {
                    if (callContext.getCurrentOperation() == Operation.CREATE) {
                        wrapper.associate();
                    }
                    wrapper.setEntityBean(bean);
                }
            } else {
                wrapper = new SynchronizationWrapper(callContext.getBeanContext(), primaryKey, bean, true, key, txPolicy);
                txPolicy.registerSynchronization(wrapper);
                txPolicy.putResource(key, wrapper);
            }
        } else {
            if (primaryKey != null && callContext.getCurrentOperation() != Operation.REMOVE) {
                Operation currentOp = callContext.getCurrentOperation();
                callContext.setCurrentOperation(Operation.PASSIVATE);
                try {
                    bean.ejbPassivate();
                }
                catch (Throwable e) {
                    if (txPolicy.isTransactionActive()) {
                        txPolicy.setRollbackOnly(e);
                        throw new ApplicationException((Exception)((Object)new TransactionRolledbackException("Reflection exception thrown while attempting to call ejbPassivate() on the instance", e)));
                    }
                    throw new ApplicationException(new RemoteException("Reflection exception thrown while attempting to call ejbPassivate() on the instance. Exception message = " + e.getMessage(), e));
                }
                finally {
                    callContext.setCurrentOperation(currentOp);
                }
            }
            Stack methodReadyPool = this.poolMap.get(callContext.getBeanContext().getDeploymentID());
            methodReadyPool.push(bean);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freeInstance(ThreadContext callContext, EntityBean bean) throws SystemException {
        this.discardInstance(callContext, bean);
        Operation currentOp = callContext.getCurrentOperation();
        callContext.setCurrentOperation(Operation.UNSET_CONTEXT);
        try {
            bean.unsetEntityContext();
        }
        catch (Exception e) {
            logger.info(this.getClass().getName() + ".freeInstance: ignoring exception " + e + " on bean instance " + bean);
        }
        finally {
            callContext.setCurrentOperation(currentOp);
        }
    }

    public void discardInstance(ThreadContext callContext, EntityBean bean) throws SystemException {
        Object primaryKey = callContext.getPrimaryKey();
        TransactionPolicy txPolicy = callContext.getTransactionPolicy();
        if (primaryKey == null || txPolicy == null || !txPolicy.isTransactionActive()) {
            return;
        }
        Key key = new Key(callContext.getBeanContext().getDeploymentID(), primaryKey);
        SynchronizationWrapper wrapper = (SynchronizationWrapper)txPolicy.getResource(key);
        if (wrapper != null) {
            wrapper.disassociate();
        }
    }

    protected class SynchronizationWrapper
    implements TransactionPolicy.TransactionSynchronization {
        private EntityBean bean;
        private boolean available;
        private boolean associated;
        private final Key readyPoolKey;
        private final BeanContext beanContext;
        private final Object primaryKey;
        private final TransactionPolicy txPolicy;

        public SynchronizationWrapper(BeanContext beanContext, Object primaryKey, EntityBean bean, boolean available, Key readyPoolKey, TransactionPolicy txPolicy) {
            if (bean == null) {
                throw new IllegalArgumentException("bean is null");
            }
            if (readyPoolKey == null) {
                throw new IllegalArgumentException("key is null");
            }
            if (beanContext == null) {
                throw new IllegalArgumentException("deploymentInfo is null");
            }
            if (primaryKey == null) {
                throw new IllegalArgumentException("primaryKey is null");
            }
            if (txPolicy == null) {
                throw new IllegalArgumentException("txEnv is null");
            }
            this.beanContext = beanContext;
            this.bean = bean;
            this.primaryKey = primaryKey;
            this.available = available;
            this.readyPoolKey = readyPoolKey;
            this.txPolicy = txPolicy;
            this.associated = true;
        }

        public void associate() {
            this.associated = true;
        }

        public void disassociate() {
            this.associated = false;
        }

        public boolean isAssociated() {
            return this.associated;
        }

        public synchronized boolean isAvailable() {
            return this.available;
        }

        public synchronized void setEntityBean(EntityBean ebean) {
            this.available = true;
            this.bean = ebean;
        }

        public synchronized EntityBean getEntityBean() {
            this.available = false;
            return this.bean;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void beforeCompletion() {
            if (this.associated) {
                EntityBean bean;
                SynchronizationWrapper synchronizationWrapper = this;
                synchronized (synchronizationWrapper) {
                    bean = this.bean;
                }
                ThreadContext callContext = new ThreadContext(this.beanContext, this.primaryKey);
                callContext.setCurrentOperation(Operation.STORE);
                ThreadContext oldCallContext = ThreadContext.enter(callContext);
                try {
                    bean.ejbStore();
                }
                catch (Exception re) {
                    logger.error("Exception occured during ejbStore()", re);
                    this.txPolicy.setRollbackOnly(re);
                }
                finally {
                    ThreadContext.exit(oldCallContext);
                }
            }
        }

        @Override
        public void afterCompletion(TransactionPolicy.TransactionSynchronization.Status status) {
            this.txPolicy.removeResource(this.readyPoolKey);
        }
    }

    private static class Key {
        private final Object deploymentId;
        private final Object primaryKey;

        public Key(Object deploymentId, Object primaryKey) {
            if (deploymentId == null) {
                throw new NullPointerException("deploymentId is null");
            }
            if (primaryKey == null) {
                throw new NullPointerException("primaryKey is null");
            }
            this.deploymentId = deploymentId;
            this.primaryKey = primaryKey;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return this.deploymentId.equals(key.deploymentId) && this.primaryKey.equals(key.primaryKey);
        }

        public int hashCode() {
            int result = this.deploymentId.hashCode();
            result = 31 * result + this.primaryKey.hashCode();
            return result;
        }
    }
}

