/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.el.ELResolver;
import javax.el.ExpressionFactory;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.ObserverMethod;
import org.apache.openejb.cdi.WebAppElResolver;
import org.apache.openejb.cdi.WebAppInjectionResolver;
import org.apache.openejb.cdi.WebappWebBeansContext;
import org.apache.openejb.util.reflection.Reflections;
import org.apache.webbeans.component.BuiltInOwbBean;
import org.apache.webbeans.component.ExtensionBean;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.context.creational.CreationalContextImpl;
import org.apache.webbeans.event.EventMetadata;
import org.apache.webbeans.util.ClassUtil;
import org.apache.webbeans.util.WebBeansUtil;

public class WebappBeanManager
extends BeanManagerImpl {
    private final WebappWebBeansContext webappCtx;
    private Set<Bean<?>> deploymentBeans;
    private boolean started;

    public WebappBeanManager(WebappWebBeansContext ctx) {
        super((WebBeansContext)ctx);
        this.webappCtx = ctx;
        this.deploymentBeans = super.getBeans();
        Reflections.set((Object)this, "injectionResolver", (Object)new WebAppInjectionResolver(ctx));
    }

    public void fireEvent(Object event, EventMetadata metadata, boolean isLifecycleEvent) {
        Class<?> eventClass = event.getClass();
        if (ClassUtil.isDefinitionContainsTypeVariables((Type)ClassUtil.getClass((Type)metadata.getType()))) {
            throw new IllegalArgumentException("Event class : " + event.getClass().getName() + " can not be defined as generic type");
        }
        this.getNotificationManager().fireEvent(event, metadata, isLifecycleEvent);
        if (WebappBeanManager.isEvent(eventClass)) {
            this.getParentBm().getNotificationManager().fireEvent(event, metadata, isLifecycleEvent);
        }
    }

    public <T> Set<ObserverMethod<? super T>> resolveObserverMethods(T event, EventMetadata metadata) {
        Class<?> eventClass = event.getClass();
        if (ClassUtil.isDefinitionContainsTypeVariables((Type)ClassUtil.getClass((Type)metadata.getType()))) {
            throw new IllegalArgumentException("Event type can not contain type variables. Event class is : " + eventClass);
        }
        HashSet<ObserverMethod<T>> set = new HashSet<ObserverMethod<T>>();
        set.addAll(this.getNotificationManager().resolveObservers(event, metadata));
        if (WebappBeanManager.isEvent(eventClass)) {
            set.addAll(this.getParentBm().getNotificationManager().resolveObservers(event, metadata));
        }
        return set;
    }

    public Object getInjectableReference(InjectionPoint injectionPoint, CreationalContext<?> ctx) {
        try {
            return super.getInjectableReference(injectionPoint, ctx);
        }
        catch (RuntimeException e) {
            return this.getParentBm().getInjectableReference(injectionPoint, ctx);
        }
    }

    public <T> CreationalContextImpl<T> createCreationalContext(Contextual<T> contextual) {
        try {
            return super.createCreationalContext(contextual);
        }
        catch (RuntimeException e) {
            try {
                return this.getParentBm().createCreationalContext(contextual);
            }
            catch (RuntimeException ignored) {
                throw e;
            }
        }
    }

    public boolean isNormalScope(Class<? extends Annotation> annotationType) {
        try {
            return super.isNormalScope(annotationType);
        }
        catch (RuntimeException e) {
            try {
                return this.getParentBm().isNormalScope(annotationType);
            }
            catch (RuntimeException ignored) {
                throw e;
            }
        }
    }

    public boolean isPassivatingScope(Class<? extends Annotation> annotationType) {
        try {
            return super.isPassivatingScope(annotationType);
        }
        catch (RuntimeException e) {
            try {
                return this.getParentBm().isPassivatingScope(annotationType);
            }
            catch (RuntimeException ignored) {
                throw e;
            }
        }
    }

    public boolean isQualifier(Class<? extends Annotation> annotationType) {
        try {
            return super.isQualifier(annotationType);
        }
        catch (RuntimeException e) {
            try {
                return this.getParentBm().isQualifier(annotationType);
            }
            catch (RuntimeException ignored) {
                throw e;
            }
        }
    }

    public boolean isInterceptorBinding(Class<? extends Annotation> annotationType) {
        try {
            return super.isInterceptorBinding(annotationType);
        }
        catch (RuntimeException e) {
            try {
                return this.getParentBm().isInterceptorBinding(annotationType);
            }
            catch (RuntimeException ignored) {
                throw e;
            }
        }
    }

    public boolean isStereotype(Class<? extends Annotation> annotationType) {
        try {
            return super.isStereotype(annotationType);
        }
        catch (RuntimeException e) {
            try {
                return this.getParentBm().isStereotype(annotationType);
            }
            catch (RuntimeException ignored) {
                throw e;
            }
        }
    }

    public Set<Annotation> getInterceptorBindingDefinition(Class<? extends Annotation> qualifier) {
        try {
            return super.getInterceptorBindingDefinition(qualifier);
        }
        catch (RuntimeException e) {
            try {
                return this.getParentBm().getInterceptorBindingDefinition(qualifier);
            }
            catch (RuntimeException ignored) {
                throw e;
            }
        }
    }

    public Context getContext(Class<? extends Annotation> scope) {
        try {
            return super.getContext(scope);
        }
        catch (RuntimeException e) {
            try {
                return this.getParentBm().getContext(scope);
            }
            catch (RuntimeException ignored) {
                throw e;
            }
        }
    }

    public ELResolver getELResolver() {
        return new WebAppElResolver(super.getELResolver(), this.getParentBm().getELResolver());
    }

    public <T> AnnotatedType<T> createAnnotatedType(Class<T> type) {
        try {
            return super.createAnnotatedType(type);
        }
        catch (RuntimeException e) {
            try {
                return this.getParentBm().createAnnotatedType(type);
            }
            catch (RuntimeException ignored) {
                throw e;
            }
        }
    }

    public <T> InjectionTarget<T> createInjectionTarget(AnnotatedType<T> type) {
        try {
            return super.createInjectionTarget(type);
        }
        catch (RuntimeException e) {
            try {
                return this.getParentBm().createInjectionTarget(type);
            }
            catch (RuntimeException ignored) {
                throw e;
            }
        }
    }

    public ExpressionFactory wrapExpressionFactory(ExpressionFactory expressionFactory) {
        return super.wrapExpressionFactory(expressionFactory);
    }

    public BeanManagerImpl getParentBm() {
        return this.webappCtx.getParent().getBeanManagerImpl();
    }

    public boolean isInUse() {
        return super.isInUse() || this.getParentBm().isInUse();
    }

    public Set<Bean<?>> getComponents() {
        if (!this.started) {
            return new IteratorSet(new MultipleIterator((Filter)InheritedBeanFilter.INSTANCE, new Iterator[]{this.deploymentBeans.iterator(), this.getParentBm().getComponents().iterator()}));
        }
        return this.deploymentBeans;
    }

    public Set<Bean<?>> getBeans() {
        return this.deploymentBeans;
    }

    public Bean<?> getPassivationCapableBean(String id) {
        Bean bean = super.getPassivationCapableBean(id);
        if (bean == null) {
            return this.getParentBm().getPassivationCapableBean(id);
        }
        return bean;
    }

    public void afterStart() {
        this.started = true;
        this.deploymentBeans = this.mergeBeans();
        this.webappCtx.getBeanManagerImpl().getInjectionResolver().clearCaches();
    }

    private Set<Bean<?>> mergeBeans() {
        CopyOnWriteArraySet allBeans = new CopyOnWriteArraySet();
        for (Bean bean : this.getParentBm().getBeans()) {
            if (!InheritedBeanFilter.INSTANCE.accept(bean)) continue;
            allBeans.add(bean);
        }
        allBeans.addAll(super.getBeans());
        return allBeans;
    }

    public void beforeStop() {
    }

    private static boolean isEvent(Class<?> eventClass) {
        return !WebBeansUtil.isDefaultExtensionBeanEventType(eventClass) && !WebBeansUtil.isExtensionEventType(eventClass);
    }

    private static final class IteratorSet<A>
    extends HashSet<A> {
        private final Iterator<A> it;

        private IteratorSet(Iterator<A> it) {
            this.it = it;
        }

        @Override
        public Iterator<A> iterator() {
            return this.it;
        }
    }

    private static final class MultipleIterator<A>
    implements Iterator<A> {
        private final Iterator<A>[] delegates;
        private final Filter<A> filter;
        private A next;
        private int idx;

        private MultipleIterator(Filter<A> filter, Iterator<A> ... delegates) {
            this.filter = filter;
            this.delegates = delegates;
        }

        @Override
        public boolean hasNext() {
            while (this.idx < this.delegates.length) {
                while (this.delegates[this.idx].hasNext()) {
                    this.next = this.delegates[this.idx].next();
                    if (this.idx != 0 && !this.filter.accept(this.next)) continue;
                    return true;
                }
                ++this.idx;
            }
            return false;
        }

        @Override
        public A next() {
            return this.next;
        }

        @Override
        public void remove() {
            this.delegates[this.idx].remove();
        }
    }

    private static final class InheritedBeanFilter
    implements Filter<Bean<?>> {
        private static final InheritedBeanFilter INSTANCE = new InheritedBeanFilter();

        private InheritedBeanFilter() {
        }

        @Override
        public boolean accept(Bean<?> bean) {
            return !BuiltInOwbBean.class.isInstance(bean) && !ExtensionBean.class.isInstance(bean);
        }
    }

    private static interface Filter<A> {
        public boolean accept(A var1);
    }
}

