/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.compiler;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.faces.FacesException;
import javax.faces.application.Resource;
import javax.faces.application.ResourceHandler;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.view.facelets.ComponentConfig;
import javax.faces.view.facelets.FaceletHandler;
import javax.faces.view.facelets.Tag;
import javax.faces.view.facelets.TagConfig;
import javax.faces.view.facelets.TagHandler;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.myfaces.config.ConfigFilesXmlValidationUtils;
import org.apache.myfaces.shared.config.MyfacesConfig;
import org.apache.myfaces.shared.util.ArrayUtils;
import org.apache.myfaces.shared.util.ClassUtils;
import org.apache.myfaces.shared.util.StringUtils;
import org.apache.myfaces.shared.util.WebConfigParamUtils;
import org.apache.myfaces.spi.FaceletConfigResourceProvider;
import org.apache.myfaces.spi.FaceletConfigResourceProviderFactory;
import org.apache.myfaces.view.facelets.compiler.Compiler;
import org.apache.myfaces.view.facelets.tag.AbstractTagLibrary;
import org.apache.myfaces.view.facelets.tag.TagLibrary;
import org.apache.myfaces.view.facelets.tag.composite.CompositeComponentResourceTagHandler;
import org.apache.myfaces.view.facelets.tag.composite.CompositeResouceWrapper;
import org.apache.myfaces.view.facelets.util.ParameterCheck;
import org.apache.myfaces.view.facelets.util.ReflectionUtil;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public final class TagLibraryConfig {
    protected static final Logger log = Logger.getLogger(TagLibraryConfig.class.getName());

    public static TagLibrary create(FacesContext facesContext, URL url) throws IOException {
        InputStream is = null;
        TagLibrary t = null;
        URLConnection conn = null;
        try {
            String version;
            ExternalContext externalContext = facesContext.getExternalContext();
            boolean schemaValidating = false;
            if (MyfacesConfig.getCurrentInstance(externalContext).isValidateXML() && (schemaValidating = "2.0".equals(version = ConfigFilesXmlValidationUtils.getFaceletTagLibVersion(url)))) {
                ConfigFilesXmlValidationUtils.validateFaceletTagLibFile(url, externalContext, version);
            }
            LibraryHandler handler = new LibraryHandler(facesContext, url);
            SAXParser parser = TagLibraryConfig.createSAXParser(handler, externalContext, schemaValidating);
            conn = url.openConnection();
            conn.setUseCaches(false);
            is = conn.getInputStream();
            parser.parse(is, (DefaultHandler)handler);
            t = handler.getLibrary();
        }
        catch (SAXException e) {
            IOException ioe = new IOException("Error parsing [" + url + "]: ");
            ioe.initCause(e);
            throw ioe;
        }
        catch (ParserConfigurationException e) {
            IOException ioe = new IOException("Error parsing [" + url + "]: ");
            ioe.initCause(e);
            throw ioe;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        return t;
    }

    public void loadImplicit(FacesContext facesContext, Compiler compiler) throws IOException {
        ExternalContext externalContext = facesContext.getExternalContext();
        FaceletConfigResourceProvider provider = FaceletConfigResourceProviderFactory.getFacesConfigResourceProviderFactory(externalContext).createFaceletConfigResourceProvider(externalContext);
        Collection<URL> urls = provider.getFaceletTagLibConfigurationResources(externalContext);
        for (URL url : urls) {
            try {
                TagLibrary tl = TagLibraryConfig.create(facesContext, url);
                if (tl != null) {
                    compiler.addTagLibrary(tl);
                }
                if (!log.isLoggable(Level.FINE)) continue;
                log.fine("Added Library from: " + url);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Error Loading Library: " + url, e);
            }
        }
    }

    private static final SAXParser createSAXParser(LibraryHandler handler, ExternalContext externalContext, boolean schemaValidating) throws SAXException, ParserConfigurationException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        if (MyfacesConfig.getCurrentInstance(externalContext).isValidateXML() && !schemaValidating) {
            factory.setNamespaceAware(false);
            factory.setFeature("http://xml.org/sax/features/validation", true);
            factory.setValidating(true);
        } else {
            factory.setNamespaceAware(true);
            factory.setFeature("http://xml.org/sax/features/validation", false);
            factory.setValidating(false);
        }
        SAXParser parser = factory.newSAXParser();
        XMLReader reader = parser.getXMLReader();
        reader.setErrorHandler(handler);
        reader.setEntityResolver(handler);
        return parser;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LibraryHandler
    extends DefaultHandler {
        private final URL source;
        private final FacesContext facesContext;
        private TagLibrary library;
        private final StringBuffer buffer;
        private Locator locator;
        private String tagName;
        private String converterId;
        private String validatorId;
        private String behaviorId;
        private String componentType;
        private String rendererType;
        private String functionName;
        private Class<? extends TagHandler> handlerClass;
        private Class<?> functionClass;
        private String functionSignature;
        private String compositeLibraryName;

        public LibraryHandler(FacesContext facesContext, URL source) {
            this.source = source;
            this.buffer = new StringBuffer(64);
            this.facesContext = facesContext;
        }

        public TagLibrary getLibrary() {
            return this.library;
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            try {
                if (!"facelet-taglib".equals(qName)) {
                    if ("library-class".equals(qName)) {
                        this.processLibraryClass();
                    } else if ("namespace".equals(qName)) {
                        this.library = new TagLibraryImpl(this.facesContext, this.captureBuffer());
                        if (this.compositeLibraryName != null) {
                            ((TagLibraryImpl)this.library).setCompositeLibrary(this.compositeLibraryName);
                        }
                    } else if ("composite-library-name".equals(qName)) {
                        this.compositeLibraryName = this.captureBuffer();
                        if (this.library != null) {
                            ((TagLibraryImpl)this.library).setCompositeLibrary(this.compositeLibraryName);
                        }
                    } else if ("component-type".equals(qName)) {
                        this.componentType = this.captureBuffer();
                    } else if ("renderer-type".equals(qName)) {
                        this.rendererType = this.captureBuffer();
                    } else if ("tag-name".equals(qName)) {
                        this.tagName = this.captureBuffer();
                    } else if ("function-name".equals(qName)) {
                        this.functionName = this.captureBuffer();
                    } else if ("function-class".equals(qName)) {
                        String className = this.captureBuffer();
                        this.functionClass = LibraryHandler.createClass(Object.class, className);
                    } else if (!("description".equals(qName) || "display-name".equals(qName) || "icon".equals(qName))) {
                        if (this.library == null) {
                            throw new IllegalStateException("No <namespace> element");
                        }
                        TagLibraryImpl impl = (TagLibraryImpl)this.library;
                        if ("tag".equals(qName)) {
                            if (this.handlerClass != null) {
                                impl.putTagHandler(this.tagName, this.handlerClass);
                            }
                        } else if ("handler-class".equals(qName)) {
                            String cName = this.captureBuffer();
                            this.handlerClass = LibraryHandler.createClass(TagHandler.class, cName);
                        } else if ("component".equals(qName)) {
                            if (this.handlerClass != null) {
                                impl.putComponent(this.tagName, this.componentType, this.rendererType, this.handlerClass);
                                this.handlerClass = null;
                            } else {
                                impl.putComponent(this.tagName, this.componentType, this.rendererType);
                            }
                        } else if ("converter-id".equals(qName)) {
                            this.converterId = this.captureBuffer();
                        } else if ("converter".equals(qName)) {
                            if (this.handlerClass != null) {
                                impl.putConverter(this.tagName, this.converterId, this.handlerClass);
                                this.handlerClass = null;
                            } else {
                                impl.putConverter(this.tagName, this.converterId);
                            }
                            this.converterId = null;
                        } else if ("validator-id".equals(qName)) {
                            this.validatorId = this.captureBuffer();
                        } else if ("validator".equals(qName)) {
                            if (this.handlerClass != null) {
                                impl.putValidator(this.tagName, this.validatorId, this.handlerClass);
                                this.handlerClass = null;
                            } else {
                                impl.putValidator(this.tagName, this.validatorId);
                            }
                            this.validatorId = null;
                        } else if ("behavior-id".equals(qName)) {
                            this.behaviorId = this.captureBuffer();
                        } else if ("behavior".equals(qName)) {
                            if (this.handlerClass != null) {
                                impl.putBehavior(this.tagName, this.behaviorId, this.handlerClass);
                                this.handlerClass = null;
                            } else {
                                impl.putBehavior(this.tagName, this.behaviorId);
                            }
                            this.behaviorId = null;
                        } else if ("source".equals(qName)) {
                            String path = this.captureBuffer();
                            URL url = new URL(this.source, path);
                            impl.putUserTag(this.tagName, url);
                        } else if ("function-signature".equals(qName)) {
                            this.functionSignature = this.captureBuffer();
                            Method m = LibraryHandler.createMethod(this.functionClass, this.functionSignature);
                            impl.putFunction(this.functionName, m);
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new SAXParseException("Error Handling [" + this.source + "@" + this.locator.getLineNumber() + "," + this.locator.getColumnNumber() + "] <" + qName + ">", this.locator, e);
            }
        }

        private String captureBuffer() throws Exception {
            String s = this.buffer.toString().trim();
            if (s.length() == 0) {
                throw new Exception("Value Cannot be Empty");
            }
            this.buffer.setLength(0);
            return s;
        }

        private static <T> Class<? extends T> createClass(Class<T> type, String name) throws Exception {
            Class<?> factory = ReflectionUtil.forName(name);
            if (!type.isAssignableFrom(factory)) {
                throw new Exception(name + " must be an instance of " + type.getName());
            }
            return factory;
        }

        private static Method createMethod(Class<?> type, String s) throws Exception {
            Class[] pc;
            int pos = s.indexOf(32);
            if (pos == -1) {
                throw new Exception("Must Provide Return Type: " + s);
            }
            int pos2 = s.indexOf(40, pos + 1);
            if (pos2 == -1) {
                throw new Exception("Must provide a method name, followed by '(': " + s);
            }
            String mn = s.substring(pos + 1, pos2).trim();
            pos = s.indexOf(41, pos2 + 1);
            if (pos == -1) {
                throw new Exception("Must close parentheses, ')' missing: " + s);
            }
            String[] ps = s.substring(pos2 + 1, pos).trim().split(",");
            if (ps.length == 1 && "".equals(ps[0])) {
                pc = new Class[]{};
            } else {
                pc = new Class[ps.length];
                for (int i = 0; i < pc.length; ++i) {
                    pc[i] = ReflectionUtil.forName(ps[i].trim());
                }
            }
            try {
                return type.getMethod(mn, pc);
            }
            catch (NoSuchMethodException e) {
                throw new Exception("No Function Found on type: " + type.getName() + " with signature: " + s);
            }
        }

        private void processLibraryClass() throws Exception {
            String name = this.captureBuffer();
            Class<TagLibrary> type = LibraryHandler.createClass(TagLibrary.class, name);
            this.library = type.newInstance();
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
            if ("-//Sun Microsystems, Inc.//DTD Facelet Taglib 1.0//EN".equals(publicId)) {
                URL url = ClassUtils.getResource("org/apache/myfaces/resource/facelet-taglib_1_0.dtd");
                return new InputSource(url.toExternalForm());
            }
            return null;
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.buffer.append(ch, start, length);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.buffer.setLength(0);
            if ("tag".equals(qName)) {
                this.handlerClass = null;
                this.componentType = null;
                this.rendererType = null;
                this.tagName = null;
            } else if ("function".equals(qName)) {
                this.functionName = null;
                this.functionClass = null;
                this.functionSignature = null;
            }
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            throw new SAXException("Error Handling [" + this.source + "@" + e.getLineNumber() + "," + e.getColumnNumber() + "]", e);
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            throw e;
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
            throw e;
        }
    }

    private static class ComponentConfigWrapper
    implements ComponentConfig {
        protected final TagConfig parent;
        protected final String componentType;
        protected final String rendererType;

        public ComponentConfigWrapper(TagConfig parent, String componentType, String rendererType) {
            this.parent = parent;
            this.componentType = componentType;
            this.rendererType = rendererType;
        }

        public String getComponentType() {
            return this.componentType;
        }

        public String getRendererType() {
            return this.rendererType;
        }

        public FaceletHandler getNextHandler() {
            return this.parent.getNextHandler();
        }

        public Tag getTag() {
            return this.parent.getTag();
        }

        public String getTagId() {
            return this.parent.getTagId();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TagLibraryImpl
    extends AbstractTagLibrary {
        private String _compositeLibraryName = null;
        private final ResourceHandler _resourceHandler;
        private Pattern _acceptPatterns;
        private String _extension;
        private String[] _defaultSuffixesArray;

        public TagLibraryImpl(FacesContext facesContext, String namespace) {
            super(namespace);
            this._resourceHandler = facesContext.getApplication().getResourceHandler();
            ExternalContext externalContext = facesContext.getExternalContext();
            this._acceptPatterns = this.loadAcceptPattern(externalContext);
            this._extension = this.loadFaceletExtension(externalContext);
            String defaultSuffixes = WebConfigParamUtils.getStringInitParameter(externalContext, "javax.faces.DEFAULT_SUFFIX", ".xhtml .view.xml .jsp");
            this._defaultSuffixesArray = StringUtils.splitShortString(defaultSuffixes, ' ');
            boolean faceletsExtensionFound = false;
            for (String ext : this._defaultSuffixesArray) {
                if (!this._extension.equals(ext)) continue;
                faceletsExtensionFound = true;
                break;
            }
            if (!faceletsExtensionFound) {
                this._defaultSuffixesArray = (String[])ArrayUtils.concat(this._defaultSuffixesArray, new String[]{this._extension});
            }
        }

        private Pattern loadAcceptPattern(ExternalContext context) {
            assert (context != null);
            String mappings = context.getInitParameter("javax.faces.FACELETS_VIEW_MAPPINGS");
            if (mappings == null) {
                return null;
            }
            if ((mappings = mappings.trim()).length() == 0) {
                return null;
            }
            return Pattern.compile(this.toRegex(mappings));
        }

        private String loadFaceletExtension(ExternalContext context) {
            assert (context != null);
            String suffix = context.getInitParameter("javax.faces.FACELETS_SUFFIX");
            if (suffix == null) {
                suffix = ".xhtml";
            } else if ((suffix = suffix.trim()).length() == 0) {
                suffix = ".xhtml";
            }
            return suffix;
        }

        private String toRegex(String mappings) {
            assert (mappings != null);
            mappings = mappings.replaceAll("\\s", "");
            mappings = mappings.replaceAll("\\.", "\\\\.");
            mappings = mappings.replaceAll("\\*", ".*");
            mappings = mappings.replaceAll(";", "|");
            return mappings;
        }

        public boolean handles(String resourceName) {
            if (resourceName == null) {
                return false;
            }
            if (resourceName.endsWith(this._extension)) {
                return true;
            }
            return this._acceptPatterns != null && this._acceptPatterns.matcher(resourceName).matches();
        }

        @Override
        public boolean containsTagHandler(String ns, String localName) {
            boolean result = super.containsTagHandler(ns, localName);
            if (!result && this._compositeLibraryName != null && this.containsNamespace(ns)) {
                for (String defaultSuffix : this._defaultSuffixesArray) {
                    Resource compositeComponentResource;
                    String resourceName = localName + defaultSuffix;
                    if (!this.handles(resourceName) || (compositeComponentResource = this._resourceHandler.createResource(resourceName, this._compositeLibraryName)) == null) continue;
                    URL url = compositeComponentResource.getURL();
                    return url != null;
                }
            }
            return result;
        }

        @Override
        public TagHandler createTagHandler(String ns, String localName, TagConfig tag) throws FacesException {
            TagHandler tagHandler = super.createTagHandler(ns, localName, tag);
            if (tagHandler == null && this._compositeLibraryName != null && this.containsNamespace(ns)) {
                for (String defaultSuffix : this._defaultSuffixesArray) {
                    CompositeResouceWrapper compositeComponentResource;
                    String resourceName = localName + defaultSuffix;
                    if (!this.handles(resourceName) || (compositeComponentResource = new CompositeResouceWrapper(this._resourceHandler.createResource(resourceName, this._compositeLibraryName))) == null) continue;
                    ComponentConfigWrapper componentConfig = new ComponentConfigWrapper(tag, "javax.faces.NamingContainer", null);
                    return new CompositeComponentResourceTagHandler(componentConfig, compositeComponentResource);
                }
            }
            return tagHandler;
        }

        public void setCompositeLibrary(String compositeLibraryName) {
            this._compositeLibraryName = compositeLibraryName;
        }

        public void putConverter(String name, String id) {
            ParameterCheck.notNull("name", name);
            ParameterCheck.notNull("id", id);
            this.addConverter(name, id);
        }

        public void putConverter(String name, String id, Class<? extends TagHandler> handlerClass) {
            ParameterCheck.notNull("name", name);
            ParameterCheck.notNull("id", id);
            ParameterCheck.notNull("handlerClass", handlerClass);
            this.addConverter(name, id, handlerClass);
        }

        public void putValidator(String name, String id) {
            ParameterCheck.notNull("name", name);
            ParameterCheck.notNull("id", id);
            this.addValidator(name, id);
        }

        public void putValidator(String name, String id, Class<? extends TagHandler> handlerClass) {
            ParameterCheck.notNull("name", name);
            ParameterCheck.notNull("id", id);
            ParameterCheck.notNull("handlerClass", handlerClass);
            this.addValidator(name, id, handlerClass);
        }

        public void putTagHandler(String name, Class<? extends TagHandler> type) {
            ParameterCheck.notNull("name", name);
            ParameterCheck.notNull("type", type);
            this.addTagHandler(name, type);
        }

        public void putComponent(String name, String componentType, String rendererType) {
            ParameterCheck.notNull("name", name);
            ParameterCheck.notNull("componentType", componentType);
            this.addComponent(name, componentType, rendererType);
        }

        public void putComponent(String name, String componentType, String rendererType, Class<? extends TagHandler> handlerClass) {
            ParameterCheck.notNull("name", name);
            ParameterCheck.notNull("componentType", componentType);
            ParameterCheck.notNull("handlerClass", handlerClass);
            this.addComponent(name, componentType, rendererType, handlerClass);
        }

        public void putUserTag(String name, URL source) {
            ParameterCheck.notNull("name", name);
            ParameterCheck.notNull("source", source);
            this.addUserTag(name, source);
        }

        public void putFunction(String name, Method method) {
            ParameterCheck.notNull("name", name);
            ParameterCheck.notNull("method", method);
            this.addFunction(name, method);
        }

        public void putBehavior(String name, String id) {
            ParameterCheck.notNull("name", name);
            ParameterCheck.notNull("id", id);
            this.addBehavior(name, id);
        }

        public void putBehavior(String name, String id, Class<? extends TagHandler> handlerClass) {
            ParameterCheck.notNull("name", name);
            ParameterCheck.notNull("id", id);
            ParameterCheck.notNull("handlerClass", handlerClass);
            this.addBehavior(name, id, handlerClass);
        }
    }
}

