/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.resource;

import java.io.IOException;
import java.net.URL;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.resource.ResourceLoader;

public class ClassLoaderResourceLoader
extends ResourceLoader {
    private final String _resourcePrefix;
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(ClassLoaderResourceLoader.class);

    public ClassLoaderResourceLoader() {
        this((String)null);
    }

    public ClassLoaderResourceLoader(ResourceLoader parent) {
        this(null, parent);
    }

    public ClassLoaderResourceLoader(String rootPackage) {
        this._resourcePrefix = ClassLoaderResourceLoader._getResourcePrefix(rootPackage);
    }

    public ClassLoaderResourceLoader(String rootPackage, ResourceLoader parent) {
        super(parent);
        this._resourcePrefix = ClassLoaderResourceLoader._getResourcePrefix(rootPackage);
    }

    protected URL findResource(String path) throws IOException {
        if (path.charAt(0) == '/') {
            path = path.substring(1);
        }
        if (this._resourcePrefix != null) {
            path = this._resourcePrefix.endsWith("/") ? this._resourcePrefix + path : this._resourcePrefix + "/" + path;
        }
        if (!ClassLoaderResourceLoader._isPathWithinRoot(path)) {
            _LOG.severe("RESOURCE_PATH_OUTSIDE_ROOT", path);
            return null;
        }
        return this.getClassLoader().getResource(path);
    }

    protected ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    private static String _getResourcePrefix(String rootPackage) {
        if (rootPackage == null || rootPackage.length() == 0) {
            return null;
        }
        return rootPackage.replace('.', '/');
    }

    private static boolean _isPathWithinRoot(String path) {
        if (path.indexOf("..") == -1) {
            return true;
        }
        _LOG.warning("RESOURCE_PATH_DOTS", path);
        while (path != null && path.length() > 0) {
            if (path.startsWith("..")) {
                return false;
            }
            int index = path.indexOf("/../");
            if (index == 0) {
                return false;
            }
            if (index == -1) {
                return true;
            }
            String beginning = path.substring(0, index);
            String end = path.substring(index + 4);
            int lastIndex = beginning.lastIndexOf("/");
            if (lastIndex == -1) {
                path = end;
                continue;
            }
            path = beginning.substring(0, lastIndex + 1) + end;
        }
        return true;
    }
}

