/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.booter.output;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.maven.surefire.booter.output.OutputConsumer;
import org.apache.maven.surefire.booter.output.OutputConsumerProxy;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.util.NestedRuntimeException;

public class FileOutputConsumerProxy
extends OutputConsumerProxy {
    private static final String USER_DIR = System.getProperty("user.dir");
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private File reportsDirectory;
    private PrintWriter printWriter;

    public FileOutputConsumerProxy(OutputConsumer outputConsumer) {
        this(outputConsumer, new File(USER_DIR));
    }

    public FileOutputConsumerProxy(OutputConsumer outputConsumer, File reportsDirectory) {
        super(outputConsumer);
        this.setReportsDirectory(reportsDirectory);
    }

    public void setReportsDirectory(File reportsDirectory) {
        this.reportsDirectory = reportsDirectory;
    }

    public File getReportsDirectory() {
        return this.reportsDirectory;
    }

    public void setPrintWriter(PrintWriter writer) {
        this.printWriter = writer;
    }

    public PrintWriter getPrintWriter() {
        return this.printWriter;
    }

    public void testSetStarting(ReportEntry reportEntry) {
        if (this.getPrintWriter() != null) {
            throw new IllegalStateException("testSetStarting called twice");
        }
        File file = new File(this.getReportsDirectory(), reportEntry.getName() + "-output.txt");
        try {
            this.setPrintWriter(new PrintWriter(new BufferedWriter(new FileWriter(file))));
        }
        catch (IOException e) {
            throw new NestedRuntimeException((Throwable)e);
        }
        super.testSetStarting(reportEntry);
    }

    public void testSetCompleted() {
        if (this.getPrintWriter() == null) {
            throw new IllegalStateException("testSetCompleted called before testSetStarting");
        }
        this.getPrintWriter().close();
        this.setPrintWriter(null);
        super.testSetCompleted();
    }

    public void consumeOutputLine(String line) {
        if (this.getPrintWriter() == null) {
            throw new IllegalStateException("consumeOutputLine called before testSetStarting");
        }
        this.getPrintWriter().write(line);
        this.getPrintWriter().write(LINE_SEPARATOR);
    }
}

