/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.util.internal;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.BitSet;

public final class UrlUtils {
    private static final BitSet UNRESERVED = new BitSet(256);
    private static final int RADIX = 16;
    private static final int MASK = 15;
    private static final String ENCODING = "UTF-8";

    private UrlUtils() {
        throw new IllegalStateException("no instantiable constructor");
    }

    public static URL toURL(File file) throws MalformedURLException {
        URL url = file.toURL();
        try {
            byte[] bytes = url.toString().getBytes(ENCODING);
            StringBuilder buf = new StringBuilder(bytes.length);
            for (byte b : bytes) {
                if (b > 0 && UNRESERVED.get(b)) {
                    buf.append((char)b);
                    continue;
                }
                buf.append('%');
                buf.append(Character.forDigit(b >>> 4 & 0xF, 16));
                buf.append(Character.forDigit(b & 0xF, 16));
            }
            return new URL(buf.toString());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        try {
            byte[] bytes;
            for (byte aByte : bytes = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-_.!~*'():/".getBytes(ENCODING)) {
                UNRESERVED.set(aByte);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }
}

