/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.jar.identification.exposers;

import java.util.ArrayList;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.shared.jar.JarAnalyzer;
import org.apache.maven.shared.jar.identification.JarIdentification;
import org.apache.maven.shared.jar.identification.JarIdentificationExposer;
import org.apache.maven.shared.jar.identification.hash.JarHashAnalyzer;
import org.apache.maven.shared.jar.identification.repository.RepositoryHashSearch;

@Singleton
@Named(value="repositorySearch")
public class RepositorySearchExposer
implements JarIdentificationExposer {
    private final RepositoryHashSearch repositoryHashSearch;
    private final JarHashAnalyzer fileHashAnalyzer;
    private final JarHashAnalyzer bytecodeHashAnalyzer;

    @Inject
    public RepositorySearchExposer(RepositoryHashSearch repositoryHashSearch, @Named(value="file") JarHashAnalyzer fileHashAnalyzer, @Named(value="bytecode") JarHashAnalyzer bytecodeHashAnalyzer) {
        this.repositoryHashSearch = Objects.requireNonNull(repositoryHashSearch);
        this.fileHashAnalyzer = Objects.requireNonNull(fileHashAnalyzer);
        this.bytecodeHashAnalyzer = Objects.requireNonNull(bytecodeHashAnalyzer);
    }

    @Override
    public void expose(JarIdentification identification, JarAnalyzer jarAnalyzer) {
        String bytecodehash;
        ArrayList<Artifact> repohits = new ArrayList<Artifact>();
        String hash = this.fileHashAnalyzer.computeHash(jarAnalyzer);
        if (hash != null) {
            repohits.addAll(this.repositoryHashSearch.searchFileHash(hash));
        }
        if ((bytecodehash = this.bytecodeHashAnalyzer.computeHash(jarAnalyzer)) != null) {
            repohits.addAll(this.repositoryHashSearch.searchBytecodeHash(bytecodehash));
        }
        for (Artifact artifact : repohits) {
            identification.addAndSetGroupId(artifact.getGroupId());
            identification.addAndSetArtifactId(artifact.getArtifactId());
            identification.addAndSetVersion(artifact.getVersion());
        }
    }
}

