/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.model.fileset.io.xpp3;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import org.apache.maven.shared.model.fileset.FileSet;
import org.apache.maven.shared.model.fileset.SetBase;
import org.codehaus.plexus.util.xml.pull.MXSerializer;
import org.codehaus.plexus.util.xml.pull.XmlSerializer;

public class FileSetXpp3Writer {
    private XmlSerializer serializer;
    private String NAMESPACE;

    public void write(Writer writer, FileSet fileSet) throws IOException {
        this.serializer = new MXSerializer();
        this.serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", (Object)"  ");
        this.serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", (Object)"\n");
        this.serializer.setOutput(writer);
        this.serializer.startDocument(fileSet.getModelEncoding(), null);
        this.writeFileSet(fileSet, "fileSet", this.serializer);
        this.serializer.endDocument();
    }

    private void writeFileSet(FileSet fileSet, String tagName, XmlSerializer serializer) throws IOException {
        if (fileSet != null) {
            Iterator iter;
            serializer.startTag(this.NAMESPACE, tagName);
            if (fileSet.getDirectory() != null) {
                serializer.startTag(this.NAMESPACE, "directory").text(fileSet.getDirectory()).endTag(this.NAMESPACE, "directory");
            }
            if (fileSet.getLineEnding() != null) {
                serializer.startTag(this.NAMESPACE, "lineEnding").text(fileSet.getLineEnding()).endTag(this.NAMESPACE, "lineEnding");
            }
            if (fileSet.isFollowSymlinks()) {
                serializer.startTag(this.NAMESPACE, "followSymlinks").text(String.valueOf(fileSet.isFollowSymlinks())).endTag(this.NAMESPACE, "followSymlinks");
            }
            if (fileSet.getOutputDirectory() != null) {
                serializer.startTag(this.NAMESPACE, "outputDirectory").text(fileSet.getOutputDirectory()).endTag(this.NAMESPACE, "outputDirectory");
            }
            if (fileSet.getIncludes() != null && fileSet.getIncludes().size() > 0) {
                serializer.startTag(this.NAMESPACE, "includes");
                iter = fileSet.getIncludes().iterator();
                while (iter.hasNext()) {
                    String include = (String)iter.next();
                    serializer.startTag(this.NAMESPACE, "include").text(include).endTag(this.NAMESPACE, "include");
                }
                serializer.endTag(this.NAMESPACE, "includes");
            }
            if (fileSet.getExcludes() != null && fileSet.getExcludes().size() > 0) {
                serializer.startTag(this.NAMESPACE, "excludes");
                iter = fileSet.getExcludes().iterator();
                while (iter.hasNext()) {
                    String exclude = (String)iter.next();
                    serializer.startTag(this.NAMESPACE, "exclude").text(exclude).endTag(this.NAMESPACE, "exclude");
                }
                serializer.endTag(this.NAMESPACE, "excludes");
            }
            if (fileSet.getFileMode() != null && !fileSet.getFileMode().equals("0644")) {
                serializer.startTag(this.NAMESPACE, "fileMode").text(fileSet.getFileMode()).endTag(this.NAMESPACE, "fileMode");
            }
            if (fileSet.getDirectoryMode() != null && !fileSet.getDirectoryMode().equals("0755")) {
                serializer.startTag(this.NAMESPACE, "directoryMode").text(fileSet.getDirectoryMode()).endTag(this.NAMESPACE, "directoryMode");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeSetBase(SetBase setBase, String tagName, XmlSerializer serializer) throws IOException {
        if (setBase != null) {
            Iterator iter;
            serializer.startTag(this.NAMESPACE, tagName);
            if (setBase.isFollowSymlinks()) {
                serializer.startTag(this.NAMESPACE, "followSymlinks").text(String.valueOf(setBase.isFollowSymlinks())).endTag(this.NAMESPACE, "followSymlinks");
            }
            if (setBase.getOutputDirectory() != null) {
                serializer.startTag(this.NAMESPACE, "outputDirectory").text(setBase.getOutputDirectory()).endTag(this.NAMESPACE, "outputDirectory");
            }
            if (setBase.getIncludes() != null && setBase.getIncludes().size() > 0) {
                serializer.startTag(this.NAMESPACE, "includes");
                iter = setBase.getIncludes().iterator();
                while (iter.hasNext()) {
                    String include = (String)iter.next();
                    serializer.startTag(this.NAMESPACE, "include").text(include).endTag(this.NAMESPACE, "include");
                }
                serializer.endTag(this.NAMESPACE, "includes");
            }
            if (setBase.getExcludes() != null && setBase.getExcludes().size() > 0) {
                serializer.startTag(this.NAMESPACE, "excludes");
                iter = setBase.getExcludes().iterator();
                while (iter.hasNext()) {
                    String exclude = (String)iter.next();
                    serializer.startTag(this.NAMESPACE, "exclude").text(exclude).endTag(this.NAMESPACE, "exclude");
                }
                serializer.endTag(this.NAMESPACE, "excludes");
            }
            if (setBase.getFileMode() != null && !setBase.getFileMode().equals("0644")) {
                serializer.startTag(this.NAMESPACE, "fileMode").text(setBase.getFileMode()).endTag(this.NAMESPACE, "fileMode");
            }
            if (setBase.getDirectoryMode() != null && !setBase.getDirectoryMode().equals("0755")) {
                serializer.startTag(this.NAMESPACE, "directoryMode").text(setBase.getDirectoryMode()).endTag(this.NAMESPACE, "directoryMode");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }
}

