/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.synergy.command.changelog;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.scm.ChangeSet;
import org.apache.maven.scm.ScmBranch;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.command.changelog.AbstractChangeLogCommand;
import org.apache.maven.scm.command.changelog.ChangeLogScmResult;
import org.apache.maven.scm.command.changelog.ChangeLogSet;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.synergy.command.SynergyCommand;
import org.apache.maven.scm.provider.synergy.repository.SynergyScmProviderRepository;
import org.apache.maven.scm.provider.synergy.util.SynergyTask;
import org.apache.maven.scm.provider.synergy.util.SynergyUtil;

public class SynergyChangeLogCommand
extends AbstractChangeLogCommand
implements SynergyCommand {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ChangeLogScmResult executeChangeLogCommand(ScmProviderRepository repository, ScmFileSet fileSet, Date startDate, Date endDate, ScmBranch branch, String datePattern) throws ScmException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("executing changelog command...");
        }
        SynergyScmProviderRepository repo = (SynergyScmProviderRepository)repository;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("basedir: " + fileSet.getBasedir());
        }
        String ccmAddr = SynergyUtil.start(this.getLogger(), repo.getUser(), repo.getPassword(), null);
        ArrayList<ChangeSet> csList = new ArrayList<ChangeSet>();
        try {
            String projectSpec = SynergyUtil.getWorkingProject(this.getLogger(), repo.getProjectSpec(), repo.getUser(), ccmAddr);
            if (projectSpec == null) {
                throw new ScmException("You should checkout project first");
            }
            List tasks = SynergyUtil.getCompletedTasks(this.getLogger(), projectSpec, startDate, endDate, ccmAddr);
            Iterator i = tasks.iterator();
            while (i.hasNext()) {
                ChangeSet cs = new ChangeSet();
                SynergyTask t = (SynergyTask)i.next();
                cs.setAuthor(t.getUsername());
                cs.setComment("Task " + t.getNumber() + ": " + t.getComment());
                cs.setDate(t.getModifiedTime());
                cs.setFiles(SynergyUtil.getModifiedObjects(this.getLogger(), t.getNumber(), ccmAddr));
                csList.add(cs);
            }
        }
        finally {
            SynergyUtil.stop(this.getLogger(), ccmAddr);
        }
        return new ChangeLogScmResult("ccm query ...", new ChangeLogSet(csList, startDate, endDate));
    }
}

