/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.local.command.update;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.changelog.ChangeLogCommand;
import org.apache.maven.scm.command.update.AbstractUpdateCommand;
import org.apache.maven.scm.command.update.UpdateScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.local.command.LocalCommand;
import org.apache.maven.scm.provider.local.command.changelog.LocalChangeLogCommand;
import org.apache.maven.scm.provider.local.command.update.LocalUpdateScmResult;
import org.apache.maven.scm.provider.local.metadata.LocalScmMetadata;
import org.apache.maven.scm.provider.local.metadata.LocalScmMetadataUtils;
import org.apache.maven.scm.provider.local.repository.LocalScmProviderRepository;
import org.codehaus.plexus.util.FileUtils;

public class LocalUpdateCommand
extends AbstractUpdateCommand
implements LocalCommand {
    protected UpdateScmResult executeUpdateCommand(ScmProviderRepository repo, ScmFileSet fileSet, ScmVersion version) throws ScmException {
        List updatedFiles;
        LocalScmProviderRepository repository = (LocalScmProviderRepository)repo;
        if (version != null) {
            throw new ScmException("The local scm doesn't support tags.");
        }
        File root = new File(repository.getRoot());
        String module = repository.getModule();
        File source = new File(root, module);
        File baseDestination = fileSet.getBasedir();
        if (!baseDestination.exists()) {
            throw new ScmException("The working directory doesn't exist (" + baseDestination.getAbsolutePath() + ").");
        }
        if (!root.exists()) {
            throw new ScmException("The base directory doesn't exist (" + root.getAbsolutePath() + ").");
        }
        if (!source.exists()) {
            throw new ScmException("The module directory doesn't exist (" + source.getAbsolutePath() + ").");
        }
        if (!baseDestination.exists() && !baseDestination.isDirectory()) {
            throw new ScmException("The destination directory isn't a directory or doesn't exist (" + baseDestination.getAbsolutePath() + ").");
        }
        try {
            this.getLogger().info("Updating '" + baseDestination.getAbsolutePath() + "' from '" + source.getAbsolutePath() + "'.");
            List fileList = FileUtils.getFiles((File)source.getAbsoluteFile(), (String)"**", null);
            updatedFiles = this.update(source, baseDestination, fileList);
            LocalScmMetadataUtils metadataUtils = new LocalScmMetadataUtils(this.getLogger());
            LocalScmMetadata originalMetadata = metadataUtils.readMetadata(baseDestination);
            if (originalMetadata != null) {
                LocalScmMetadata newMetadata = metadataUtils.buildMetadata(source);
                Iterator it = originalMetadata.getRepositoryFileNames().iterator();
                while (it.hasNext()) {
                    File localFile;
                    String filename = (String)it.next();
                    if (newMetadata.getRepositoryFileNames().contains(filename) || !(localFile = new File(baseDestination, filename)).exists()) continue;
                    localFile.delete();
                    updatedFiles.add(new ScmFile("/" + filename, ScmFileStatus.UPDATED));
                }
            }
            metadataUtils.writeMetadata(baseDestination, metadataUtils.buildMetadata(source));
        }
        catch (IOException ex) {
            throw new ScmException("Error while checking out the files.", (Throwable)ex);
        }
        return new LocalUpdateScmResult(null, updatedFiles);
    }

    private List update(File source, File baseDestination, List files) throws ScmException, IOException {
        String sourcePath = source.getAbsolutePath();
        ArrayList<ScmFile> updatedFiles = new ArrayList<ScmFile>();
        Iterator i = files.iterator();
        while (i.hasNext()) {
            String destionationFileContents;
            File repositoryFile = (File)i.next();
            File repositoryDirectory = repositoryFile.getParentFile();
            if (repositoryDirectory != null && repositoryDirectory.getName().equals("CVS")) continue;
            String dest = repositoryFile.getAbsolutePath().substring(sourcePath.length() + 1);
            File destinationFile = new File(baseDestination, dest);
            String repositoryFileContents = FileUtils.fileRead((File)repositoryFile);
            if (destinationFile.exists() && repositoryFileContents.equals(destionationFileContents = FileUtils.fileRead((File)destinationFile))) continue;
            File destinationDirectory = destinationFile.getParentFile();
            if (!destinationDirectory.exists() && !destinationDirectory.mkdirs()) {
                throw new ScmException("Could not create destination directory '" + destinationDirectory.getAbsolutePath() + "'.");
            }
            ScmFileStatus status = destinationFile.exists() ? ScmFileStatus.UPDATED : ScmFileStatus.ADDED;
            FileUtils.copyFileToDirectory((File)repositoryFile, (File)destinationDirectory);
            int chop = baseDestination.getAbsolutePath().length();
            String fileName = "/" + destinationFile.getAbsolutePath().substring(chop + 1);
            updatedFiles.add(new ScmFile(fileName, status));
        }
        return updatedFiles;
    }

    protected ChangeLogCommand getChangeLogCommand() {
        return new LocalChangeLogCommand();
    }
}

