/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release.phase;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.release.ReleaseExecutionException;
import org.apache.maven.shared.release.ReleaseFailureException;
import org.apache.maven.shared.release.ReleaseResult;
import org.apache.maven.shared.release.config.ReleaseDescriptor;
import org.apache.maven.shared.release.env.ReleaseEnvironment;
import org.apache.maven.shared.release.phase.AbstractBackupPomsPhase;
import org.apache.maven.shared.release.util.ReleaseUtil;
import org.codehaus.plexus.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateBackupPomsPhase
extends AbstractBackupPomsPhase {
    @Override
    public ReleaseResult execute(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List<MavenProject> reactorProjects) throws ReleaseExecutionException, ReleaseFailureException {
        ReleaseResult result = new ReleaseResult();
        this.clean(reactorProjects);
        for (MavenProject project : reactorProjects) {
            this.createPomBackup(project);
        }
        result.setResultCode(0);
        return result;
    }

    @Override
    public ReleaseResult clean(List<MavenProject> reactorProjects) {
        ReleaseResult result = new ReleaseResult();
        for (MavenProject project : reactorProjects) {
            this.deletePomBackup(project);
        }
        result.setResultCode(0);
        return result;
    }

    @Override
    public ReleaseResult simulate(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List<MavenProject> reactorProjects) throws ReleaseExecutionException, ReleaseFailureException {
        return this.execute(releaseDescriptor, releaseEnvironment, reactorProjects);
    }

    private void createPomBackup(MavenProject project) throws ReleaseExecutionException {
        this.deletePomBackup(project);
        try {
            FileUtils.copyFile((File)ReleaseUtil.getStandardPom(project), (File)this.getPomBackup(project));
        }
        catch (IOException e) {
            throw new ReleaseExecutionException("Error creating backup POM: " + e.getMessage(), e);
        }
    }
}

