/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.shade.filter;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.shade.filter.Filter;
import org.apache.maven.plugins.shade.filter.SimpleFilter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.IOUtil;
import org.vafer.jdependency.Clazz;
import org.vafer.jdependency.Clazzpath;
import org.vafer.jdependency.ClazzpathUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MinijarFilter
implements Filter {
    private Log log;
    private Set removable;
    private int classesKept;
    private int classesRemoved;

    public MinijarFilter(MavenProject project, Log log) throws IOException {
        this(project, log, Collections.emptyList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MinijarFilter(MavenProject project, Log log, List<SimpleFilter> simpleFilters) throws IOException {
        this.log = log;
        Clazzpath cp = new Clazzpath();
        ClazzpathUnit artifactUnit = cp.addClazzpathUnit((InputStream)new FileInputStream(project.getArtifact().getFile()), project.toString());
        for (Artifact dependency : project.getArtifacts()) {
            FileInputStream is = null;
            try {
                is = new FileInputStream(dependency.getFile());
                cp.addClazzpathUnit((InputStream)is, dependency.toString());
            }
            catch (Throwable throwable) {
                IOUtil.close(is);
                throw throwable;
            }
            IOUtil.close((InputStream)is);
        }
        this.removable = cp.getClazzes();
        this.removePackages(artifactUnit);
        this.removable.removeAll(artifactUnit.getClazzes());
        this.removable.removeAll(artifactUnit.getTransitiveDependencies());
        this.removeSpecificallyIncludedClasses(project, simpleFilters == null ? Collections.emptyList() : simpleFilters);
    }

    private void removePackages(ClazzpathUnit artifactUnit) {
        HashSet packageNames = new HashSet();
        this.removePackages(artifactUnit.getClazzes(), packageNames);
        this.removePackages(artifactUnit.getTransitiveDependencies(), packageNames);
    }

    private void removePackages(Set clazzes, Set packageNames) {
        for (Clazz clazz : clazzes) {
            String name = clazz.getName();
            while (name.contains(".")) {
                if (!packageNames.add(name = name.substring(0, name.lastIndexOf(46)))) continue;
                this.removable.remove(new Clazz(name + ".package-info"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSpecificallyIncludedClasses(MavenProject project, List<SimpleFilter> simpleFilters) throws IOException {
        Clazzpath checkCp = new Clazzpath();
        for (Artifact dependency : project.getArtifacts()) {
            File jar = dependency.getFile();
            for (SimpleFilter simpleFilter : simpleFilters) {
                if (!simpleFilter.canFilter(jar)) continue;
                FileInputStream is = null;
                ClazzpathUnit depClazzpathUnit = null;
                try {
                    is = new FileInputStream(dependency.getFile());
                    depClazzpathUnit = checkCp.addClazzpathUnit((InputStream)is, dependency.toString());
                }
                catch (Throwable throwable) {
                    IOUtil.close(is);
                    throw throwable;
                }
                IOUtil.close((InputStream)is);
                if (depClazzpathUnit == null) continue;
                Iterator j = this.removable.iterator();
                while (j.hasNext()) {
                    Clazz clazz = (Clazz)j.next();
                    if (!depClazzpathUnit.getClazzes().contains(clazz) || !simpleFilter.isSpecificallyIncluded(clazz.getName().replace('.', '/'))) continue;
                    this.log.info((CharSequence)(clazz.getName() + " not removed because it was specifically included"));
                    j.remove();
                }
            }
        }
    }

    @Override
    public boolean canFilter(File jar) {
        return true;
    }

    @Override
    public boolean isFiltered(String classFile) {
        String className = classFile.replace('/', '.').replaceFirst("\\.class$", "");
        Clazz clazz = new Clazz(className);
        if (this.removable.contains(clazz)) {
            this.log.debug((CharSequence)("Removing " + className));
            ++this.classesRemoved;
            return true;
        }
        ++this.classesKept;
        return false;
    }

    @Override
    public void finished() {
        int classes_total = this.classesRemoved + this.classesKept;
        this.log.info((CharSequence)("Minimized " + classes_total + " -> " + this.classesKept + " (" + 100 * this.classesKept / classes_total + "%)"));
    }
}

