/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.shade.mojo;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private static final int DEFAULT_WIDTH = 80;
    private static final String DEFAULT_INDENT = HelpMojo.repeat(" ", 2);
    private boolean detail;

    public void execute() throws MojoExecutionException {
        StringBuffer sb = new StringBuffer();
        sb.append("The 'org.apache.maven.plugins:maven-shade-plugin' plugin has 2 goals:").append("\n");
        sb.append("\n");
        sb.append("shade:shade").append("\n");
        Iterator it = HelpMojo.toLines("Mojo that performs shading delegating to the Shader component.").iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append("\n");
        }
        if (this.detail) {
            sb.append("\n");
            sb.append(HelpMojo.repeat(" ", 2));
            sb.append("Available parameters:").append("\n");
            sb.append("\n");
            it = HelpMojo.toLines("artifactSet", HelpMojo.repeat(" ", 4), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("Artifacts to include/exclude from the final artifact.", HelpMojo.repeat(" ", 6), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("createDependencyReducedPom (Default: 'true')", HelpMojo.repeat(" ", 4), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("Flag whether to generate a simplified POM for the shaded artifact. If set to true, dependencies that have been included into the uber JAR will be removed from the <dependencies> section of the generated POM. The reduced POM will be named dependency-reduced-pom.xml and is stored into the same directory as the shaded artifact.", HelpMojo.repeat(" ", 6), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("createSourcesJar (Default: 'false')", HelpMojo.repeat(" ", 4), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("When true, it will attempt to create a sources jar as well", HelpMojo.repeat(" ", 6), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("filters", HelpMojo.repeat(" ", 4), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("Archive Filters to be used. Allows you to specify an artifact in the form of groupId:artifactId and a set of include/exclude file patterns for filtering which contents of the archive are added to the shaded jar. From a logical perspective, includes are processed before excludes, thus it's possible to use an include to collect a set of files from the archive then use excludes to further reduce the set. By default, all files are included and no files are excluded.", HelpMojo.repeat(" ", 6), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("finalName", HelpMojo.repeat(" ", 4), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("The name of the shaded artifactId", HelpMojo.repeat(" ", 6), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("keepDependenciesWithProvidedScope (Default: 'false')", HelpMojo.repeat(" ", 4), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("When true, dependencies are kept in the pom but with scope 'provided'; when false, the dependency is removed.", HelpMojo.repeat(" ", 6), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("outputDirectory (Default: '${project.build.directory}')", HelpMojo.repeat(" ", 4), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("The destination directory for the shaded artifact.", HelpMojo.repeat(" ", 6), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("promoteTransitiveDependencies (Default: 'false')", HelpMojo.repeat(" ", 4), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("When true, transitive deps of removed dependencies are promoted to direct dependencies. This should allow the drop in replacement of the removed deps with the new shaded jar and everything should still work.", HelpMojo.repeat(" ", 6), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("relocations", HelpMojo.repeat(" ", 4), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("Packages to be relocated.", HelpMojo.repeat(" ", 6), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("shadedArtifactAttached (Default: 'false')", HelpMojo.repeat(" ", 4), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("Defines whether the shaded artifact should be attached as classifier to the original artifact. If false, the shaded jar will be the main artifact of the project", HelpMojo.repeat(" ", 6), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("shadedArtifactId (Default: '${project.artifactId}')", HelpMojo.repeat(" ", 4), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("The name of the shaded artifactId. So you may want to use a different artifactId and keep the standard version. If the original artifactId was 'foo' then the final artifact would be something like foo-1.0.jar. So if you change the artifactId you might have something like foo-special-1.0.jar.", HelpMojo.repeat(" ", 6), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("shadedClassifierName (Default: 'shaded')", HelpMojo.repeat(" ", 4), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("The name of the classifier used in case the shaded artifact is attached.", HelpMojo.repeat(" ", 6), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("shadedGroupFilter", HelpMojo.repeat(" ", 4), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("If specified, this will include only artifacts which have groupIds which start with this.", HelpMojo.repeat(" ", 6), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("transformers", HelpMojo.repeat(" ", 4), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
            it = HelpMojo.toLines("Resource transformers to be used.", HelpMojo.repeat(" ", 6), 80).iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString()).append("\n");
            }
        }
        sb.append("\n");
        sb.append("shade:help").append("\n");
        it = HelpMojo.toLines("Display help information on 'org.apache.maven.plugins:maven-shade-plugin' plugin. Call 'mvn shade:help -Ddetail=true' to display all details.").iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append("\n");
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private static List toLines(String str) {
        return HelpMojo.toLines(str, DEFAULT_INDENT, 80);
    }

    private static List toLines(String str, String indent, int size) {
        ArrayList<String> sentences = new ArrayList<String>();
        if (indent == null) {
            indent = "";
        }
        if (size < 0) {
            throw new IllegalArgumentException("size should be positive");
        }
        StringBuffer tmp = new StringBuffer(indent);
        StringTokenizer tokenizer = new StringTokenizer(str, " ");
        while (tokenizer.hasMoreTokens()) {
            String word = tokenizer.nextToken();
            if (tmp.length() + word.length() + 1 < size) {
                tmp.append(word).append(" ");
                continue;
            }
            sentences.add(tmp.toString());
            tmp = new StringBuffer(indent);
            tmp.append(word).append(" ");
        }
        if (tmp.toString().length() > 0) {
            sentences.add(tmp.toString());
        }
        return sentences;
    }
}

