/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.report.projectinfo;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import javax.inject.Inject;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.model.CiManagement;
import org.apache.maven.model.Model;
import org.apache.maven.model.Notifier;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.report.projectinfo.AbstractProjectInfoRenderer;
import org.apache.maven.report.projectinfo.AbstractProjectInfoReport;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.repository.RepositorySystem;
import org.codehaus.plexus.i18n.I18N;

@Mojo(name="ci-management")
public class CiManagementReport
extends AbstractProjectInfoReport {
    @Inject
    public CiManagementReport(RepositorySystem repositorySystem, I18N i18n, ProjectBuilder projectBuilder) {
        super(repositorySystem, i18n, projectBuilder);
    }

    @Override
    public boolean canGenerateReport() throws MavenReportException {
        boolean result = super.canGenerateReport();
        if (result && this.skipEmptyReport) {
            CiManagement cim = this.getProject().getModel().getCiManagement();
            result = cim != null;
        }
        return result;
    }

    public void executeReport(Locale locale) {
        CiManagementRenderer r = new CiManagementRenderer(this.getSink(), this.getProject().getModel(), this.getI18N(locale), locale);
        r.render();
    }

    public String getOutputName() {
        return "ci-management";
    }

    @Override
    protected String getI18Nsection() {
        return "ci-management";
    }

    private static class CiManagementRenderer
    extends AbstractProjectInfoRenderer {
        private static final Set<String> SYSTEMS = new HashSet<String>(Arrays.asList("anthill", "bamboo", "buildforge", "continuum", "cruisecontrol", "github", "hudson", "jenkins", "luntbuild", "teamcity", "travis"));
        private Model model;

        CiManagementRenderer(Sink sink, Model model, I18N i18n, Locale locale) {
            super(sink, i18n, locale);
            this.model = model;
        }

        @Override
        protected String getI18Nsection() {
            return "ci-management";
        }

        protected void renderBody() {
            CiManagement cim = this.model.getCiManagement();
            if (cim == null) {
                this.startSection(this.getTitle());
                this.paragraph(this.getI18nString("nocim"));
                this.endSection();
                return;
            }
            String system = cim.getSystem();
            String url = cim.getUrl();
            List notifiers = cim.getNotifiers();
            this.startSection(this.getI18nString("overview.title"));
            this.sink.paragraph();
            this.linkPatternedText(this.getIntroForCiManagementSystem(system));
            this.sink.paragraph_();
            this.endSection();
            this.startSection(this.getI18nString("access"));
            if (url != null && !url.isEmpty()) {
                this.paragraph(this.getI18nString("url"));
                this.verbatimLink(url, url);
            } else {
                this.paragraph(this.getI18nString("nourl"));
            }
            this.endSection();
            this.startSection(this.getI18nString("notifiers.title"));
            if (notifiers == null || notifiers.isEmpty()) {
                this.paragraph(this.getI18nString("notifiers.nolist"));
            } else {
                this.sink.paragraph();
                this.sink.text(this.getI18nString("notifiers.intro"));
                this.sink.paragraph_();
                this.startTable();
                String type = this.getI18nString("notifiers.column.type");
                String address = this.getI18nString("notifiers.column.address");
                String configuration = this.getI18nString("notifiers.column.configuration");
                this.tableHeader(new String[]{type, address, configuration});
                for (Notifier notifier : notifiers) {
                    this.tableRow(new String[]{notifier.getType(), CiManagementRenderer.createLinkPatternedText((String)notifier.getAddress(), (String)notifier.getAddress()), CiManagementRenderer.propertiesToString((Properties)notifier.getConfiguration())});
                }
                this.endTable();
            }
            this.endSection();
        }

        private String getIntroForCiManagementSystem(String system) {
            if (system == null || system.isEmpty()) {
                return this.getI18nString("general.intro");
            }
            String systemLowerCase = system.toLowerCase(Locale.ENGLISH);
            for (String systemName : SYSTEMS) {
                if (!systemLowerCase.startsWith(systemName)) continue;
                return this.getI18nString(systemName + ".intro");
            }
            return this.getI18nString("general.intro");
        }
    }
}

