/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.report.projectinfo.dependencies.renderer;

import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.License;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.report.projectinfo.AbstractProjectInfoRenderer;
import org.apache.maven.report.projectinfo.ProjectInfoReportUtils;
import org.apache.maven.report.projectinfo.dependencies.ManagementDependencies;
import org.apache.maven.report.projectinfo.dependencies.RepositoryUtils;
import org.apache.maven.repository.RepositorySystem;
import org.codehaus.plexus.i18n.I18N;
import org.codehaus.plexus.util.StringUtils;

public class DependencyManagementRenderer
extends AbstractProjectInfoRenderer {
    private final ManagementDependencies dependencies;
    private final Log log;
    private final ArtifactMetadataSource artifactMetadataSource;
    private final RepositorySystem repositorySystem;
    private final ProjectBuilder projectBuilder;
    private final ProjectBuildingRequest buildingRequest;
    private final RepositoryUtils repoUtils;

    public DependencyManagementRenderer(Sink sink, Locale locale, I18N i18n, Log log, ManagementDependencies dependencies, ArtifactMetadataSource artifactMetadataSource, RepositorySystem repositorySystem, ProjectBuilder projectBuilder, ProjectBuildingRequest buildingRequest, RepositoryUtils repoUtils) {
        super(sink, i18n, locale);
        this.log = log;
        this.dependencies = dependencies;
        this.artifactMetadataSource = artifactMetadataSource;
        this.repositorySystem = repositorySystem;
        this.projectBuilder = projectBuilder;
        this.buildingRequest = buildingRequest;
        this.repoUtils = repoUtils;
    }

    @Override
    protected String getI18Nsection() {
        return "dependency-management";
    }

    public void renderBody() {
        if (!this.dependencies.hasDependencies()) {
            this.startSection(this.getTitle());
            this.paragraph(this.getI18nString("nolist"));
            this.endSection();
            return;
        }
        this.renderSectionProjectDependencies();
    }

    private void renderSectionProjectDependencies() {
        this.startSection(this.getTitle());
        Map<String, List<Dependency>> dependenciesByScope = this.dependencies.getManagementDependenciesByScope();
        this.renderDependenciesForAllScopes(dependenciesByScope);
        this.endSection();
    }

    private void renderDependenciesForAllScopes(Map<String, List<Dependency>> dependenciesByScope) {
        this.renderDependenciesForScope("compile", dependenciesByScope.get("compile"));
        this.renderDependenciesForScope("runtime", dependenciesByScope.get("runtime"));
        this.renderDependenciesForScope("test", dependenciesByScope.get("test"));
        this.renderDependenciesForScope("provided", dependenciesByScope.get("provided"));
        this.renderDependenciesForScope("system", dependenciesByScope.get("system"));
    }

    private String[] getDependencyTableHeader(boolean hasClassifier) {
        String groupId = this.getI18nString("column.groupId");
        String artifactId = this.getI18nString("column.artifactId");
        String version = this.getI18nString("column.version");
        String classifier = this.getI18nString("column.classifier");
        String type = this.getI18nString("column.type");
        String license = this.getI18nString("column.license");
        if (hasClassifier) {
            return new String[]{groupId, artifactId, version, classifier, type, license};
        }
        return new String[]{groupId, artifactId, version, type, license};
    }

    private void renderDependenciesForScope(String scope, List<Dependency> artifacts) {
        if (artifacts != null) {
            Collections.sort(artifacts, this.getDependencyComparator());
            this.startSection(scope);
            this.paragraph(this.getI18nString("intro." + scope));
            this.startTable();
            boolean hasClassifier = false;
            for (Dependency dependency : artifacts) {
                if (!StringUtils.isNotEmpty((String)dependency.getClassifier())) continue;
                hasClassifier = true;
                break;
            }
            String[] tableHeader = this.getDependencyTableHeader(hasClassifier);
            this.tableHeader(tableHeader);
            for (Dependency dependency : artifacts) {
                this.tableRow(this.getDependencyRow(dependency, hasClassifier));
            }
            this.endTable();
            this.endSection();
        }
    }

    private String[] getDependencyRow(Dependency dependency, boolean hasClassifier) {
        Artifact artifact = this.repositorySystem.createArtifact(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), dependency.getScope(), dependency.getType());
        StringBuilder licensesBuffer = new StringBuilder();
        String url = null;
        try {
            VersionRange range = VersionRange.createFromVersionSpec((String)dependency.getVersion());
            if (range.getRecommendedVersion() == null) {
                this.log.debug((CharSequence)("Resolving range for DependencyManagement on " + artifact.getId()));
                List versions = this.artifactMetadataSource.retrieveAvailableVersions(artifact, this.buildingRequest.getLocalRepository(), this.buildingRequest.getRemoteRepositories());
                Iterator iter = versions.iterator();
                while (iter.hasNext()) {
                    if (range.containsVersion((ArtifactVersion)iter.next())) continue;
                    iter.remove();
                }
                if (!versions.isEmpty()) {
                    ArtifactVersion maxArtifactVersion = (ArtifactVersion)Collections.max(versions);
                    artifact.setVersion(maxArtifactVersion.toString());
                    this.log.debug((CharSequence)("DependencyManagement resolved: " + artifact.getId()));
                }
            }
            url = ProjectInfoReportUtils.getArtifactUrl(this.repositorySystem, artifact, this.projectBuilder, this.buildingRequest);
            MavenProject artifactProject = this.repoUtils.getMavenProjectFromRepository(artifact);
            List licenses = artifactProject.getLicenses();
            for (License license : licenses) {
                String licenseCell = ProjectInfoReportUtils.getArtifactIdCell(license.getName(), license.getUrl());
                if (licensesBuffer.length() > 0) {
                    licensesBuffer.append(", ");
                }
                licensesBuffer.append(licenseCell);
            }
        }
        catch (InvalidVersionSpecificationException e) {
            this.log.warn((CharSequence)("Unable to parse version for " + artifact.getId()), (Throwable)e);
        }
        catch (ArtifactMetadataRetrievalException e) {
            this.log.warn((CharSequence)("Unable to retrieve versions for " + artifact.getId() + " from repository."), (Throwable)e);
        }
        catch (ProjectBuildingException e) {
            if (this.log.isDebugEnabled()) {
                this.log.warn((CharSequence)("Unable to create Maven project for " + artifact.getId() + " from repository."), (Throwable)e);
            }
            this.log.warn((CharSequence)("Unable to create Maven project for " + artifact.getId() + " from repository."));
        }
        String artifactIdCell = ProjectInfoReportUtils.getArtifactIdCell(artifact.getArtifactId(), url);
        if (hasClassifier) {
            return new String[]{dependency.getGroupId(), artifactIdCell, dependency.getVersion(), dependency.getClassifier(), dependency.getType(), licensesBuffer.toString()};
        }
        return new String[]{dependency.getGroupId(), artifactIdCell, dependency.getVersion(), dependency.getType(), licensesBuffer.toString()};
    }

    private Comparator<Dependency> getDependencyComparator() {
        return new Comparator<Dependency>(){

            @Override
            public int compare(Dependency a1, Dependency a2) {
                int result = a1.getGroupId().compareTo(a2.getGroupId());
                if (result != 0) {
                    return result;
                }
                result = a1.getArtifactId().compareTo(a2.getArtifactId());
                if (result != 0) {
                    return result;
                }
                result = a1.getType().compareTo(a2.getType());
                if (result != 0) {
                    return result;
                }
                if (a1.getClassifier() == null) {
                    if (a2.getClassifier() != null) {
                        return 1;
                    }
                } else if (a2.getClassifier() != null) {
                    result = a1.getClassifier().compareTo(a2.getClassifier());
                } else {
                    return -1;
                }
                if (result != 0) {
                    return result;
                }
                return a1.getVersion().compareTo(a2.getVersion());
            }
        };
    }
}

