/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.report.projectinfo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.report.projectinfo.AbstractProjectInfoReport;
import org.apache.maven.report.projectinfo.ProjectInfoReportUtils;
import org.apache.maven.reporting.AbstractMavenReportRenderer;
import org.codehaus.plexus.i18n.I18N;
import org.codehaus.plexus.util.StringUtils;

public class PluginManagementReport
extends AbstractProjectInfoReport {
    private MavenProjectBuilder mavenProjectBuilder;
    private ArtifactFactory artifactFactory;

    public String getName(Locale locale) {
        return this.i18n.getString("project-info-report", locale, "report.pluginManagement.name");
    }

    public String getDescription(Locale locale) {
        return this.i18n.getString("project-info-report", locale, "report.pluginManagement.description");
    }

    public void executeReport(Locale locale) {
        PluginManagementRenderer r = new PluginManagementRenderer(this.getLog(), this.getSink(), locale, this.i18n, this.project.getPluginManagement().getPlugins(), this.project, this.mavenProjectBuilder, this.artifactFactory, this.localRepository);
        r.render();
    }

    public String getOutputName() {
        return "plugin-management";
    }

    public boolean canGenerateReport() {
        return this.project.getPluginManagement() != null && this.project.getPluginManagement().getPlugins() != null && !this.project.getPluginManagement().getPlugins().isEmpty();
    }

    protected static class PluginManagementRenderer
    extends AbstractMavenReportRenderer {
        private final Log log;
        private final List pluginManagement;
        private final Locale locale;
        private final I18N i18n;
        private final MavenProject project;
        private final MavenProjectBuilder mavenProjectBuilder;
        private final ArtifactFactory artifactFactory;
        private final ArtifactRepository localRepository;

        public PluginManagementRenderer(Log log, Sink sink, Locale locale, I18N i18n, List plugins, MavenProject project, MavenProjectBuilder mavenProjectBuilder, ArtifactFactory artifactFactory, ArtifactRepository localRepository) {
            super(sink);
            this.log = log;
            this.locale = locale;
            this.pluginManagement = plugins;
            this.i18n = i18n;
            this.project = project;
            this.mavenProjectBuilder = mavenProjectBuilder;
            this.artifactFactory = artifactFactory;
            this.localRepository = localRepository;
        }

        public String getTitle() {
            return this.getReportString("report.pluginManagement.title");
        }

        public void renderBody() {
            this.renderSectionPluginManagement();
        }

        private void renderSectionPluginManagement() {
            String[] tableHeader = this.getPluginTableHeader();
            this.startSection(this.getTitle());
            Collections.sort(this.pluginManagement, this.getPluginComparator());
            this.startTable();
            this.tableHeader(tableHeader);
            Iterator iterator = this.pluginManagement.iterator();
            while (iterator.hasNext()) {
                Plugin plugin = (Plugin)iterator.next();
                VersionRange versionRange = StringUtils.isEmpty((String)plugin.getVersion()) ? VersionRange.createFromVersion((String)"RELEASE") : VersionRange.createFromVersion((String)plugin.getVersion());
                Artifact pluginArtifact = this.artifactFactory.createParentArtifact(plugin.getGroupId(), plugin.getArtifactId(), versionRange.toString());
                ArrayList artifactRepositories = this.project.getPluginArtifactRepositories();
                if (artifactRepositories == null) {
                    artifactRepositories = new ArrayList();
                }
                try {
                    MavenProject pluginProject = this.mavenProjectBuilder.buildFromRepository(pluginArtifact, artifactRepositories, this.localRepository);
                    this.tableRow(this.getPluginRow(pluginProject.getGroupId(), pluginProject.getArtifactId(), pluginProject.getVersion(), pluginProject.getUrl()));
                }
                catch (ProjectBuildingException e) {
                    this.log.info((CharSequence)("Could not build project for: " + plugin.getArtifactId() + ":" + e.getMessage()), (Throwable)e);
                    this.tableRow(this.getPluginRow(plugin.getGroupId(), plugin.getArtifactId(), plugin.getVersion(), null));
                }
            }
            this.endTable();
            this.endSection();
        }

        private String[] getPluginTableHeader() {
            String groupId = this.getReportString("report.dependencyManagement.column.groupId");
            String artifactId = this.getReportString("report.dependencyManagement.column.artifactId");
            String version = this.getReportString("report.dependencyManagement.column.version");
            return new String[]{groupId, artifactId, version};
        }

        private String[] getPluginRow(String groupId, String artifactId, String version, String link) {
            artifactId = ProjectInfoReportUtils.getArtifactIdCell(artifactId, link);
            return new String[]{groupId, artifactId, version};
        }

        private Comparator getPluginComparator() {
            return new Comparator(){

                public int compare(Object o1, Object o2) {
                    Plugin a1 = (Plugin)o1;
                    Plugin a2 = (Plugin)o2;
                    int result = a1.getGroupId().compareTo(a2.getGroupId());
                    if (result == 0) {
                        result = a1.getArtifactId().compareTo(a2.getArtifactId());
                    }
                    return result;
                }
            };
        }

        private String getReportString(String key) {
            return this.i18n.getString("project-info-report", this.locale, key);
        }
    }
}

