/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.report.projectinfo;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.model.MailingList;
import org.apache.maven.model.Model;
import org.apache.maven.report.projectinfo.AbstractProjectInfoReport;
import org.apache.maven.reporting.AbstractMavenReportRenderer;
import org.codehaus.plexus.i18n.I18N;
import org.codehaus.plexus.util.StringUtils;

public class MailingListsReport
extends AbstractProjectInfoReport {
    public String getName(Locale locale) {
        return this.i18n.getString("project-info-report", locale, "report.mailing-lists.name");
    }

    public String getDescription(Locale locale) {
        return this.i18n.getString("project-info-report", locale, "report.mailing-lists.description");
    }

    public void executeReport(Locale locale) {
        MailingListsRenderer r = new MailingListsRenderer(this.getSink(), this.getProject().getModel(), this.i18n, locale);
        r.render();
    }

    public String getOutputName() {
        return "mail-lists";
    }

    protected static class MailingListsRenderer
    extends AbstractMavenReportRenderer {
        private Model model;
        private I18N i18n;
        private Locale locale;
        private static final String[] EMPTY_STRING_ARRAY = new String[0];

        MailingListsRenderer(Sink sink, Model model, I18N i18n, Locale locale) {
            super(sink);
            this.model = model;
            this.i18n = i18n;
            this.locale = locale;
        }

        public String getTitle() {
            return this.i18n.getString("project-info-report", this.locale, "report.mailing-lists.title");
        }

        public void renderBody() {
            List mailingLists = this.model.getMailingLists();
            if (mailingLists == null || mailingLists.isEmpty()) {
                this.startSection(this.getTitle());
                this.paragraph(this.i18n.getString("project-info-report", this.locale, "report.mailing-lists.nolist"));
                this.endSection();
                return;
            }
            this.startSection(this.getTitle());
            this.paragraph(this.i18n.getString("project-info-report", this.locale, "report.mailing-lists.intro"));
            this.startTable();
            boolean otherArchives = false;
            Iterator i = mailingLists.iterator();
            while (i.hasNext()) {
                MailingList m = (MailingList)i.next();
                if (m.getOtherArchives() == null || m.getOtherArchives().isEmpty()) continue;
                otherArchives = true;
            }
            String name = this.i18n.getString("project-info-report", this.locale, "report.mailing-lists.column.name");
            String subscribe = this.i18n.getString("project-info-report", this.locale, "report.mailing-lists.column.subscribe");
            String unsubscribe = this.i18n.getString("project-info-report", this.locale, "report.mailing-lists.column.unsubscribe");
            String post = this.i18n.getString("project-info-report", this.locale, "report.mailing-lists.column.post");
            String archive = this.i18n.getString("project-info-report", this.locale, "report.mailing-lists.column.archive");
            String archivesOther = this.i18n.getString("project-info-report", this.locale, "report.mailing-lists.column.otherArchives");
            if (otherArchives) {
                this.tableHeader(new String[]{name, subscribe, unsubscribe, post, archive, archivesOther});
            } else {
                this.tableHeader(new String[]{name, subscribe, unsubscribe, post, archive});
            }
            Iterator i2 = this.model.getMailingLists().iterator();
            while (i2.hasNext()) {
                MailingList mailingList = (MailingList)i2.next();
                ArrayList<String> textRow = new ArrayList<String>();
                textRow.add(mailingList.getName());
                textRow.add(MailingListsRenderer.createLinkPatternedText((String)subscribe, (String)mailingList.getSubscribe()));
                textRow.add(MailingListsRenderer.createLinkPatternedText((String)unsubscribe, (String)mailingList.getUnsubscribe()));
                if (mailingList.getPost() != null && mailingList.getPost().length() > 0) {
                    textRow.add(MailingListsRenderer.createLinkPatternedText((String)post, (String)mailingList.getPost()));
                } else {
                    textRow.add("-");
                }
                if (mailingList.getArchive() != null && mailingList.getArchive().length() > 0) {
                    textRow.add(MailingListsRenderer.createLinkPatternedText((String)MailingListsRenderer.getArchiveServer(mailingList.getArchive()), (String)mailingList.getArchive()));
                } else {
                    textRow.add("-");
                }
                if (mailingList.getOtherArchives() != null && !mailingList.getOtherArchives().isEmpty()) {
                    Iterator it = mailingList.getOtherArchives().iterator();
                    String otherArchive = it.next().toString();
                    textRow.add(MailingListsRenderer.createLinkPatternedText((String)MailingListsRenderer.getArchiveServer(otherArchive), (String)otherArchive));
                    this.tableRow(textRow.toArray(EMPTY_STRING_ARRAY));
                    while (it.hasNext()) {
                        otherArchive = (String)it.next();
                        textRow = new ArrayList();
                        textRow.add(" ");
                        textRow.add(" ");
                        textRow.add(" ");
                        textRow.add(" ");
                        textRow.add(" ");
                        textRow.add(MailingListsRenderer.createLinkPatternedText((String)MailingListsRenderer.getArchiveServer(otherArchive), (String)otherArchive));
                        this.tableRow(textRow.toArray(EMPTY_STRING_ARRAY));
                    }
                    continue;
                }
                if (otherArchives) {
                    textRow.add(null);
                }
                this.tableRow(textRow.toArray(EMPTY_STRING_ARRAY));
            }
            this.endTable();
            this.endSection();
        }

        private static String getArchiveServer(String uri) {
            if (StringUtils.isEmpty((String)uri)) {
                return "???UNKNOWN???";
            }
            int at = uri.indexOf("//");
            int fromIndex = at >= 0 ? (uri.lastIndexOf("/", at - 1) >= 0 ? 0 : at + 2) : 0;
            int from = uri.indexOf("/", fromIndex);
            if (from == -1) {
                return uri.substring(at + 2);
            }
            return uri.substring(at + 2, from);
        }
    }
}

