/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.pmd.exec;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PmdRequest
implements Serializable {
    private static final long serialVersionUID = -6324416880563476455L;
    private String javaExecutable;
    private String language;
    private String languageVersion;
    private int minimumPriority;
    private String auxClasspath;
    private String suppressMarker;
    private String analysisCacheLocation;
    private List<String> rulesets;
    private String sourceEncoding;
    private List<File> files = new ArrayList<File>();
    private String logLevel;
    private boolean skipPmdError;
    private String excludeFromFailureFile;
    private String targetDirectory;
    private String outputEncoding;
    private String format;
    private String benchmarkOutputLocation;
    private boolean includeXmlInSite;
    private String reportOutputDirectory;

    public void setLanguageAndVersion(String language, String targetJdk) {
        if ("java".equals(language) || null == language) {
            this.language = "java";
            this.languageVersion = targetJdk;
        } else {
            this.language = "javascript".equals(language) || "ecmascript".equals(language) ? "ecmascript" : ("jsp".equals(language) ? "jsp" : language);
        }
    }

    public void setJavaExecutable(String javaExecutable) {
        this.javaExecutable = javaExecutable;
    }

    public void setMinimumPriority(int minimumPriority) {
        this.minimumPriority = minimumPriority;
    }

    public void setAuxClasspath(String auxClasspath) {
        this.auxClasspath = auxClasspath;
    }

    public void setSuppressMarker(String suppressMarker) {
        this.suppressMarker = suppressMarker;
    }

    public void setAnalysisCacheLocation(String analysisCacheLocation) {
        this.analysisCacheLocation = analysisCacheLocation;
    }

    public void setRulesets(List<String> rulesets) {
        this.rulesets = rulesets;
    }

    public void setSourceEncoding(String sourceEncoding) {
        this.sourceEncoding = sourceEncoding;
    }

    public void addFiles(Collection<File> files) {
        this.files.addAll(files);
    }

    public void setBenchmarkOutputLocation(String benchmarkOutputLocation) {
        this.benchmarkOutputLocation = benchmarkOutputLocation;
    }

    public void setTargetDirectory(String targetDirectory) {
        this.targetDirectory = targetDirectory;
    }

    public void setOutputEncoding(String outputEncoding) {
        this.outputEncoding = outputEncoding;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setLogLevel(String logLevel) {
        this.logLevel = logLevel;
    }

    public void setSkipPmdError(boolean skipPmdError) {
        this.skipPmdError = skipPmdError;
    }

    public void setIncludeXmlInSite(boolean includeXmlInSite) {
        this.includeXmlInSite = includeXmlInSite;
    }

    public void setReportOutputDirectory(String reportOutputDirectory) {
        this.reportOutputDirectory = reportOutputDirectory;
    }

    public void setExcludeFromFailureFile(String excludeFromFailureFile) {
        this.excludeFromFailureFile = excludeFromFailureFile;
    }

    public String getJavaExecutable() {
        return this.javaExecutable;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getLanguageVersion() {
        return this.languageVersion;
    }

    public int getMinimumPriority() {
        return this.minimumPriority;
    }

    public String getAuxClasspath() {
        return this.auxClasspath;
    }

    public String getSuppressMarker() {
        return this.suppressMarker;
    }

    public String getAnalysisCacheLocation() {
        return this.analysisCacheLocation;
    }

    public List<String> getRulesets() {
        return this.rulesets;
    }

    public String getSourceEncoding() {
        return this.sourceEncoding;
    }

    public List<File> getFiles() {
        return this.files;
    }

    public String getBenchmarkOutputLocation() {
        return this.benchmarkOutputLocation;
    }

    public String getTargetDirectory() {
        return this.targetDirectory;
    }

    public String getOutputEncoding() {
        return this.outputEncoding;
    }

    public String getFormat() {
        return this.format;
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public boolean isDebugEnabled() {
        return "debug".equals(this.logLevel);
    }

    public boolean isSkipPmdError() {
        return this.skipPmdError;
    }

    public boolean isIncludeXmlInSite() {
        return this.includeXmlInSite;
    }

    public String getReportOutputDirectory() {
        return this.reportOutputDirectory;
    }

    public String getExcludeFromFailureFile() {
        return this.excludeFromFailureFile;
    }
}

