/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.pmd.exec;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import org.apache.maven.cli.logging.Slf4jConfiguration;
import org.apache.maven.cli.logging.Slf4jConfigurationFactory;
import org.codehaus.plexus.logging.console.ConsoleLogger;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class Executor {
    private static final Logger LOG = LoggerFactory.getLogger(Executor.class);

    Executor() {
    }

    protected void setupLogLevel(String logLevel) {
        ILoggerFactory slf4jLoggerFactory = LoggerFactory.getILoggerFactory();
        Slf4jConfiguration slf4jConfiguration = Slf4jConfigurationFactory.getConfiguration((ILoggerFactory)slf4jLoggerFactory);
        if ("debug".equals(logLevel)) {
            slf4jConfiguration.setRootLoggerLevel(Slf4jConfiguration.Level.DEBUG);
        } else if ("info".equals(logLevel)) {
            slf4jConfiguration.setRootLoggerLevel(Slf4jConfiguration.Level.INFO);
        } else {
            slf4jConfiguration.setRootLoggerLevel(Slf4jConfiguration.Level.ERROR);
        }
        slf4jConfiguration.activate();
    }

    protected static String buildClasspath() {
        StringBuilder classpath = new StringBuilder();
        ClassLoader pluginClassloader = Executor.class.getClassLoader();
        Executor.buildClasspath(classpath, pluginClassloader);
        ClassLoader coreClassloader = ConsoleLogger.class.getClassLoader();
        Executor.buildClasspath(classpath, coreClassloader);
        return classpath.toString();
    }

    static void buildClasspath(StringBuilder classpath, ClassLoader cl) {
        if (cl instanceof URLClassLoader) {
            for (URL url : ((URLClassLoader)cl).getURLs()) {
                if (!"file".equalsIgnoreCase(url.getProtocol())) continue;
                try {
                    String filename = URLDecoder.decode(url.getPath(), StandardCharsets.UTF_8.name());
                    classpath.append(new File(filename).getPath()).append(File.pathSeparatorChar);
                }
                catch (UnsupportedEncodingException e) {
                    LOG.warn("Ignoring " + url + " in classpath due to UnsupportedEncodingException", (Throwable)e);
                }
            }
        }
    }

    protected static class ProcessStreamHandler
    implements Runnable {
        private static final int BUFFER_SIZE = 8192;
        private final BufferedInputStream in;
        private final BufferedOutputStream out;

        public static void start(InputStream in, OutputStream out) {
            Thread t = new Thread(new ProcessStreamHandler(in, out));
            t.start();
        }

        private ProcessStreamHandler(InputStream in, OutputStream out) {
            this.in = new BufferedInputStream(in);
            this.out = new BufferedOutputStream(out);
        }

        @Override
        public void run() {
            byte[] buffer = new byte[8192];
            try {
                int count = this.in.read(buffer);
                while (count != -1) {
                    this.out.write(buffer, 0, count);
                    this.out.flush();
                    count = this.in.read(buffer);
                }
                this.out.flush();
            }
            catch (IOException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

