/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.pmd;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.sourceforge.pmd.RuleViolation;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.pmd.ExcludeFromFile;
import org.apache.maven.plugins.pmd.model.Violation;

public class ExcludeViolationsFromFile
implements ExcludeFromFile<Violation> {
    private Map<String, Set<String>> excludeFromFailureClasses = new HashMap<String, Set<String>>();

    @Override
    public void loadExcludeFromFailuresData(String excludeFromFailureFile) throws MojoExecutionException {
        if (excludeFromFailureFile == null || excludeFromFailureFile.isEmpty()) {
            return;
        }
        File file = new File(excludeFromFailureFile);
        if (!file.exists()) {
            return;
        }
        Properties props = new Properties();
        try (FileInputStream fileInputStream = new FileInputStream(new File(excludeFromFailureFile));){
            props.load(fileInputStream);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot load properties file " + excludeFromFailureFile, (Exception)e);
        }
        for (Map.Entry<Object, Object> propEntry : props.entrySet()) {
            String[] excludedRules;
            HashSet<String> excludedRuleSet = new HashSet<String>();
            String className = propEntry.getKey().toString();
            for (String excludedRule : excludedRules = propEntry.getValue().toString().split(",")) {
                excludedRuleSet.add(excludedRule.trim());
            }
            this.excludeFromFailureClasses.put(className, excludedRuleSet);
        }
    }

    @Override
    public boolean isExcludedFromFailure(Violation errorDetail) {
        String className = this.extractClassName(errorDetail.getViolationPackage(), errorDetail.getViolationClass(), errorDetail.getFileName());
        return this.isExcludedFromFailure(className, errorDetail.getRule());
    }

    @Override
    public boolean isExcludedFromFailure(RuleViolation errorDetail) {
        String className = this.extractClassName(errorDetail.getPackageName(), errorDetail.getClassName(), errorDetail.getFilename());
        return this.isExcludedFromFailure(className, errorDetail.getRule().getName());
    }

    @Override
    public int countExclusions() {
        int result = 0;
        for (Set<String> rules : this.excludeFromFailureClasses.values()) {
            result += rules.size();
        }
        return result;
    }

    private boolean isExcludedFromFailure(String className, String ruleName) {
        Set<String> excludedRuleSet = this.excludeFromFailureClasses.get(className);
        return excludedRuleSet != null && excludedRuleSet.contains(ruleName);
    }

    private String extractClassName(String packageName, String className, String fullPath) {
        String fileName;
        if (packageName != null && !packageName.isEmpty() && className != null && !className.isEmpty()) {
            return packageName + "." + className;
        }
        if (packageName != null && !packageName.isEmpty()) {
            String fileName2 = fullPath;
            fileName2 = fileName2.substring(fileName2.lastIndexOf(File.separatorChar) + 1);
            fileName2 = fileName2.substring(0, fileName2.length() - 5);
            return packageName + "." + fileName2;
        }
        int javaIdx = (fileName = fullPath).indexOf(File.separator + "java" + File.separator);
        return fileName.substring(javaIdx >= 0 ? javaIdx + 6 : 0, fileName.length() - 5).replace(File.separatorChar, '.');
    }
}

