/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.invoker;

import java.util.List;
import java.util.Locale;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.invoker.model.BuildJob;
import org.apache.maven.reporting.AbstractMavenReportRenderer;
import org.codehaus.plexus.i18n.I18N;

public class InvokerReportRenderer
extends AbstractMavenReportRenderer {
    private final I18N i18n;
    private final Locale locale;
    private final Log log;
    private final List<BuildJob> buildJobs;

    public InvokerReportRenderer(Sink sink, I18N i18n, Locale locale, Log log, List<BuildJob> buildJobs) {
        super(sink);
        this.i18n = i18n;
        this.locale = locale;
        this.log = log;
        this.buildJobs = buildJobs;
    }

    public String getTitle() {
        return this.getI18nString("title");
    }

    private String getI18nString(String key) {
        return this.i18n.getString("invoker-report", this.locale, "report.invoker." + key);
    }

    private String formatI18nString(String key, Object ... args) {
        return this.i18n.format("invoker-report", this.locale, "report.invoker." + key, args);
    }

    protected void renderBody() {
        this.startSection(this.getTitle());
        this.paragraph(this.getI18nString("description"));
        this.renderSectionSummary();
        this.renderSectionDetails();
        this.endSection();
    }

    private void renderSectionSummary() {
        this.startSection(this.getI18nString("summary.title"));
        this.startTable();
        this.tableHeader(new String[]{this.getI18nString("summary.builds"), this.getI18nString("summary.success"), this.getI18nString("summary.failures"), this.getI18nString("summary.skipped"), this.getI18nString("summary.successrate"), this.getI18nString("summary.time")});
        int totalBuilds = this.buildJobs.size();
        int totalSuccess = 0;
        int totalFailures = 0;
        int totalSkipped = 0;
        float totalTime = 0.0f;
        for (BuildJob buildJob : this.buildJobs) {
            switch (buildJob.getResult()) {
                case "success": {
                    ++totalSuccess;
                    break;
                }
                case "skipped": {
                    ++totalSkipped;
                    break;
                }
                default: {
                    ++totalFailures;
                }
            }
            totalTime += buildJob.getTime();
        }
        this.tableRow(new String[]{Integer.toString(totalBuilds), Integer.toString(totalSuccess), Integer.toString(totalFailures), Integer.toString(totalSkipped), totalSuccess + totalFailures > 0 ? this.formatI18nString("value.successrate", Float.valueOf((float)totalSuccess / (float)(totalSuccess + totalFailures))) : "", this.formatI18nString("value.time", Float.valueOf(totalTime))});
        this.endTable();
        this.endSection();
    }

    private void renderSectionDetails() {
        this.startSection(this.getI18nString("detail.title"));
        this.startTable();
        this.tableHeader(new String[]{this.getI18nString("detail.name"), this.getI18nString("detail.result"), this.getI18nString("detail.time"), this.getI18nString("detail.message")});
        for (BuildJob buildJob : this.buildJobs) {
            this.renderBuildJob(buildJob);
        }
        this.endTable();
        this.endSection();
    }

    private void renderBuildJob(BuildJob buildJob) {
        this.tableRow(new String[]{this.getBuildJobReportName(buildJob), buildJob.getResult(), this.formatI18nString("value.time", Float.valueOf(buildJob.getTime())), buildJob.getFailureMessage()});
    }

    private String getBuildJobReportName(BuildJob buildJob) {
        boolean isReportJobNameComplete;
        String buildJobName = buildJob.getName();
        String buildJobDescription = buildJob.getDescription();
        boolean emptyJobName = buildJobName == null || buildJobName.isEmpty();
        boolean emptyJobDescription = buildJobDescription == null || buildJobDescription.isEmpty();
        boolean bl = isReportJobNameComplete = !emptyJobName && !emptyJobDescription;
        if (isReportJobNameComplete) {
            return this.formatI18nString("text.name_with_description", buildJobName, buildJobDescription);
        }
        String buildJobProject = buildJob.getProject();
        if (!emptyJobName) {
            this.log.warn((CharSequence)InvokerReportRenderer.incompleteNameWarning("description", buildJobProject));
        } else if (!emptyJobDescription) {
            this.log.warn((CharSequence)InvokerReportRenderer.incompleteNameWarning("name", buildJobProject));
        }
        return buildJobProject;
    }

    private static String incompleteNameWarning(String missing, String pom) {
        return "Incomplete job name-description: " + missing + " is missing. POM (" + pom + ") will be used in place of job name!";
    }
}

