/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.help;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.model.InputLocation;
import org.apache.maven.model.InputSource;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.model.io.xpp3.MavenXpp3WriterEx;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.help.AbstractEffectiveMojo;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.utils.logging.MessageUtils;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import org.codehaus.plexus.util.xml.XMLWriter;

@Mojo(name="effective-pom", aggregator=true)
public class EffectivePomMojo
extends AbstractEffectiveMojo {
    @Parameter(defaultValue="${reactorProjects}", required=true, readonly=true)
    private List<MavenProject> projects;
    @Parameter(defaultValue="${mojo}", required=true, readonly=true)
    private MojoExecution mojoExecution;
    @Parameter(property="artifact")
    private String artifact;
    @Parameter(property="verbose", defaultValue="false")
    private boolean verbose = false;

    public void execute() throws MojoExecutionException {
        if (StringUtils.isNotEmpty((String)this.artifact)) {
            this.project = this.getMavenProject(this.artifact);
            this.projects = Collections.singletonList(this.project);
        }
        StringWriter w = new StringWriter();
        String encoding = this.output != null ? this.project.getModel().getModelEncoding() : System.getProperty("file.encoding");
        PrettyPrintXMLWriter writer = new PrettyPrintXMLWriter((Writer)w, StringUtils.repeat((String)" ", (int)2), encoding, null);
        EffectivePomMojo.writeHeader((XMLWriter)writer);
        if (this.shouldWriteAllEffectivePOMsInReactor()) {
            writer.startElement("projects");
            for (MavenProject subProject : this.projects) {
                this.writeEffectivePom(subProject, (XMLWriter)writer);
            }
            writer.endElement();
        } else {
            this.writeEffectivePom(this.project, (XMLWriter)writer);
        }
        String effectivePom = EffectivePomMojo.prettyFormat(w.toString(), encoding, false);
        if (this.verbose) {
            effectivePom = effectivePom.replaceAll("(?m)>\\s+<!--}", ">  <!-- ");
        }
        if (this.output != null) {
            try {
                EffectivePomMojo.writeXmlFile(this.output, effectivePom);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Cannot write effective-POM to output: " + this.output, (Exception)e);
            }
            this.getLog().info((CharSequence)("Effective-POM written to: " + this.output));
        } else {
            if (MessageUtils.isColorEnabled()) {
                String comment = MessageUtils.buffer().project((Object)"<!--.-->").toString();
                int dotIndex = comment.indexOf(".");
                String commentStart = comment.substring(0, dotIndex);
                String commentEnd = comment.substring(dotIndex + 1);
                effectivePom = effectivePom.replace("<!--", commentStart).replace("-->", commentEnd);
            }
            this.getLog().info((CharSequence)(LS + "Effective POMs, after inheritance, interpolation, and profiles are applied:" + LS + LS + effectivePom + LS));
        }
    }

    private boolean shouldWriteAllEffectivePOMsInReactor() {
        MojoExecution.Source source = this.mojoExecution.getSource();
        return this.projects.size() > 1 && (source == MojoExecution.Source.CLI || this.projects.get(0).equals((Object)this.project));
    }

    private void writeEffectivePom(MavenProject project, XMLWriter writer) throws MojoExecutionException {
        Model pom = project.getModel();
        EffectivePomMojo.cleanModel(pom);
        StringWriter sWriter = new StringWriter();
        try {
            if (this.verbose) {
                MavenXpp3WriterEx mavenXpp3WriterEx = new MavenXpp3WriterEx();
                mavenXpp3WriterEx.setStringFormatter((InputLocation.StringFormatter)new InputLocationStringFormatter());
                mavenXpp3WriterEx.write((Writer)sWriter, pom);
            } else {
                new MavenXpp3Writer().write((Writer)sWriter, pom);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot serialize POM to XML.", (Exception)e);
        }
        String effectivePom = EffectivePomMojo.prettyFormat(sWriter.toString(), null, true);
        EffectivePomMojo.writeComment(writer, "Effective POM for project '" + project.getId() + "'");
        writer.writeMarkup(effectivePom);
    }

    private static void cleanModel(Model pom) {
        AbstractEffectiveMojo.SortedProperties properties = new AbstractEffectiveMojo.SortedProperties();
        properties.putAll((Map<?, ?>)pom.getProperties());
        pom.setProperties((Properties)properties);
    }

    private static class InputLocationStringFormatter
    extends InputLocation.StringFormatter {
        private InputLocationStringFormatter() {
        }

        public String toString(InputLocation location) {
            InputSource source = location.getSource();
            String s = source.getModelId();
            if (StringUtils.isBlank((String)s) || s.contains("[unknown-version]")) {
                s = source.toString();
            }
            return '}' + s + (location.getLineNumber() >= 0 ? ", line " + location.getLineNumber() : "") + ' ';
        }
    }
}

