/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.help;

import java.io.IOException;
import java.util.Properties;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.help.AbstractHelpMojo;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineUtils;

@Mojo(name="system", requiresProject=false)
public class SystemMojo
extends AbstractHelpMojo {
    private static final int REPEAT = 25;

    public void execute() throws MojoExecutionException {
        StringBuilder message = new StringBuilder();
        message.append(LS);
        message.append(StringUtils.repeat((String)"=", (int)79)).append(LS);
        message.append(StringUtils.repeat((String)"=", (int)25));
        message.append(" Platform Properties Details ");
        message.append(StringUtils.repeat((String)"=", (int)25)).append(LS);
        message.append(StringUtils.repeat((String)"=", (int)79)).append(LS);
        message.append(LS);
        message.append(StringUtils.repeat((String)"=", (int)79)).append(LS);
        message.append("System Properties").append(LS);
        message.append(StringUtils.repeat((String)"=", (int)79)).append(LS);
        Properties systemProperties = System.getProperties();
        for (String string : systemProperties.stringPropertyNames()) {
            message.append(LS);
            message.append(string).append("=").append(systemProperties.getProperty(string));
        }
        message.append(LS).append(LS);
        message.append(StringUtils.repeat((String)"=", (int)79)).append(LS);
        message.append("Environment Variables").append(LS);
        message.append(StringUtils.repeat((String)"=", (int)79)).append(LS);
        try {
            Properties envVars = CommandLineUtils.getSystemEnvVars();
            for (String key : envVars.stringPropertyNames()) {
                message.append(LS);
                message.append(key).append("=").append(envVars.getProperty(key));
            }
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)("Unable to get the environment variables: " + e.getMessage()));
        }
        message.append(LS);
        if (this.output != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("Generated by Maven Help Plugin").append(LS);
            sb.append("See: https://maven.apache.org/plugins/maven-help-plugin/").append(LS).append(LS);
            sb.append(message.toString());
            try {
                SystemMojo.writeFile(this.output, sb);
            }
            catch (IOException iOException) {
                throw new MojoExecutionException("Cannot write system report to output: " + this.output, (Exception)iOException);
            }
            this.getLog().info((CharSequence)("System report written to: " + this.output));
        } else {
            this.getLog().info((CharSequence)message);
        }
    }
}

