/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.help;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.model.Profile;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.help.AbstractHelpMojo;
import org.apache.maven.project.MavenProject;

public class ActiveProfilesMojo
extends AbstractHelpMojo {
    private List projects;

    public void execute() throws MojoExecutionException {
        StringBuffer message = new StringBuffer();
        Iterator it = this.projects.iterator();
        while (it.hasNext()) {
            MavenProject project = (MavenProject)it.next();
            this.getActiveProfileStatement(project, message);
            message.append("\n\n");
        }
        if (this.output != null) {
            StringBuffer sb = new StringBuffer();
            sb.append("Created by: " + ((Object)((Object)this)).getClass().getName()).append("\n");
            sb.append("Created on: " + new Date()).append("\n").append("\n");
            sb.append(message.toString());
            try {
                ActiveProfilesMojo.writeFile(this.output, sb);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Cannot write active profiles to output: " + this.output, (Exception)e);
            }
            if (this.getLog().isInfoEnabled()) {
                this.getLog().info((CharSequence)("Active profile report written to: " + this.output));
            }
        } else if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)message);
        }
    }

    private void getActiveProfileStatement(MavenProject project, StringBuffer message) {
        ArrayList profiles = new ArrayList(project.getActiveProfiles());
        message.append("\n");
        message.append("Active Profiles for Project '" + project.getId() + "': \n\n");
        if (profiles == null || profiles.isEmpty()) {
            message.append("There are no active profiles.");
        } else {
            message.append("The following profiles are active:\n");
            Iterator it = profiles.iterator();
            while (it.hasNext()) {
                Profile profile = (Profile)it.next();
                message.append("\n - ").append(profile.getId());
                message.append(" (source: ").append(profile.getSource()).append(")");
            }
        }
        message.append("\n");
    }
}

