/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.ear;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.zip.ZipException;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.ear.AbstractEarMojo;
import org.apache.maven.plugin.ear.EarModule;
import org.apache.maven.plugin.ear.EarModuleFactory;
import org.apache.maven.plugin.ear.Ejb3Module;
import org.apache.maven.plugin.ear.JarModule;
import org.apache.maven.plugin.ear.JavaModule;
import org.apache.maven.plugin.ear.util.EarMavenArchiver;
import org.apache.maven.plugin.ear.util.JavaEEVersion;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.shared.filtering.MavenFileFilter;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.apache.maven.shared.filtering.MavenResourcesExecution;
import org.apache.maven.shared.filtering.MavenResourcesFiltering;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.jar.Manifest;
import org.codehaus.plexus.archiver.jar.ManifestException;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.archiver.zip.ZipArchiver;
import org.codehaus.plexus.archiver.zip.ZipUnArchiver;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

public class EarMojo
extends AbstractEarMojo {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private File earSourceDirectory;
    private String earSourceIncludes;
    private String earSourceExcludes;
    private boolean filtering;
    private List filters;
    private List nonFilteredFileExtensions;
    private boolean escapedBackslashesInFilePath;
    protected String escapeString;
    private File manifestFile;
    private String applicationXml;
    private String outputDirectory;
    private String finalName;
    private String unpackTypes;
    private String classifier;
    private String packagingExcludes;
    private String packagingIncludes;
    private boolean skinnyWars;
    private JarArchiver jarArchiver;
    private ZipArchiver zipArchiver;
    private ZipUnArchiver zipUnArchiver;
    private MavenArchiveConfiguration archive = new MavenArchiveConfiguration();
    private MavenProjectHelper projectHelper;
    private ArchiverManager archiverManager;
    private MavenFileFilter mavenFileFilter;
    private MavenResourcesFiltering mavenResourcesFiltering;
    private MavenSession session;
    private List filterWrappers;

    public void execute() throws MojoExecutionException, MojoFailureException {
        super.execute();
        JavaEEVersion javaEEVersion = JavaEEVersion.getJavaEEVersion(this.version);
        List<Object> unpackTypesList = new ArrayList();
        if (this.unpackTypes != null) {
            unpackTypesList = Arrays.asList(this.unpackTypes.split(","));
            for (String string : unpackTypesList) {
                if (EarModuleFactory.standardArtifactTypes.contains(string)) continue;
                throw new MojoExecutionException("Invalid type [" + string + "] supported types are " + EarModuleFactory.standardArtifactTypes);
            }
            this.getLog().debug((CharSequence)("Initialized unpack types " + unpackTypesList));
        }
        try {
            for (EarModule earModule : this.getModules()) {
                if (earModule instanceof JavaModule) {
                    this.getLog().warn((CharSequence)("JavaModule is deprecated (" + earModule + "), please use JarModule instead."));
                }
                if (earModule instanceof Ejb3Module) {
                    this.getLog().warn((CharSequence)("Ejb3Module is deprecated (" + earModule + "), please use EjbModule instead."));
                }
                File sourceFile = earModule.getArtifact().getFile();
                File destinationFile = EarMojo.buildDestinationFile(this.getWorkDirectory(), earModule.getUri());
                if (!sourceFile.isFile()) {
                    throw new MojoExecutionException("Cannot copy a directory: " + sourceFile.getAbsolutePath() + "; Did you package/install " + earModule.getArtifact() + "?");
                }
                if (destinationFile.getCanonicalPath().equals(sourceFile.getCanonicalPath())) {
                    this.getLog().info((CharSequence)("Skipping artifact [" + earModule + "], as it already exists at [" + earModule.getUri() + "]"));
                    continue;
                }
                if (unpackTypesList.contains(earModule.getType()) && (earModule.shouldUnpack() == null || earModule.shouldUnpack().booleanValue()) || earModule.shouldUnpack() != null && earModule.shouldUnpack().booleanValue()) {
                    this.getLog().info((CharSequence)("Copying artifact [" + earModule + "] to [" + earModule.getUri() + "] (unpacked)"));
                    destinationFile.mkdirs();
                    this.unpack(sourceFile, destinationFile);
                    if (!this.skinnyWars || !earModule.changeManifestClasspath()) continue;
                    this.changeManifestClasspath(earModule, destinationFile);
                    continue;
                }
                if (sourceFile.lastModified() > destinationFile.lastModified()) {
                    this.getLog().info((CharSequence)("Copying artifact [" + earModule + "] to [" + earModule.getUri() + "]"));
                    FileUtils.copyFile((File)sourceFile, (File)destinationFile);
                    if (!this.skinnyWars || !earModule.changeManifestClasspath()) continue;
                    this.changeManifestClasspath(earModule, destinationFile);
                    continue;
                }
                this.getLog().debug((CharSequence)("Skipping artifact [" + earModule + "], as it is already up to date at [" + earModule.getUri() + "]"));
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error copying EAR modules", (Exception)e);
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("Error unpacking EAR modules", (Exception)((Object)e));
        }
        catch (NoSuchArchiverException e) {
            throw new MojoExecutionException("No Archiver found for EAR modules", (Exception)((Object)e));
        }
        try {
            File earSourceDir = this.earSourceDirectory;
            if (earSourceDir.exists()) {
                this.getLog().info((CharSequence)("Copy ear sources to " + this.getWorkDirectory().getAbsolutePath()));
                String[] stringArray = this.getEarFiles(earSourceDir);
                for (int i = 0; i < stringArray.length; ++i) {
                    this.copyFile(new File(earSourceDir, stringArray[i]), new File(this.getWorkDirectory(), stringArray[i]));
                }
            }
            if (this.applicationXml != null && !"".equals(this.applicationXml)) {
                this.getLog().info((CharSequence)("Including custom application.xml[" + this.applicationXml + "]"));
                File file = new File(this.getWorkDirectory(), "META-INF");
                this.copyFile(new File(this.applicationXml), new File(file, "/application.xml"));
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error copying EAR sources", (Exception)e);
        }
        catch (MavenFilteringException e) {
            throw new MojoExecutionException("Error filtering EAR sources", (Exception)((Object)e));
        }
        File ddFile = new File(this.getWorkDirectory(), "META-INF/application.xml");
        if (!ddFile.exists() && javaEEVersion.lt(JavaEEVersion.Five)) {
            throw new MojoExecutionException("Deployment descriptor: " + ddFile.getAbsolutePath() + " does not exist.");
        }
        try {
            File file = EarMojo.getEarFile(this.outputDirectory, this.finalName, this.classifier);
            EarMavenArchiver archiver = new EarMavenArchiver(this.getModules());
            JarArchiver jarArchiver = this.getJarArchiver();
            this.getLog().debug((CharSequence)("Jar archiver implementation [" + jarArchiver.getClass().getName() + "]"));
            archiver.setArchiver(jarArchiver);
            archiver.setOutputFile(file);
            this.includeCustomManifestFile();
            this.getLog().debug((CharSequence)("Excluding " + Arrays.asList(this.getPackagingExcludes()) + " from the generated EAR."));
            this.getLog().debug((CharSequence)("Including " + Arrays.asList(this.getPackagingIncludes()) + " in the generated EAR."));
            archiver.getArchiver().addDirectory(this.getWorkDirectory(), this.getPackagingIncludes(), this.getPackagingExcludes());
            archiver.createArchive(this.getProject(), this.archive);
            if (this.classifier != null) {
                this.projectHelper.attachArtifact(this.getProject(), "ear", this.classifier, file);
            } else {
                this.getProject().getArtifact().setFile(file);
            }
        }
        catch (Exception exception) {
            throw new MojoExecutionException("Error assembling EAR", exception);
        }
    }

    public String getApplicationXml() {
        return this.applicationXml;
    }

    public void setApplicationXml(String applicationXml) {
        this.applicationXml = applicationXml;
    }

    protected String[] getExcludes() {
        ArrayList<String> excludeList = new ArrayList<String>(FileUtils.getDefaultExcludesAsList());
        if (this.earSourceExcludes != null && !"".equals(this.earSourceExcludes)) {
            excludeList.addAll(Arrays.asList(StringUtils.split((String)this.earSourceExcludes, (String)",")));
        }
        if (this.getApplicationXml() != null && !"".equals(this.getApplicationXml())) {
            excludeList.add("**/META-INF/application.xml");
        }
        return excludeList.toArray(EMPTY_STRING_ARRAY);
    }

    protected String[] getIncludes() {
        return StringUtils.split((String)StringUtils.defaultString((Object)this.earSourceIncludes), (String)",");
    }

    public String[] getPackagingExcludes() {
        if (StringUtils.isEmpty((String)this.packagingExcludes)) {
            return new String[0];
        }
        return StringUtils.split((String)this.packagingExcludes, (String)",");
    }

    public void setPackagingExcludes(String packagingExcludes) {
        this.packagingExcludes = packagingExcludes;
    }

    public String[] getPackagingIncludes() {
        if (StringUtils.isEmpty((String)this.packagingIncludes)) {
            return new String[]{"**"};
        }
        return StringUtils.split((String)this.packagingIncludes, (String)",");
    }

    public void setPackagingIncludes(String packagingIncludes) {
        this.packagingIncludes = packagingIncludes;
    }

    private static File buildDestinationFile(File buildDir, String uri) {
        return new File(buildDir, uri);
    }

    private void includeCustomManifestFile() {
        if (this.manifestFile == null) {
            this.manifestFile = new File(this.getWorkDirectory(), "META-INF/MANIFEST.MF");
        }
        if (!this.manifestFile.exists()) {
            this.getLog().info((CharSequence)("Could not find manifest file: " + this.manifestFile + " - Generating one"));
        } else {
            this.getLog().info((CharSequence)("Including custom manifest file [" + this.manifestFile + "]"));
            this.archive.setManifestFile(this.manifestFile);
        }
    }

    private static File getEarFile(String basedir, String finalName, String classifier) {
        if (classifier == null) {
            classifier = "";
        } else if (classifier.trim().length() > 0 && !classifier.startsWith("-")) {
            classifier = "-" + classifier;
        }
        return new File(basedir, finalName + classifier + ".ear");
    }

    private String[] getEarFiles(File sourceDir) {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(sourceDir);
        scanner.setExcludes(this.getExcludes());
        scanner.addDefaultExcludes();
        scanner.setIncludes(this.getIncludes());
        scanner.scan();
        return scanner.getIncludedFiles();
    }

    public void unpack(File source, File destDir) throws NoSuchArchiverException, IOException, ArchiverException {
        UnArchiver unArchiver = this.archiverManager.getUnArchiver("zip");
        unArchiver.setSourceFile(source);
        unArchiver.setDestDirectory(destDir);
        unArchiver.extract();
    }

    protected JarArchiver getJarArchiver() {
        return this.jarArchiver;
    }

    private void copyFile(File source, File target) throws MavenFilteringException, IOException, MojoExecutionException {
        if (this.filtering && !this.isNonFilteredExtension(source.getName())) {
            if (target.getParentFile() != null && !target.getParentFile().exists()) {
                target.getParentFile().mkdirs();
            }
            this.mavenFileFilter.copyFile(source, target, true, this.getFilterWrappers(), null);
        } else {
            FileUtils.copyFile((File)source, (File)target);
        }
    }

    public boolean isNonFilteredExtension(String fileName) {
        return !this.mavenResourcesFiltering.filteredFileExtension(fileName, this.nonFilteredFileExtensions);
    }

    private List getFilterWrappers() throws MojoExecutionException {
        if (this.filterWrappers == null) {
            try {
                MavenResourcesExecution mavenResourcesExecution = new MavenResourcesExecution();
                mavenResourcesExecution.setEscapeString(this.escapeString);
                this.filterWrappers = this.mavenFileFilter.getDefaultFilterWrappers(this.project, this.filters, this.escapedBackslashesInFilePath, this.session, mavenResourcesExecution);
            }
            catch (MavenFilteringException e) {
                this.getLog().error((CharSequence)("Fail to build filtering wrappers " + e.getMessage()));
                throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
            }
        }
        return this.filterWrappers;
    }

    private void changeManifestClasspath(EarModule module, File original) throws MojoFailureException {
        try {
            File manifestFile;
            boolean newManifestCreated;
            File workDirectory;
            if (original.isFile()) {
                workDirectory = new File(new File(this.generatedDescriptorLocation, "temp"), module.getArtifact().getArtifactId());
                workDirectory.mkdirs();
                this.getLog().debug((CharSequence)("Created a temporary work directory: " + workDirectory.getAbsolutePath()));
                this.zipUnArchiver.setSourceFile(original);
                this.zipUnArchiver.setDestDirectory(workDirectory);
                this.zipUnArchiver.extract();
            } else {
                workDirectory = original;
            }
            File metaInfDirectory = new File(workDirectory, "META-INF");
            boolean newMetaInfCreated = metaInfDirectory.mkdirs();
            if (newMetaInfCreated) {
                this.getLog().debug((CharSequence)"This project did not have a META-INF directory before, so a new directory was created.");
            }
            if (newManifestCreated = (manifestFile = new File(metaInfDirectory, "MANIFEST.MF")).createNewFile()) {
                this.getLog().debug((CharSequence)"This project did not have a META-INF/MANIFEST.MF file before, so a new file was created.");
            }
            Manifest mf = new Manifest((Reader)new FileReader(manifestFile));
            Manifest.Attribute classPath = mf.getMainSection().getAttribute("Class-Path");
            ArrayList<String> classPathElements = new ArrayList<String>();
            if (classPath != null) {
                classPathElements.addAll(Arrays.asList(classPath.getValue().split(" ")));
            } else {
                classPath = new Manifest.Attribute("Class-Path", "");
                mf.getMainSection().addConfiguredAttribute(classPath);
            }
            for (EarModule o : this.getModules()) {
                File artifact;
                if (!(o instanceof JarModule)) continue;
                JarModule jm = (JarModule)o;
                if (module.getLibDir() != null && (artifact = new File(new File(workDirectory, module.getLibDir()), jm.getBundleFileName())).exists() && !artifact.delete()) {
                    this.getLog().error((CharSequence)("Could not delete '" + artifact + "'"));
                }
                if (classPathElements.contains(jm.getBundleFileName())) {
                    classPathElements.set(classPathElements.indexOf(jm.getBundleFileName()), jm.getUri());
                    continue;
                }
                classPathElements.add(jm.getUri());
            }
            classPath.setValue(StringUtils.join(classPathElements.iterator(), (String)" "));
            PrintWriter pw = new PrintWriter(manifestFile);
            mf.write(pw);
            pw.close();
            if (original.isFile()) {
                if (!original.delete()) {
                    this.getLog().error((CharSequence)("Could not delete original artifact file " + original));
                }
                this.getLog().debug((CharSequence)"Zipping module");
                this.zipArchiver.setDestFile(original);
                this.zipArchiver.addDirectory(workDirectory);
                this.zipArchiver.createArchive();
            }
        }
        catch (ManifestException e) {
            throw new MojoFailureException(e.getMessage());
        }
        catch (ZipException e) {
            throw new MojoFailureException(e.getMessage());
        }
        catch (IOException e) {
            throw new MojoFailureException(e.getMessage());
        }
        catch (ArchiverException e) {
            throw new MojoFailureException(e.getMessage());
        }
    }
}

