/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.clover;

import com.cenqua.clover.tasks.CloverFormatType;
import com.cenqua.clover.tasks.CloverReportTask;
import java.io.File;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.clover.internal.AbstractCloverMojo;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.apache.tools.ant.Project;
import org.codehaus.plexus.resource.ResourceManager;

public class CloverReportMojo
extends AbstractMavenReport {
    private String cloverDatabase;
    private String cloverMergeDatabase;
    private File outputDirectory;
    private String historyDir;
    private int flushInterval;
    private boolean waitForFlush;
    private boolean generateHtml;
    private boolean generatePdf;
    private boolean generateXml;
    private boolean generateHistorical;
    private String contextFilters;
    private Renderer siteRenderer;
    private MavenProject project;
    private List reactorProjects;
    private String licenseLocation;
    private ResourceManager resourceManager;
    static /* synthetic */ Class class$org$apache$maven$plugin$clover$CloverReportMojo;

    public void executeReport(Locale locale) throws MavenReportException {
        File mergedCloverDatabase;
        try {
            AbstractCloverMojo.registerLicenseFile(this.resourceManager, this.licenseLocation, this.getLog(), ((Object)((Object)this)).getClass().getClassLoader());
        }
        catch (MojoExecutionException e) {
            throw new MavenReportException("Failed to locate Clover license", (Exception)((Object)e));
        }
        this.outputDirectory.mkdirs();
        File singleModuleCloverDatabase = new File(this.cloverDatabase);
        if (singleModuleCloverDatabase.exists()) {
            this.createAllReportTypes(this.cloverDatabase, "Maven Clover");
        }
        if ((mergedCloverDatabase = new File(this.cloverMergeDatabase)).exists()) {
            this.createAllReportTypes(this.cloverMergeDatabase, "Maven Aggregated Clover");
        }
    }

    private void createAllReportTypes(String database, String titlePrefix) {
        File historyDir = new File(this.outputDirectory, "history");
        if (this.generateHtml) {
            this.createReport(database, this.createCurrentReportForCloverReportTask(titlePrefix + " report", this.outputDirectory, false), this.createHistoricalReportForCloverReportTask(titlePrefix + " historical report", historyDir), this.createFormatTypeForCloverReportTask("html"));
        }
        if (this.generatePdf) {
            this.createReport(database, this.createCurrentReportForCloverReportTask(titlePrefix + "report", new File(this.outputDirectory, "clover.pdf"), true), this.createHistoricalReportForCloverReportTask(titlePrefix + "Historical report", new File(historyDir, "clover-history.pdf")), this.createFormatTypeForCloverReportTask("pdf"));
        }
        if (this.generateXml) {
            this.createReport(database, this.createCurrentReportForCloverReportTask(titlePrefix + "report", new File(this.outputDirectory, "clover.xml"), false), null, this.createFormatTypeForCloverReportTask("xml"));
        }
    }

    private void createReport(String database, CloverReportTask.CurrentEx currentEx, CloverReportTask.HistoricalEx historicalEx, CloverFormatType type) {
        Project antProject = AbstractCloverMojo.registerCloverAntTasks();
        CloverReportTask cloverReportTask = (CloverReportTask)antProject.createTask("clover-report");
        cloverReportTask.setInitString(database);
        currentEx.addFormat(type);
        cloverReportTask.addCurrent(currentEx);
        if (historicalEx != null) {
            historicalEx.addFormat(type);
            cloverReportTask.addHistorical(historicalEx);
        }
        cloverReportTask.execute();
    }

    private CloverReportTask.CurrentEx createCurrentReportForCloverReportTask(String title, File outFile, boolean isSummaryReport) {
        CloverReportTask.CurrentEx currentEx = new CloverReportTask.CurrentEx();
        currentEx.setTitle(title);
        currentEx.setAlwaysReport(true);
        currentEx.setOutFile(outFile);
        currentEx.setSummary(isSummaryReport);
        return currentEx;
    }

    private CloverReportTask.HistoricalEx createHistoricalReportForCloverReportTask(String title, File outFile) {
        CloverReportTask.HistoricalEx historicalEx = null;
        if (this.generateHistorical && this.isHistoricalDirectoryValid(outFile)) {
            historicalEx = new CloverReportTask.HistoricalEx();
            historicalEx.setTitle(title);
            historicalEx.setAlwaysReport(true);
            historicalEx.setOutFile(outFile);
            historicalEx.setHistoryDir(new File(this.historyDir));
        }
        return historicalEx;
    }

    private boolean isHistoricalDirectoryValid(File outFile) {
        boolean isValid = false;
        File dir = new File(this.historyDir);
        if (dir.exists()) {
            if (dir.listFiles().length > 0) {
                isValid = true;
            } else {
                this.getLog().warn((CharSequence)("No Clover historical data found in [" + this.historyDir + "], skipping Clover " + "historical report generation ([" + outFile + "])"));
            }
        } else {
            this.getLog().warn((CharSequence)("Clover historical directory [" + this.historyDir + "] does not exist, skipping Clover " + "historical report generation ([" + outFile + "])"));
        }
        return isValid;
    }

    private CloverFormatType createFormatTypeForCloverReportTask(String format) {
        CloverFormatType type = new CloverFormatType();
        type.setType(format);
        if (this.contextFilters != null) {
            type.setFilter(this.contextFilters);
        }
        return type;
    }

    public String getOutputName() {
        return "clover/index";
    }

    public String getDescription(Locale locale) {
        return CloverReportMojo.getBundle(locale).getString("report.clover.description");
    }

    private static ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("clover-report", locale, (class$org$apache$maven$plugin$clover$CloverReportMojo == null ? (class$org$apache$maven$plugin$clover$CloverReportMojo = CloverReportMojo.class$("org.apache.maven.plugin.clover.CloverReportMojo")) : class$org$apache$maven$plugin$clover$CloverReportMojo).getClassLoader());
    }

    protected String getOutputDirectory() {
        return this.outputDirectory.getAbsoluteFile().toString();
    }

    protected Renderer getSiteRenderer() {
        return this.siteRenderer;
    }

    protected MavenProject getProject() {
        return this.project;
    }

    public String getName(Locale locale) {
        return CloverReportMojo.getBundle(locale).getString("report.clover.name");
    }

    public boolean isExternalReport() {
        return true;
    }

    public boolean canGenerateReport() {
        boolean canGenerate = false;
        AbstractCloverMojo.waitForFlush(this.waitForFlush, this.flushInterval);
        File singleModuleCloverDatabase = new File(this.cloverDatabase);
        File mergedCloverDatabase = new File(this.cloverMergeDatabase);
        if (singleModuleCloverDatabase.exists() || mergedCloverDatabase.exists()) {
            if (this.generateHtml || this.generatePdf || this.generateXml) {
                canGenerate = true;
            }
        } else {
            this.getLog().warn((CharSequence)"No Clover database found, skipping report generation");
        }
        return canGenerate;
    }

    public void setReportOutputDirectory(File reportOutputDirectory) {
        this.outputDirectory = reportOutputDirectory != null && !reportOutputDirectory.getAbsolutePath().endsWith("clover") ? new File(reportOutputDirectory, "clover") : reportOutputDirectory;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

