/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.tools.plugin.generator;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.Parameter;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.project.MavenProject;
import org.apache.maven.tools.plugin.DefaultPluginToolsRequest;
import org.apache.maven.tools.plugin.PluginToolsRequest;
import org.apache.maven.tools.plugin.generator.Generator;
import org.apache.maven.tools.plugin.util.PluginUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import org.codehaus.plexus.util.xml.XMLWriter;

public class PluginXdocGenerator
implements Generator {
    private final Locale locale;
    private final MavenProject project;

    public PluginXdocGenerator() {
        this.project = null;
        this.locale = Locale.ENGLISH;
    }

    public PluginXdocGenerator(MavenProject project) {
        this.project = project;
        this.locale = Locale.ENGLISH;
    }

    public PluginXdocGenerator(MavenProject project, Locale locale) {
        this.project = project;
        this.locale = locale == null ? Locale.ENGLISH : locale;
    }

    public void execute(File destinationDirectory, PluginDescriptor pluginDescriptor) throws IOException {
        this.execute(destinationDirectory, new DefaultPluginToolsRequest(this.project, pluginDescriptor));
    }

    public void execute(File destinationDirectory, PluginToolsRequest request) throws IOException {
        if (request.getPluginDescriptor().getMojos() != null) {
            Iterator it = request.getPluginDescriptor().getMojos().iterator();
            while (it.hasNext()) {
                MojoDescriptor descriptor = (MojoDescriptor)it.next();
                this.processMojoDescriptor(descriptor, destinationDirectory);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processMojoDescriptor(MojoDescriptor mojoDescriptor, File destinationDirectory) throws IOException {
        File outputFile = new File(destinationDirectory, this.getMojoFilename(mojoDescriptor, "xml"));
        String encoding = "UTF-8";
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), encoding);
            PrettyPrintXMLWriter w = new PrettyPrintXMLWriter(new PrintWriter(writer), encoding, null);
            this.writeBody(mojoDescriptor, (XMLWriter)w);
            ((Writer)writer).flush();
        }
        catch (Throwable throwable) {
            IOUtil.close(writer);
            throw throwable;
        }
        IOUtil.close((Writer)writer);
    }

    private String getMojoFilename(MojoDescriptor mojo, String ext) {
        return mojo.getGoal() + "-mojo." + ext;
    }

    private void writeBody(MojoDescriptor mojoDescriptor, XMLWriter w) {
        w.startElement("document");
        w.addAttribute("xmlns", "http://maven.apache.org/XDOC/2.0");
        w.addAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        w.addAttribute("xsi:schemaLocation", "http://maven.apache.org/XDOC/2.0 http://maven.apache.org/xsd/xdoc-2.0.xsd");
        w.startElement("properties");
        w.startElement("title");
        w.writeText(mojoDescriptor.getFullGoalName());
        w.endElement();
        w.endElement();
        w.startElement("body");
        w.startElement("section");
        w.addAttribute("name", mojoDescriptor.getFullGoalName());
        this.writeReportNotice(mojoDescriptor, w);
        w.startElement("p");
        w.writeMarkup(this.getString("pluginxdoc.mojodescriptor.fullname"));
        w.endElement();
        w.startElement("p");
        w.writeMarkup(mojoDescriptor.getPluginDescriptor().getGroupId() + ":" + mojoDescriptor.getPluginDescriptor().getArtifactId() + ":" + mojoDescriptor.getPluginDescriptor().getVersion() + ":" + mojoDescriptor.getGoal());
        w.endElement();
        if (StringUtils.isNotEmpty((String)mojoDescriptor.getDeprecated())) {
            w.startElement("p");
            w.writeMarkup(this.getString("pluginxdoc.mojodescriptor.deprecated"));
            w.endElement();
            w.startElement("div");
            w.writeMarkup(PluginUtils.makeHtmlValid(mojoDescriptor.getDeprecated()));
            w.endElement();
        }
        w.startElement("p");
        w.writeMarkup(this.getString("pluginxdoc.description"));
        w.endElement();
        w.startElement("div");
        if (StringUtils.isNotEmpty((String)mojoDescriptor.getDescription())) {
            w.writeMarkup(PluginUtils.makeHtmlValid(mojoDescriptor.getDescription()));
        } else {
            w.writeText(this.getString("pluginxdoc.nodescription"));
        }
        w.endElement();
        this.writeGoalAttributes(mojoDescriptor, w);
        this.writeGoalParameterTable(mojoDescriptor, w);
        w.endElement();
        w.endElement();
        w.endElement();
    }

    private void writeReportNotice(MojoDescriptor mojoDescriptor, XMLWriter w) {
        if (PluginUtils.isMavenReport(mojoDescriptor.getImplementation(), this.project)) {
            w.startElement("p");
            w.writeMarkup(this.getString("pluginxdoc.mojodescriptor.notice.note"));
            w.writeText(this.getString("pluginxdoc.mojodescriptor.notice.isMavenReport"));
            w.endElement();
        }
    }

    private void writeGoalAttributes(MojoDescriptor mojoDescriptor, XMLWriter w) {
        String value;
        w.startElement("p");
        w.writeMarkup(this.getString("pluginxdoc.mojodescriptor.attributes"));
        w.endElement();
        boolean addedUl = false;
        if (mojoDescriptor.isProjectRequired()) {
            if (!addedUl) {
                w.startElement("ul");
                addedUl = true;
            }
            w.startElement("li");
            w.writeMarkup(this.getString("pluginxdoc.mojodescriptor.projectRequired"));
            w.endElement();
        }
        if (mojoDescriptor.isAggregator()) {
            if (!addedUl) {
                w.startElement("ul");
                addedUl = true;
            }
            w.startElement("li");
            w.writeMarkup(this.getString("pluginxdoc.mojodescriptor.aggregator"));
            w.endElement();
        }
        if (mojoDescriptor.isDirectInvocationOnly()) {
            if (!addedUl) {
                w.startElement("ul");
                addedUl = true;
            }
            w.startElement("li");
            w.writeMarkup(this.getString("pluginxdoc.mojodescriptor.directInvocationOnly"));
            w.endElement();
        }
        if (StringUtils.isNotEmpty((String)(value = mojoDescriptor.isDependencyResolutionRequired()))) {
            if (!addedUl) {
                w.startElement("ul");
                addedUl = true;
            }
            w.startElement("li");
            w.writeMarkup(this.format("pluginxdoc.mojodescriptor.dependencyResolutionRequired", value));
            w.endElement();
        }
        if (StringUtils.isNotEmpty((String)(value = mojoDescriptor.getSince()))) {
            if (!addedUl) {
                w.startElement("ul");
                addedUl = true;
            }
            w.startElement("li");
            w.writeMarkup(this.format("pluginxdoc.mojodescriptor.since", value));
            w.endElement();
        }
        if (StringUtils.isNotEmpty((String)(value = mojoDescriptor.getPhase()))) {
            if (!addedUl) {
                w.startElement("ul");
                addedUl = true;
            }
            w.startElement("li");
            w.writeMarkup(this.format("pluginxdoc.mojodescriptor.phase", value));
            w.endElement();
        }
        if (StringUtils.isNotEmpty((String)(value = mojoDescriptor.getExecutePhase()))) {
            if (!addedUl) {
                w.startElement("ul");
                addedUl = true;
            }
            w.startElement("li");
            w.writeMarkup(this.format("pluginxdoc.mojodescriptor.executePhase", value));
            w.endElement();
        }
        if (StringUtils.isNotEmpty((String)(value = mojoDescriptor.getExecuteGoal()))) {
            if (!addedUl) {
                w.startElement("ul");
                addedUl = true;
            }
            w.startElement("li");
            w.writeMarkup(this.format("pluginxdoc.mojodescriptor.executeGoal", value));
            w.endElement();
        }
        if (StringUtils.isNotEmpty((String)(value = mojoDescriptor.getExecuteLifecycle()))) {
            if (!addedUl) {
                w.startElement("ul");
                addedUl = true;
            }
            w.startElement("li");
            w.writeMarkup(this.format("pluginxdoc.mojodescriptor.executeLifecycle", value));
            w.endElement();
        }
        if (mojoDescriptor.isOnlineRequired()) {
            if (!addedUl) {
                w.startElement("ul");
                addedUl = true;
            }
            w.startElement("li");
            w.writeMarkup(this.getString("pluginxdoc.mojodescriptor.onlineRequired"));
            w.endElement();
        }
        if (!mojoDescriptor.isInheritedByDefault()) {
            if (!addedUl) {
                w.startElement("ul");
                addedUl = true;
            }
            w.startElement("li");
            w.writeMarkup(this.getString("pluginxdoc.mojodescriptor.inheritedByDefault"));
            w.endElement();
        }
        if (addedUl) {
            w.endElement();
        }
    }

    private void writeGoalParameterTable(MojoDescriptor mojoDescriptor, XMLWriter w) {
        List parameterList = mojoDescriptor.getParameters();
        List list = this.filterParameters(parameterList);
        if (list != null && list.size() > 0) {
            this.writeParameterSummary(mojoDescriptor, list, w);
            this.writeParameterDetails(mojoDescriptor, list, w);
        } else {
            w.startElement("subsection");
            w.addAttribute("name", this.getString("pluginxdoc.mojodescriptor.parameters"));
            w.startElement("p");
            w.writeMarkup(this.getString("pluginxdoc.mojodescriptor.noParameter"));
            w.endElement();
            w.endElement();
        }
    }

    private List filterParameters(List parameterList) {
        ArrayList<Parameter> filtered = new ArrayList<Parameter>();
        if (parameterList != null) {
            Iterator parameters = parameterList.iterator();
            while (parameters.hasNext()) {
                String expression;
                Parameter parameter = (Parameter)parameters.next();
                if (!parameter.isEditable() || (expression = parameter.getExpression()) != null && expression.startsWith("${component.")) continue;
                filtered.add(parameter);
            }
        }
        return filtered;
    }

    private void writeParameterDetails(MojoDescriptor mojoDescriptor, List parameterList, XMLWriter w) {
        w.startElement("subsection");
        w.addAttribute("name", this.getString("pluginxdoc.mojodescriptor.parameter.details"));
        Iterator parameters = parameterList.iterator();
        while (parameters.hasNext()) {
            Parameter parameter = (Parameter)parameters.next();
            w.startElement("p");
            w.writeMarkup(this.format("pluginxdoc.mojodescriptor.parameter.name_internal", parameter.getName()));
            w.endElement();
            if (StringUtils.isNotEmpty((String)parameter.getDeprecated())) {
                w.startElement("div");
                w.writeMarkup(this.format("pluginxdoc.mojodescriptor.parameter.deprecated", PluginUtils.makeHtmlValid(parameter.getDeprecated())));
                w.endElement();
            }
            w.startElement("div");
            if (StringUtils.isNotEmpty((String)parameter.getDescription())) {
                w.writeMarkup(PluginUtils.makeHtmlValid(parameter.getDescription()));
            } else {
                w.writeMarkup(this.getString("pluginxdoc.nodescription"));
            }
            w.endElement();
            boolean addedUl = false;
            if (!addedUl && StringUtils.isNotEmpty((String)parameter.getType())) {
                w.startElement("ul");
                addedUl = true;
            }
            this.writeDetail(this.getString("pluginxdoc.mojodescriptor.parameter.type"), parameter.getType(), w);
            if (StringUtils.isNotEmpty((String)parameter.getSince())) {
                if (!addedUl) {
                    w.startElement("ul");
                    addedUl = true;
                }
                this.writeDetail(this.getString("pluginxdoc.mojodescriptor.parameter.since"), parameter.getSince(), w);
            } else if (StringUtils.isNotEmpty((String)mojoDescriptor.getSince())) {
                if (!addedUl) {
                    w.startElement("ul");
                    addedUl = true;
                }
                this.writeDetail(this.getString("pluginxdoc.mojodescriptor.parameter.since"), mojoDescriptor.getSince(), w);
            }
            if (parameter.isRequired()) {
                if (!addedUl) {
                    w.startElement("ul");
                    addedUl = true;
                }
                this.writeDetail(this.getString("pluginxdoc.mojodescriptor.parameter.required"), this.getString("pluginxdoc.yes"), w);
            } else {
                if (!addedUl) {
                    w.startElement("ul");
                    addedUl = true;
                }
                this.writeDetail(this.getString("pluginxdoc.mojodescriptor.parameter.required"), this.getString("pluginxdoc.no"), w);
            }
            if (!addedUl && StringUtils.isNotEmpty((String)parameter.getExpression())) {
                w.startElement("ul");
                addedUl = true;
            }
            this.writeDetail(this.getString("pluginxdoc.mojodescriptor.parameter.expression"), parameter.getExpression(), w);
            if (!addedUl && StringUtils.isNotEmpty((String)parameter.getDefaultValue())) {
                w.startElement("ul");
                addedUl = true;
            }
            this.writeDetail(this.getString("pluginxdoc.mojodescriptor.parameter.default"), this.escapeXml(parameter.getDefaultValue()), w);
            if (addedUl) {
                w.endElement();
            }
            if (!parameters.hasNext()) continue;
            w.writeMarkup("<hr/>");
        }
        w.endElement();
    }

    private void writeDetail(String param, String value, XMLWriter w) {
        if (StringUtils.isNotEmpty((String)value)) {
            w.startElement("li");
            w.writeMarkup(this.format("pluginxdoc.detail", new String[]{param, value}));
            w.endElement();
        }
    }

    private void writeParameterSummary(MojoDescriptor mojoDescriptor, List parameterList, XMLWriter w) {
        List optionalParams;
        List requiredParams = this.getParametersByRequired(true, parameterList);
        if (requiredParams.size() > 0) {
            this.writeParameterList(mojoDescriptor, this.getString("pluginxdoc.mojodescriptor.requiredParameters"), requiredParams, w);
        }
        if ((optionalParams = this.getParametersByRequired(false, parameterList)).size() > 0) {
            this.writeParameterList(mojoDescriptor, this.getString("pluginxdoc.mojodescriptor.optionalParameters"), optionalParams, w);
        }
    }

    private void writeParameterList(MojoDescriptor mojoDescriptor, String title, List parameterList, XMLWriter w) {
        w.startElement("subsection");
        w.addAttribute("name", title);
        w.startElement("table");
        w.addAttribute("border", "0");
        w.addAttribute("align", "left");
        w.startElement("tr");
        w.startElement("th");
        w.writeText(this.getString("pluginxdoc.mojodescriptor.parameter.name"));
        w.endElement();
        w.startElement("th");
        w.writeText(this.getString("pluginxdoc.mojodescriptor.parameter.type"));
        w.endElement();
        w.startElement("th");
        w.writeText(this.getString("pluginxdoc.mojodescriptor.parameter.since"));
        w.endElement();
        w.startElement("th");
        w.writeText(this.getString("pluginxdoc.mojodescriptor.parameter.description"));
        w.endElement();
        w.endElement();
        Iterator parameters = parameterList.iterator();
        while (parameters.hasNext()) {
            Parameter parameter = (Parameter)parameters.next();
            w.startElement("tr");
            w.startElement("td");
            w.writeMarkup(this.format("pluginxdoc.mojodescriptor.parameter.name_link", parameter.getName()));
            w.endElement();
            w.startElement("td");
            int index = parameter.getType().lastIndexOf(".");
            w.writeMarkup("<code>" + parameter.getType().substring(index + 1) + "</code>");
            w.endElement();
            w.startElement("td");
            if (StringUtils.isNotEmpty((String)parameter.getSince())) {
                w.writeMarkup("<code>" + parameter.getSince() + "</code>");
            } else if (StringUtils.isNotEmpty((String)mojoDescriptor.getSince())) {
                w.writeMarkup("<code>" + mojoDescriptor.getSince() + "</code>");
            } else {
                w.writeMarkup("<code>-</code>");
            }
            w.endElement();
            w.startElement("td");
            String description = StringUtils.isNotEmpty((String)parameter.getDeprecated()) ? this.format("pluginxdoc.mojodescriptor.parameter.deprecated", PluginUtils.makeHtmlValid(parameter.getDeprecated())) : (StringUtils.isNotEmpty((String)parameter.getDescription()) ? PluginUtils.makeHtmlValid(parameter.getDescription()) : this.getString("pluginxdoc.nodescription"));
            w.writeMarkup(description + "<br/>");
            if (StringUtils.isNotEmpty((String)parameter.getDefaultValue())) {
                w.writeMarkup(this.format("pluginxdoc.mojodescriptor.parameter.defaultValue", this.escapeXml(parameter.getDefaultValue())));
            }
            w.endElement();
            w.endElement();
        }
        w.endElement();
        w.endElement();
    }

    private List getParametersByRequired(boolean required, List parameterList) {
        ArrayList<Parameter> list = new ArrayList<Parameter>();
        Iterator parameters = parameterList.iterator();
        while (parameters.hasNext()) {
            Parameter parameter = (Parameter)parameters.next();
            if (parameter.isRequired() != required) continue;
            list.add(parameter);
        }
        return list;
    }

    private ResourceBundle getBundle() {
        return ResourceBundle.getBundle("pluginxdoc", this.locale, this.getClass().getClassLoader());
    }

    private String getString(String key) {
        return this.getBundle().getString(key);
    }

    private String format(String key, Object arg1) {
        return this.format(key, new Object[]{arg1});
    }

    private String format(String key, Object[] args) {
        String pattern = this.getString(key);
        pattern = StringUtils.replace((String)pattern, (String)"'", (String)"''");
        MessageFormat messageFormat = new MessageFormat("");
        messageFormat.setLocale(this.locale);
        messageFormat.applyPattern(pattern);
        return messageFormat.format(args);
    }

    private String escapeXml(String text) {
        if (text != null) {
            text = text.replaceAll("&", "&amp;");
            text = text.replaceAll("<", "&lt;");
            text = text.replaceAll(">", "&gt;");
            text = text.replaceAll("\"", "&quot;");
            text = text.replaceAll("'", "&apos;");
        }
        return text;
    }
}

