/*
 * $Id$
 */

package org.apache.maven.usability.plugin;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.*;
import java.util.List;

/**
 * Class ExpressionDocumentation.
 * 
 * @version $Revision$ $Date$
 */
public class ExpressionDocumentation implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field expressions
     */
    private java.util.List expressions;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addExpression
     * 
     * @param expression
     */
    public void addExpression(Expression expression)
    {
        getExpressions().add( expression );
    } //-- void addExpression(Expression) 

    /**
     * Method getExpressions
     */
    public java.util.List getExpressions()
    {
        if ( this.expressions == null )
        {
            this.expressions = new java.util.ArrayList();
        }
        
        return this.expressions;
    } //-- java.util.List getExpressions() 

    /**
     * Method removeExpression
     * 
     * @param expression
     */
    public void removeExpression(Expression expression)
    {
        getExpressions().remove( expression );
    } //-- void removeExpression(Expression) 

    /**
     * Method setExpressions
     * 
     * @param expressions
     */
    public void setExpressions(java.util.List expressions)
    {
        this.expressions = expressions;
    } //-- void setExpressions(java.util.List) 

    private Map expressionsBySyntax;
    
    public Map getExpressionsBySyntax()
    {
        if ( expressionsBySyntax == null )
        {
            expressionsBySyntax = new HashMap();
       
            List expressions = getExpressions();
       
            if ( expressions != null && !expressions.isEmpty() )
            {
                for ( Iterator it = expressions.iterator(); it.hasNext(); )
                {
                    Expression expr = (Expression) it.next();
       
                    expressionsBySyntax.put( expr.getSyntax(), expr );
                }
            }
        }
        
        return expressionsBySyntax;
    }
    
    public void flushExpressionsBySyntax()
    {
        expressionsBySyntax = null;
    }
}
