/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.xdoc;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.swing.text.html.HTML;
import org.apache.maven.doxia.macro.MacroExecutionException;
import org.apache.maven.doxia.macro.MacroRequest;
import org.apache.maven.doxia.macro.manager.MacroNotFoundException;
import org.apache.maven.doxia.module.xdoc.XdocMarkup;
import org.apache.maven.doxia.parser.ParseException;
import org.apache.maven.doxia.parser.XhtmlBaseParser;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.sink.SinkEventAttributeSet;
import org.apache.maven.doxia.sink.SinkEventAttributes;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class XdocParser
extends XhtmlBaseParser
implements XdocMarkup {
    private String sourceContent;
    private boolean scriptBlock;
    private boolean isEmptyElement;
    private String macroName;
    private Map macroParameters = new HashMap();

    public void parse(Reader source, Sink sink) throws ParseException {
        try {
            StringWriter contentWriter = new StringWriter();
            IOUtil.copy((Reader)source, (Writer)contentWriter);
            this.sourceContent = contentWriter.toString();
        }
        catch (IOException ex) {
            throw new ParseException("Error reading the input source: " + ex.getMessage(), (Exception)ex);
        }
        finally {
            IOUtil.close((Reader)source);
        }
        StringReader tmp = new StringReader(this.sourceContent);
        this.setIgnorableWhitespace(true);
        super.parse((Reader)tmp, sink);
    }

    protected void handleStartTag(XmlPullParser parser, Sink sink) throws XmlPullParserException, MacroExecutionException {
        this.isEmptyElement = parser.isEmptyElementTag();
        SinkEventAttributeSet attribs = this.getAttributesFromParser(parser);
        if (this.isVerbatim()) {
            if (parser.getName().equals(SOURCE_TAG.toString()) || parser.getName().equals(HTML.Tag.PRE.toString())) {
                this.verbatim();
            }
            sink.text(this.getText(parser));
        } else {
            if (parser.getName().equals(DOCUMENT_TAG.toString())) {
                return;
            }
            if (parser.getName().equals(HTML.Tag.HEAD.toString())) {
                sink.head((SinkEventAttributes)attribs);
            } else if (parser.getName().equals(HTML.Tag.TITLE.toString())) {
                sink.title((SinkEventAttributes)attribs);
            } else if (parser.getName().equals(AUTHOR_TAG.toString())) {
                sink.author((SinkEventAttributes)attribs);
            } else if (parser.getName().equals(DATE_TAG.toString())) {
                sink.date((SinkEventAttributes)attribs);
            } else if (parser.getName().equals(HTML.Tag.BODY.toString())) {
                sink.body((SinkEventAttributes)attribs);
            } else if (parser.getName().equals(SECTION_TAG.toString())) {
                this.consecutiveSections(1, sink);
                Object id = attribs.getAttribute((Object)HTML.Attribute.ID.toString());
                if (id != null) {
                    sink.anchor(id.toString());
                    sink.anchor_();
                }
                sink.section(1, (SinkEventAttributes)attribs);
                sink.sectionTitle(1, (SinkEventAttributes)attribs);
                sink.text(parser.getAttributeValue(null, HTML.Attribute.NAME.toString()));
                sink.sectionTitle1_();
            } else if (parser.getName().equals(SUBSECTION_TAG.toString())) {
                this.consecutiveSections(2, sink);
                Object id = attribs.getAttribute((Object)HTML.Attribute.ID.toString());
                if (id != null) {
                    sink.anchor(id.toString());
                    sink.anchor_();
                }
                sink.section(2, (SinkEventAttributes)attribs);
                sink.sectionTitle(2, (SinkEventAttributes)attribs);
                sink.text(parser.getAttributeValue(null, HTML.Attribute.NAME.toString()));
                sink.sectionTitle2_();
            } else if (parser.getName().equals(SOURCE_TAG.toString())) {
                this.verbatim();
                attribs.addAttribute((Object)"decoration", (Object)"boxed");
                sink.verbatim((SinkEventAttributes)attribs);
            } else if (parser.getName().equals(PROPERTIES_TAG.toString())) {
                sink.head();
            } else if (parser.getName().equals(MACRO_TAG.toString())) {
                if (!this.isSecondParsing()) {
                    this.macroName = parser.getAttributeValue(null, HTML.Attribute.NAME.toString());
                    if (this.macroParameters == null) {
                        this.macroParameters = new HashMap();
                    }
                    if (StringUtils.isEmpty((String)this.macroName)) {
                        throw new MacroExecutionException("The '" + HTML.Attribute.NAME.toString() + "' attribute for the '" + MACRO_TAG.toString() + "' tag is required.");
                    }
                }
            } else if (parser.getName().equals(HTML.Tag.PARAM.toString())) {
                if (!this.isSecondParsing()) {
                    if (StringUtils.isNotEmpty((String)this.macroName)) {
                        String paramName = parser.getAttributeValue(null, HTML.Attribute.NAME.toString());
                        String paramValue = parser.getAttributeValue(null, HTML.Attribute.VALUE.toString());
                        if (StringUtils.isEmpty((String)paramName) || StringUtils.isEmpty((String)paramValue)) {
                            throw new MacroExecutionException("'" + HTML.Attribute.NAME.toString() + "' and '" + HTML.Attribute.VALUE.toString() + "' attributes for the '" + HTML.Tag.PARAM.toString() + "' tag are required inside the '" + MACRO_TAG.toString() + "' tag.");
                        }
                        this.macroParameters.put(paramName, paramValue);
                    } else {
                        this.handleUnknown(parser, sink, 2);
                    }
                }
            } else if (parser.getName().equals(HTML.Tag.SCRIPT.toString())) {
                this.handleUnknown(parser, sink, 2);
                this.scriptBlock = true;
            } else if (!this.baseStartTag(parser, sink)) {
                if (this.isEmptyElement) {
                    this.handleUnknown(parser, sink, 1);
                } else {
                    this.handleUnknown(parser, sink, 2);
                }
                if (!this.isVerbatim() && this.getLog().isDebugEnabled()) {
                    String position = "[" + parser.getLineNumber() + ":" + parser.getColumnNumber() + "]";
                    String tag = "<" + parser.getName() + ">";
                    this.getLog().debug((CharSequence)("Unrecognized xdoc tag: " + tag + " at " + position));
                }
            }
        }
    }

    protected void handleEndTag(XmlPullParser parser, Sink sink) throws XmlPullParserException, MacroExecutionException {
        if (this.isVerbatim()) {
            if (parser.getName().equals(SOURCE_TAG.toString()) || parser.getName().equals(HTML.Tag.PRE.toString())) {
                this.verbatim_();
                if (this.isVerbatim()) {
                    sink.text(this.getText(parser));
                } else {
                    sink.verbatim_();
                }
            } else {
                sink.text(this.getText(parser));
            }
        } else {
            if (parser.getName().equals(DOCUMENT_TAG.toString())) {
                return;
            }
            if (parser.getName().equals(HTML.Tag.HEAD.toString())) {
                sink.head_();
            } else if (parser.getName().equals(HTML.Tag.BODY.toString())) {
                this.consecutiveSections(0, sink);
                sink.body_();
            } else if (parser.getName().equals(HTML.Tag.TITLE.toString())) {
                sink.title_();
            } else if (parser.getName().equals(AUTHOR_TAG.toString())) {
                sink.author_();
            } else if (parser.getName().equals(DATE_TAG.toString())) {
                sink.date_();
            } else if (parser.getName().equals(SOURCE_TAG.toString())) {
                this.verbatim_();
                sink.verbatim_();
            } else if (parser.getName().equals(PROPERTIES_TAG.toString())) {
                sink.head_();
            } else if (parser.getName().equals(MACRO_TAG.toString())) {
                if (!this.isSecondParsing() && StringUtils.isNotEmpty((String)this.macroName)) {
                    this.macroParameters.put("sourceContent", this.sourceContent);
                    XdocParser xdocParser = new XdocParser();
                    xdocParser.setSecondParsing(true);
                    this.macroParameters.put("parser", xdocParser);
                    MacroRequest request = new MacroRequest(this.macroParameters, this.getBasedir());
                    try {
                        this.executeMacro(this.macroName, request, sink);
                    }
                    catch (MacroNotFoundException me) {
                        throw new MacroExecutionException("Macro not found: " + this.macroName, (Throwable)me);
                    }
                }
                this.macroName = null;
                this.macroParameters = null;
            } else if (parser.getName().equals(HTML.Tag.PARAM.toString())) {
                if (!StringUtils.isNotEmpty((String)this.macroName)) {
                    this.handleUnknown(parser, sink, 3);
                }
            } else if (parser.getName().equals(SECTION_TAG.toString())) {
                this.consecutiveSections(0, sink);
                sink.section1_();
            } else if (parser.getName().equals(SUBSECTION_TAG.toString())) {
                this.consecutiveSections(1, sink);
            } else if (parser.getName().equals(HTML.Tag.SCRIPT.toString())) {
                this.handleUnknown(parser, sink, 3);
                this.scriptBlock = false;
            } else if (!this.baseEndTag(parser, sink) && !this.isEmptyElement) {
                this.handleUnknown(parser, sink, 3);
            }
        }
        this.isEmptyElement = false;
    }

    protected void handleCdsect(XmlPullParser parser, Sink sink) throws XmlPullParserException {
        String text = this.getText(parser);
        if (this.scriptBlock) {
            sink.rawText(text);
        } else {
            sink.text(text);
        }
    }

    protected void consecutiveSections(int newLevel, Sink sink) {
        this.closeOpenSections(newLevel, sink);
        this.openMissingSections(newLevel, sink);
        this.setSectionLevel(newLevel);
    }

    private void closeOpenSections(int newLevel, Sink sink) {
        while (this.getSectionLevel() >= newLevel) {
            if (this.getSectionLevel() == 5) {
                sink.section5_();
            } else if (this.getSectionLevel() == 4) {
                sink.section4_();
            } else if (this.getSectionLevel() == 3) {
                sink.section3_();
            } else if (this.getSectionLevel() == 2) {
                sink.section2_();
            }
            this.setSectionLevel(this.getSectionLevel() - 1);
        }
    }

    private void openMissingSections(int newLevel, Sink sink) {
        while (this.getSectionLevel() < newLevel - 1) {
            this.setSectionLevel(this.getSectionLevel() + 1);
            if (this.getSectionLevel() == 5) {
                sink.section5();
                continue;
            }
            if (this.getSectionLevel() == 4) {
                sink.section4();
                continue;
            }
            if (this.getSectionLevel() == 3) {
                sink.section3();
                continue;
            }
            if (this.getSectionLevel() != 2) continue;
            sink.section2();
        }
    }
}

