/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.fo;

import java.io.Writer;
import java.util.Calendar;
import java.util.Iterator;
import javax.swing.text.html.HTML;
import org.apache.maven.doxia.document.DocumentMeta;
import org.apache.maven.doxia.document.DocumentModel;
import org.apache.maven.doxia.document.DocumentTOC;
import org.apache.maven.doxia.document.DocumentTOCItem;
import org.apache.maven.doxia.module.fo.FoSink;
import org.apache.maven.doxia.util.DoxiaUtils;
import org.apache.maven.doxia.util.HtmlTools;
import org.codehaus.plexus.util.StringUtils;

public class FoAggregateSink
extends FoSink {
    private DocumentModel docModel;
    private int chapter = 0;
    private String docName;
    private String docTitle = "";
    private boolean ignoreText;

    public FoAggregateSink(Writer writer) {
        super(writer);
    }

    public void head() {
        this.ignoreText = true;
    }

    public void head_() {
        this.ignoreText = false;
        this.writeEOL();
    }

    public void title() {
    }

    public void title_() {
    }

    public void author() {
    }

    public void author_() {
    }

    public void date() {
    }

    public void date_() {
    }

    public void body() {
        ++this.chapter;
        this.resetSectionCounter();
        this.startPageSequence(this.getHeaderText(), this.getFooterText());
        if (this.docName == null) {
            this.getLog().warn((CharSequence)"No document root specified, local links will not be resolved correctly!");
        } else {
            this.writeStartTag(BLOCK_TAG, "id", this.docName);
        }
    }

    public void body_() {
        this.writeEOL();
        this.writeEndTag(BLOCK_TAG);
        this.writeEndTag(FLOW_TAG);
        this.writeEndTag(PAGE_SEQUENCE_TAG);
        this.docName = null;
    }

    public void setDocumentTitle(String title) {
        this.docTitle = title;
        if (title == null) {
            this.docTitle = "";
        }
    }

    public void setDocumentName(String name) {
        this.docName = this.getIdName(name);
    }

    public void setDocumentModel(DocumentModel model) {
        this.docModel = model;
    }

    private String getIdName(String name) {
        if (StringUtils.isEmpty((String)name)) {
            this.getLog().warn((CharSequence)"Empty document reference, links will not be resolved correctly!");
            return "";
        }
        String idName = name;
        if (!idName.startsWith("./")) {
            idName = "./" + idName;
        }
        if (idName.indexOf(".", 2) != -1) {
            idName = idName.substring(0, idName.indexOf(".", 2));
        }
        return idName;
    }

    public void figureGraphics(String name) {
        if (!this.isFigure()) {
            this.write("<fo:external-graphic" + this.getFoConfiguration().getAttributeString("figure.graphics"));
        }
        String anchor = name;
        if (name.startsWith("../") && this.docName != null) {
            anchor = this.resolveLinkRelativeToBase(name);
        }
        this.writeln(" src=\"" + anchor + "\"/>");
    }

    public void anchor(String name) {
        if (name == null) {
            throw new NullPointerException("Anchor name cannot be null!");
        }
        String anchor = name;
        if (!DoxiaUtils.isValidId((String)anchor)) {
            anchor = DoxiaUtils.encodeId((String)name);
            this.getLog().warn((CharSequence)("[FO Sink] Modified invalid anchor name: " + name));
        }
        anchor = "#" + anchor;
        if (this.docName != null) {
            anchor = this.docName + anchor;
        }
        this.writeStartTag(INLINE_TAG, "id", anchor);
    }

    public void link(String name) {
        if (name == null) {
            throw new NullPointerException("Link name cannot be null!");
        }
        if (DoxiaUtils.isExternalLink((String)name)) {
            this.writeStartTag(BASIC_LINK_TAG, "external-destination", HtmlTools.escapeHTML((String)name));
            this.writeStartTag(INLINE_TAG, "href.external");
        } else if (DoxiaUtils.isInternalLink((String)name)) {
            String anchor = name.substring(1);
            if (!DoxiaUtils.isValidId((String)anchor)) {
                anchor = DoxiaUtils.encodeId((String)anchor);
                this.getLog().warn((CharSequence)("[FO Sink] Modified invalid link name: " + name));
            }
            if (this.docName != null) {
                anchor = this.docName + "#" + anchor;
            }
            this.writeStartTag(BASIC_LINK_TAG, "internal-destination", HtmlTools.escapeHTML((String)anchor));
            this.writeStartTag(INLINE_TAG, "href.internal");
        } else if (name.startsWith("../")) {
            if (this.docName == null) {
                this.writeStartTag(BASIC_LINK_TAG, "internal-destination", HtmlTools.escapeHTML((String)name));
                this.writeStartTag(INLINE_TAG, "href.internal");
                return;
            }
            String anchor = this.resolveLinkRelativeToBase(this.chopExtension(name));
            this.writeStartTag(BASIC_LINK_TAG, "internal-destination", HtmlTools.escapeHTML((String)anchor));
            this.writeStartTag(INLINE_TAG, "href.internal");
        } else {
            String anchor = name;
            if (anchor.startsWith("./")) {
                anchor = anchor.substring(2);
            }
            anchor = this.chopExtension(anchor);
            String base = this.docName.substring(0, this.docName.lastIndexOf("/"));
            anchor = base + "/" + anchor;
            this.writeStartTag(BASIC_LINK_TAG, "internal-destination", HtmlTools.escapeHTML((String)anchor));
            this.writeStartTag(INLINE_TAG, "href.internal");
        }
    }

    private String resolveLinkRelativeToBase(String name) {
        String anchor = name;
        String base = this.docName.substring(0, this.docName.lastIndexOf("/"));
        if (base.indexOf("/") != -1) {
            while (anchor.startsWith("../")) {
                base = base.substring(0, base.lastIndexOf("/"));
                anchor = anchor.substring(3);
            }
        }
        return base + "/" + anchor;
    }

    private String chopExtension(String name) {
        String anchor = name;
        int dot = anchor.indexOf(".");
        if (dot != -1) {
            int dot2;
            int hash = anchor.indexOf("#", dot);
            anchor = hash != -1 ? ((dot2 = anchor.indexOf(".", hash)) != -1 ? anchor.substring(0, dot) + "#" + HtmlTools.encodeId((String)anchor.substring(hash + 1, dot2)) : anchor.substring(0, dot) + "#" + HtmlTools.encodeId((String)anchor.substring(hash + 1, anchor.length()))) : anchor.substring(0, dot);
        }
        return anchor;
    }

    protected void writeStartTag(HTML.Tag tag, String attributeId) {
        if (!this.ignoreText) {
            super.writeStartTag(tag, attributeId);
        }
    }

    protected void writeStartTag(HTML.Tag tag, String id, String name) {
        if (!this.ignoreText) {
            super.writeStartTag(tag, id, name);
        }
    }

    protected void writeEndTag(HTML.Tag tag) {
        if (!this.ignoreText) {
            super.writeEndTag(tag);
        }
    }

    protected void writeEmptyTag(HTML.Tag tag, String attributeId) {
        if (!this.ignoreText) {
            super.writeEmptyTag(tag, attributeId);
        }
    }

    protected void write(String text) {
        if (!this.ignoreText) {
            super.write(text);
        }
    }

    protected void writeln(String text) {
        if (!this.ignoreText) {
            super.writeln(text);
        }
    }

    protected void content(String text) {
        if (!this.ignoreText) {
            super.content(text);
        }
    }

    protected void newline() {
        if (!this.ignoreText) {
            this.writeEOL();
        }
    }

    protected void startPageSequence(String headerText, String footerText) {
        if (this.chapter == 1) {
            this.startPageSequence("0", headerText, footerText);
        } else {
            this.startPageSequence("auto", headerText, footerText);
        }
    }

    protected String getHeaderText() {
        return Integer.toString(this.chapter) + "   " + this.docTitle;
    }

    protected String getFooterText() {
        int actualYear = Calendar.getInstance().get(1);
        return "&#169;" + actualYear + " The Apache Software Foundation &#8226; ALL RIGHTS RESERVED";
    }

    protected String getChapterString() {
        return Integer.toString(this.chapter) + ".";
    }

    protected void regionBefore(String headerText) {
        this.writeStartTag(STATIC_CONTENT_TAG, "flow-name", "xsl-region-before");
        this.writeln("<fo:table table-layout=\"fixed\" width=\"100%\" >");
        this.writeEmptyTag(TABLE_COLUMN_TAG, "column-width", "5.625in");
        this.writeEmptyTag(TABLE_COLUMN_TAG, "column-width", "0.625in");
        this.writeStartTag(TABLE_BODY_TAG, "");
        this.writeStartTag(TABLE_ROW_TAG, "");
        this.writeStartTag(TABLE_CELL_TAG, "");
        this.writeStartTag(BLOCK_TAG, "header.style");
        if (headerText != null) {
            this.write(headerText);
        }
        this.writeEndTag(BLOCK_TAG);
        this.writeEndTag(TABLE_CELL_TAG);
        this.writeStartTag(TABLE_CELL_TAG, "");
        this.writeStartTag(BLOCK_TAG, "page.number");
        this.writeEmptyTag(PAGE_NUMBER_TAG, "");
        this.writeEndTag(BLOCK_TAG);
        this.writeEndTag(TABLE_CELL_TAG);
        this.writeEndTag(TABLE_ROW_TAG);
        this.writeEndTag(TABLE_BODY_TAG);
        this.writeEndTag(TABLE_TAG);
        this.writeEndTag(STATIC_CONTENT_TAG);
    }

    protected void regionAfter(String footerText) {
        this.writeStartTag(STATIC_CONTENT_TAG, "flow-name", "xsl-region-after");
        this.writeStartTag(BLOCK_TAG, "footer.style");
        if (footerText != null) {
            this.write(footerText);
        }
        this.writeEndTag(BLOCK_TAG);
        this.writeEndTag(STATIC_CONTENT_TAG);
    }

    protected void chapterHeading(String headerText, boolean chapterNumber) {
        this.writeStartTag(BLOCK_TAG, "");
        this.writeStartTag(LIST_BLOCK_TAG, "");
        this.writeStartTag(LIST_ITEM_TAG, "");
        this.writeln("<fo:list-item-label end-indent=\"6.375in\" start-indent=\"-1in\">");
        this.writeStartTag(BLOCK_TAG, "outdented.number.style");
        if (chapterNumber) {
            this.write(Integer.toString(this.chapter));
        }
        this.writeEndTag(BLOCK_TAG);
        this.writeEndTag(LIST_ITEM_LABEL_TAG);
        this.writeln("<fo:list-item-body end-indent=\"1in\" start-indent=\"0in\">");
        this.writeStartTag(BLOCK_TAG, "chapter.title");
        if (headerText == null) {
            this.write(this.docTitle);
        } else {
            this.write(headerText);
        }
        this.writeEndTag(BLOCK_TAG);
        this.writeEndTag(LIST_ITEM_BODY_TAG);
        this.writeEndTag(LIST_ITEM_TAG);
        this.writeEndTag(LIST_BLOCK_TAG);
        this.writeEndTag(BLOCK_TAG);
        this.writeStartTag(BLOCK_TAG, "space-after.optimum", "0em");
        this.writeEmptyTag(LEADER_TAG, "chapter.rule");
        this.writeEndTag(BLOCK_TAG);
    }

    public void toc() {
        if (this.docModel == null) {
            return;
        }
        DocumentTOC toc = this.docModel.getToc();
        if (toc == null) {
            return;
        }
        this.writeln("<fo:page-sequence master-reference=\"toc\" initial-page-number=\"1\" format=\"i\">");
        this.regionBefore(toc.getName());
        this.regionAfter(this.getFooterText());
        this.writeStartTag(FLOW_TAG, "flow-name", "xsl-region-body");
        this.chapterHeading(toc.getName(), false);
        this.writeln("<fo:table table-layout=\"fixed\" width=\"100%\" >");
        this.writeEmptyTag(TABLE_COLUMN_TAG, "column-width", "0.45in");
        this.writeEmptyTag(TABLE_COLUMN_TAG, "column-width", "0.4in");
        this.writeEmptyTag(TABLE_COLUMN_TAG, "column-width", "0.4in");
        this.writeEmptyTag(TABLE_COLUMN_TAG, "column-width", "5in");
        this.writeStartTag(TABLE_BODY_TAG, "");
        int count = 0;
        Iterator k = toc.getItems().iterator();
        while (k.hasNext()) {
            DocumentTOCItem tocItem = (DocumentTOCItem)k.next();
            String ref = this.getIdName(tocItem.getRef());
            this.writeStartTag(TABLE_ROW_TAG, "keep-with-next", "always");
            this.writeStartTag(TABLE_CELL_TAG, "toc.cell");
            this.writeStartTag(BLOCK_TAG, "toc.number.style");
            this.write(Integer.toString(++count));
            this.writeEndTag(BLOCK_TAG);
            this.writeEndTag(TABLE_CELL_TAG);
            this.writeStartTag(TABLE_CELL_TAG, "number-columns-spanned", "3", "toc.cell");
            this.writeStartTag(BLOCK_TAG, "toc.h1.style");
            this.writeStartTag(BASIC_LINK_TAG, "internal-destination", ref);
            this.write(tocItem.getName());
            this.writeEndTag(BASIC_LINK_TAG);
            this.writeEmptyTag(LEADER_TAG, "toc.leader.style");
            this.writeStartTag(INLINE_TAG, "page.number");
            this.writeEmptyTag(PAGE_NUMBER_CITATION_TAG, "ref-id", ref);
            this.writeEndTag(INLINE_TAG);
            this.writeEndTag(BLOCK_TAG);
            this.writeEndTag(TABLE_CELL_TAG);
            this.writeEndTag(TABLE_ROW_TAG);
        }
        this.writeEndTag(TABLE_BODY_TAG);
        this.writeEndTag(TABLE_TAG);
        this.writeEndTag(FLOW_TAG);
        this.writeEndTag(PAGE_SEQUENCE_TAG);
    }

    protected void pdfBookmarks() {
        if (this.docModel == null) {
            return;
        }
        DocumentTOC toc = this.docModel.getToc();
        if (toc == null) {
            return;
        }
        this.writeStartTag(BOOKMARK_TREE_TAG, "");
        Iterator k = toc.getItems().iterator();
        while (k.hasNext()) {
            DocumentTOCItem tocItem = (DocumentTOCItem)k.next();
            String ref = this.getIdName(tocItem.getRef());
            this.writeStartTag(BOOKMARK_TAG, "internal-destination", ref);
            this.writeStartTag(BOOKMARK_TITLE_TAG, "");
            this.write(tocItem.getName());
            this.writeEndTag(BOOKMARK_TITLE_TAG);
            this.writeEndTag(BOOKMARK_TAG);
        }
        this.writeEndTag(BOOKMARK_TREE_TAG);
    }

    public void coverPage() {
        if (this.docModel == null) {
            return;
        }
        DocumentMeta meta = this.docModel.getMeta();
        if (meta == null) {
            return;
        }
        String title = meta.getTitle();
        String author = meta.getAuthor();
        this.writeStartTag(PAGE_SEQUENCE_TAG, "master-reference", "cover-page");
        this.writeStartTag(FLOW_TAG, "flow-name", "xsl-region-body");
        this.writeStartTag(BLOCK_TAG, "text-align", "center");
        this.writeln("<fo:table table-layout=\"fixed\" width=\"100%\" >");
        this.writeEmptyTag(TABLE_COLUMN_TAG, "column-width", "3.125in");
        this.writeEmptyTag(TABLE_COLUMN_TAG, "column-width", "3.125in");
        this.writeStartTag(TABLE_BODY_TAG, "");
        this.writeStartTag(TABLE_ROW_TAG, "height", "1.5in");
        this.writeStartTag(TABLE_CELL_TAG, "");
        this.writeEmptyTag(BLOCK_TAG, "");
        this.writeEndTag(TABLE_CELL_TAG);
        this.writeStartTag(TABLE_CELL_TAG, "");
        this.writeEmptyTag(BLOCK_TAG, "");
        this.writeEndTag(TABLE_CELL_TAG);
        this.writeEndTag(TABLE_ROW_TAG);
        this.writeln("<fo:table-row keep-with-previous=\"always\" height=\"0.014in\">");
        this.writeStartTag(TABLE_CELL_TAG, "number-columns-spanned", "2");
        this.writeStartTag(BLOCK_TAG, "line-height", "0.014in");
        this.writeEmptyTag(LEADER_TAG, "chapter.rule");
        this.writeEndTag(BLOCK_TAG);
        this.writeEndTag(TABLE_CELL_TAG);
        this.writeEndTag(TABLE_ROW_TAG);
        this.writeStartTag(TABLE_ROW_TAG, "height", "7.447in");
        this.writeStartTag(TABLE_CELL_TAG, "number-columns-spanned", "2");
        this.writeln("<fo:table table-layout=\"fixed\" width=\"100%\" >");
        this.writeEmptyTag(TABLE_COLUMN_TAG, "column-width", "2.083in");
        this.writeEmptyTag(TABLE_COLUMN_TAG, "column-width", "2.083in");
        this.writeEmptyTag(TABLE_COLUMN_TAG, "column-width", "2.083in");
        this.writeStartTag(TABLE_BODY_TAG, "");
        this.writeStartTag(TABLE_ROW_TAG, "");
        this.writeStartTag(TABLE_CELL_TAG, "number-columns-spanned", "3");
        this.writeEmptyTag(BLOCK_TAG, "");
        this.writeEmptyTag(BLOCK_TAG, "space-before", "3.2235in");
        this.writeEndTag(TABLE_CELL_TAG);
        this.writeEndTag(TABLE_ROW_TAG);
        this.writeStartTag(TABLE_ROW_TAG, "");
        this.writeStartTag(TABLE_CELL_TAG, "");
        this.writeEmptyTag(BLOCK_TAG, "space-after", "0.5in");
        this.writeEndTag(TABLE_CELL_TAG);
        this.writeStartTag(TABLE_CELL_TAG, "number-columns-spanned", "2", "cover.border.left");
        this.writeStartTag(BLOCK_TAG, "cover.title");
        this.write(title);
        this.writeEndTag(BLOCK_TAG);
        this.writeEndTag(TABLE_CELL_TAG);
        this.writeEndTag(TABLE_ROW_TAG);
        this.writeStartTag(TABLE_ROW_TAG, "");
        this.writeStartTag(TABLE_CELL_TAG, "");
        this.writeEmptyTag(BLOCK_TAG, "");
        this.writeEndTag(TABLE_CELL_TAG);
        this.writeStartTag(TABLE_CELL_TAG, "number-columns-spanned", "2", "cover.border.left.bottom");
        this.writeStartTag(BLOCK_TAG, "cover.subtitle");
        this.writeEndTag(BLOCK_TAG);
        this.writeEndTag(TABLE_CELL_TAG);
        this.writeEndTag(TABLE_ROW_TAG);
        this.writeEndTag(TABLE_BODY_TAG);
        this.writeEndTag(TABLE_TAG);
        this.writeEndTag(TABLE_CELL_TAG);
        this.writeEndTag(TABLE_ROW_TAG);
        this.writeStartTag(TABLE_ROW_TAG, "height", "0.014in");
        this.writeStartTag(TABLE_CELL_TAG, "number-columns-spanned", "2");
        this.writeln("<fo:block space-after=\"0.2in\" line-height=\"0.014in\">");
        this.writeEmptyTag(LEADER_TAG, "chapter.rule");
        this.writeEndTag(BLOCK_TAG);
        this.writeEndTag(TABLE_CELL_TAG);
        this.writeEndTag(TABLE_ROW_TAG);
        this.writeStartTag(TABLE_ROW_TAG, "");
        this.writeStartTag(TABLE_CELL_TAG, "number-columns-spanned", "2");
        this.writeEmptyTag(BLOCK_TAG, "");
        this.writeEmptyTag(BLOCK_TAG, "space-before", "0.2in");
        this.writeEndTag(TABLE_CELL_TAG);
        this.writeEndTag(TABLE_ROW_TAG);
        this.writeStartTag(TABLE_ROW_TAG, "height", "0.3in");
        this.writeStartTag(TABLE_CELL_TAG, "");
        this.writeStartTag(BLOCK_TAG, "height", "0.3in", "cover.subtitle");
        this.write(author);
        this.writeEndTag(BLOCK_TAG);
        this.writeEndTag(TABLE_CELL_TAG);
        this.writeStartTag(TABLE_CELL_TAG, "");
        this.writeStartTag(BLOCK_TAG, "height", "0.3in", "cover.subtitle");
        this.writeEndTag(BLOCK_TAG);
        this.writeEndTag(TABLE_CELL_TAG);
        this.writeEndTag(TABLE_ROW_TAG);
        this.writeEndTag(TABLE_BODY_TAG);
        this.writeEndTag(TABLE_TAG);
        this.writeEndTag(BLOCK_TAG);
        this.writeEndTag(FLOW_TAG);
        this.writeEndTag(PAGE_SEQUENCE_TAG);
    }
}

