/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.suggest.analyzing;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.TokenStreamToAutomaton;
import org.apache.lucene.search.spell.TermFreqIterator;
import org.apache.lucene.search.suggest.Lookup;
import org.apache.lucene.search.suggest.analyzing.FSTUtil;
import org.apache.lucene.search.suggest.fst.Sort;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.store.ByteArrayDataOutput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.InputStreamDataInput;
import org.apache.lucene.store.OutputStreamDataOutput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.UnicodeUtil;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.BasicOperations;
import org.apache.lucene.util.automaton.SpecialOperations;
import org.apache.lucene.util.automaton.State;
import org.apache.lucene.util.automaton.Transition;
import org.apache.lucene.util.fst.Builder;
import org.apache.lucene.util.fst.ByteSequenceOutputs;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.Outputs;
import org.apache.lucene.util.fst.PairOutputs;
import org.apache.lucene.util.fst.PositiveIntOutputs;
import org.apache.lucene.util.fst.Util;

public class AnalyzingSuggester
extends Lookup {
    private FST<PairOutputs.Pair<Long, BytesRef>> fst = null;
    private final Analyzer indexAnalyzer;
    private final Analyzer queryAnalyzer;
    private final boolean exactFirst;
    private final boolean preserveSep;
    public static final int EXACT_FIRST = 1;
    public static final int PRESERVE_SEP = 2;
    private static final int SEP_LABEL = 255;
    private static final int END_BYTE = 0;
    private final int maxSurfaceFormsPerAnalyzedForm;
    private final int maxGraphExpansions;
    private int maxAnalyzedPathsForOneInput;
    private Comparator<BytesRef> sortComparator = new Comparator<BytesRef>(){
        private final ByteArrayDataInput readerA = new ByteArrayDataInput();
        private final ByteArrayDataInput readerB = new ByteArrayDataInput();
        private final BytesRef scratchA = new BytesRef();
        private final BytesRef scratchB = new BytesRef();

        @Override
        public int compare(BytesRef a, BytesRef b) {
            long bCost;
            this.readerA.reset(a.bytes, a.offset, a.length);
            this.scratchA.length = this.readerA.readShort();
            this.scratchA.bytes = a.bytes;
            this.scratchA.offset = this.readerA.getPosition();
            this.readerB.reset(b.bytes, b.offset, b.length);
            this.scratchB.bytes = b.bytes;
            this.scratchB.length = this.readerB.readShort();
            this.scratchB.offset = this.readerB.getPosition();
            int cmp = this.scratchA.compareTo(this.scratchB);
            if (cmp != 0) {
                return cmp;
            }
            long aCost = this.readerA.readInt();
            if (aCost < (bCost = (long)this.readerB.readInt())) {
                return -1;
            }
            if (aCost > bCost) {
                return 1;
            }
            this.scratchA.offset = this.readerA.getPosition();
            this.scratchA.length = a.length - this.scratchA.offset;
            this.scratchB.offset = this.readerB.getPosition();
            this.scratchB.length = b.length - this.scratchB.offset;
            cmp = this.scratchA.compareTo(this.scratchB);
            if (cmp != 0) {
                return cmp;
            }
            return 0;
        }
    };
    static final Comparator<PairOutputs.Pair<Long, BytesRef>> weightComparator = new Comparator<PairOutputs.Pair<Long, BytesRef>>(){

        @Override
        public int compare(PairOutputs.Pair<Long, BytesRef> left, PairOutputs.Pair<Long, BytesRef> right) {
            return ((Long)left.output1).compareTo((Long)right.output1);
        }
    };

    public AnalyzingSuggester(Analyzer analyzer) {
        this(analyzer, analyzer, 3, 256, -1);
    }

    public AnalyzingSuggester(Analyzer indexAnalyzer, Analyzer queryAnalyzer) {
        this(indexAnalyzer, queryAnalyzer, 3, 256, -1);
    }

    public AnalyzingSuggester(Analyzer indexAnalyzer, Analyzer queryAnalyzer, int options, int maxSurfaceFormsPerAnalyzedForm, int maxGraphExpansions) {
        this.indexAnalyzer = indexAnalyzer;
        this.queryAnalyzer = queryAnalyzer;
        if ((options & 0xFFFFFFFC) != 0) {
            throw new IllegalArgumentException("options should only contain EXACT_FIRST and PRESERVE_SEP; got " + options);
        }
        this.exactFirst = (options & 1) != 0;
        boolean bl = this.preserveSep = (options & 2) != 0;
        if (maxSurfaceFormsPerAnalyzedForm <= 0 || maxSurfaceFormsPerAnalyzedForm > 256) {
            throw new IllegalArgumentException("maxSurfaceFormsPerAnalyzedForm must be > 0 and < 256 (got: " + maxSurfaceFormsPerAnalyzedForm + ")");
        }
        this.maxSurfaceFormsPerAnalyzedForm = maxSurfaceFormsPerAnalyzedForm;
        if (maxGraphExpansions < 1 && maxGraphExpansions != -1) {
            throw new IllegalArgumentException("maxGraphExpansions must -1 (no limit) or > 0 (got: " + maxGraphExpansions + ")");
        }
        this.maxGraphExpansions = maxGraphExpansions;
    }

    public long sizeInBytes() {
        return this.fst == null ? 0L : (long)this.fst.sizeInBytes();
    }

    private void copyDestTransitions(State from, State to, List<Transition> transitions) {
        if (to.isAccept()) {
            from.setAccept(true);
        }
        for (Transition t : to.getTransitions()) {
            transitions.add(t);
        }
    }

    private void replaceSep(Automaton a) {
        State[] states = a.getNumberedStates();
        for (int stateNumber = states.length - 1; stateNumber >= 0; --stateNumber) {
            State state = states[stateNumber];
            ArrayList<Transition> newTransitions = new ArrayList<Transition>();
            for (Transition t : state.getTransitions()) {
                assert (t.getMin() == t.getMax());
                if (t.getMin() == 256) {
                    if (this.preserveSep) {
                        newTransitions.add(new Transition(255, t.getDest()));
                        continue;
                    }
                    this.copyDestTransitions(state, t.getDest(), newTransitions);
                    a.setDeterministic(false);
                    continue;
                }
                if (t.getMin() == 257) {
                    this.copyDestTransitions(state, t.getDest(), newTransitions);
                    a.setDeterministic(false);
                    continue;
                }
                newTransitions.add(t);
            }
            state.setTransitions(newTransitions.toArray(new Transition[newTransitions.size()]));
        }
    }

    TokenStreamToAutomaton getTokenStreamToAutomaton() {
        if (this.preserveSep) {
            return new EscapingTokenStreamToAutomaton();
        }
        return new TokenStreamToAutomaton();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void build(TermFreqIterator iterator) throws IOException {
        File tempSorted;
        File tempInput;
        block14: {
            Sort.ByteSequencesReader reader;
            Sort.ByteSequencesWriter writer;
            block13: {
                String prefix = this.getClass().getSimpleName();
                File directory = Sort.defaultTempDir();
                tempInput = File.createTempFile(prefix, ".input", directory);
                tempSorted = File.createTempFile(prefix, ".sorted", directory);
                writer = new Sort.ByteSequencesWriter(tempInput);
                reader = null;
                BytesRef scratch = new BytesRef();
                TokenStreamToAutomaton ts2a = this.getTokenStreamToAutomaton();
                boolean success = false;
                byte[] buffer = new byte[8];
                try {
                    BytesRef surfaceForm;
                    ByteArrayDataOutput output = new ByteArrayDataOutput(buffer);
                    while ((surfaceForm = iterator.next()) != null) {
                        Set<IntsRef> paths = this.toFiniteStrings(surfaceForm, ts2a);
                        this.maxAnalyzedPathsForOneInput = Math.max(this.maxAnalyzedPathsForOneInput, paths.size());
                        for (IntsRef path : paths) {
                            Util.toBytesRef((IntsRef)path, (BytesRef)scratch);
                            if (scratch.length > 32765) {
                                throw new IllegalArgumentException("cannot handle analyzed forms > 32765 in length (got " + scratch.length + ")");
                            }
                            short analyzedLength = (short)scratch.length;
                            int requiredLength = analyzedLength + 4 + surfaceForm.length + 2;
                            buffer = ArrayUtil.grow((byte[])buffer, (int)requiredLength);
                            output.reset(buffer);
                            output.writeShort(analyzedLength);
                            output.writeBytes(scratch.bytes, scratch.offset, scratch.length);
                            output.writeInt(AnalyzingSuggester.encodeWeight(iterator.weight()));
                            output.writeBytes(surfaceForm.bytes, surfaceForm.offset, surfaceForm.length);
                            assert (output.getPosition() == requiredLength) : output.getPosition() + " vs " + requiredLength;
                            writer.write(buffer, 0, output.getPosition());
                        }
                    }
                    writer.close();
                    new Sort(this.sortComparator).sort(tempInput, tempSorted);
                    tempInput.delete();
                    reader = new Sort.ByteSequencesReader(tempSorted);
                    PairOutputs outputs = new PairOutputs((Outputs)PositiveIntOutputs.getSingleton((boolean)true), (Outputs)ByteSequenceOutputs.getSingleton());
                    Builder builder = new Builder(FST.INPUT_TYPE.BYTE1, (Outputs)outputs);
                    BytesRef previousAnalyzed = null;
                    BytesRef analyzed = new BytesRef();
                    BytesRef surface = new BytesRef();
                    IntsRef scratchInts = new IntsRef();
                    ByteArrayDataInput input = new ByteArrayDataInput();
                    HashSet<BytesRef> seenSurfaceForms = new HashSet<BytesRef>();
                    int dedup = 0;
                    while (reader.read(scratch)) {
                        input.reset(scratch.bytes, scratch.offset, scratch.length);
                        short analyzedLength = input.readShort();
                        analyzed.grow(analyzedLength + 2);
                        input.readBytes(analyzed.bytes, 0, (int)analyzedLength);
                        analyzed.length = analyzedLength;
                        long cost = input.readInt();
                        surface.bytes = scratch.bytes;
                        surface.offset = input.getPosition();
                        surface.length = scratch.length - surface.offset;
                        if (previousAnalyzed == null) {
                            previousAnalyzed = new BytesRef();
                            previousAnalyzed.copyBytes(analyzed);
                            seenSurfaceForms.add(BytesRef.deepCopyOf((BytesRef)surface));
                        } else if (analyzed.equals(previousAnalyzed)) {
                            if (++dedup >= this.maxSurfaceFormsPerAnalyzedForm || seenSurfaceForms.contains(surface)) continue;
                            seenSurfaceForms.add(BytesRef.deepCopyOf((BytesRef)surface));
                        } else {
                            dedup = 0;
                            previousAnalyzed.copyBytes(analyzed);
                            seenSurfaceForms.clear();
                            seenSurfaceForms.add(BytesRef.deepCopyOf((BytesRef)surface));
                        }
                        analyzed.bytes[analyzed.offset + analyzed.length] = 0;
                        analyzed.bytes[analyzed.offset + analyzed.length + 1] = (byte)dedup;
                        analyzed.length += 2;
                        Util.toIntsRef((BytesRef)analyzed, (IntsRef)scratchInts);
                        builder.add(scratchInts, (Object)outputs.newPair((Object)cost, (Object)BytesRef.deepCopyOf((BytesRef)surface)));
                    }
                    this.fst = builder.finish();
                    success = true;
                    if (!success) break block13;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close((Closeable[])new Closeable[]{reader, writer});
                    } else {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{reader, writer});
                    }
                    tempInput.delete();
                    tempSorted.delete();
                    throw throwable;
                }
                IOUtils.close((Closeable[])new Closeable[]{reader, writer});
                break block14;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{reader, writer});
        }
        tempInput.delete();
        tempSorted.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean store(OutputStream output) throws IOException {
        OutputStreamDataOutput dataOut;
        block3: {
            boolean bl;
            dataOut = new OutputStreamDataOutput(output);
            try {
                if (this.fst != null) break block3;
                bl = false;
            }
            catch (Throwable throwable) {
                IOUtils.close((Closeable[])new Closeable[]{output});
                throw throwable;
            }
            IOUtils.close((Closeable[])new Closeable[]{output});
            return bl;
        }
        this.fst.save((DataOutput)dataOut);
        dataOut.writeVInt(this.maxAnalyzedPathsForOneInput);
        IOUtils.close((Closeable[])new Closeable[]{output});
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean load(InputStream input) throws IOException {
        InputStreamDataInput dataIn = new InputStreamDataInput(input);
        try {
            this.fst = new FST((DataInput)dataIn, (Outputs)new PairOutputs((Outputs)PositiveIntOutputs.getSingleton((boolean)true), (Outputs)ByteSequenceOutputs.getSingleton()));
            this.maxAnalyzedPathsForOneInput = dataIn.readVInt();
        }
        catch (Throwable throwable) {
            IOUtils.close((Closeable[])new Closeable[]{input});
            throw throwable;
        }
        IOUtils.close((Closeable[])new Closeable[]{input});
        return true;
    }

    @Override
    public List<Lookup.LookupResult> lookup(CharSequence key, boolean onlyMorePopular, int num) {
        assert (num > 0);
        if (onlyMorePopular) {
            throw new IllegalArgumentException("this suggester only works with onlyMorePopular=false");
        }
        if (this.fst == null) {
            return Collections.emptyList();
        }
        final BytesRef utf8Key = new BytesRef(key);
        try {
            Util.MinResult[] completions;
            Automaton lookupAutomaton = this.toLookupAutomaton(key);
            CharsRef spare = new CharsRef();
            FST.BytesReader bytesReader = this.fst.getBytesReader(0);
            FST.Arc scratchArc = new FST.Arc();
            final ArrayList<Lookup.LookupResult> results = new ArrayList<Lookup.LookupResult>();
            List<FSTUtil.Path<PairOutputs.Pair<Long, BytesRef>>> prefixPaths = FSTUtil.intersectPrefixPaths(lookupAutomaton, this.fst);
            if (this.exactFirst) {
                Util.MinResult[] completions2;
                int count = 0;
                for (FSTUtil.Path<PairOutputs.Pair<Long, BytesRef>> path : prefixPaths) {
                    if (this.fst.findTargetArc(0, path.fstNode, scratchArc, bytesReader) == null) continue;
                    ++count;
                }
                Util.TopNSearcher searcher = new Util.TopNSearcher(this.fst, count * this.maxSurfaceFormsPerAnalyzedForm, count * this.maxSurfaceFormsPerAnalyzedForm, weightComparator);
                for (FSTUtil.Path<PairOutputs.Pair<Long, BytesRef>> path : prefixPaths) {
                    if (this.fst.findTargetArc(0, path.fstNode, scratchArc, bytesReader) == null) continue;
                    searcher.addStartPaths(scratchArc, this.fst.outputs.add(path.output, scratchArc.output), false, path.input);
                }
                for (Util.MinResult completion : completions2 = searcher.search()) {
                    if (!utf8Key.bytesEquals((BytesRef)((PairOutputs.Pair)completion.output).output2)) continue;
                    spare.grow(((BytesRef)((PairOutputs.Pair)completion.output).output2).length);
                    UnicodeUtil.UTF8toUTF16((BytesRef)((BytesRef)((PairOutputs.Pair)completion.output).output2), (CharsRef)spare);
                    results.add(new Lookup.LookupResult(spare.toString(), AnalyzingSuggester.decodeWeight((Long)((PairOutputs.Pair)completion.output).output1)));
                    break;
                }
                if (results.size() == num) {
                    return results;
                }
            }
            Util.TopNSearcher<PairOutputs.Pair<Long, BytesRef>> searcher = new Util.TopNSearcher<PairOutputs.Pair<Long, BytesRef>>(this.fst, num - results.size(), num * this.maxAnalyzedPathsForOneInput, weightComparator){
                private final Set<BytesRef> seen;
                {
                    super(x0, x1, x2, x3);
                    this.seen = new HashSet<BytesRef>();
                }

                protected boolean acceptResult(IntsRef input, PairOutputs.Pair<Long, BytesRef> output) {
                    if (this.seen.contains(output.output2)) {
                        return false;
                    }
                    this.seen.add((BytesRef)output.output2);
                    if (!AnalyzingSuggester.this.exactFirst) {
                        return true;
                    }
                    if (utf8Key.bytesEquals((BytesRef)output.output2)) {
                        assert (results.size() == 1);
                        return false;
                    }
                    return true;
                }
            };
            prefixPaths = this.getFullPrefixPaths(prefixPaths, lookupAutomaton, this.fst);
            for (FSTUtil.Path<PairOutputs.Pair<Long, BytesRef>> path : prefixPaths) {
                searcher.addStartPaths(path.fstNode, path.output, true, path.input);
            }
            for (Util.MinResult completion : completions = searcher.search()) {
                spare.grow(((BytesRef)((PairOutputs.Pair)completion.output).output2).length);
                UnicodeUtil.UTF8toUTF16((BytesRef)((BytesRef)((PairOutputs.Pair)completion.output).output2), (CharsRef)spare);
                Lookup.LookupResult result = new Lookup.LookupResult(spare.toString(), AnalyzingSuggester.decodeWeight((Long)((PairOutputs.Pair)completion.output).output1));
                results.add(result);
                if (results.size() == num) break;
            }
            return results;
        }
        catch (IOException bogus) {
            throw new RuntimeException(bogus);
        }
    }

    protected List<FSTUtil.Path<PairOutputs.Pair<Long, BytesRef>>> getFullPrefixPaths(List<FSTUtil.Path<PairOutputs.Pair<Long, BytesRef>>> prefixPaths, Automaton lookupAutomaton, FST<PairOutputs.Pair<Long, BytesRef>> fst) throws IOException {
        return prefixPaths;
    }

    final Set<IntsRef> toFiniteStrings(BytesRef surfaceForm, TokenStreamToAutomaton ts2a) throws IOException {
        TokenStream ts = this.indexAnalyzer.tokenStream("", (Reader)new StringReader(surfaceForm.utf8ToString()));
        Automaton automaton = ts2a.toAutomaton(ts);
        ts.end();
        ts.close();
        this.replaceSep(automaton);
        assert (SpecialOperations.isFinite((Automaton)automaton));
        return SpecialOperations.getFiniteStrings((Automaton)automaton, (int)this.maxGraphExpansions);
    }

    final Automaton toLookupAutomaton(CharSequence key) throws IOException {
        TokenStream ts = this.queryAnalyzer.tokenStream("", (Reader)new StringReader(((Object)key).toString()));
        Automaton automaton = this.getTokenStreamToAutomaton().toAutomaton(ts);
        ts.end();
        ts.close();
        this.replaceSep(automaton);
        BasicOperations.determinize((Automaton)automaton);
        return automaton;
    }

    public Object get(CharSequence key) {
        throw new UnsupportedOperationException();
    }

    private static int decodeWeight(long encoded) {
        return (int)(Integer.MAX_VALUE - encoded);
    }

    private static int encodeWeight(long value) {
        if (value < 0L || value > Integer.MAX_VALUE) {
            throw new UnsupportedOperationException("cannot encode value: " + value);
        }
        return Integer.MAX_VALUE - (int)value;
    }

    private static final class EscapingTokenStreamToAutomaton
    extends TokenStreamToAutomaton {
        final BytesRef spare = new BytesRef();

        private EscapingTokenStreamToAutomaton() {
        }

        protected BytesRef changeToken(BytesRef in) {
            int upto = 0;
            for (int i = 0; i < in.length; ++i) {
                byte b = in.bytes[in.offset + i];
                if (b == -1) {
                    if (this.spare.bytes.length == upto) {
                        this.spare.grow(upto + 2);
                    }
                    this.spare.bytes[upto++] = -1;
                    this.spare.bytes[upto++] = b;
                    continue;
                }
                if (this.spare.bytes.length == upto) {
                    this.spare.grow(upto + 1);
                }
                this.spare.bytes[upto++] = b;
            }
            this.spare.offset = 0;
            this.spare.length = upto;
            return this.spare;
        }
    }
}

