/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.search;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.facet.search.DrillSidewaysScorer;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;

class DrillSidewaysQuery
extends Query {
    final Query baseQuery;
    final Collector drillDownCollector;
    final Collector[] drillSidewaysCollectors;
    final Term[][] drillDownTerms;

    DrillSidewaysQuery(Query baseQuery, Collector drillDownCollector, Collector[] drillSidewaysCollectors, Term[][] drillDownTerms) {
        this.baseQuery = baseQuery;
        this.drillDownCollector = drillDownCollector;
        this.drillSidewaysCollectors = drillSidewaysCollectors;
        this.drillDownTerms = drillDownTerms;
    }

    public String toString(String field) {
        return "DrillSidewaysQuery";
    }

    public Query rewrite(IndexReader reader) throws IOException {
        Query rewrittenQuery;
        Query newQuery = this.baseQuery;
        while ((rewrittenQuery = newQuery.rewrite(reader)) != newQuery) {
            newQuery = rewrittenQuery;
        }
        if (newQuery == this.baseQuery) {
            return this;
        }
        return new DrillSidewaysQuery(newQuery, this.drillDownCollector, this.drillSidewaysCollectors, this.drillDownTerms);
    }

    public Weight createWeight(IndexSearcher searcher) throws IOException {
        final Weight baseWeight = this.baseQuery.createWeight(searcher);
        return new Weight(){

            public Explanation explain(AtomicReaderContext context, int doc) throws IOException {
                return baseWeight.explain(context, doc);
            }

            public Query getQuery() {
                return DrillSidewaysQuery.this.baseQuery;
            }

            public float getValueForNormalization() throws IOException {
                return baseWeight.getValueForNormalization();
            }

            public void normalize(float norm, float topLevelBoost) {
                baseWeight.normalize(norm, topLevelBoost);
            }

            public boolean scoresDocsOutOfOrder() {
                return false;
            }

            public Scorer scorer(AtomicReaderContext context, boolean scoreDocsInOrder, boolean topScorer, Bits acceptDocs) throws IOException {
                Object[] dims = new DrillSidewaysScorer.DocsEnumsAndFreq[DrillSidewaysQuery.this.drillDownTerms.length];
                TermsEnum termsEnum = null;
                String lastField = null;
                int nullCount = 0;
                for (int dim = 0; dim < dims.length; ++dim) {
                    dims[dim] = new DrillSidewaysScorer.DocsEnumsAndFreq();
                    ((DrillSidewaysScorer.DocsEnumsAndFreq)dims[dim]).sidewaysCollector = DrillSidewaysQuery.this.drillSidewaysCollectors[dim];
                    String field = DrillSidewaysQuery.this.drillDownTerms[dim][0].field();
                    ((DrillSidewaysScorer.DocsEnumsAndFreq)dims[dim]).dim = DrillSidewaysQuery.this.drillDownTerms[dim][0].text();
                    if (lastField == null || !lastField.equals(field)) {
                        AtomicReader reader = context.reader();
                        Terms terms = reader.terms(field);
                        termsEnum = terms != null ? terms.iterator(null) : null;
                        lastField = field;
                    }
                    ((DrillSidewaysScorer.DocsEnumsAndFreq)dims[dim]).docsEnums = new DocsEnum[DrillSidewaysQuery.this.drillDownTerms[dim].length];
                    if (termsEnum == null) {
                        ++nullCount;
                        continue;
                    }
                    for (int i = 0; i < DrillSidewaysQuery.this.drillDownTerms[dim].length; ++i) {
                        DocsEnum docsEnum;
                        if (!termsEnum.seekExact(DrillSidewaysQuery.this.drillDownTerms[dim][i].bytes()) || (docsEnum = termsEnum.docs(null, null, 0)) == null) continue;
                        ((DrillSidewaysScorer.DocsEnumsAndFreq)dims[dim]).docsEnums[i] = docsEnum;
                        ((DrillSidewaysScorer.DocsEnumsAndFreq)dims[dim]).maxCost = Math.max(((DrillSidewaysScorer.DocsEnumsAndFreq)dims[dim]).maxCost, docsEnum.cost());
                    }
                }
                if (nullCount > 1 || nullCount == 1 && dims.length == 1) {
                    return null;
                }
                Arrays.sort(dims);
                Scorer baseScorer = baseWeight.scorer(context, scoreDocsInOrder, false, acceptDocs);
                if (baseScorer == null) {
                    return null;
                }
                return new DrillSidewaysScorer(this, context, baseScorer, DrillSidewaysQuery.this.drillDownCollector, (DrillSidewaysScorer.DocsEnumsAndFreq[])dims);
            }
        };
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.baseQuery == null ? 0 : this.baseQuery.hashCode());
        result = 31 * result + (this.drillDownCollector == null ? 0 : this.drillDownCollector.hashCode());
        result = 31 * result + Arrays.hashCode((Object[])this.drillDownTerms);
        result = 31 * result + Arrays.hashCode(this.drillSidewaysCollectors);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        DrillSidewaysQuery other = (DrillSidewaysQuery)((Object)obj);
        if (this.baseQuery == null ? other.baseQuery != null : !this.baseQuery.equals((Object)other.baseQuery)) {
            return false;
        }
        if (this.drillDownCollector == null ? other.drillDownCollector != null : !this.drillDownCollector.equals(other.drillDownCollector)) {
            return false;
        }
        if (!Arrays.equals((Object[])this.drillDownTerms, (Object[])other.drillDownTerms)) {
            return false;
        }
        return Arrays.equals(this.drillSidewaysCollectors, other.drillSidewaysCollectors);
    }
}

