/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Locale;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class Util {
    public static final String PAGE_WEBAPPS = "/webapps";
    public static final String PAGE_VM_STAT = "/vmstat";
    public static final String PAGE_LOGS = "/logs";
    public static final String PARAM_ACTION = "action";
    public static final String PARAM_CONTENT = "content";
    public static final String PARAM_SHUTDOWN = "shutdown";
    public static final String VALUE_SHUTDOWN = "shutdown";

    public static String getName(Bundle bundle, Locale locale) {
        String loc = locale == null ? null : locale.toString();
        String name = (String)bundle.getHeaders(loc).get("Bundle-Name");
        if ((name == null || name.length() == 0) && (name = bundle.getSymbolicName()) == null && (name = bundle.getLocation()) == null) {
            name = String.valueOf(bundle.getBundleId());
        }
        return name;
    }

    public static String getHeaderValue(Bundle bundle, String headerName) {
        Object value = bundle.getHeaders().get(headerName);
        if (value != null) {
            return value.toString();
        }
        return "";
    }

    public static void sort(Bundle[] bundles, Locale locale) {
        Arrays.sort(bundles, new BundleNameComparator(locale));
    }

    public static final ArrayList list(Enumeration e) {
        ArrayList l = new ArrayList();
        while (e.hasMoreElements()) {
            l.add(e.nextElement());
        }
        return l;
    }

    public static final Locale parseLocaleString(String locale) {
        String language;
        if (locale == null) {
            return Locale.getDefault();
        }
        int idx = locale.indexOf(95);
        String country = "";
        if (idx < 0) {
            language = locale;
        } else {
            int last;
            language = locale.substring(0, idx);
            if ((last = locale.indexOf(95, ++idx)) < 0) {
                last = locale.length();
            }
            country = locale.substring(idx, last);
        }
        return new Locale(language, country);
    }

    private static final class BundleNameComparator
    implements Comparator {
        private final Locale locale;

        BundleNameComparator(Locale locale) {
            this.locale = locale;
        }

        public int compare(Object o1, Object o2) {
            return this.compare((Bundle)o1, (Bundle)o2);
        }

        public int compare(Bundle b1, Bundle b2) {
            Version v2;
            if (b1 == b2 || b1.getBundleId() == b2.getBundleId()) {
                return 0;
            }
            if (b1.getBundleId() == 0L) {
                return -1;
            }
            if (b2.getBundleId() == 0L) {
                return 1;
            }
            int snComp = Util.getName(b1, this.locale).compareToIgnoreCase(Util.getName(b2, this.locale));
            if (snComp != 0) {
                return snComp;
            }
            Version v1 = Version.parseVersion((String)((String)b1.getHeaders().get("Bundle-Version")));
            int vComp = v1.compareTo((Object)(v2 = Version.parseVersion((String)((String)b2.getHeaders().get("Bundle-Version")))));
            if (vComp != 0) {
                return vComp;
            }
            if (b1.getBundleId() < b2.getBundleId()) {
                return -1;
            }
            return 1;
        }
    }
}

