/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.protocol.types;

import java.nio.ByteBuffer;
import org.apache.kafka.common.compress.Compression;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TypeTest {
    @Test
    public void testEmptyRecordsSerde() {
        ByteBuffer buffer = ByteBuffer.allocate(4);
        Type.RECORDS.write(buffer, (Object)MemoryRecords.EMPTY);
        buffer.flip();
        Assertions.assertEquals((int)4, (int)Type.RECORDS.sizeOf((Object)MemoryRecords.EMPTY));
        Assertions.assertEquals((int)4, (int)buffer.limit());
        Assertions.assertEquals((Object)MemoryRecords.EMPTY, (Object)Type.RECORDS.read(buffer));
    }

    @Test
    public void testNullRecordsSerde() {
        ByteBuffer buffer = ByteBuffer.allocate(4);
        Type.RECORDS.write(buffer, null);
        buffer.flip();
        Assertions.assertEquals((int)4, (int)Type.RECORDS.sizeOf((Object)MemoryRecords.EMPTY));
        Assertions.assertEquals((int)4, (int)buffer.limit());
        Assertions.assertNull((Object)Type.RECORDS.read(buffer));
    }

    @Test
    public void testRecordsSerde() {
        MemoryRecords records = MemoryRecords.withRecords((Compression)Compression.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("foo".getBytes()), new SimpleRecord("bar".getBytes())});
        ByteBuffer buffer = ByteBuffer.allocate(Type.RECORDS.sizeOf((Object)records));
        Type.RECORDS.write(buffer, (Object)records);
        buffer.flip();
        Assertions.assertEquals((Object)records, (Object)Type.RECORDS.read(buffer));
    }

    @Test
    public void testEmptyCompactRecordsSerde() {
        ByteBuffer buffer = ByteBuffer.allocate(4);
        Type.COMPACT_RECORDS.write(buffer, (Object)MemoryRecords.EMPTY);
        buffer.flip();
        Assertions.assertEquals((int)1, (int)Type.COMPACT_RECORDS.sizeOf((Object)MemoryRecords.EMPTY));
        Assertions.assertEquals((int)1, (int)buffer.limit());
        Assertions.assertEquals((Object)MemoryRecords.EMPTY, (Object)Type.COMPACT_RECORDS.read(buffer));
    }

    @Test
    public void testNullCompactRecordsSerde() {
        ByteBuffer buffer = ByteBuffer.allocate(4);
        Type.COMPACT_RECORDS.write(buffer, null);
        buffer.flip();
        Assertions.assertEquals((int)1, (int)Type.COMPACT_RECORDS.sizeOf((Object)MemoryRecords.EMPTY));
        Assertions.assertEquals((int)1, (int)buffer.limit());
        Assertions.assertNull((Object)Type.COMPACT_RECORDS.read(buffer));
    }

    @Test
    public void testCompactRecordsSerde() {
        MemoryRecords records = MemoryRecords.withRecords((Compression)Compression.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("foo".getBytes()), new SimpleRecord("bar".getBytes())});
        ByteBuffer buffer = ByteBuffer.allocate(Type.COMPACT_RECORDS.sizeOf((Object)records));
        Type.COMPACT_RECORDS.write(buffer, (Object)records);
        buffer.flip();
        Assertions.assertEquals((Object)records, (Object)Type.COMPACT_RECORDS.read(buffer));
    }
}

