/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network;

import java.lang.reflect.Field;
import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.internals.BrokerSecurityConfigs;
import org.apache.kafka.common.message.ApiMessageType;
import org.apache.kafka.common.network.CertStores;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Mode;
import org.apache.kafka.common.network.SaslChannelBuilder;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.TestSecurityConfig;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.authenticator.TestJaasConfig;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerLoginModule;
import org.apache.kafka.common.security.plain.PlainLoginModule;
import org.apache.kafka.common.security.scram.ScramLoginModule;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.test.TestUtils;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class SaslChannelBuilderTest {
    @AfterEach
    public void tearDown() {
        System.clearProperty("sun.security.jgss.native");
    }

    @Test
    public void testCloseBeforeConfigureIsIdempotent() {
        SaslChannelBuilder builder = this.createChannelBuilder(SecurityProtocol.SASL_PLAINTEXT, "PLAIN");
        builder.close();
        Assertions.assertTrue((boolean)builder.loginManagers().isEmpty());
        builder.close();
        Assertions.assertTrue((boolean)builder.loginManagers().isEmpty());
    }

    @Test
    public void testCloseAfterConfigIsIdempotent() {
        SaslChannelBuilder builder = this.createChannelBuilder(SecurityProtocol.SASL_PLAINTEXT, "PLAIN");
        builder.configure(new HashMap());
        Assertions.assertNotNull(builder.loginManagers().get("PLAIN"));
        builder.close();
        Assertions.assertTrue((boolean)builder.loginManagers().isEmpty());
        builder.close();
        Assertions.assertTrue((boolean)builder.loginManagers().isEmpty());
    }

    @Test
    public void testLoginManagerReleasedIfConfigureThrowsException() {
        SaslChannelBuilder builder = this.createChannelBuilder(SecurityProtocol.SASL_SSL, "PLAIN");
        try {
            builder.configure(Collections.singletonMap("ssl.enabled.protocols", "1"));
            Assertions.fail((String)"Exception should have been thrown");
        }
        catch (KafkaException e) {
            Assertions.assertTrue((boolean)builder.loginManagers().isEmpty());
        }
        builder.close();
        Assertions.assertTrue((boolean)builder.loginManagers().isEmpty());
    }

    @Test
    public void testNativeGssapiCredentials() throws Exception {
        System.setProperty("sun.security.jgss.native", "true");
        TestJaasConfig jaasConfig = new TestJaasConfig();
        jaasConfig.addEntry("jaasContext", TestGssapiLoginModule.class.getName(), new HashMap<String, Object>());
        JaasContext jaasContext = new JaasContext("jaasContext", JaasContext.Type.SERVER, (Configuration)jaasConfig, null);
        Map<String, JaasContext> jaasContexts = Collections.singletonMap("GSSAPI", jaasContext);
        GSSManager gssManager = (GSSManager)Mockito.mock(GSSManager.class);
        GSSName gssName = (GSSName)Mockito.mock(GSSName.class);
        Mockito.when((Object)gssManager.createName(Mockito.anyString(), (Oid)Mockito.any())).thenAnswer(unused -> gssName);
        Oid oid = new Oid("1.2.840.113554.1.2.2");
        Mockito.when((Object)gssManager.createCredential(gssName, Integer.MAX_VALUE, oid, 2)).thenAnswer(unused -> (GSSCredential)Mockito.mock(GSSCredential.class));
        SaslChannelBuilder channelBuilder1 = this.createGssapiChannelBuilder(jaasContexts, gssManager);
        Assertions.assertEquals((int)1, (int)channelBuilder1.subject("GSSAPI").getPrincipals().size());
        Assertions.assertEquals((int)1, (int)channelBuilder1.subject("GSSAPI").getPrivateCredentials().size());
        SaslChannelBuilder channelBuilder2 = this.createGssapiChannelBuilder(jaasContexts, gssManager);
        Assertions.assertEquals((int)1, (int)channelBuilder2.subject("GSSAPI").getPrincipals().size());
        Assertions.assertEquals((int)1, (int)channelBuilder2.subject("GSSAPI").getPrivateCredentials().size());
        Assertions.assertSame((Object)channelBuilder1.subject("GSSAPI"), (Object)channelBuilder2.subject("GSSAPI"));
        ((GSSManager)Mockito.verify((Object)gssManager, (VerificationMode)Mockito.times((int)1))).createCredential(gssName, Integer.MAX_VALUE, oid, 2);
    }

    @Test
    public void testClientChannelBuilderWithBrokerConfigs() throws Exception {
        HashMap<String, Object> configs = new HashMap<String, Object>();
        CertStores certStores = new CertStores(false, "client", "localhost");
        configs.putAll(certStores.getTrustingConfig(certStores));
        configs.put("sasl.kerberos.service.name", "kafka");
        configs.putAll(new ConfigDef().withClientSaslSupport().parse(configs));
        for (Field field : BrokerSecurityConfigs.class.getFields()) {
            if (!field.getName().endsWith("_CONFIG")) continue;
            configs.put(field.get(BrokerSecurityConfigs.class).toString(), "somevalue");
        }
        SaslChannelBuilder plainBuilder = this.createChannelBuilder(SecurityProtocol.SASL_PLAINTEXT, "PLAIN");
        plainBuilder.configure(configs);
        SaslChannelBuilder gssapiBuilder = this.createChannelBuilder(SecurityProtocol.SASL_PLAINTEXT, "GSSAPI");
        gssapiBuilder.configure(configs);
        SaslChannelBuilder oauthBearerBuilder = this.createChannelBuilder(SecurityProtocol.SASL_PLAINTEXT, "OAUTHBEARER");
        oauthBearerBuilder.configure(configs);
        SaslChannelBuilder scramBuilder = this.createChannelBuilder(SecurityProtocol.SASL_PLAINTEXT, "SCRAM-SHA-256");
        scramBuilder.configure(configs);
        SaslChannelBuilder saslSslBuilder = this.createChannelBuilder(SecurityProtocol.SASL_SSL, "PLAIN");
        saslSslBuilder.configure(configs);
    }

    private SaslChannelBuilder createGssapiChannelBuilder(Map<String, JaasContext> jaasContexts, final GSSManager gssManager) {
        SaslChannelBuilder channelBuilder = new SaslChannelBuilder(Mode.SERVER, jaasContexts, SecurityProtocol.SASL_PLAINTEXT, new ListenerName("GSSAPI"), false, "GSSAPI", true, null, null, null, Time.SYSTEM, new LogContext(), this.defaultApiVersionsSupplier()){

            protected GSSManager gssManager() {
                return gssManager;
            }
        };
        Map<String, String> props = Collections.singletonMap("sasl.kerberos.service.name", "kafka");
        channelBuilder.configure(new TestSecurityConfig(props).values());
        return channelBuilder;
    }

    private Supplier<ApiVersionsResponse> defaultApiVersionsSupplier() {
        return () -> TestUtils.defaultApiVersionsResponse(ApiMessageType.ListenerType.ZK_BROKER);
    }

    private SaslChannelBuilder createChannelBuilder(SecurityProtocol securityProtocol, String saslMechanism) {
        Class loginModule;
        switch (saslMechanism) {
            case "PLAIN": {
                loginModule = PlainLoginModule.class;
                break;
            }
            case "SCRAM-SHA-256": {
                loginModule = ScramLoginModule.class;
                break;
            }
            case "OAUTHBEARER": {
                loginModule = OAuthBearerLoginModule.class;
                break;
            }
            case "GSSAPI": {
                loginModule = TestGssapiLoginModule.class;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported SASL mechanism " + saslMechanism);
            }
        }
        TestJaasConfig jaasConfig = new TestJaasConfig();
        jaasConfig.addEntry("jaasContext", loginModule.getName(), new HashMap<String, Object>());
        JaasContext jaasContext = new JaasContext("jaasContext", JaasContext.Type.SERVER, (Configuration)jaasConfig, null);
        Map<String, JaasContext> jaasContexts = Collections.singletonMap(saslMechanism, jaasContext);
        return new SaslChannelBuilder(Mode.CLIENT, jaasContexts, securityProtocol, new ListenerName(saslMechanism), false, saslMechanism, true, null, null, null, Time.SYSTEM, new LogContext(), this.defaultApiVersionsSupplier());
    }

    public static final class TestGssapiLoginModule
    implements LoginModule {
        private Subject subject;

        @Override
        public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
            this.subject = subject;
        }

        @Override
        public boolean login() throws LoginException {
            this.subject.getPrincipals().add((Principal)new KafkaPrincipal("User", "kafka@kafka1.example.com"));
            return true;
        }

        @Override
        public boolean commit() throws LoginException {
            return true;
        }

        @Override
        public boolean abort() throws LoginException {
            return true;
        }

        @Override
        public boolean logout() {
            return true;
        }
    }
}

