/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.value;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import org.apache.jackrabbit.core.value.BLOBFileValue;
import org.apache.jackrabbit.uuid.Constants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BLOBInMemory
extends BLOBFileValue {
    private static Logger log;
    private static final String PREFIX = "0x";
    private byte[] data;
    private static final byte[] EMPTY_BYTE_ARRAY;
    private static final BLOBInMemory EMPTY;
    static final /* synthetic */ boolean $assertionsDisabled;

    private BLOBInMemory(byte[] data) {
        this.data = data;
    }

    static BLOBInMemory getInstance(byte[] data) {
        if (data.length == 0) {
            return EMPTY;
        }
        return new BLOBInMemory(data);
    }

    static boolean isInstance(String s) {
        return s.startsWith(PREFIX);
    }

    static BLOBInMemory getInstance(String s) throws IllegalArgumentException {
        if (!$assertionsDisabled && !s.startsWith(PREFIX)) {
            throw new AssertionError();
        }
        int len = (s = s.substring(PREFIX.length())).length();
        if (len % 2 != 0) {
            String msg = "unable to deserialize byte array " + s + " , length=" + s.length();
            log.debug(msg);
            throw new IllegalArgumentException(msg);
        }
        byte[] data = new byte[len /= 2];
        try {
            for (int i = 0; i < len; ++i) {
                data[i] = (byte)(Character.digit(s.charAt(2 * i), 16) << 4 | Character.digit(s.charAt(2 * i + 1), 16));
            }
        }
        catch (NumberFormatException e) {
            String msg = "unable to deserialize byte array " + s;
            log.debug(msg);
            throw new IllegalArgumentException(msg);
        }
        return BLOBInMemory.getInstance(data);
    }

    public void delete(boolean pruneEmptyParentDirs) {
    }

    public void discard() {
    }

    public boolean isImmutable() {
        return true;
    }

    public long getLength() {
        return this.data.length;
    }

    public InputStream getStream() {
        return new ByteArrayInputStream(this.data);
    }

    public String toString() {
        StringBuffer buff = new StringBuffer(PREFIX.length() + 2 * this.data.length);
        buff.append(PREFIX);
        char[] hex = Constants.hexDigits;
        for (int i = 0; i < this.data.length; ++i) {
            int c = this.data[i] & 0xFF;
            buff.append(hex[c >> 4]);
            buff.append(hex[c & 0xF]);
        }
        return buff.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BLOBInMemory) {
            BLOBInMemory other = (BLOBInMemory)obj;
            return Arrays.equals(this.data, other.data);
        }
        return false;
    }

    public int hashCode() {
        return 0;
    }

    public boolean isSmall() {
        return true;
    }

    static {
        $assertionsDisabled = !BLOBInMemory.class.desiredAssertionStatus();
        log = LoggerFactory.getLogger(BLOBInMemory.class);
        EMPTY_BYTE_ARRAY = new byte[0];
        EMPTY = new BLOBInMemory(EMPTY_BYTE_ARRAY);
    }
}

