/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.authorization.principalbased;

import java.security.Principal;
import java.security.acl.Group;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.Item;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import org.apache.jackrabbit.api.jsr283.security.AccessControlEntry;
import org.apache.jackrabbit.api.jsr283.security.AccessControlException;
import org.apache.jackrabbit.api.jsr283.security.AccessControlManager;
import org.apache.jackrabbit.api.jsr283.security.Privilege;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.PropertyImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.security.authorization.AccessControlConstants;
import org.apache.jackrabbit.core.security.authorization.AccessControlEntryImpl;
import org.apache.jackrabbit.core.security.authorization.JackrabbitAccessControlList;
import org.apache.jackrabbit.core.security.authorization.principalbased.GlobPattern;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ACLTemplate
implements JackrabbitAccessControlList,
AccessControlConstants {
    private static Logger log = LoggerFactory.getLogger(ACLTemplate.class);
    static final Name P_NODE_PATH = NF.create("internal", "nodePath");
    static final Name P_GLOB = NF.create("internal", "glob");
    private final Principal principal;
    private final String path;
    private final ValueFactory valueFactory;
    private final List entries = new ArrayList();
    private final String jcrNodePathName;
    private final String jcrGlobName;

    ACLTemplate(Principal principal, String path, NamePathResolver resolver, ValueFactory vf) throws RepositoryException {
        this(principal, path, null, resolver, vf);
    }

    ACLTemplate(Principal principal, NodeImpl acNode) throws RepositoryException {
        this(principal, acNode.getPath(), acNode, (SessionImpl)acNode.getSession(), acNode.getSession().getValueFactory());
    }

    private ACLTemplate(Principal principal, String path, NodeImpl acNode, NamePathResolver resolver, ValueFactory vf) throws RepositoryException {
        this.principal = principal;
        this.path = path;
        this.valueFactory = vf;
        this.jcrNodePathName = resolver.getJCRName(P_NODE_PATH);
        this.jcrGlobName = resolver.getJCRName(P_GLOB);
        if (acNode != null && acNode.hasNode(N_POLICY)) {
            NodeImpl aclNode = acNode.getNode(N_POLICY);
            AccessControlManager acMgr = ((SessionImpl)aclNode.getSession()).getAccessControlManager();
            NodeIterator aceNodes = aclNode.getNodes();
            while (aceNodes.hasNext()) {
                NodeImpl aceNode = (NodeImpl)aceNodes.nextNode();
                if (aceNode.isNodeType(NT_REP_ACE)) {
                    boolean isAllow = aceNode.isNodeType(NT_REP_GRANT_ACE);
                    Value[] pValues = aceNode.getProperty(P_PRIVILEGES).getValues();
                    Privilege[] privileges = new Privilege[pValues.length];
                    for (int i = 0; i < pValues.length; ++i) {
                        privileges[i] = acMgr.privilegeFromName(pValues[i].getString());
                    }
                    HashMap<String, Value> restrictions = new HashMap<String, Value>(2);
                    PropertyImpl prop = aceNode.getProperty(P_NODE_PATH);
                    restrictions.put(prop.getName(), prop.getValue());
                    if (aceNode.hasProperty(P_GLOB)) {
                        prop = aceNode.getProperty(P_GLOB);
                        restrictions.put(prop.getName(), prop.getValue());
                    }
                    AccessControlEntry entry = this.createEntry(principal, privileges, isAllow, restrictions);
                    this.entries.add(entry);
                    continue;
                }
                log.warn("ACE must be of nodetype rep:ACE -> ignored child-node " + aceNode.getPath());
            }
        }
    }

    AccessControlEntry createEntry(Principal princ, Privilege[] privileges, boolean allow, Map restrictions) throws RepositoryException {
        if (!((Object)this.principal).equals(princ)) {
            throw new AccessControlException("Invalid principal. Expected: " + this.principal);
        }
        if (!allow && this.principal instanceof Group) {
            throw new AccessControlException("For group principals permissions can only be added but not denied.");
        }
        Set rNames = restrictions.keySet();
        if (!rNames.contains(this.jcrNodePathName)) {
            throw new AccessControlException("Missing mandatory restriction: " + this.jcrNodePathName);
        }
        Value v = (Value)restrictions.get(this.jcrNodePathName);
        if (v.getType() != 8) {
            v = this.valueFactory.createValue(v.getString(), 8);
            restrictions.put(this.jcrNodePathName, v);
        }
        if ((v = (Value)restrictions.get(this.jcrGlobName)) != null && v.getType() != 1) {
            v = this.valueFactory.createValue(v.getString(), 1);
            restrictions.put(this.jcrGlobName, v);
        }
        return new Entry(princ, privileges, allow, restrictions);
    }

    public String getPath() {
        return this.path;
    }

    public String[] getRestrictionNames() {
        return new String[]{this.jcrNodePathName, this.jcrGlobName};
    }

    public int getRestrictionType(String restrictionName) {
        if (this.jcrNodePathName.equals(restrictionName)) {
            return 8;
        }
        if (this.jcrGlobName.equals(restrictionName)) {
            return 1;
        }
        return 0;
    }

    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    public int size() {
        return this.entries.size();
    }

    public boolean addEntry(Principal principal, Privilege[] privileges, boolean isAllow) throws AccessControlException, RepositoryException {
        return this.addEntry(principal, privileges, isAllow, null);
    }

    public boolean addEntry(Principal principal, Privilege[] privileges, boolean isAllow, Map restrictions) throws AccessControlException, RepositoryException {
        AccessControlEntry entry;
        if (restrictions == null || restrictions.isEmpty()) {
            log.debug("Restrictions missing. Using default: rep:nodePath = " + this.getPath() + "; rep:glob = null.");
            restrictions = Collections.singletonMap(this.jcrNodePathName, this.valueFactory.createValue(this.getPath(), 8));
        }
        if (this.entries.contains(entry = this.createEntry(principal, privileges, isAllow, restrictions))) {
            log.debug("Entry is already contained in policy -> no modification.");
            return false;
        }
        this.entries.add(0, entry);
        return true;
    }

    public AccessControlEntry[] getAccessControlEntries() throws RepositoryException {
        return this.entries.toArray(new AccessControlEntry[this.entries.size()]);
    }

    public boolean addAccessControlEntry(Principal principal, Privilege[] privileges) throws AccessControlException, RepositoryException {
        return this.addEntry(principal, privileges, true, Collections.EMPTY_MAP);
    }

    public void removeAccessControlEntry(AccessControlEntry ace) throws AccessControlException, RepositoryException {
        if (!(ace instanceof Entry)) {
            throw new AccessControlException("Invalid AccessControlEntry implementation " + ace.getClass().getName() + ".");
        }
        if (!this.entries.remove(ace)) {
            throw new AccessControlException("Cannot remove AccessControlEntry " + ace);
        }
    }

    public int hashCode() {
        return 0;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ACLTemplate) {
            ACLTemplate acl = (ACLTemplate)obj;
            return ((Object)this.principal).equals(acl.principal) && this.path.equals(acl.path) && ((Object)this.entries).equals(acl.entries);
        }
        return false;
    }

    class Entry
    extends AccessControlEntryImpl {
        private final String nodePath;
        private final GlobPattern pattern;

        private Entry(Principal principal, Privilege[] privileges, boolean allow, Map restrictions) throws AccessControlException, RepositoryException {
            super(principal, privileges, allow, restrictions, ACLTemplate.this.valueFactory);
            Value np = this.getRestriction(ACLTemplate.this.jcrNodePathName);
            this.nodePath = this.getRestriction(ACLTemplate.this.jcrNodePathName).getString();
            Value glob = this.getRestriction(ACLTemplate.this.jcrGlobName);
            if (glob != null) {
                StringBuffer b = new StringBuffer(this.nodePath);
                b.append(glob.getString());
                this.pattern = GlobPattern.create(b.toString());
            } else {
                this.pattern = GlobPattern.create(this.nodePath);
            }
        }

        boolean matches(String jcrPath) throws RepositoryException {
            return this.pattern.matches(jcrPath);
        }

        boolean matches(Item item) throws RepositoryException {
            return this.pattern.matches(item);
        }

        boolean matchesNodePath(String jcrPath) {
            return this.nodePath.equals(jcrPath);
        }
    }
}

