/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.google.protobuf.BlockingRpcChannel;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.RetriesExhaustedWithDetailsException;
import org.apache.hadoop.hbase.client.ReversedClientScanner;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.ZooKeeperKeepAliveConnection;
import org.apache.hadoop.hbase.client.metrics.ScanMetrics;
import org.apache.hadoop.hbase.coprocessor.MultiRowMutationEndpoint;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.KeyOnlyFilter;
import org.apache.hadoop.hbase.filter.LongComparator;
import org.apache.hadoop.hbase.filter.PrefixFilter;
import org.apache.hadoop.hbase.filter.QualifierFilter;
import org.apache.hadoop.hbase.filter.RegexStringComparator;
import org.apache.hadoop.hbase.filter.RowFilter;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.hbase.filter.WhileMatchFilter;
import org.apache.hadoop.hbase.io.hfile.BlockCache;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.protobuf.generated.MultiRowMutationProtos;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.NoSuchColumnFamilyException;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestFromClientSide {
    final Log LOG = LogFactory.getLog(this.getClass());
    protected static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static byte[] ROW = Bytes.toBytes((String)"testRow");
    private static byte[] FAMILY = Bytes.toBytes((String)"testFamily");
    private static byte[] QUALIFIER = Bytes.toBytes((String)"testQualifier");
    private static byte[] VALUE = Bytes.toBytes((String)"testValue");
    protected static int SLAVES = 3;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setStrings("hbase.coprocessor.region.classes", new String[]{MultiRowMutationEndpoint.class.getName()});
        conf.setBoolean("hbase.table.sanity.checks", true);
        TEST_UTIL.startMiniCluster(SLAVES);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testKeepDeletedCells() throws Exception {
        byte[] TABLENAME = Bytes.toBytes((String)"testKeepDeletesCells");
        byte[] FAMILY = Bytes.toBytes((String)"family");
        byte[] C0 = Bytes.toBytes((String)"c0");
        byte[] T1 = Bytes.toBytes((String)"T1");
        byte[] T2 = Bytes.toBytes((String)"T2");
        byte[] T3 = Bytes.toBytes((String)"T3");
        HColumnDescriptor hcd = new HColumnDescriptor(FAMILY).setKeepDeletedCells(true).setMaxVersions(3);
        HTableDescriptor desc = new HTableDescriptor(TableName.valueOf((byte[])TABLENAME));
        desc.addFamily(hcd);
        TEST_UTIL.getHBaseAdmin().createTable(desc);
        Configuration c = TEST_UTIL.getConfiguration();
        HTable h = new HTable(c, TABLENAME);
        long ts = System.currentTimeMillis();
        Put p = new Put(T1, ts);
        p.add(FAMILY, C0, T1);
        h.put(p);
        p = new Put(T1, ts + 2L);
        p.add(FAMILY, C0, T2);
        h.put(p);
        p = new Put(T1, ts + 4L);
        p.add(FAMILY, C0, T3);
        h.put(p);
        Delete d = new Delete(T1, ts + 3L);
        h.delete(d);
        d = new Delete(T1, ts + 3L);
        d.deleteColumns(FAMILY, C0, ts + 3L);
        h.delete(d);
        Get g = new Get(T1);
        g.setTimeRange(0L, ts + 3L);
        Result r = h.get(g);
        Assert.assertArrayEquals((byte[])T2, (byte[])r.getValue(FAMILY, C0));
        Scan s = new Scan(T1);
        s.setTimeRange(0L, ts + 3L);
        s.setMaxVersions();
        ResultScanner scanner = h.getScanner(s);
        Cell[] kvs = scanner.next().rawCells();
        Assert.assertArrayEquals((byte[])T2, (byte[])CellUtil.cloneValue((Cell)kvs[0]));
        Assert.assertArrayEquals((byte[])T1, (byte[])CellUtil.cloneValue((Cell)kvs[1]));
        scanner.close();
        s = new Scan(T1);
        s.setRaw(true);
        s.setMaxVersions();
        scanner = h.getScanner(s);
        kvs = scanner.next().rawCells();
        Assert.assertTrue((boolean)CellUtil.isDeleteFamily((Cell)kvs[0]));
        Assert.assertArrayEquals((byte[])T3, (byte[])CellUtil.cloneValue((Cell)kvs[1]));
        Assert.assertTrue((boolean)CellUtil.isDelete((Cell)kvs[2]));
        Assert.assertArrayEquals((byte[])T2, (byte[])CellUtil.cloneValue((Cell)kvs[3]));
        Assert.assertArrayEquals((byte[])T1, (byte[])CellUtil.cloneValue((Cell)kvs[4]));
        scanner.close();
        h.close();
    }

    @Test
    public void testPurgeFutureDeletes() throws Exception {
        final byte[] TABLENAME = Bytes.toBytes((String)"testPurgeFutureDeletes");
        byte[] ROW = Bytes.toBytes((String)"row");
        byte[] FAMILY = Bytes.toBytes((String)"family");
        byte[] COLUMN = Bytes.toBytes((String)"column");
        byte[] VALUE = Bytes.toBytes((String)"value");
        HTable table = TEST_UTIL.createTable(TABLENAME, FAMILY);
        long ts = System.currentTimeMillis() * 2L;
        Put put = new Put(ROW, ts);
        put.add(FAMILY, COLUMN, VALUE);
        table.put(put);
        Get get = new Get(ROW);
        Result result = table.get(get);
        Assert.assertArrayEquals((byte[])VALUE, (byte[])result.getValue(FAMILY, COLUMN));
        Delete del = new Delete(ROW);
        del.deleteColumn(FAMILY, COLUMN, ts);
        table.delete(del);
        get = new Get(ROW);
        result = table.get(get);
        Assert.assertNull((Object)result.getValue(FAMILY, COLUMN));
        TEST_UTIL.getHBaseAdmin().flush(TABLENAME);
        TEST_UTIL.getHBaseAdmin().majorCompact(TABLENAME);
        TEST_UTIL.waitFor(6000L, new Waiter.Predicate<IOException>(){

            public boolean evaluate() throws IOException {
                try {
                    return TEST_UTIL.getHBaseAdmin().getCompactionState(TABLENAME) == AdminProtos.GetRegionInfoResponse.CompactionState.NONE;
                }
                catch (InterruptedException e) {
                    throw new IOException(e);
                }
            }
        });
        put = new Put(ROW, ts);
        put.add(FAMILY, COLUMN, VALUE);
        table.put(put);
        get = new Get(ROW);
        result = table.get(get);
        Assert.assertArrayEquals((byte[])VALUE, (byte[])result.getValue(FAMILY, COLUMN));
        table.close();
    }

    @Test
    public void testSharedZooKeeper() throws Exception {
        Configuration newConfig = new Configuration(TEST_UTIL.getConfiguration());
        newConfig.set("hbase.client.instance.id", "12345");
        ZooKeeperWatcher z0 = new ZooKeeperWatcher(newConfig, "hconnection", new Abortable(){

            public void abort(String why, Throwable e) {
            }

            public boolean isAborted() {
                return false;
            }
        });
        z0.getRecoverableZooKeeper().getZooKeeper().exists("/oldZooKeeperWatcher", false);
        z0.close();
        HConnectionManager.HConnectionImplementation connection1 = (HConnectionManager.HConnectionImplementation)HConnectionManager.getConnection((Configuration)newConfig);
        ZooKeeperKeepAliveConnection z1 = connection1.getKeepAliveZooKeeperWatcher();
        z1.getRecoverableZooKeeper().getZooKeeper().exists("/z1", false);
        z1.close();
        z1.getRecoverableZooKeeper().getZooKeeper().exists("/z1afterclose", false);
        ZooKeeperKeepAliveConnection z2 = connection1.getKeepAliveZooKeeperWatcher();
        Assert.assertTrue((String)"ZooKeeperKeepAliveConnection equals on same connection", (z1 == z2 ? 1 : 0) != 0);
        Configuration newConfig2 = new Configuration(TEST_UTIL.getConfiguration());
        newConfig2.set("hbase.client.instance.id", "6789");
        HConnectionManager.HConnectionImplementation connection2 = (HConnectionManager.HConnectionImplementation)HConnectionManager.getConnection((Configuration)newConfig2);
        Assert.assertTrue((String)"connections should be different ", (connection1 != connection2 ? 1 : 0) != 0);
        ZooKeeperKeepAliveConnection z3 = connection2.getKeepAliveZooKeeperWatcher();
        Assert.assertTrue((String)"ZooKeeperKeepAliveConnection should be different on different connections", (z1 != z3 ? 1 : 0) != 0);
        Method m = HConnectionManager.HConnectionImplementation.class.getDeclaredMethod("closeZooKeeperWatcher", new Class[0]);
        m.setAccessible(true);
        m.invoke((Object)connection2, new Object[0]);
        ZooKeeperKeepAliveConnection z4 = connection2.getKeepAliveZooKeeperWatcher();
        Assert.assertTrue((String)"ZooKeeperKeepAliveConnection should be recreated when previous connections was closed", (z3 != z4 ? 1 : 0) != 0);
        z2.getRecoverableZooKeeper().getZooKeeper().exists("/z2", false);
        z4.getRecoverableZooKeeper().getZooKeeper().exists("/z4", false);
        HConnectionManager.deleteConnection((Configuration)newConfig);
        try {
            z2.getRecoverableZooKeeper().getZooKeeper().exists("/z2", false);
            Assert.assertTrue((String)"We should not have a valid connection for z2", (boolean)false);
        }
        catch (Exception e) {
            // empty catch block
        }
        z4.getRecoverableZooKeeper().getZooKeeper().exists("/z4", false);
        HConnectionManager.deleteConnection((Configuration)newConfig2);
        try {
            z4.getRecoverableZooKeeper().getZooKeeper().exists("/z4", false);
            Assert.assertTrue((String)"We should not have a valid connection for z4", (boolean)false);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    @Test
    public void testRegionCachePreWarm() throws Exception {
        this.LOG.info((Object)"Starting testRegionCachePreWarm");
        TableName TABLENAME = TableName.valueOf((String)"testCachePrewarm");
        Configuration conf = TEST_UTIL.getConfiguration();
        TEST_UTIL.createTable(TABLENAME, FAMILY);
        HTable.setRegionCachePrefetch((Configuration)conf, (TableName)TABLENAME, (boolean)false);
        Assert.assertFalse((String)"The table is disabled for region cache prefetch", (boolean)HTable.getRegionCachePrefetch((Configuration)conf, (TableName)TABLENAME));
        HTable table = new HTable(conf, TABLENAME);
        TEST_UTIL.createMultiRegions(table, FAMILY);
        TEST_UTIL.countRows(table);
        table.getConnection().clearRegionCache();
        Assert.assertEquals((String)"Clearing cache should have 0 cached ", (long)0L, (long)HConnectionManager.getCachedRegionCount((Configuration)conf, (TableName)TABLENAME));
        Get g = new Get(Bytes.toBytes((String)"aaa"));
        table.get(g);
        Assert.assertEquals((String)"Number of cached region is incorrect ", (long)1L, (long)HConnectionManager.getCachedRegionCount((Configuration)conf, (TableName)TABLENAME));
        HTable.setRegionCachePrefetch((Configuration)conf, (TableName)TABLENAME, (boolean)true);
        Assert.assertTrue((String)"The table is enabled for region cache prefetch", (boolean)HTable.getRegionCachePrefetch((Configuration)conf, (TableName)TABLENAME));
        HTable.setRegionCachePrefetch((Configuration)conf, (TableName)TABLENAME, (boolean)false);
        Assert.assertFalse((String)"The table is disabled for region cache prefetch", (boolean)HTable.getRegionCachePrefetch((Configuration)conf, (TableName)TABLENAME));
        HTable.setRegionCachePrefetch((Configuration)conf, (TableName)TABLENAME, (boolean)true);
        Assert.assertTrue((String)"The table is enabled for region cache prefetch", (boolean)HTable.getRegionCachePrefetch((Configuration)conf, (TableName)TABLENAME));
        table.getConnection().clearRegionCache();
        Assert.assertEquals((String)"Number of cached region is incorrect ", (long)0L, (long)HConnectionManager.getCachedRegionCount((Configuration)conf, (TableName)TABLENAME));
        Get g2 = new Get(Bytes.toBytes((String)"bbb"));
        table.get(g2);
        int prefetchRegionNumber = conf.getInt("hbase.client.prefetch.limit", 10);
        this.LOG.info((Object)"Testing how many regions cached");
        Assert.assertEquals((String)"Number of cached region is incorrect ", (long)prefetchRegionNumber, (long)HConnectionManager.getCachedRegionCount((Configuration)conf, (TableName)TABLENAME));
        table.getConnection().clearRegionCache();
        Get g3 = new Get(Bytes.toBytes((String)"abc"));
        table.get(g3);
        Assert.assertEquals((String)"Number of cached region is incorrect ", (long)prefetchRegionNumber, (long)HConnectionManager.getCachedRegionCount((Configuration)conf, (TableName)TABLENAME));
        this.LOG.info((Object)"Finishing testRegionCachePreWarm");
    }

    @Test
    public void testPrefetchDisableToggle() throws Exception {
        TableName TABLENAME = TableName.valueOf((String)"testPrefetchDisableToggle");
        Configuration conf = new Configuration(TEST_UTIL.getConfiguration());
        conf.setBoolean(HConstants.HBASE_CLIENT_PREFETCH, false);
        HConnection connection = HConnectionManager.createConnection((Configuration)conf);
        Assert.assertFalse((String)"The table is not disabled for region cache prefetch", (boolean)((HConnectionManager.HConnectionImplementation)connection).getRegionCachePrefetch(TABLENAME));
    }

    @Test
    public void testGetConfiguration() throws Exception {
        byte[] TABLE = Bytes.toBytes((String)"testGetConfiguration");
        byte[][] FAMILIES = new byte[][]{Bytes.toBytes((String)"foo")};
        Configuration conf = TEST_UTIL.getConfiguration();
        HTable table = TEST_UTIL.createTable(TABLE, (byte[][])FAMILIES, conf);
        Assert.assertSame((Object)conf, (Object)table.getConfiguration());
    }

    @Test
    public void testWeirdCacheBehaviour() throws Exception {
        byte[] TABLE = Bytes.toBytes((String)"testWeirdCacheBehaviour");
        byte[][] FAMILIES = new byte[][]{Bytes.toBytes((String)"trans-blob"), Bytes.toBytes((String)"trans-type"), Bytes.toBytes((String)"trans-date"), Bytes.toBytes((String)"trans-tags"), Bytes.toBytes((String)"trans-group")};
        HTable ht = TEST_UTIL.createTable(TABLE, (byte[][])FAMILIES);
        String value = "this is the value";
        String value2 = "this is some other value";
        String keyPrefix1 = UUID.randomUUID().toString();
        String keyPrefix2 = UUID.randomUUID().toString();
        String keyPrefix3 = UUID.randomUUID().toString();
        this.putRows(ht, 3, value, keyPrefix1);
        this.putRows(ht, 3, value, keyPrefix2);
        this.putRows(ht, 3, value, keyPrefix3);
        ht.flushCommits();
        this.putRows(ht, 3, value2, keyPrefix1);
        this.putRows(ht, 3, value2, keyPrefix2);
        this.putRows(ht, 3, value2, keyPrefix3);
        HTable table = new HTable(TEST_UTIL.getConfiguration(), TABLE);
        System.out.println("Checking values for key: " + keyPrefix1);
        Assert.assertEquals((String)"Got back incorrect number of rows from scan", (long)3L, (long)this.getNumberOfRows(keyPrefix1, value2, table));
        System.out.println("Checking values for key: " + keyPrefix2);
        Assert.assertEquals((String)"Got back incorrect number of rows from scan", (long)3L, (long)this.getNumberOfRows(keyPrefix2, value2, table));
        System.out.println("Checking values for key: " + keyPrefix3);
        Assert.assertEquals((String)"Got back incorrect number of rows from scan", (long)3L, (long)this.getNumberOfRows(keyPrefix3, value2, table));
        this.deleteColumns(ht, value2, keyPrefix1);
        this.deleteColumns(ht, value2, keyPrefix2);
        this.deleteColumns(ht, value2, keyPrefix3);
        System.out.println("Starting important checks.....");
        Assert.assertEquals((String)("Got back incorrect number of rows from scan: " + keyPrefix1), (long)0L, (long)this.getNumberOfRows(keyPrefix1, value2, table));
        Assert.assertEquals((String)("Got back incorrect number of rows from scan: " + keyPrefix2), (long)0L, (long)this.getNumberOfRows(keyPrefix2, value2, table));
        Assert.assertEquals((String)("Got back incorrect number of rows from scan: " + keyPrefix3), (long)0L, (long)this.getNumberOfRows(keyPrefix3, value2, table));
        ht.setScannerCaching(0);
        Assert.assertEquals((String)"Got back incorrect number of rows from scan", (long)0L, (long)this.getNumberOfRows(keyPrefix1, value2, table));
        ht.setScannerCaching(100);
        Assert.assertEquals((String)"Got back incorrect number of rows from scan", (long)0L, (long)this.getNumberOfRows(keyPrefix2, value2, table));
    }

    private void deleteColumns(HTable ht, String value, String keyPrefix) throws IOException {
        ResultScanner scanner = this.buildScanner(keyPrefix, value, ht);
        Iterator it = scanner.iterator();
        int count = 0;
        while (it.hasNext()) {
            Result result = (Result)it.next();
            Delete delete = new Delete(result.getRow());
            delete.deleteColumn(Bytes.toBytes((String)"trans-tags"), Bytes.toBytes((String)"qual2"));
            ht.delete(delete);
            ++count;
        }
        Assert.assertEquals((String)"Did not perform correct number of deletes", (long)3L, (long)count);
    }

    private int getNumberOfRows(String keyPrefix, String value, HTable ht) throws Exception {
        ResultScanner resultScanner = this.buildScanner(keyPrefix, value, ht);
        Iterator scanner = resultScanner.iterator();
        int numberOfResults = 0;
        while (scanner.hasNext()) {
            Result result = (Result)scanner.next();
            System.out.println("Got back key: " + Bytes.toString((byte[])result.getRow()));
            for (Cell kv : result.rawCells()) {
                System.out.println("kv=" + kv.toString() + ", " + Bytes.toString((byte[])CellUtil.cloneValue((Cell)kv)));
            }
            ++numberOfResults;
        }
        return numberOfResults;
    }

    private ResultScanner buildScanner(String keyPrefix, String value, HTable ht) throws IOException {
        FilterList allFilters = new FilterList(new Filter[0]);
        allFilters.addFilter((Filter)new PrefixFilter(Bytes.toBytes((String)keyPrefix)));
        SingleColumnValueFilter filter = new SingleColumnValueFilter(Bytes.toBytes((String)"trans-tags"), Bytes.toBytes((String)"qual2"), CompareFilter.CompareOp.EQUAL, Bytes.toBytes((String)value));
        filter.setFilterIfMissing(true);
        allFilters.addFilter((Filter)filter);
        Scan scan = new Scan();
        scan.addFamily(Bytes.toBytes((String)"trans-blob"));
        scan.addFamily(Bytes.toBytes((String)"trans-type"));
        scan.addFamily(Bytes.toBytes((String)"trans-date"));
        scan.addFamily(Bytes.toBytes((String)"trans-tags"));
        scan.addFamily(Bytes.toBytes((String)"trans-group"));
        scan.setFilter((Filter)allFilters);
        return ht.getScanner(scan);
    }

    private void putRows(HTable ht, int numRows, String value, String key) throws IOException {
        for (int i = 0; i < numRows; ++i) {
            String row = key + "_" + UUID.randomUUID().toString();
            System.out.println(String.format("Saving row: %s, with value %s", row, value));
            Put put = new Put(Bytes.toBytes((String)row));
            put.setDurability(Durability.SKIP_WAL);
            put.add(Bytes.toBytes((String)"trans-blob"), null, Bytes.toBytes((String)"value for blob"));
            put.add(Bytes.toBytes((String)"trans-type"), null, Bytes.toBytes((String)"statement"));
            put.add(Bytes.toBytes((String)"trans-date"), null, Bytes.toBytes((String)"20090921010101999"));
            put.add(Bytes.toBytes((String)"trans-tags"), Bytes.toBytes((String)"qual2"), Bytes.toBytes((String)value));
            put.add(Bytes.toBytes((String)"trans-group"), null, Bytes.toBytes((String)"adhocTransactionGroupId"));
            ht.put(put);
        }
    }

    @Test
    public void testFilterAcrossMultipleRegions() throws IOException, InterruptedException {
        byte[] name = Bytes.toBytes((String)"testFilterAcrossMutlipleRegions");
        HTable t = TEST_UTIL.createTable(name, FAMILY);
        int rowCount = TEST_UTIL.loadTable(t, FAMILY, false);
        this.assertRowCount(t, rowCount);
        Map<HRegionInfo, ServerName> regions = this.splitTable(t);
        this.assertRowCount(t, rowCount);
        byte[] endKey = regions.keySet().iterator().next().getEndKey();
        int endKeyCount = this.countRows(t, this.createScanWithRowFilter(endKey));
        Assert.assertTrue((endKeyCount < rowCount ? 1 : 0) != 0);
        byte[] key = new byte[]{endKey[0], endKey[1], (byte)(endKey[2] + 1)};
        int plusOneCount = this.countRows(t, this.createScanWithRowFilter(key));
        Assert.assertEquals((long)(endKeyCount + 1), (long)plusOneCount);
        key = new byte[]{endKey[0], endKey[1], (byte)(endKey[2] + 2)};
        int plusTwoCount = this.countRows(t, this.createScanWithRowFilter(key));
        Assert.assertEquals((long)(endKeyCount + 2), (long)plusTwoCount);
        key = new byte[]{endKey[0], endKey[1], (byte)(endKey[2] - 1)};
        int minusOneCount = this.countRows(t, this.createScanWithRowFilter(key));
        Assert.assertEquals((long)(endKeyCount - 1), (long)minusOneCount);
        key = new byte[]{97, 97, 97};
        int countBBB = this.countRows(t, this.createScanWithRowFilter(key, null, CompareFilter.CompareOp.EQUAL));
        Assert.assertEquals((long)1L, (long)countBBB);
        int countGreater = this.countRows(t, this.createScanWithRowFilter(endKey, null, CompareFilter.CompareOp.GREATER_OR_EQUAL));
        Assert.assertEquals((long)0L, (long)countGreater);
        countGreater = this.countRows(t, this.createScanWithRowFilter(endKey, endKey, CompareFilter.CompareOp.GREATER_OR_EQUAL));
        Assert.assertEquals((long)(rowCount - endKeyCount), (long)countGreater);
    }

    private Scan createScanWithRowFilter(byte[] key) {
        return this.createScanWithRowFilter(key, null, CompareFilter.CompareOp.LESS);
    }

    private Scan createScanWithRowFilter(byte[] key, byte[] startRow, CompareFilter.CompareOp op) {
        Assert.assertTrue((key != null && key.length > 0 && Bytes.BYTES_COMPARATOR.compare(key, new byte[]{97, 97, 97}) >= 0 ? 1 : 0) != 0);
        this.LOG.info((Object)("Key=" + Bytes.toString((byte[])key)));
        Scan s = startRow == null ? new Scan() : new Scan(startRow);
        RowFilter f = new RowFilter(op, (ByteArrayComparable)new BinaryComparator(key));
        f = new WhileMatchFilter((Filter)f);
        s.setFilter((Filter)f);
        return s;
    }

    private int countRows(HTable t, Scan s) throws IOException {
        ResultScanner scanner = t.getScanner(s);
        int count = 0;
        for (Result result : scanner) {
            ++count;
            Assert.assertTrue((result.size() > 0 ? 1 : 0) != 0);
        }
        return count;
    }

    private void assertRowCount(HTable t, int expected) throws IOException {
        Assert.assertEquals((long)expected, (long)this.countRows(t, new Scan()));
    }

    private Map<HRegionInfo, ServerName> splitTable(HTable t) throws IOException, InterruptedException {
        HBaseAdmin admin = new HBaseAdmin(TEST_UTIL.getConfiguration());
        admin.split(t.getTableName());
        admin.close();
        Map<HRegionInfo, ServerName> regions = this.waitOnSplit(t);
        Assert.assertTrue((regions.size() > 1 ? 1 : 0) != 0);
        return regions;
    }

    private Map<HRegionInfo, ServerName> waitOnSplit(HTable t) throws IOException {
        NavigableMap regions = t.getRegionLocations();
        int originalCount = regions.size();
        for (int i = 0; i < TEST_UTIL.getConfiguration().getInt("hbase.test.retries", 30); ++i) {
            Thread.currentThread();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            regions = t.getRegionLocations();
            if (regions.size() > originalCount) break;
        }
        return regions;
    }

    @Test
    public void testSuperSimple() throws Exception {
        byte[] TABLE = Bytes.toBytes((String)"testSuperSimple");
        HTable ht = TEST_UTIL.createTable(TABLE, FAMILY);
        Put put = new Put(ROW);
        put.add(FAMILY, QUALIFIER, VALUE);
        ht.put(put);
        Scan scan = new Scan();
        scan.addColumn(FAMILY, TABLE);
        ResultScanner scanner = ht.getScanner(scan);
        Result result = scanner.next();
        Assert.assertTrue((String)"Expected null result", (result == null ? 1 : 0) != 0);
        scanner.close();
    }

    @Test
    public void testMaxKeyValueSize() throws Exception {
        byte[] TABLE = Bytes.toBytes((String)"testMaxKeyValueSize");
        Configuration conf = TEST_UTIL.getConfiguration();
        String oldMaxSize = conf.get("hbase.client.keyvalue.maxsize");
        HTable ht = TEST_UTIL.createTable(TABLE, FAMILY);
        byte[] value = new byte[0x400000];
        Put put = new Put(ROW);
        put.add(FAMILY, QUALIFIER, value);
        ht.put(put);
        try {
            conf.setInt("hbase.client.keyvalue.maxsize", 0x200000);
            TABLE = Bytes.toBytes((String)"testMaxKeyValueSize2");
            ht = TEST_UTIL.createTable(TABLE, FAMILY);
            put = new Put(ROW);
            put.add(FAMILY, QUALIFIER, value);
            ht.put(put);
            Assert.fail((String)"Inserting a too large KeyValue worked, should throw exception");
        }
        catch (Exception e) {
            // empty catch block
        }
        conf.set("hbase.client.keyvalue.maxsize", oldMaxSize);
    }

    @Test
    public void testFilters() throws Exception {
        byte[] TABLE = Bytes.toBytes((String)"testFilters");
        HTable ht = TEST_UTIL.createTable(TABLE, FAMILY);
        byte[][] ROWS = this.makeN(ROW, 10);
        byte[][] QUALIFIERS = new byte[][]{Bytes.toBytes((String)"col0-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col1-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col2-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col3-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col4-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col5-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col6-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col7-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col8-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col9-<d2v1>-<d3v2>")};
        for (int i = 0; i < 10; ++i) {
            Put put = new Put(ROWS[i]);
            put.setDurability(Durability.SKIP_WAL);
            put.add(FAMILY, QUALIFIERS[i], VALUE);
            ht.put(put);
        }
        Scan scan = new Scan();
        scan.addFamily(FAMILY);
        QualifierFilter filter = new QualifierFilter(CompareFilter.CompareOp.EQUAL, (ByteArrayComparable)new RegexStringComparator("col[1-5]"));
        scan.setFilter((Filter)filter);
        ResultScanner scanner = ht.getScanner(scan);
        int expectedIndex = 1;
        for (Result result : ht.getScanner(scan)) {
            Assert.assertEquals((long)result.size(), (long)1L);
            Assert.assertTrue((boolean)Bytes.equals((byte[])CellUtil.cloneRow((Cell)result.rawCells()[0]), (byte[])ROWS[expectedIndex]));
            Assert.assertTrue((boolean)Bytes.equals((byte[])CellUtil.cloneQualifier((Cell)result.rawCells()[0]), (byte[])QUALIFIERS[expectedIndex]));
            ++expectedIndex;
        }
        Assert.assertEquals((long)expectedIndex, (long)6L);
        scanner.close();
    }

    @Test
    public void testFilterWithLongCompartor() throws Exception {
        int i;
        byte[] TABLE = Bytes.toBytes((String)"testFilterWithLongCompartor");
        HTable ht = TEST_UTIL.createTable(TABLE, FAMILY);
        byte[][] ROWS = this.makeN(ROW, 10);
        byte[][] values = new byte[10][];
        for (i = 0; i < 10; ++i) {
            values[i] = Bytes.toBytes((long)(100L * (long)i));
        }
        for (i = 0; i < 10; ++i) {
            Put put = new Put(ROWS[i]);
            put.setDurability(Durability.SKIP_WAL);
            put.add(FAMILY, QUALIFIER, values[i]);
            ht.put(put);
        }
        Scan scan = new Scan();
        scan.addFamily(FAMILY);
        SingleColumnValueFilter filter = new SingleColumnValueFilter(FAMILY, QUALIFIER, CompareFilter.CompareOp.GREATER, (ByteArrayComparable)new LongComparator(500L));
        scan.setFilter((Filter)filter);
        ResultScanner scanner = ht.getScanner(scan);
        int expectedIndex = 0;
        for (Result result : ht.getScanner(scan)) {
            Assert.assertEquals((long)result.size(), (long)1L);
            Assert.assertTrue((Bytes.toLong((byte[])result.getValue(FAMILY, QUALIFIER)) > 500L ? 1 : 0) != 0);
            ++expectedIndex;
        }
        Assert.assertEquals((long)expectedIndex, (long)4L);
        scanner.close();
    }

    @Test
    public void testKeyOnlyFilter() throws Exception {
        byte[] TABLE = Bytes.toBytes((String)"testKeyOnlyFilter");
        HTable ht = TEST_UTIL.createTable(TABLE, FAMILY);
        byte[][] ROWS = this.makeN(ROW, 10);
        byte[][] QUALIFIERS = new byte[][]{Bytes.toBytes((String)"col0-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col1-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col2-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col3-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col4-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col5-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col6-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col7-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col8-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col9-<d2v1>-<d3v2>")};
        for (int i = 0; i < 10; ++i) {
            Put put = new Put(ROWS[i]);
            put.setDurability(Durability.SKIP_WAL);
            put.add(FAMILY, QUALIFIERS[i], VALUE);
            ht.put(put);
        }
        Scan scan = new Scan();
        scan.addFamily(FAMILY);
        KeyOnlyFilter filter = new KeyOnlyFilter(true);
        scan.setFilter((Filter)filter);
        ResultScanner scanner = ht.getScanner(scan);
        int count = 0;
        for (Result result : ht.getScanner(scan)) {
            Assert.assertEquals((long)result.size(), (long)1L);
            Assert.assertEquals((long)result.rawCells()[0].getValueLength(), (long)4L);
            Assert.assertEquals((long)Bytes.toInt((byte[])CellUtil.cloneValue((Cell)result.rawCells()[0])), (long)VALUE.length);
            ++count;
        }
        Assert.assertEquals((long)count, (long)10L);
        scanner.close();
    }

    @Test
    public void testSimpleMissing() throws Exception {
        byte[] TABLE = Bytes.toBytes((String)"testSimpleMissing");
        HTable ht = TEST_UTIL.createTable(TABLE, FAMILY);
        byte[][] ROWS = this.makeN(ROW, 4);
        Get get = new Get(ROWS[0]);
        Result result = ht.get(get);
        this.assertEmptyResult(result);
        get = new Get(ROWS[0]);
        get.addFamily(FAMILY);
        result = ht.get(get);
        this.assertEmptyResult(result);
        get = new Get(ROWS[0]);
        get.addColumn(FAMILY, QUALIFIER);
        result = ht.get(get);
        this.assertEmptyResult(result);
        Scan scan = new Scan();
        result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
        scan = new Scan(ROWS[0]);
        result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
        scan = new Scan(ROWS[0], ROWS[1]);
        result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
        scan = new Scan();
        scan.addFamily(FAMILY);
        result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
        scan = new Scan();
        scan.addColumn(FAMILY, QUALIFIER);
        result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
        Put put = new Put(ROWS[2]);
        put.add(FAMILY, QUALIFIER, VALUE);
        ht.put(put);
        get = new Get(ROWS[1]);
        result = ht.get(get);
        this.assertEmptyResult(result);
        get = new Get(ROWS[0]);
        get.addFamily(FAMILY);
        result = ht.get(get);
        this.assertEmptyResult(result);
        get = new Get(ROWS[3]);
        get.addColumn(FAMILY, QUALIFIER);
        result = ht.get(get);
        this.assertEmptyResult(result);
        scan = new Scan(ROWS[3]);
        result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
        scan = new Scan(ROWS[0], ROWS[2]);
        result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
        get = new Get(ROWS[2]);
        result = ht.get(get);
        this.assertSingleResult(result, ROWS[2], FAMILY, QUALIFIER, VALUE);
        get = new Get(ROWS[2]);
        get.addFamily(FAMILY);
        result = ht.get(get);
        this.assertSingleResult(result, ROWS[2], FAMILY, QUALIFIER, VALUE);
        get = new Get(ROWS[2]);
        get.addColumn(FAMILY, QUALIFIER);
        result = ht.get(get);
        this.assertSingleResult(result, ROWS[2], FAMILY, QUALIFIER, VALUE);
        scan = new Scan();
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[2], FAMILY, QUALIFIER, VALUE);
        scan = new Scan(ROWS[0], ROWS[3]);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[2], FAMILY, QUALIFIER, VALUE);
        scan = new Scan(ROWS[2], ROWS[3]);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[2], FAMILY, QUALIFIER, VALUE);
    }

    @Test
    public void testSingleRowMultipleFamily() throws Exception {
        byte[] TABLE = Bytes.toBytes((String)"testSingleRowMultipleFamily");
        byte[][] ROWS = this.makeN(ROW, 3);
        byte[][] FAMILIES = this.makeNAscii(FAMILY, 10);
        byte[][] QUALIFIERS = this.makeN(QUALIFIER, 10);
        byte[][] VALUES = this.makeN(VALUE, 10);
        HTable ht = TEST_UTIL.createTable(TABLE, FAMILIES);
        Put put = new Put(ROWS[0]);
        put.add(FAMILIES[4], QUALIFIERS[0], VALUES[0]);
        ht.put(put);
        this.getVerifySingleColumn(ht, ROWS, 0, FAMILIES, 4, QUALIFIERS, 0, VALUES, 0);
        this.scanVerifySingleColumn(ht, ROWS, 0, FAMILIES, 4, QUALIFIERS, 0, VALUES, 0);
        this.getVerifySingleEmpty(ht, ROWS, 0, FAMILIES, 4, QUALIFIERS, 0);
        this.scanVerifySingleEmpty(ht, ROWS, 0, FAMILIES, 4, QUALIFIERS, 0);
        TEST_UTIL.flush();
        this.getVerifySingleColumn(ht, ROWS, 0, FAMILIES, 4, QUALIFIERS, 0, VALUES, 0);
        this.scanVerifySingleColumn(ht, ROWS, 0, FAMILIES, 4, QUALIFIERS, 0, VALUES, 0);
        this.getVerifySingleEmpty(ht, ROWS, 0, FAMILIES, 4, QUALIFIERS, 0);
        this.scanVerifySingleEmpty(ht, ROWS, 0, FAMILIES, 4, QUALIFIERS, 0);
        put = new Put(ROWS[0]);
        put.add(FAMILIES[2], QUALIFIERS[2], VALUES[2]);
        put.add(FAMILIES[2], QUALIFIERS[4], VALUES[4]);
        put.add(FAMILIES[4], QUALIFIERS[4], VALUES[4]);
        put.add(FAMILIES[6], QUALIFIERS[6], VALUES[6]);
        put.add(FAMILIES[6], QUALIFIERS[7], VALUES[7]);
        put.add(FAMILIES[7], QUALIFIERS[7], VALUES[7]);
        put.add(FAMILIES[9], QUALIFIERS[0], VALUES[0]);
        ht.put(put);
        this.singleRowGetTest(ht, ROWS, FAMILIES, QUALIFIERS, VALUES);
        this.singleRowScanTest(ht, ROWS, FAMILIES, QUALIFIERS, VALUES);
        TEST_UTIL.flush();
        this.singleRowGetTest(ht, ROWS, FAMILIES, QUALIFIERS, VALUES);
        this.singleRowScanTest(ht, ROWS, FAMILIES, QUALIFIERS, VALUES);
        put = new Put(ROWS[0]);
        put.add(FAMILIES[6], QUALIFIERS[5], VALUES[5]);
        put.add(FAMILIES[6], QUALIFIERS[8], VALUES[8]);
        put.add(FAMILIES[6], QUALIFIERS[9], VALUES[9]);
        put.add(FAMILIES[4], QUALIFIERS[3], VALUES[3]);
        ht.put(put);
        Delete delete = new Delete(ROWS[0]);
        delete.deleteColumns(FAMILIES[6], QUALIFIERS[7]);
        ht.delete(delete);
        Get get = new Get(ROWS[0]);
        get.addColumn(FAMILIES[6], QUALIFIERS[7]);
        Result result = ht.get(get);
        this.assertEmptyResult(result);
        Scan scan = new Scan();
        scan.addColumn(FAMILIES[6], QUALIFIERS[7]);
        result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
        get = new Get(ROWS[0]);
        get.addColumn(FAMILIES[6], QUALIFIERS[6]);
        result = ht.get(get);
        this.assertSingleResult(result, ROWS[0], FAMILIES[6], QUALIFIERS[6], VALUES[6]);
        get = new Get(ROWS[0]);
        get.addColumn(FAMILIES[6], QUALIFIERS[8]);
        result = ht.get(get);
        this.assertSingleResult(result, ROWS[0], FAMILIES[6], QUALIFIERS[8], VALUES[8]);
        scan = new Scan();
        scan.addColumn(FAMILIES[6], QUALIFIERS[6]);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[0], FAMILIES[6], QUALIFIERS[6], VALUES[6]);
        scan = new Scan();
        scan.addColumn(FAMILIES[6], QUALIFIERS[8]);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[0], FAMILIES[6], QUALIFIERS[8], VALUES[8]);
        delete = new Delete(ROWS[0]);
        delete.deleteColumns(FAMILIES[6], QUALIFIERS[8]);
        ht.delete(delete);
        get = new Get(ROWS[0]);
        get.addColumn(FAMILIES[6], QUALIFIERS[8]);
        result = ht.get(get);
        this.assertEmptyResult(result);
        scan = new Scan();
        scan.addColumn(FAMILIES[6], QUALIFIERS[8]);
        result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
        get = new Get(ROWS[0]);
        get.addColumn(FAMILIES[6], QUALIFIERS[6]);
        result = ht.get(get);
        this.assertSingleResult(result, ROWS[0], FAMILIES[6], QUALIFIERS[6], VALUES[6]);
        get = new Get(ROWS[0]);
        get.addColumn(FAMILIES[6], QUALIFIERS[9]);
        result = ht.get(get);
        this.assertSingleResult(result, ROWS[0], FAMILIES[6], QUALIFIERS[9], VALUES[9]);
        scan = new Scan();
        scan.addColumn(FAMILIES[6], QUALIFIERS[6]);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[0], FAMILIES[6], QUALIFIERS[6], VALUES[6]);
        scan = new Scan();
        scan.addColumn(FAMILIES[6], QUALIFIERS[9]);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[0], FAMILIES[6], QUALIFIERS[9], VALUES[9]);
        delete = new Delete(ROWS[0]);
        delete.deleteFamily(FAMILIES[4]);
        ht.delete(delete);
        get = new Get(ROWS[0]);
        get.addColumn(FAMILIES[4], QUALIFIERS[4]);
        result = ht.get(get);
        this.assertEmptyResult(result);
        get = new Get(ROWS[0]);
        get.addColumn(FAMILIES[4], QUALIFIERS[3]);
        result = ht.get(get);
        this.assertEmptyResult(result);
        get = new Get(ROWS[0]);
        get.addFamily(FAMILIES[4]);
        result = ht.get(get);
        this.assertEmptyResult(result);
        scan = new Scan();
        scan.addColumn(FAMILIES[4], QUALIFIERS[4]);
        result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
        scan = new Scan();
        scan.addColumn(FAMILIES[4], QUALIFIERS[3]);
        result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
        scan = new Scan();
        scan.addFamily(FAMILIES[4]);
        result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
        get = new Get(ROWS[0]);
        get.addColumn(FAMILIES[2], QUALIFIERS[2]);
        result = ht.get(get);
        this.assertSingleResult(result, ROWS[0], FAMILIES[2], QUALIFIERS[2], VALUES[2]);
        get = new Get(ROWS[0]);
        get.addColumn(FAMILIES[6], QUALIFIERS[9]);
        result = ht.get(get);
        this.assertSingleResult(result, ROWS[0], FAMILIES[6], QUALIFIERS[9], VALUES[9]);
        scan = new Scan();
        scan.addColumn(FAMILIES[6], QUALIFIERS[6]);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[0], FAMILIES[6], QUALIFIERS[6], VALUES[6]);
        scan = new Scan();
        scan.addColumn(FAMILIES[6], QUALIFIERS[9]);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[0], FAMILIES[6], QUALIFIERS[9], VALUES[9]);
        TEST_UTIL.flush();
        get = new Get(ROWS[0]);
        get.addColumn(FAMILIES[4], QUALIFIERS[4]);
        result = ht.get(get);
        this.assertEmptyResult(result);
        get = new Get(ROWS[0]);
        get.addColumn(FAMILIES[4], QUALIFIERS[3]);
        result = ht.get(get);
        this.assertEmptyResult(result);
        get = new Get(ROWS[0]);
        get.addFamily(FAMILIES[4]);
        result = ht.get(get);
        this.assertEmptyResult(result);
        scan = new Scan();
        scan.addColumn(FAMILIES[4], QUALIFIERS[4]);
        result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
        scan = new Scan();
        scan.addColumn(FAMILIES[4], QUALIFIERS[3]);
        result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
        scan = new Scan();
        scan.addFamily(FAMILIES[4]);
        result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
        get = new Get(ROWS[0]);
        get.addColumn(FAMILIES[2], QUALIFIERS[2]);
        result = ht.get(get);
        this.assertSingleResult(result, ROWS[0], FAMILIES[2], QUALIFIERS[2], VALUES[2]);
        get = new Get(ROWS[0]);
        get.addColumn(FAMILIES[6], QUALIFIERS[9]);
        result = ht.get(get);
        this.assertSingleResult(result, ROWS[0], FAMILIES[6], QUALIFIERS[9], VALUES[9]);
        scan = new Scan();
        scan.addColumn(FAMILIES[6], QUALIFIERS[6]);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[0], FAMILIES[6], QUALIFIERS[6], VALUES[6]);
        scan = new Scan();
        scan.addColumn(FAMILIES[6], QUALIFIERS[9]);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[0], FAMILIES[6], QUALIFIERS[9], VALUES[9]);
    }

    @Test
    public void testNull() throws Exception {
        Put put;
        Put put2;
        byte[] TABLE = Bytes.toBytes((String)"testNull");
        try {
            TEST_UTIL.createTable((TableName)null, FAMILY);
            Assert.fail((String)"Creating a table with null name passed, should have failed");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            TEST_UTIL.createTable(TABLE, (byte[])null);
            Assert.fail((String)"Creating a table with a null family passed, should fail");
        }
        catch (Exception e) {
            // empty catch block
        }
        HTable ht = TEST_UTIL.createTable(TABLE, FAMILY);
        try {
            put2 = new Put((byte[])null);
            put2.add(FAMILY, QUALIFIER, VALUE);
            ht.put(put2);
            Assert.fail((String)"Inserting a null row worked, should throw exception");
        }
        catch (Exception e) {
            // empty catch block
        }
        put2 = new Put(ROW);
        put2.add(FAMILY, null, VALUE);
        ht.put(put2);
        this.getTestNull(ht, ROW, FAMILY, VALUE);
        this.scanTestNull(ht, ROW, FAMILY, VALUE);
        Delete delete = new Delete(ROW);
        delete.deleteColumns(FAMILY, null);
        ht.delete(delete);
        Get get = new Get(ROW);
        Result result = ht.get(get);
        this.assertEmptyResult(result);
        byte[] TABLE2 = Bytes.toBytes((String)"testNull2");
        ht = TEST_UTIL.createTable(TABLE2, FAMILY);
        try {
            put = new Put(ROW);
            put.add(FAMILY, HConstants.EMPTY_BYTE_ARRAY, VALUE);
            ht.put(put);
            this.getTestNull(ht, ROW, FAMILY, VALUE);
            this.scanTestNull(ht, ROW, FAMILY, VALUE);
            TEST_UTIL.flush();
            this.getTestNull(ht, ROW, FAMILY, VALUE);
            this.scanTestNull(ht, ROW, FAMILY, VALUE);
            Delete delete2 = new Delete(ROW);
            delete2.deleteColumns(FAMILY, HConstants.EMPTY_BYTE_ARRAY);
            ht.delete(delete2);
            Get get2 = new Get(ROW);
            Result result2 = ht.get(get2);
            this.assertEmptyResult(result2);
        }
        catch (Exception e) {
            throw new IOException("Using a row with null qualifier threw exception, should ");
        }
        try {
            put = new Put(ROW);
            put.add(FAMILY, QUALIFIER, null);
            ht.put(put);
            get = new Get(ROW);
            get.addColumn(FAMILY, QUALIFIER);
            result = ht.get(get);
            this.assertSingleResult(result, ROW, FAMILY, QUALIFIER, null);
            Scan scan = new Scan();
            scan.addColumn(FAMILY, QUALIFIER);
            result = this.getSingleScanResult(ht, scan);
            this.assertSingleResult(result, ROW, FAMILY, QUALIFIER, null);
            Delete delete3 = new Delete(ROW);
            delete3.deleteColumns(FAMILY, QUALIFIER);
            ht.delete(delete3);
            get = new Get(ROW);
            result = ht.get(get);
            this.assertEmptyResult(result);
        }
        catch (Exception e) {
            throw new IOException("Null values should be allowed, but threw exception");
        }
    }

    @Test
    public void testVersions() throws Exception {
        byte[] TABLE = Bytes.toBytes((String)"testVersions");
        long[] STAMPS = this.makeStamps(20);
        byte[][] VALUES = this.makeNAscii(VALUE, 20);
        HTable ht = TEST_UTIL.createTable(TABLE, FAMILY, 10);
        Put put = new Put(ROW);
        put.add(FAMILY, QUALIFIER, STAMPS[1], VALUES[1]);
        put.add(FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
        put.add(FAMILY, QUALIFIER, STAMPS[4], VALUES[4]);
        put.add(FAMILY, QUALIFIER, STAMPS[5], VALUES[5]);
        ht.put(put);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[1], VALUES[1]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[4], VALUES[4]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[5], VALUES[5]);
        this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[1], VALUES[1]);
        this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
        this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[4], VALUES[4]);
        this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[5], VALUES[5]);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[0]);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[3]);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[6]);
        this.scanVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[0]);
        this.scanVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[3]);
        this.scanVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[6]);
        Get get = new Get(ROW);
        get.addColumn(FAMILY, QUALIFIER);
        get.setMaxVersions(2);
        Result result = ht.get(get);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[4], STAMPS[5]}, new byte[][]{VALUES[4], VALUES[5]}, 0, 1);
        Scan scan = new Scan(ROW);
        scan.addColumn(FAMILY, QUALIFIER);
        scan.setMaxVersions(2);
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[4], STAMPS[5]}, new byte[][]{VALUES[4], VALUES[5]}, 0, 1);
        TEST_UTIL.flush();
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[1], VALUES[1]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[4], VALUES[4]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[5], VALUES[5]);
        this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[1], VALUES[1]);
        this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
        this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[4], VALUES[4]);
        this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[5], VALUES[5]);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[0]);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[3]);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[6]);
        this.scanVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[0]);
        this.scanVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[3]);
        this.scanVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[6]);
        get = new Get(ROW);
        get.addColumn(FAMILY, QUALIFIER);
        get.setMaxVersions(2);
        result = ht.get(get);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[4], STAMPS[5]}, new byte[][]{VALUES[4], VALUES[5]}, 0, 1);
        scan = new Scan(ROW);
        scan.addColumn(FAMILY, QUALIFIER);
        scan.setMaxVersions(2);
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[4], STAMPS[5]}, new byte[][]{VALUES[4], VALUES[5]}, 0, 1);
        put = new Put(ROW);
        put.add(FAMILY, QUALIFIER, STAMPS[3], VALUES[3]);
        put.add(FAMILY, QUALIFIER, STAMPS[6], VALUES[6]);
        put.add(FAMILY, QUALIFIER, STAMPS[7], VALUES[7]);
        put.add(FAMILY, QUALIFIER, STAMPS[8], VALUES[8]);
        ht.put(put);
        get = new Get(ROW);
        get.addColumn(FAMILY, QUALIFIER);
        get.setMaxVersions();
        result = ht.get(get);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[1], STAMPS[2], STAMPS[3], STAMPS[4], STAMPS[5], STAMPS[6], STAMPS[7], STAMPS[8]}, new byte[][]{VALUES[1], VALUES[2], VALUES[3], VALUES[4], VALUES[5], VALUES[6], VALUES[7], VALUES[8]}, 0, 7);
        scan = new Scan(ROW);
        scan.addColumn(FAMILY, QUALIFIER);
        scan.setMaxVersions();
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[1], STAMPS[2], STAMPS[3], STAMPS[4], STAMPS[5], STAMPS[6], STAMPS[7], STAMPS[8]}, new byte[][]{VALUES[1], VALUES[2], VALUES[3], VALUES[4], VALUES[5], VALUES[6], VALUES[7], VALUES[8]}, 0, 7);
        get = new Get(ROW);
        get.setMaxVersions();
        result = ht.get(get);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[1], STAMPS[2], STAMPS[3], STAMPS[4], STAMPS[5], STAMPS[6], STAMPS[7], STAMPS[8]}, new byte[][]{VALUES[1], VALUES[2], VALUES[3], VALUES[4], VALUES[5], VALUES[6], VALUES[7], VALUES[8]}, 0, 7);
        scan = new Scan(ROW);
        scan.setMaxVersions();
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[1], STAMPS[2], STAMPS[3], STAMPS[4], STAMPS[5], STAMPS[6], STAMPS[7], STAMPS[8]}, new byte[][]{VALUES[1], VALUES[2], VALUES[3], VALUES[4], VALUES[5], VALUES[6], VALUES[7], VALUES[8]}, 0, 7);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[1], VALUES[1]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[4], VALUES[4]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[7], VALUES[7]);
        this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[1], VALUES[1]);
        this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
        this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[4], VALUES[4]);
        this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[7], VALUES[7]);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[0]);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[9]);
        this.scanVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[0]);
        this.scanVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[9]);
        TEST_UTIL.flush();
        put = new Put(ROW);
        put.add(FAMILY, QUALIFIER, STAMPS[9], VALUES[9]);
        put.add(FAMILY, QUALIFIER, STAMPS[11], VALUES[11]);
        put.add(FAMILY, QUALIFIER, STAMPS[13], VALUES[13]);
        put.add(FAMILY, QUALIFIER, STAMPS[15], VALUES[15]);
        ht.put(put);
        get = new Get(ROW);
        get.addColumn(FAMILY, QUALIFIER);
        get.setMaxVersions(Integer.MAX_VALUE);
        result = ht.get(get);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[3], STAMPS[4], STAMPS[5], STAMPS[6], STAMPS[7], STAMPS[8], STAMPS[9], STAMPS[11], STAMPS[13], STAMPS[15]}, new byte[][]{VALUES[3], VALUES[4], VALUES[5], VALUES[6], VALUES[7], VALUES[8], VALUES[9], VALUES[11], VALUES[13], VALUES[15]}, 0, 9);
        scan = new Scan(ROW);
        scan.addColumn(FAMILY, QUALIFIER);
        scan.setMaxVersions(Integer.MAX_VALUE);
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[3], STAMPS[4], STAMPS[5], STAMPS[6], STAMPS[7], STAMPS[8], STAMPS[9], STAMPS[11], STAMPS[13], STAMPS[15]}, new byte[][]{VALUES[3], VALUES[4], VALUES[5], VALUES[6], VALUES[7], VALUES[8], VALUES[9], VALUES[11], VALUES[13], VALUES[15]}, 0, 9);
        Delete delete = new Delete(ROW);
        delete.deleteColumn(FAMILY, QUALIFIER, STAMPS[11]);
        delete.deleteColumn(FAMILY, QUALIFIER, STAMPS[7]);
        ht.delete(delete);
        get = new Get(ROW);
        get.addColumn(FAMILY, QUALIFIER);
        get.setMaxVersions(Integer.MAX_VALUE);
        result = ht.get(get);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[1], STAMPS[2], STAMPS[3], STAMPS[4], STAMPS[5], STAMPS[6], STAMPS[8], STAMPS[9], STAMPS[13], STAMPS[15]}, new byte[][]{VALUES[1], VALUES[2], VALUES[3], VALUES[4], VALUES[5], VALUES[6], VALUES[8], VALUES[9], VALUES[13], VALUES[15]}, 0, 9);
        scan = new Scan(ROW);
        scan.addColumn(FAMILY, QUALIFIER);
        scan.setMaxVersions(Integer.MAX_VALUE);
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[1], STAMPS[2], STAMPS[3], STAMPS[4], STAMPS[5], STAMPS[6], STAMPS[8], STAMPS[9], STAMPS[13], STAMPS[15]}, new byte[][]{VALUES[1], VALUES[2], VALUES[3], VALUES[4], VALUES[5], VALUES[6], VALUES[8], VALUES[9], VALUES[13], VALUES[15]}, 0, 9);
    }

    @Test
    public void testVersionLimits() throws Exception {
        byte[] TABLE = Bytes.toBytes((String)"testVersionLimits");
        byte[][] FAMILIES = this.makeNAscii(FAMILY, 3);
        int[] LIMITS = new int[]{1, 3, 5};
        long[] STAMPS = this.makeStamps(10);
        byte[][] VALUES = this.makeNAscii(VALUE, 10);
        HTable ht = TEST_UTIL.createTable(TABLE, FAMILIES, LIMITS);
        Put put = new Put(ROW);
        put.add(FAMILIES[0], QUALIFIER, STAMPS[0], VALUES[0]);
        put.add(FAMILIES[0], QUALIFIER, STAMPS[1], VALUES[1]);
        put.add(FAMILIES[1], QUALIFIER, STAMPS[0], VALUES[0]);
        put.add(FAMILIES[1], QUALIFIER, STAMPS[1], VALUES[1]);
        put.add(FAMILIES[1], QUALIFIER, STAMPS[2], VALUES[2]);
        put.add(FAMILIES[1], QUALIFIER, STAMPS[3], VALUES[3]);
        put.add(FAMILIES[2], QUALIFIER, STAMPS[0], VALUES[0]);
        put.add(FAMILIES[2], QUALIFIER, STAMPS[1], VALUES[1]);
        put.add(FAMILIES[2], QUALIFIER, STAMPS[2], VALUES[2]);
        put.add(FAMILIES[2], QUALIFIER, STAMPS[3], VALUES[3]);
        put.add(FAMILIES[2], QUALIFIER, STAMPS[4], VALUES[4]);
        put.add(FAMILIES[2], QUALIFIER, STAMPS[5], VALUES[5]);
        put.add(FAMILIES[2], QUALIFIER, STAMPS[6], VALUES[6]);
        ht.put(put);
        Get get = new Get(ROW);
        get.addColumn(FAMILIES[0], QUALIFIER);
        get.setMaxVersions(Integer.MAX_VALUE);
        Result result = ht.get(get);
        this.assertNResult(result, ROW, FAMILIES[0], QUALIFIER, new long[]{STAMPS[1]}, new byte[][]{VALUES[1]}, 0, 0);
        get = new Get(ROW);
        get.addFamily(FAMILIES[0]);
        get.setMaxVersions(Integer.MAX_VALUE);
        result = ht.get(get);
        this.assertNResult(result, ROW, FAMILIES[0], QUALIFIER, new long[]{STAMPS[1]}, new byte[][]{VALUES[1]}, 0, 0);
        Scan scan = new Scan(ROW);
        scan.addColumn(FAMILIES[0], QUALIFIER);
        scan.setMaxVersions(Integer.MAX_VALUE);
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROW, FAMILIES[0], QUALIFIER, new long[]{STAMPS[1]}, new byte[][]{VALUES[1]}, 0, 0);
        scan = new Scan(ROW);
        scan.addFamily(FAMILIES[0]);
        scan.setMaxVersions(Integer.MAX_VALUE);
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROW, FAMILIES[0], QUALIFIER, new long[]{STAMPS[1]}, new byte[][]{VALUES[1]}, 0, 0);
        get = new Get(ROW);
        get.addColumn(FAMILIES[1], QUALIFIER);
        get.setMaxVersions(Integer.MAX_VALUE);
        result = ht.get(get);
        this.assertNResult(result, ROW, FAMILIES[1], QUALIFIER, new long[]{STAMPS[1], STAMPS[2], STAMPS[3]}, new byte[][]{VALUES[1], VALUES[2], VALUES[3]}, 0, 2);
        get = new Get(ROW);
        get.addFamily(FAMILIES[1]);
        get.setMaxVersions(Integer.MAX_VALUE);
        result = ht.get(get);
        this.assertNResult(result, ROW, FAMILIES[1], QUALIFIER, new long[]{STAMPS[1], STAMPS[2], STAMPS[3]}, new byte[][]{VALUES[1], VALUES[2], VALUES[3]}, 0, 2);
        scan = new Scan(ROW);
        scan.addColumn(FAMILIES[1], QUALIFIER);
        scan.setMaxVersions(Integer.MAX_VALUE);
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROW, FAMILIES[1], QUALIFIER, new long[]{STAMPS[1], STAMPS[2], STAMPS[3]}, new byte[][]{VALUES[1], VALUES[2], VALUES[3]}, 0, 2);
        scan = new Scan(ROW);
        scan.addFamily(FAMILIES[1]);
        scan.setMaxVersions(Integer.MAX_VALUE);
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROW, FAMILIES[1], QUALIFIER, new long[]{STAMPS[1], STAMPS[2], STAMPS[3]}, new byte[][]{VALUES[1], VALUES[2], VALUES[3]}, 0, 2);
        get = new Get(ROW);
        get.addColumn(FAMILIES[2], QUALIFIER);
        get.setMaxVersions(Integer.MAX_VALUE);
        result = ht.get(get);
        this.assertNResult(result, ROW, FAMILIES[2], QUALIFIER, new long[]{STAMPS[2], STAMPS[3], STAMPS[4], STAMPS[5], STAMPS[6]}, new byte[][]{VALUES[2], VALUES[3], VALUES[4], VALUES[5], VALUES[6]}, 0, 4);
        get = new Get(ROW);
        get.addFamily(FAMILIES[2]);
        get.setMaxVersions(Integer.MAX_VALUE);
        result = ht.get(get);
        this.assertNResult(result, ROW, FAMILIES[2], QUALIFIER, new long[]{STAMPS[2], STAMPS[3], STAMPS[4], STAMPS[5], STAMPS[6]}, new byte[][]{VALUES[2], VALUES[3], VALUES[4], VALUES[5], VALUES[6]}, 0, 4);
        scan = new Scan(ROW);
        scan.addColumn(FAMILIES[2], QUALIFIER);
        scan.setMaxVersions(Integer.MAX_VALUE);
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROW, FAMILIES[2], QUALIFIER, new long[]{STAMPS[2], STAMPS[3], STAMPS[4], STAMPS[5], STAMPS[6]}, new byte[][]{VALUES[2], VALUES[3], VALUES[4], VALUES[5], VALUES[6]}, 0, 4);
        scan = new Scan(ROW);
        scan.addFamily(FAMILIES[2]);
        scan.setMaxVersions(Integer.MAX_VALUE);
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROW, FAMILIES[2], QUALIFIER, new long[]{STAMPS[2], STAMPS[3], STAMPS[4], STAMPS[5], STAMPS[6]}, new byte[][]{VALUES[2], VALUES[3], VALUES[4], VALUES[5], VALUES[6]}, 0, 4);
        get = new Get(ROW);
        get.setMaxVersions(Integer.MAX_VALUE);
        result = ht.get(get);
        Assert.assertTrue((String)("Expected 9 keys but received " + result.size()), (result.size() == 9 ? 1 : 0) != 0);
        get = new Get(ROW);
        get.addFamily(FAMILIES[0]);
        get.addFamily(FAMILIES[1]);
        get.addFamily(FAMILIES[2]);
        get.setMaxVersions(Integer.MAX_VALUE);
        result = ht.get(get);
        Assert.assertTrue((String)("Expected 9 keys but received " + result.size()), (result.size() == 9 ? 1 : 0) != 0);
        get = new Get(ROW);
        get.addColumn(FAMILIES[0], QUALIFIER);
        get.addColumn(FAMILIES[1], QUALIFIER);
        get.addColumn(FAMILIES[2], QUALIFIER);
        get.setMaxVersions(Integer.MAX_VALUE);
        result = ht.get(get);
        Assert.assertTrue((String)("Expected 9 keys but received " + result.size()), (result.size() == 9 ? 1 : 0) != 0);
        scan = new Scan(ROW);
        scan.setMaxVersions(Integer.MAX_VALUE);
        result = this.getSingleScanResult(ht, scan);
        Assert.assertTrue((String)("Expected 9 keys but received " + result.size()), (result.size() == 9 ? 1 : 0) != 0);
        scan = new Scan(ROW);
        scan.setMaxVersions(Integer.MAX_VALUE);
        scan.addFamily(FAMILIES[0]);
        scan.addFamily(FAMILIES[1]);
        scan.addFamily(FAMILIES[2]);
        result = this.getSingleScanResult(ht, scan);
        Assert.assertTrue((String)("Expected 9 keys but received " + result.size()), (result.size() == 9 ? 1 : 0) != 0);
        scan = new Scan(ROW);
        scan.setMaxVersions(Integer.MAX_VALUE);
        scan.addColumn(FAMILIES[0], QUALIFIER);
        scan.addColumn(FAMILIES[1], QUALIFIER);
        scan.addColumn(FAMILIES[2], QUALIFIER);
        result = this.getSingleScanResult(ht, scan);
        Assert.assertTrue((String)("Expected 9 keys but received " + result.size()), (result.size() == 9 ? 1 : 0) != 0);
    }

    @Test
    public void testDeleteFamilyVersion() throws Exception {
        HBaseAdmin admin = new HBaseAdmin(TEST_UTIL.getConfiguration());
        byte[] TABLE = Bytes.toBytes((String)"testDeleteFamilyVersion");
        byte[][] QUALIFIERS = this.makeNAscii(QUALIFIER, 1);
        byte[][] VALUES = this.makeN(VALUE, 5);
        long[] ts = new long[]{1000L, 2000L, 3000L, 4000L, 5000L};
        HTable ht = TEST_UTIL.createTable(TABLE, FAMILY, 5);
        Put put = new Put(ROW);
        for (int q = 0; q < 1; ++q) {
            for (int t = 0; t < 5; ++t) {
                put.add(FAMILY, QUALIFIERS[q], ts[t], VALUES[t]);
            }
        }
        ht.put(put);
        admin.flush(TABLE);
        Delete delete = new Delete(ROW);
        delete.deleteFamilyVersion(FAMILY, ts[1]);
        delete.deleteFamilyVersion(FAMILY, ts[3]);
        ht.delete(delete);
        admin.flush(TABLE);
        for (int i = 0; i < 1; ++i) {
            Get get = new Get(ROW);
            get.addColumn(FAMILY, QUALIFIERS[i]);
            get.setMaxVersions(Integer.MAX_VALUE);
            Result result = ht.get(get);
            this.assertNResult(result, ROW, FAMILY, QUALIFIERS[i], new long[]{ts[0], ts[2], ts[4]}, new byte[][]{VALUES[0], VALUES[2], VALUES[4]}, 0, 2);
        }
        ht.close();
        admin.close();
    }

    @Test
    public void testDeleteFamilyVersionWithOtherDeletes() throws Exception {
        byte[] TABLE = Bytes.toBytes((String)"testDeleteFamilyVersionWithOtherDeletes");
        byte[][] QUALIFIERS = this.makeNAscii(QUALIFIER, 5);
        byte[][] VALUES = this.makeN(VALUE, 5);
        long[] ts = new long[]{1000L, 2000L, 3000L, 4000L, 5000L};
        HBaseAdmin admin = new HBaseAdmin(TEST_UTIL.getConfiguration());
        HTable ht = TEST_UTIL.createTable(TABLE, FAMILY, 5);
        Put put = null;
        Result result = null;
        Get get = null;
        Delete delete = null;
        put = new Put(ROW);
        for (int q = 0; q < 5; ++q) {
            for (int t = 0; t < 5; ++t) {
                put.add(FAMILY, QUALIFIERS[q], ts[t], VALUES[t]);
            }
        }
        ht.put(put);
        admin.flush(TABLE);
        byte[] ROW2 = Bytes.toBytes((String)"myRowForTest");
        put = new Put(ROW2);
        for (int q = 0; q < 5; ++q) {
            for (int t = 0; t < 5; ++t) {
                put.add(FAMILY, QUALIFIERS[q], ts[t], VALUES[t]);
            }
        }
        ht.put(put);
        admin.flush(TABLE);
        delete = new Delete(ROW);
        delete.deleteFamily(FAMILY, ts[1]);
        delete.deleteFamilyVersion(FAMILY, ts[3]);
        delete.deleteColumns(FAMILY, QUALIFIERS[0], ts[2]);
        delete.deleteColumns(FAMILY, QUALIFIERS[2], ts[4]);
        delete.deleteColumn(FAMILY, QUALIFIERS[4], ts[4]);
        ht.delete(delete);
        admin.flush(TABLE);
        delete = new Delete(ROW2);
        delete.deleteFamilyVersion(FAMILY, ts[1]);
        delete.deleteFamilyVersion(FAMILY, ts[3]);
        ht.delete(delete);
        admin.flush(TABLE);
        get = new Get(ROW);
        get.addColumn(FAMILY, QUALIFIERS[0]);
        get.setMaxVersions(Integer.MAX_VALUE);
        result = ht.get(get);
        this.assertNResult(result, ROW, FAMILY, QUALIFIERS[0], new long[]{ts[4]}, new byte[][]{VALUES[4]}, 0, 0);
        get = new Get(ROW);
        get.addColumn(FAMILY, QUALIFIERS[1]);
        get.setMaxVersions(Integer.MAX_VALUE);
        result = ht.get(get);
        this.assertNResult(result, ROW, FAMILY, QUALIFIERS[1], new long[]{ts[2], ts[4]}, new byte[][]{VALUES[2], VALUES[4]}, 0, 1);
        get = new Get(ROW);
        get.addColumn(FAMILY, QUALIFIERS[2]);
        get.setMaxVersions(Integer.MAX_VALUE);
        result = ht.get(get);
        Assert.assertEquals((long)0L, (long)result.size());
        get = new Get(ROW);
        get.addColumn(FAMILY, QUALIFIERS[3]);
        get.setMaxVersions(Integer.MAX_VALUE);
        result = ht.get(get);
        this.assertNResult(result, ROW, FAMILY, QUALIFIERS[3], new long[]{ts[2], ts[4]}, new byte[][]{VALUES[2], VALUES[4]}, 0, 1);
        get = new Get(ROW);
        get.addColumn(FAMILY, QUALIFIERS[4]);
        get.setMaxVersions(Integer.MAX_VALUE);
        result = ht.get(get);
        this.assertNResult(result, ROW, FAMILY, QUALIFIERS[4], new long[]{ts[2]}, new byte[][]{VALUES[2]}, 0, 0);
        for (int i = 0; i < 5; ++i) {
            get = new Get(ROW2);
            get.addColumn(FAMILY, QUALIFIERS[i]);
            get.setMaxVersions(Integer.MAX_VALUE);
            result = ht.get(get);
            this.assertNResult(result, ROW2, FAMILY, QUALIFIERS[i], new long[]{ts[0], ts[2], ts[4]}, new byte[][]{VALUES[0], VALUES[2], VALUES[4]}, 0, 2);
        }
        ht.close();
        admin.close();
    }

    @Test
    public void testDeletes() throws Exception {
        byte[] bytes;
        int i;
        byte[] bytes2;
        int i2;
        byte[] TABLE = Bytes.toBytes((String)"testDeletes");
        byte[][] ROWS = this.makeNAscii(ROW, 6);
        byte[][] FAMILIES = this.makeNAscii(FAMILY, 3);
        byte[][] VALUES = this.makeN(VALUE, 5);
        long[] ts = new long[]{1000L, 2000L, 3000L, 4000L, 5000L};
        HTable ht = TEST_UTIL.createTable(TABLE, FAMILIES, 3);
        Put put = new Put(ROW);
        put.add(FAMILIES[0], QUALIFIER, ts[0], VALUES[0]);
        put.add(FAMILIES[0], QUALIFIER, ts[1], VALUES[1]);
        ht.put(put);
        Delete delete = new Delete(ROW);
        delete.deleteFamily(FAMILIES[0], ts[0]);
        ht.delete(delete);
        Get get = new Get(ROW);
        get.addFamily(FAMILIES[0]);
        get.setMaxVersions(Integer.MAX_VALUE);
        Result result = ht.get(get);
        this.assertNResult(result, ROW, FAMILIES[0], QUALIFIER, new long[]{ts[1]}, new byte[][]{VALUES[1]}, 0, 0);
        Scan scan = new Scan(ROW);
        scan.addFamily(FAMILIES[0]);
        scan.setMaxVersions(Integer.MAX_VALUE);
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROW, FAMILIES[0], QUALIFIER, new long[]{ts[1]}, new byte[][]{VALUES[1]}, 0, 0);
        put = new Put(ROW);
        put.add(FAMILIES[0], QUALIFIER, ts[4], VALUES[4]);
        put.add(FAMILIES[0], QUALIFIER, ts[2], VALUES[2]);
        put.add(FAMILIES[0], QUALIFIER, ts[3], VALUES[3]);
        put.add(FAMILIES[0], null, ts[4], VALUES[4]);
        put.add(FAMILIES[0], null, ts[2], VALUES[2]);
        put.add(FAMILIES[0], null, ts[3], VALUES[3]);
        ht.put(put);
        delete = new Delete(ROW);
        delete.deleteColumn(FAMILIES[0], QUALIFIER);
        ht.delete(delete);
        get = new Get(ROW);
        get.addColumn(FAMILIES[0], QUALIFIER);
        get.setMaxVersions(Integer.MAX_VALUE);
        result = ht.get(get);
        this.assertNResult(result, ROW, FAMILIES[0], QUALIFIER, new long[]{ts[1], ts[2], ts[3]}, new byte[][]{VALUES[1], VALUES[2], VALUES[3]}, 0, 2);
        scan = new Scan(ROW);
        scan.addColumn(FAMILIES[0], QUALIFIER);
        scan.setMaxVersions(Integer.MAX_VALUE);
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROW, FAMILIES[0], QUALIFIER, new long[]{ts[1], ts[2], ts[3]}, new byte[][]{VALUES[1], VALUES[2], VALUES[3]}, 0, 2);
        delete = new Delete(ROW);
        delete.deleteColumn(FAMILIES[0], null);
        ht.delete(delete);
        delete = new Delete(ROW);
        delete.deleteColumns(FAMILIES[0], null);
        ht.delete(delete);
        put = new Put(ROW);
        put.add(FAMILIES[0], QUALIFIER, ts[0], VALUES[0]);
        put.add(FAMILIES[0], QUALIFIER, ts[4], VALUES[4]);
        ht.put(put);
        get = new Get(ROW);
        get.addFamily(FAMILIES[0]);
        get.setMaxVersions(Integer.MAX_VALUE);
        result = ht.get(get);
        this.assertNResult(result, ROW, FAMILIES[0], QUALIFIER, new long[]{ts[1], ts[2], ts[3]}, new byte[][]{VALUES[1], VALUES[2], VALUES[3]}, 0, 2);
        scan = new Scan(ROW);
        scan.addFamily(FAMILIES[0]);
        scan.setMaxVersions(Integer.MAX_VALUE);
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROW, FAMILIES[0], QUALIFIER, new long[]{ts[1], ts[2], ts[3]}, new byte[][]{VALUES[1], VALUES[2], VALUES[3]}, 0, 2);
        put = new Put(ROWS[0]);
        put.add(FAMILIES[1], QUALIFIER, ts[0], VALUES[0]);
        put.add(FAMILIES[1], QUALIFIER, ts[1], VALUES[1]);
        put.add(FAMILIES[2], QUALIFIER, ts[2], VALUES[2]);
        put.add(FAMILIES[2], QUALIFIER, ts[3], VALUES[3]);
        ht.put(put);
        put = new Put(ROWS[1]);
        put.add(FAMILIES[1], QUALIFIER, ts[0], VALUES[0]);
        put.add(FAMILIES[1], QUALIFIER, ts[1], VALUES[1]);
        put.add(FAMILIES[2], QUALIFIER, ts[2], VALUES[2]);
        put.add(FAMILIES[2], QUALIFIER, ts[3], VALUES[3]);
        ht.put(put);
        put = new Put(ROWS[2]);
        put.add(FAMILIES[1], QUALIFIER, ts[0], VALUES[0]);
        put.add(FAMILIES[1], QUALIFIER, ts[1], VALUES[1]);
        put.add(FAMILIES[2], QUALIFIER, ts[2], VALUES[2]);
        put.add(FAMILIES[2], QUALIFIER, ts[3], VALUES[3]);
        ht.put(put);
        get = new Get(ROWS[2]);
        get.addFamily(FAMILIES[1]);
        get.addFamily(FAMILIES[2]);
        get.setMaxVersions(Integer.MAX_VALUE);
        result = ht.get(get);
        Assert.assertTrue((String)("Expected 4 key but received " + result.size() + ": " + result), (result.size() == 4 ? 1 : 0) != 0);
        delete = new Delete(ROWS[0]);
        delete.deleteFamily(FAMILIES[2]);
        ht.delete(delete);
        delete = new Delete(ROWS[1]);
        delete.deleteColumns(FAMILIES[1], QUALIFIER);
        ht.delete(delete);
        delete = new Delete(ROWS[2]);
        delete.deleteColumn(FAMILIES[1], QUALIFIER);
        delete.deleteColumn(FAMILIES[1], QUALIFIER);
        delete.deleteColumn(FAMILIES[2], QUALIFIER);
        ht.delete(delete);
        get = new Get(ROWS[0]);
        get.addFamily(FAMILIES[1]);
        get.addFamily(FAMILIES[2]);
        get.setMaxVersions(Integer.MAX_VALUE);
        result = ht.get(get);
        Assert.assertTrue((String)("Expected 2 keys but received " + result.size()), (result.size() == 2 ? 1 : 0) != 0);
        this.assertNResult(result, ROWS[0], FAMILIES[1], QUALIFIER, new long[]{ts[0], ts[1]}, new byte[][]{VALUES[0], VALUES[1]}, 0, 1);
        scan = new Scan(ROWS[0]);
        scan.addFamily(FAMILIES[1]);
        scan.addFamily(FAMILIES[2]);
        scan.setMaxVersions(Integer.MAX_VALUE);
        result = this.getSingleScanResult(ht, scan);
        Assert.assertTrue((String)("Expected 2 keys but received " + result.size()), (result.size() == 2 ? 1 : 0) != 0);
        this.assertNResult(result, ROWS[0], FAMILIES[1], QUALIFIER, new long[]{ts[0], ts[1]}, new byte[][]{VALUES[0], VALUES[1]}, 0, 1);
        get = new Get(ROWS[1]);
        get.addFamily(FAMILIES[1]);
        get.addFamily(FAMILIES[2]);
        get.setMaxVersions(Integer.MAX_VALUE);
        result = ht.get(get);
        Assert.assertTrue((String)("Expected 2 keys but received " + result.size()), (result.size() == 2 ? 1 : 0) != 0);
        scan = new Scan(ROWS[1]);
        scan.addFamily(FAMILIES[1]);
        scan.addFamily(FAMILIES[2]);
        scan.setMaxVersions(Integer.MAX_VALUE);
        result = this.getSingleScanResult(ht, scan);
        Assert.assertTrue((String)("Expected 2 keys but received " + result.size()), (result.size() == 2 ? 1 : 0) != 0);
        get = new Get(ROWS[2]);
        get.addFamily(FAMILIES[1]);
        get.addFamily(FAMILIES[2]);
        get.setMaxVersions(Integer.MAX_VALUE);
        result = ht.get(get);
        Assert.assertEquals((long)1L, (long)result.size());
        this.assertNResult(result, ROWS[2], FAMILIES[2], QUALIFIER, new long[]{ts[2]}, new byte[][]{VALUES[2]}, 0, 0);
        scan = new Scan(ROWS[2]);
        scan.addFamily(FAMILIES[1]);
        scan.addFamily(FAMILIES[2]);
        scan.setMaxVersions(Integer.MAX_VALUE);
        result = this.getSingleScanResult(ht, scan);
        Assert.assertEquals((long)1L, (long)result.size());
        this.assertNResult(result, ROWS[2], FAMILIES[2], QUALIFIER, new long[]{ts[2]}, new byte[][]{VALUES[2]}, 0, 0);
        delete = new Delete(ROWS[3]);
        delete.deleteFamily(FAMILIES[1]);
        ht.delete(delete);
        put = new Put(ROWS[3]);
        put.add(FAMILIES[2], QUALIFIER, VALUES[0]);
        ht.put(put);
        put = new Put(ROWS[4]);
        put.add(FAMILIES[1], QUALIFIER, VALUES[1]);
        put.add(FAMILIES[2], QUALIFIER, VALUES[2]);
        ht.put(put);
        get = new Get(ROWS[3]);
        get.addFamily(FAMILIES[1]);
        get.addFamily(FAMILIES[2]);
        get.setMaxVersions(Integer.MAX_VALUE);
        result = ht.get(get);
        Assert.assertTrue((String)("Expected 1 key but received " + result.size()), (result.size() == 1 ? 1 : 0) != 0);
        get = new Get(ROWS[4]);
        get.addFamily(FAMILIES[1]);
        get.addFamily(FAMILIES[2]);
        get.setMaxVersions(Integer.MAX_VALUE);
        result = ht.get(get);
        Assert.assertTrue((String)("Expected 2 keys but received " + result.size()), (result.size() == 2 ? 1 : 0) != 0);
        scan = new Scan(ROWS[3]);
        scan.addFamily(FAMILIES[1]);
        scan.addFamily(FAMILIES[2]);
        scan.setMaxVersions(Integer.MAX_VALUE);
        ResultScanner scanner = ht.getScanner(scan);
        result = scanner.next();
        Assert.assertTrue((String)("Expected 1 key but received " + result.size()), (result.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Bytes.equals((byte[])CellUtil.cloneRow((Cell)result.rawCells()[0]), (byte[])ROWS[3]));
        Assert.assertTrue((boolean)Bytes.equals((byte[])CellUtil.cloneValue((Cell)result.rawCells()[0]), (byte[])VALUES[0]));
        result = scanner.next();
        Assert.assertTrue((String)("Expected 2 keys but received " + result.size()), (result.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Bytes.equals((byte[])CellUtil.cloneRow((Cell)result.rawCells()[0]), (byte[])ROWS[4]));
        Assert.assertTrue((boolean)Bytes.equals((byte[])CellUtil.cloneRow((Cell)result.rawCells()[1]), (byte[])ROWS[4]));
        Assert.assertTrue((boolean)Bytes.equals((byte[])CellUtil.cloneValue((Cell)result.rawCells()[0]), (byte[])VALUES[1]));
        Assert.assertTrue((boolean)Bytes.equals((byte[])CellUtil.cloneValue((Cell)result.rawCells()[1]), (byte[])VALUES[2]));
        scanner.close();
        for (i2 = 0; i2 < 10; ++i2) {
            bytes2 = Bytes.toBytes((int)i2);
            put = new Put(bytes2);
            put.setDurability(Durability.SKIP_WAL);
            put.add(FAMILIES[0], QUALIFIER, bytes2);
            ht.put(put);
        }
        for (i2 = 0; i2 < 10; ++i2) {
            bytes2 = Bytes.toBytes((int)i2);
            get = new Get(bytes2);
            get.addFamily(FAMILIES[0]);
            result = ht.get(get);
            Assert.assertTrue((result.size() == 1 ? 1 : 0) != 0);
        }
        ArrayList<Delete> deletes = new ArrayList<Delete>();
        for (i = 0; i < 10; ++i) {
            bytes = Bytes.toBytes((int)i);
            delete = new Delete(bytes);
            delete.deleteFamily(FAMILIES[0]);
            deletes.add(delete);
        }
        ht.delete(deletes);
        for (i = 0; i < 10; ++i) {
            bytes = Bytes.toBytes((int)i);
            get = new Get(bytes);
            get.addFamily(FAMILIES[0]);
            result = ht.get(get);
            Assert.assertTrue((result.size() == 0 ? 1 : 0) != 0);
        }
    }

    @Ignore
    @Test
    public void testMillions() throws Exception {
    }

    @Ignore
    @Test
    public void testMultipleRegionsAndBatchPuts() throws Exception {
    }

    @Ignore
    @Test
    public void testMultipleRowMultipleFamily() throws Exception {
    }

    @Test
    public void testJiraTest867() throws Exception {
        int i;
        int numRows = 10;
        int numColsPerRow = 2000;
        byte[] TABLE = Bytes.toBytes((String)"testJiraTest867");
        byte[][] ROWS = this.makeN(ROW, numRows);
        byte[][] QUALIFIERS = this.makeN(QUALIFIER, numColsPerRow);
        HTable ht = TEST_UTIL.createTable(TABLE, FAMILY);
        for (int i2 = 0; i2 < numRows; ++i2) {
            Put put = new Put(ROWS[i2]);
            put.setDurability(Durability.SKIP_WAL);
            for (int j = 0; j < numColsPerRow; ++j) {
                put.add(FAMILY, QUALIFIERS[j], QUALIFIERS[j]);
            }
            Assert.assertTrue((String)("Put expected to contain " + numColsPerRow + " columns but " + "only contains " + put.size()), (put.size() == numColsPerRow ? 1 : 0) != 0);
            ht.put(put);
        }
        Get get = new Get(ROWS[numRows - 1]);
        Result result = ht.get(get);
        this.assertNumKeys(result, numColsPerRow);
        Cell[] keys = result.rawCells();
        for (int i3 = 0; i3 < result.size(); ++i3) {
            this.assertKey(keys[i3], ROWS[numRows - 1], FAMILY, QUALIFIERS[i3], QUALIFIERS[i3]);
        }
        Scan scan = new Scan();
        ResultScanner scanner = ht.getScanner(scan);
        int rowCount = 0;
        while ((result = scanner.next()) != null) {
            this.assertNumKeys(result, numColsPerRow);
            Cell[] kvs = result.rawCells();
            for (i = 0; i < numColsPerRow; ++i) {
                this.assertKey(kvs[i], ROWS[rowCount], FAMILY, QUALIFIERS[i], QUALIFIERS[i]);
            }
            ++rowCount;
        }
        scanner.close();
        Assert.assertTrue((String)("Expected to scan " + numRows + " rows but actually scanned " + rowCount + " rows"), (rowCount == numRows ? 1 : 0) != 0);
        TEST_UTIL.flush();
        get = new Get(ROWS[numRows - 1]);
        result = ht.get(get);
        this.assertNumKeys(result, numColsPerRow);
        keys = result.rawCells();
        for (int i4 = 0; i4 < result.size(); ++i4) {
            this.assertKey(keys[i4], ROWS[numRows - 1], FAMILY, QUALIFIERS[i4], QUALIFIERS[i4]);
        }
        scan = new Scan();
        scanner = ht.getScanner(scan);
        rowCount = 0;
        while ((result = scanner.next()) != null) {
            this.assertNumKeys(result, numColsPerRow);
            Cell[] kvs = result.rawCells();
            for (i = 0; i < numColsPerRow; ++i) {
                this.assertKey(kvs[i], ROWS[rowCount], FAMILY, QUALIFIERS[i], QUALIFIERS[i]);
            }
            ++rowCount;
        }
        scanner.close();
        Assert.assertTrue((String)("Expected to scan " + numRows + " rows but actually scanned " + rowCount + " rows"), (rowCount == numRows ? 1 : 0) != 0);
    }

    @Test
    public void testJiraTest861() throws Exception {
        byte[] TABLE = Bytes.toBytes((String)"testJiraTest861");
        byte[][] VALUES = this.makeNAscii(VALUE, 7);
        long[] STAMPS = this.makeStamps(7);
        HTable ht = TEST_UTIL.createTable(TABLE, FAMILY, 10);
        Put put = new Put(ROW);
        put.add(FAMILY, QUALIFIER, STAMPS[3], VALUES[3]);
        put.add(FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
        put.add(FAMILY, QUALIFIER, STAMPS[4], VALUES[4]);
        ht.put(put);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[1]);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[5]);
        TEST_UTIL.flush();
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[1]);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[5]);
        put = new Put(ROW);
        put.add(FAMILY, QUALIFIER, STAMPS[0], VALUES[0]);
        put.add(FAMILY, QUALIFIER, STAMPS[6], VALUES[6]);
        ht.put(put);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[0], VALUES[0]);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[1]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[3], VALUES[3]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[4], VALUES[4]);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[5]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[6], VALUES[6]);
        TEST_UTIL.flush();
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[0], VALUES[0]);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[1]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[3], VALUES[3]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[4], VALUES[4]);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[5]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[6], VALUES[6]);
    }

    @Test
    public void testJiraTest33() throws Exception {
        byte[] TABLE = Bytes.toBytes((String)"testJiraTest33");
        byte[][] VALUES = this.makeNAscii(VALUE, 7);
        long[] STAMPS = this.makeStamps(7);
        HTable ht = TEST_UTIL.createTable(TABLE, FAMILY, 10);
        Put put = new Put(ROW);
        put.add(FAMILY, QUALIFIER, STAMPS[0], VALUES[0]);
        put.add(FAMILY, QUALIFIER, STAMPS[1], VALUES[1]);
        put.add(FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
        put.add(FAMILY, QUALIFIER, STAMPS[3], VALUES[3]);
        put.add(FAMILY, QUALIFIER, STAMPS[4], VALUES[4]);
        put.add(FAMILY, QUALIFIER, STAMPS[5], VALUES[5]);
        ht.put(put);
        this.getVersionRangeAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 0, 5);
        this.getVersionRangeAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 0, 2);
        this.getVersionRangeAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 4, 5);
        this.getVersionRangeAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 2, 3);
        this.scanVersionRangeAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 0, 5);
        this.scanVersionRangeAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 0, 2);
        this.scanVersionRangeAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 4, 5);
        this.scanVersionRangeAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 2, 3);
        TEST_UTIL.flush();
        this.getVersionRangeAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 0, 5);
        this.getVersionRangeAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 0, 2);
        this.getVersionRangeAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 4, 5);
        this.getVersionRangeAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 2, 3);
        this.scanVersionRangeAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 0, 5);
        this.scanVersionRangeAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 0, 2);
        this.scanVersionRangeAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 4, 5);
        this.scanVersionRangeAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 2, 3);
    }

    @Test
    public void testJiraTest1014() throws Exception {
        byte[] TABLE = Bytes.toBytes((String)"testJiraTest1014");
        HTable ht = TEST_UTIL.createTable(TABLE, FAMILY, 10);
        long manualStamp = 12345L;
        Put put = new Put(ROW);
        put.add(FAMILY, QUALIFIER, manualStamp, VALUE);
        ht.put(put);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, manualStamp, VALUE);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, manualStamp - 1L);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, manualStamp + 1L);
    }

    @Test
    public void testJiraTest1182() throws Exception {
        byte[] TABLE = Bytes.toBytes((String)"testJiraTest1182");
        byte[][] VALUES = this.makeNAscii(VALUE, 7);
        long[] STAMPS = this.makeStamps(7);
        HTable ht = TEST_UTIL.createTable(TABLE, FAMILY, 10);
        Put put = new Put(ROW);
        put.add(FAMILY, QUALIFIER, STAMPS[0], VALUES[0]);
        put.add(FAMILY, QUALIFIER, STAMPS[1], VALUES[1]);
        put.add(FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
        put.add(FAMILY, QUALIFIER, STAMPS[3], VALUES[3]);
        put.add(FAMILY, QUALIFIER, STAMPS[4], VALUES[4]);
        put.add(FAMILY, QUALIFIER, STAMPS[5], VALUES[5]);
        ht.put(put);
        this.getVersionRangeAndVerifyGreaterThan(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 0, 5);
        this.getVersionRangeAndVerifyGreaterThan(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 2, 5);
        this.getVersionRangeAndVerifyGreaterThan(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 4, 5);
        this.scanVersionRangeAndVerifyGreaterThan(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 0, 5);
        this.scanVersionRangeAndVerifyGreaterThan(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 2, 5);
        this.scanVersionRangeAndVerifyGreaterThan(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 4, 5);
        TEST_UTIL.flush();
        this.getVersionRangeAndVerifyGreaterThan(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 0, 5);
        this.getVersionRangeAndVerifyGreaterThan(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 2, 5);
        this.getVersionRangeAndVerifyGreaterThan(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 4, 5);
        this.scanVersionRangeAndVerifyGreaterThan(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 0, 5);
        this.scanVersionRangeAndVerifyGreaterThan(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 2, 5);
        this.scanVersionRangeAndVerifyGreaterThan(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 4, 5);
    }

    @Test
    public void testJiraTest52() throws Exception {
        byte[] TABLE = Bytes.toBytes((String)"testJiraTest52");
        byte[][] VALUES = this.makeNAscii(VALUE, 7);
        long[] STAMPS = this.makeStamps(7);
        HTable ht = TEST_UTIL.createTable(TABLE, FAMILY, 10);
        Put put = new Put(ROW);
        put.add(FAMILY, QUALIFIER, STAMPS[0], VALUES[0]);
        put.add(FAMILY, QUALIFIER, STAMPS[1], VALUES[1]);
        put.add(FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
        put.add(FAMILY, QUALIFIER, STAMPS[3], VALUES[3]);
        put.add(FAMILY, QUALIFIER, STAMPS[4], VALUES[4]);
        put.add(FAMILY, QUALIFIER, STAMPS[5], VALUES[5]);
        ht.put(put);
        this.getAllVersionsAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 0, 5);
        this.scanAllVersionsAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 0, 5);
        TEST_UTIL.flush();
        this.getAllVersionsAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 0, 5);
        this.scanAllVersionsAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS, VALUES, 0, 5);
    }

    private void getVersionRangeAndVerifyGreaterThan(HTable ht, byte[] row, byte[] family, byte[] qualifier, long[] stamps, byte[][] values, int start, int end) throws IOException {
        Get get = new Get(row);
        get.addColumn(family, qualifier);
        get.setMaxVersions(Integer.MAX_VALUE);
        get.setTimeRange(stamps[start + 1], Long.MAX_VALUE);
        Result result = ht.get(get);
        this.assertNResult(result, row, family, qualifier, stamps, values, start + 1, end);
    }

    private void getVersionRangeAndVerify(HTable ht, byte[] row, byte[] family, byte[] qualifier, long[] stamps, byte[][] values, int start, int end) throws IOException {
        Get get = new Get(row);
        get.addColumn(family, qualifier);
        get.setMaxVersions(Integer.MAX_VALUE);
        get.setTimeRange(stamps[start], stamps[end] + 1L);
        Result result = ht.get(get);
        this.assertNResult(result, row, family, qualifier, stamps, values, start, end);
    }

    private void getAllVersionsAndVerify(HTable ht, byte[] row, byte[] family, byte[] qualifier, long[] stamps, byte[][] values, int start, int end) throws IOException {
        Get get = new Get(row);
        get.addColumn(family, qualifier);
        get.setMaxVersions(Integer.MAX_VALUE);
        Result result = ht.get(get);
        this.assertNResult(result, row, family, qualifier, stamps, values, start, end);
    }

    private void scanVersionRangeAndVerifyGreaterThan(HTable ht, byte[] row, byte[] family, byte[] qualifier, long[] stamps, byte[][] values, int start, int end) throws IOException {
        Scan scan = new Scan(row);
        scan.addColumn(family, qualifier);
        scan.setMaxVersions(Integer.MAX_VALUE);
        scan.setTimeRange(stamps[start + 1], Long.MAX_VALUE);
        Result result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, row, family, qualifier, stamps, values, start + 1, end);
    }

    private void scanVersionRangeAndVerify(HTable ht, byte[] row, byte[] family, byte[] qualifier, long[] stamps, byte[][] values, int start, int end) throws IOException {
        Scan scan = new Scan(row);
        scan.addColumn(family, qualifier);
        scan.setMaxVersions(Integer.MAX_VALUE);
        scan.setTimeRange(stamps[start], stamps[end] + 1L);
        Result result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, row, family, qualifier, stamps, values, start, end);
    }

    private void scanAllVersionsAndVerify(HTable ht, byte[] row, byte[] family, byte[] qualifier, long[] stamps, byte[][] values, int start, int end) throws IOException {
        Scan scan = new Scan(row);
        scan.addColumn(family, qualifier);
        scan.setMaxVersions(Integer.MAX_VALUE);
        Result result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, row, family, qualifier, stamps, values, start, end);
    }

    private void getVersionAndVerify(HTable ht, byte[] row, byte[] family, byte[] qualifier, long stamp, byte[] value) throws Exception {
        Get get = new Get(row);
        get.addColumn(family, qualifier);
        get.setTimeStamp(stamp);
        get.setMaxVersions(Integer.MAX_VALUE);
        Result result = ht.get(get);
        this.assertSingleResult(result, row, family, qualifier, stamp, value);
    }

    private void getVersionAndVerifyMissing(HTable ht, byte[] row, byte[] family, byte[] qualifier, long stamp) throws Exception {
        Get get = new Get(row);
        get.addColumn(family, qualifier);
        get.setTimeStamp(stamp);
        get.setMaxVersions(Integer.MAX_VALUE);
        Result result = ht.get(get);
        this.assertEmptyResult(result);
    }

    private void scanVersionAndVerify(HTable ht, byte[] row, byte[] family, byte[] qualifier, long stamp, byte[] value) throws Exception {
        Scan scan = new Scan(row);
        scan.addColumn(family, qualifier);
        scan.setTimeStamp(stamp);
        scan.setMaxVersions(Integer.MAX_VALUE);
        Result result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, row, family, qualifier, stamp, value);
    }

    private void scanVersionAndVerifyMissing(HTable ht, byte[] row, byte[] family, byte[] qualifier, long stamp) throws Exception {
        Scan scan = new Scan(row);
        scan.addColumn(family, qualifier);
        scan.setTimeStamp(stamp);
        scan.setMaxVersions(Integer.MAX_VALUE);
        Result result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
    }

    private void getTestNull(HTable ht, byte[] row, byte[] family, byte[] value) throws Exception {
        Get get = new Get(row);
        get.addColumn(family, null);
        Result result = ht.get(get);
        this.assertSingleResult(result, row, family, null, value);
        get = new Get(row);
        get.addColumn(family, HConstants.EMPTY_BYTE_ARRAY);
        result = ht.get(get);
        this.assertSingleResult(result, row, family, HConstants.EMPTY_BYTE_ARRAY, value);
        get = new Get(row);
        get.addFamily(family);
        result = ht.get(get);
        this.assertSingleResult(result, row, family, HConstants.EMPTY_BYTE_ARRAY, value);
        get = new Get(row);
        result = ht.get(get);
        this.assertSingleResult(result, row, family, HConstants.EMPTY_BYTE_ARRAY, value);
    }

    private void scanTestNull(HTable ht, byte[] row, byte[] family, byte[] value) throws Exception {
        this.scanTestNull(ht, row, family, value, false);
    }

    private void scanTestNull(HTable ht, byte[] row, byte[] family, byte[] value, boolean isReversedScan) throws Exception {
        Scan scan = new Scan();
        scan.setReversed(isReversedScan);
        scan.addColumn(family, null);
        Result result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, row, family, HConstants.EMPTY_BYTE_ARRAY, value);
        scan = new Scan();
        scan.setReversed(isReversedScan);
        scan.addColumn(family, HConstants.EMPTY_BYTE_ARRAY);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, row, family, HConstants.EMPTY_BYTE_ARRAY, value);
        scan = new Scan();
        scan.setReversed(isReversedScan);
        scan.addFamily(family);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, row, family, HConstants.EMPTY_BYTE_ARRAY, value);
        scan = new Scan();
        scan.setReversed(isReversedScan);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, row, family, HConstants.EMPTY_BYTE_ARRAY, value);
    }

    private void singleRowGetTest(HTable ht, byte[][] ROWS, byte[][] FAMILIES, byte[][] QUALIFIERS, byte[][] VALUES) throws Exception {
        Get get = new Get(ROWS[0]);
        get.addColumn(FAMILIES[4], QUALIFIERS[0]);
        Result result = ht.get(get);
        this.assertSingleResult(result, ROWS[0], FAMILIES[4], QUALIFIERS[0], VALUES[0]);
        get = new Get(ROWS[0]);
        get.addColumn(FAMILIES[2], QUALIFIERS[2]);
        result = ht.get(get);
        this.assertSingleResult(result, ROWS[0], FAMILIES[2], QUALIFIERS[2], VALUES[2]);
        get = new Get(ROWS[0]);
        get.addFamily(FAMILIES[7]);
        result = ht.get(get);
        this.assertSingleResult(result, ROWS[0], FAMILIES[7], QUALIFIERS[7], VALUES[7]);
        get = new Get(ROWS[0]);
        get.addFamily(FAMILIES[4]);
        result = ht.get(get);
        this.assertDoubleResult(result, ROWS[0], FAMILIES[4], QUALIFIERS[0], VALUES[0], FAMILIES[4], QUALIFIERS[4], VALUES[4]);
        get = new Get(ROWS[0]);
        get.addColumn(FAMILIES[4], QUALIFIERS[0]);
        get.addColumn(FAMILIES[4], QUALIFIERS[4]);
        result = ht.get(get);
        this.assertDoubleResult(result, ROWS[0], FAMILIES[4], QUALIFIERS[0], VALUES[0], FAMILIES[4], QUALIFIERS[4], VALUES[4]);
        get = new Get(ROWS[0]);
        get.addFamily(FAMILIES[4]);
        get.addFamily(FAMILIES[7]);
        result = ht.get(get);
        this.assertNResult(result, ROWS[0], FAMILIES, QUALIFIERS, VALUES, new int[][]{{4, 0, 0}, {4, 4, 4}, {7, 7, 7}});
        get = new Get(ROWS[0]);
        get.addFamily(FAMILIES[2]);
        get.addFamily(FAMILIES[4]);
        get.addFamily(FAMILIES[6]);
        get.addFamily(FAMILIES[7]);
        result = ht.get(get);
        this.assertNResult(result, ROWS[0], FAMILIES, QUALIFIERS, VALUES, new int[][]{{2, 2, 2}, {2, 4, 4}, {4, 0, 0}, {4, 4, 4}, {6, 6, 6}, {6, 7, 7}, {7, 7, 7}});
        get = new Get(ROWS[0]);
        get.addColumn(FAMILIES[2], QUALIFIERS[2]);
        get.addColumn(FAMILIES[2], QUALIFIERS[4]);
        get.addColumn(FAMILIES[4], QUALIFIERS[0]);
        get.addColumn(FAMILIES[4], QUALIFIERS[4]);
        get.addColumn(FAMILIES[6], QUALIFIERS[6]);
        get.addColumn(FAMILIES[6], QUALIFIERS[7]);
        get.addColumn(FAMILIES[7], QUALIFIERS[7]);
        get.addColumn(FAMILIES[7], QUALIFIERS[8]);
        result = ht.get(get);
        this.assertNResult(result, ROWS[0], FAMILIES, QUALIFIERS, VALUES, new int[][]{{2, 2, 2}, {2, 4, 4}, {4, 0, 0}, {4, 4, 4}, {6, 6, 6}, {6, 7, 7}, {7, 7, 7}});
        get = new Get(ROWS[0]);
        result = ht.get(get);
        this.assertNResult(result, ROWS[0], FAMILIES, QUALIFIERS, VALUES, new int[][]{{2, 2, 2}, {2, 4, 4}, {4, 0, 0}, {4, 4, 4}, {6, 6, 6}, {6, 7, 7}, {7, 7, 7}, {9, 0, 0}});
        get = new Get(ROWS[1]);
        result = ht.get(get);
        this.assertEmptyResult(result);
        get = new Get(ROWS[0]);
        get.addColumn(FAMILIES[4], QUALIFIERS[3]);
        get.addColumn(FAMILIES[2], QUALIFIERS[3]);
        result = ht.get(get);
        this.assertEmptyResult(result);
    }

    private void singleRowScanTest(HTable ht, byte[][] ROWS, byte[][] FAMILIES, byte[][] QUALIFIERS, byte[][] VALUES) throws Exception {
        Scan scan = new Scan();
        scan.addColumn(FAMILIES[4], QUALIFIERS[0]);
        Result result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[0], FAMILIES[4], QUALIFIERS[0], VALUES[0]);
        scan = new Scan();
        scan.addColumn(FAMILIES[2], QUALIFIERS[2]);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[0], FAMILIES[2], QUALIFIERS[2], VALUES[2]);
        scan = new Scan();
        scan.addFamily(FAMILIES[7]);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[0], FAMILIES[7], QUALIFIERS[7], VALUES[7]);
        scan = new Scan();
        scan.addFamily(FAMILIES[4]);
        result = this.getSingleScanResult(ht, scan);
        this.assertDoubleResult(result, ROWS[0], FAMILIES[4], QUALIFIERS[0], VALUES[0], FAMILIES[4], QUALIFIERS[4], VALUES[4]);
        scan = new Scan();
        scan.addColumn(FAMILIES[4], QUALIFIERS[0]);
        scan.addColumn(FAMILIES[4], QUALIFIERS[4]);
        result = this.getSingleScanResult(ht, scan);
        this.assertDoubleResult(result, ROWS[0], FAMILIES[4], QUALIFIERS[0], VALUES[0], FAMILIES[4], QUALIFIERS[4], VALUES[4]);
        scan = new Scan();
        scan.addFamily(FAMILIES[4]);
        scan.addFamily(FAMILIES[7]);
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROWS[0], FAMILIES, QUALIFIERS, VALUES, new int[][]{{4, 0, 0}, {4, 4, 4}, {7, 7, 7}});
        scan = new Scan();
        scan.addFamily(FAMILIES[2]);
        scan.addFamily(FAMILIES[4]);
        scan.addFamily(FAMILIES[6]);
        scan.addFamily(FAMILIES[7]);
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROWS[0], FAMILIES, QUALIFIERS, VALUES, new int[][]{{2, 2, 2}, {2, 4, 4}, {4, 0, 0}, {4, 4, 4}, {6, 6, 6}, {6, 7, 7}, {7, 7, 7}});
        scan = new Scan();
        scan.addColumn(FAMILIES[2], QUALIFIERS[2]);
        scan.addColumn(FAMILIES[2], QUALIFIERS[4]);
        scan.addColumn(FAMILIES[4], QUALIFIERS[0]);
        scan.addColumn(FAMILIES[4], QUALIFIERS[4]);
        scan.addColumn(FAMILIES[6], QUALIFIERS[6]);
        scan.addColumn(FAMILIES[6], QUALIFIERS[7]);
        scan.addColumn(FAMILIES[7], QUALIFIERS[7]);
        scan.addColumn(FAMILIES[7], QUALIFIERS[8]);
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROWS[0], FAMILIES, QUALIFIERS, VALUES, new int[][]{{2, 2, 2}, {2, 4, 4}, {4, 0, 0}, {4, 4, 4}, {6, 6, 6}, {6, 7, 7}, {7, 7, 7}});
        scan = new Scan();
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROWS[0], FAMILIES, QUALIFIERS, VALUES, new int[][]{{2, 2, 2}, {2, 4, 4}, {4, 0, 0}, {4, 4, 4}, {6, 6, 6}, {6, 7, 7}, {7, 7, 7}, {9, 0, 0}});
        scan = new Scan(ROWS[1]);
        result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
        scan = new Scan();
        scan.addColumn(FAMILIES[4], QUALIFIERS[3]);
        scan.addColumn(FAMILIES[2], QUALIFIERS[3]);
        result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
    }

    private void getVerifySingleColumn(HTable ht, byte[][] ROWS, int ROWIDX, byte[][] FAMILIES, int FAMILYIDX, byte[][] QUALIFIERS, int QUALIFIERIDX, byte[][] VALUES, int VALUEIDX) throws Exception {
        Get get = new Get(ROWS[ROWIDX]);
        Result result = ht.get(get);
        this.assertSingleResult(result, ROWS[ROWIDX], FAMILIES[FAMILYIDX], QUALIFIERS[QUALIFIERIDX], VALUES[VALUEIDX]);
        get = new Get(ROWS[ROWIDX]);
        get.addFamily(FAMILIES[FAMILYIDX]);
        result = ht.get(get);
        this.assertSingleResult(result, ROWS[ROWIDX], FAMILIES[FAMILYIDX], QUALIFIERS[QUALIFIERIDX], VALUES[VALUEIDX]);
        get = new Get(ROWS[ROWIDX]);
        get.addFamily(FAMILIES[FAMILYIDX - 2]);
        get.addFamily(FAMILIES[FAMILYIDX]);
        get.addFamily(FAMILIES[FAMILYIDX + 2]);
        result = ht.get(get);
        this.assertSingleResult(result, ROWS[ROWIDX], FAMILIES[FAMILYIDX], QUALIFIERS[QUALIFIERIDX], VALUES[VALUEIDX]);
        get = new Get(ROWS[ROWIDX]);
        get.addColumn(FAMILIES[FAMILYIDX], QUALIFIERS[0]);
        result = ht.get(get);
        this.assertSingleResult(result, ROWS[ROWIDX], FAMILIES[FAMILYIDX], QUALIFIERS[QUALIFIERIDX], VALUES[VALUEIDX]);
        get = new Get(ROWS[ROWIDX]);
        get.addColumn(FAMILIES[FAMILYIDX], QUALIFIERS[1]);
        get.addFamily(FAMILIES[FAMILYIDX]);
        result = ht.get(get);
        this.assertSingleResult(result, ROWS[ROWIDX], FAMILIES[FAMILYIDX], QUALIFIERS[QUALIFIERIDX], VALUES[VALUEIDX]);
        get = new Get(ROWS[ROWIDX]);
        get.addFamily(FAMILIES[FAMILYIDX]);
        get.addColumn(FAMILIES[FAMILYIDX + 1], QUALIFIERS[1]);
        get.addColumn(FAMILIES[FAMILYIDX - 2], QUALIFIERS[1]);
        get.addFamily(FAMILIES[FAMILYIDX - 1]);
        get.addFamily(FAMILIES[FAMILYIDX + 2]);
        result = ht.get(get);
        this.assertSingleResult(result, ROWS[ROWIDX], FAMILIES[FAMILYIDX], QUALIFIERS[QUALIFIERIDX], VALUES[VALUEIDX]);
    }

    private void scanVerifySingleColumn(HTable ht, byte[][] ROWS, int ROWIDX, byte[][] FAMILIES, int FAMILYIDX, byte[][] QUALIFIERS, int QUALIFIERIDX, byte[][] VALUES, int VALUEIDX) throws Exception {
        Scan scan = new Scan();
        Result result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[ROWIDX], FAMILIES[FAMILYIDX], QUALIFIERS[QUALIFIERIDX], VALUES[VALUEIDX]);
        scan = new Scan(ROWS[ROWIDX]);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[ROWIDX], FAMILIES[FAMILYIDX], QUALIFIERS[QUALIFIERIDX], VALUES[VALUEIDX]);
        scan = new Scan(ROWS[ROWIDX], ROWS[ROWIDX + 1]);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[ROWIDX], FAMILIES[FAMILYIDX], QUALIFIERS[QUALIFIERIDX], VALUES[VALUEIDX]);
        scan = new Scan(HConstants.EMPTY_START_ROW, ROWS[ROWIDX + 1]);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[ROWIDX], FAMILIES[FAMILYIDX], QUALIFIERS[QUALIFIERIDX], VALUES[VALUEIDX]);
        scan = new Scan();
        scan.addFamily(FAMILIES[FAMILYIDX]);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[ROWIDX], FAMILIES[FAMILYIDX], QUALIFIERS[QUALIFIERIDX], VALUES[VALUEIDX]);
        scan = new Scan();
        scan.addColumn(FAMILIES[FAMILYIDX], QUALIFIERS[QUALIFIERIDX]);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[ROWIDX], FAMILIES[FAMILYIDX], QUALIFIERS[QUALIFIERIDX], VALUES[VALUEIDX]);
        scan = new Scan();
        scan.addColumn(FAMILIES[FAMILYIDX], QUALIFIERS[QUALIFIERIDX + 1]);
        scan.addFamily(FAMILIES[FAMILYIDX]);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[ROWIDX], FAMILIES[FAMILYIDX], QUALIFIERS[QUALIFIERIDX], VALUES[VALUEIDX]);
        scan = new Scan();
        scan.addColumn(FAMILIES[FAMILYIDX - 1], QUALIFIERS[QUALIFIERIDX + 1]);
        scan.addColumn(FAMILIES[FAMILYIDX], QUALIFIERS[QUALIFIERIDX]);
        scan.addFamily(FAMILIES[FAMILYIDX + 1]);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[ROWIDX], FAMILIES[FAMILYIDX], QUALIFIERS[QUALIFIERIDX], VALUES[VALUEIDX]);
    }

    private void getVerifySingleEmpty(HTable ht, byte[][] ROWS, int ROWIDX, byte[][] FAMILIES, int FAMILYIDX, byte[][] QUALIFIERS, int QUALIFIERIDX) throws Exception {
        Get get = new Get(ROWS[ROWIDX]);
        get.addFamily(FAMILIES[4]);
        get.addColumn(FAMILIES[4], QUALIFIERS[1]);
        Result result = ht.get(get);
        this.assertEmptyResult(result);
        get = new Get(ROWS[ROWIDX]);
        get.addFamily(FAMILIES[4]);
        get.addColumn(FAMILIES[4], QUALIFIERS[2]);
        result = ht.get(get);
        this.assertEmptyResult(result);
        get = new Get(ROWS[ROWIDX]);
        get.addFamily(FAMILIES[3]);
        get.addColumn(FAMILIES[4], QUALIFIERS[2]);
        get.addFamily(FAMILIES[5]);
        result = ht.get(get);
        this.assertEmptyResult(result);
        get = new Get(ROWS[ROWIDX + 1]);
        result = ht.get(get);
        this.assertEmptyResult(result);
    }

    private void scanVerifySingleEmpty(HTable ht, byte[][] ROWS, int ROWIDX, byte[][] FAMILIES, int FAMILYIDX, byte[][] QUALIFIERS, int QUALIFIERIDX) throws Exception {
        Scan scan = new Scan(ROWS[ROWIDX + 1]);
        Result result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
        scan = new Scan(ROWS[ROWIDX + 1], ROWS[ROWIDX + 2]);
        result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
        scan = new Scan(HConstants.EMPTY_START_ROW, ROWS[ROWIDX]);
        result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
        scan = new Scan();
        scan.addColumn(FAMILIES[FAMILYIDX], QUALIFIERS[QUALIFIERIDX + 1]);
        scan.addFamily(FAMILIES[FAMILYIDX - 1]);
        result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
    }

    private void assertKey(Cell key, byte[] row, byte[] family, byte[] qualifier, byte[] value) throws Exception {
        Assert.assertTrue((String)("Expected row [" + Bytes.toString((byte[])row) + "] " + "Got row [" + Bytes.toString((byte[])CellUtil.cloneRow((Cell)key)) + "]"), (boolean)this.equals(row, CellUtil.cloneRow((Cell)key)));
        Assert.assertTrue((String)("Expected family [" + Bytes.toString((byte[])family) + "] " + "Got family [" + Bytes.toString((byte[])CellUtil.cloneFamily((Cell)key)) + "]"), (boolean)this.equals(family, CellUtil.cloneFamily((Cell)key)));
        Assert.assertTrue((String)("Expected qualifier [" + Bytes.toString((byte[])qualifier) + "] " + "Got qualifier [" + Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)key)) + "]"), (boolean)this.equals(qualifier, CellUtil.cloneQualifier((Cell)key)));
        Assert.assertTrue((String)("Expected value [" + Bytes.toString((byte[])value) + "] " + "Got value [" + Bytes.toString((byte[])CellUtil.cloneValue((Cell)key)) + "]"), (boolean)this.equals(value, CellUtil.cloneValue((Cell)key)));
    }

    private void assertIncrementKey(Cell key, byte[] row, byte[] family, byte[] qualifier, long value) throws Exception {
        Assert.assertTrue((String)("Expected row [" + Bytes.toString((byte[])row) + "] " + "Got row [" + Bytes.toString((byte[])CellUtil.cloneRow((Cell)key)) + "]"), (boolean)this.equals(row, CellUtil.cloneRow((Cell)key)));
        Assert.assertTrue((String)("Expected family [" + Bytes.toString((byte[])family) + "] " + "Got family [" + Bytes.toString((byte[])CellUtil.cloneFamily((Cell)key)) + "]"), (boolean)this.equals(family, CellUtil.cloneFamily((Cell)key)));
        Assert.assertTrue((String)("Expected qualifier [" + Bytes.toString((byte[])qualifier) + "] " + "Got qualifier [" + Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)key)) + "]"), (boolean)this.equals(qualifier, CellUtil.cloneQualifier((Cell)key)));
        Assert.assertTrue((String)("Expected value [" + value + "] " + "Got value [" + Bytes.toLong((byte[])CellUtil.cloneValue((Cell)key)) + "]"), (Bytes.toLong((byte[])CellUtil.cloneValue((Cell)key)) == value ? 1 : 0) != 0);
    }

    private void assertNumKeys(Result result, int n) throws Exception {
        Assert.assertTrue((String)("Expected " + n + " keys but got " + result.size()), (result.size() == n ? 1 : 0) != 0);
    }

    private void assertNResult(Result result, byte[] row, byte[][] families, byte[][] qualifiers, byte[][] values, int[][] idxs) throws Exception {
        Assert.assertTrue((String)("Expected row [" + Bytes.toString((byte[])row) + "] " + "Got row [" + Bytes.toString((byte[])result.getRow()) + "]"), (boolean)this.equals(row, result.getRow()));
        Assert.assertTrue((String)("Expected " + idxs.length + " keys but result contains " + result.size()), (result.size() == idxs.length ? 1 : 0) != 0);
        Cell[] keys = result.rawCells();
        for (int i = 0; i < keys.length; ++i) {
            byte[] family = families[idxs[i][0]];
            byte[] qualifier = qualifiers[idxs[i][1]];
            byte[] value = values[idxs[i][2]];
            Cell key = keys[i];
            byte[] famb = CellUtil.cloneFamily((Cell)key);
            byte[] qualb = CellUtil.cloneQualifier((Cell)key);
            byte[] valb = CellUtil.cloneValue((Cell)key);
            Assert.assertTrue((String)("(" + i + ") Expected family [" + Bytes.toString((byte[])family) + "] " + "Got family [" + Bytes.toString((byte[])famb) + "]"), (boolean)this.equals(family, famb));
            Assert.assertTrue((String)("(" + i + ") Expected qualifier [" + Bytes.toString((byte[])qualifier) + "] " + "Got qualifier [" + Bytes.toString((byte[])qualb) + "]"), (boolean)this.equals(qualifier, qualb));
            Assert.assertTrue((String)("(" + i + ") Expected value [" + Bytes.toString((byte[])value) + "] " + "Got value [" + Bytes.toString((byte[])valb) + "]"), (boolean)this.equals(value, valb));
        }
    }

    private void assertNResult(Result result, byte[] row, byte[] family, byte[] qualifier, long[] stamps, byte[][] values, int start, int end) throws IOException {
        Assert.assertTrue((String)("Expected row [" + Bytes.toString((byte[])row) + "] " + "Got row [" + Bytes.toString((byte[])result.getRow()) + "]"), (boolean)this.equals(row, result.getRow()));
        int expectedResults = end - start + 1;
        Assert.assertEquals((long)expectedResults, (long)result.size());
        Cell[] keys = result.rawCells();
        for (int i = 0; i < keys.length; ++i) {
            byte[] value = values[end - i];
            long ts = stamps[end - i];
            Cell key = keys[i];
            Assert.assertTrue((String)("(" + i + ") Expected family [" + Bytes.toString((byte[])family) + "] " + "Got family [" + Bytes.toString((byte[])CellUtil.cloneFamily((Cell)key)) + "]"), (boolean)CellUtil.matchingFamily((Cell)key, (byte[])family));
            Assert.assertTrue((String)("(" + i + ") Expected qualifier [" + Bytes.toString((byte[])qualifier) + "] " + "Got qualifier [" + Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)key)) + "]"), (boolean)CellUtil.matchingQualifier((Cell)key, (byte[])qualifier));
            Assert.assertTrue((String)("Expected ts [" + ts + "] " + "Got ts [" + key.getTimestamp() + "]"), (ts == key.getTimestamp() ? 1 : 0) != 0);
            Assert.assertTrue((String)("(" + i + ") Expected value [" + Bytes.toString((byte[])value) + "] " + "Got value [" + Bytes.toString((byte[])CellUtil.cloneValue((Cell)key)) + "]"), (boolean)CellUtil.matchingValue((Cell)key, (byte[])value));
        }
    }

    private void assertDoubleResult(Result result, byte[] row, byte[] familyA, byte[] qualifierA, byte[] valueA, byte[] familyB, byte[] qualifierB, byte[] valueB) throws Exception {
        Assert.assertTrue((String)("Expected row [" + Bytes.toString((byte[])row) + "] " + "Got row [" + Bytes.toString((byte[])result.getRow()) + "]"), (boolean)this.equals(row, result.getRow()));
        Assert.assertTrue((String)("Expected two keys but result contains " + result.size()), (result.size() == 2 ? 1 : 0) != 0);
        Cell[] kv = result.rawCells();
        Cell kvA = kv[0];
        Assert.assertTrue((String)("(A) Expected family [" + Bytes.toString((byte[])familyA) + "] " + "Got family [" + Bytes.toString((byte[])CellUtil.cloneFamily((Cell)kvA)) + "]"), (boolean)this.equals(familyA, CellUtil.cloneFamily((Cell)kvA)));
        Assert.assertTrue((String)("(A) Expected qualifier [" + Bytes.toString((byte[])qualifierA) + "] " + "Got qualifier [" + Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)kvA)) + "]"), (boolean)this.equals(qualifierA, CellUtil.cloneQualifier((Cell)kvA)));
        Assert.assertTrue((String)("(A) Expected value [" + Bytes.toString((byte[])valueA) + "] " + "Got value [" + Bytes.toString((byte[])CellUtil.cloneValue((Cell)kvA)) + "]"), (boolean)this.equals(valueA, CellUtil.cloneValue((Cell)kvA)));
        Cell kvB = kv[1];
        Assert.assertTrue((String)("(B) Expected family [" + Bytes.toString((byte[])familyB) + "] " + "Got family [" + Bytes.toString((byte[])CellUtil.cloneFamily((Cell)kvB)) + "]"), (boolean)this.equals(familyB, CellUtil.cloneFamily((Cell)kvB)));
        Assert.assertTrue((String)("(B) Expected qualifier [" + Bytes.toString((byte[])qualifierB) + "] " + "Got qualifier [" + Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)kvB)) + "]"), (boolean)this.equals(qualifierB, CellUtil.cloneQualifier((Cell)kvB)));
        Assert.assertTrue((String)("(B) Expected value [" + Bytes.toString((byte[])valueB) + "] " + "Got value [" + Bytes.toString((byte[])CellUtil.cloneValue((Cell)kvB)) + "]"), (boolean)this.equals(valueB, CellUtil.cloneValue((Cell)kvB)));
    }

    private void assertSingleResult(Result result, byte[] row, byte[] family, byte[] qualifier, byte[] value) throws Exception {
        Assert.assertTrue((String)("Expected row [" + Bytes.toString((byte[])row) + "] " + "Got row [" + Bytes.toString((byte[])result.getRow()) + "]"), (boolean)this.equals(row, result.getRow()));
        Assert.assertTrue((String)("Expected a single key but result contains " + result.size()), (result.size() == 1 ? 1 : 0) != 0);
        Cell kv = result.rawCells()[0];
        Assert.assertTrue((String)("Expected family [" + Bytes.toString((byte[])family) + "] " + "Got family [" + Bytes.toString((byte[])CellUtil.cloneFamily((Cell)kv)) + "]"), (boolean)this.equals(family, CellUtil.cloneFamily((Cell)kv)));
        Assert.assertTrue((String)("Expected qualifier [" + Bytes.toString((byte[])qualifier) + "] " + "Got qualifier [" + Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)kv)) + "]"), (boolean)this.equals(qualifier, CellUtil.cloneQualifier((Cell)kv)));
        Assert.assertTrue((String)("Expected value [" + Bytes.toString((byte[])value) + "] " + "Got value [" + Bytes.toString((byte[])CellUtil.cloneValue((Cell)kv)) + "]"), (boolean)this.equals(value, CellUtil.cloneValue((Cell)kv)));
    }

    private void assertSingleResult(Result result, byte[] row, byte[] family, byte[] qualifier, long ts, byte[] value) throws Exception {
        Assert.assertTrue((String)("Expected row [" + Bytes.toString((byte[])row) + "] " + "Got row [" + Bytes.toString((byte[])result.getRow()) + "]"), (boolean)this.equals(row, result.getRow()));
        Assert.assertTrue((String)("Expected a single key but result contains " + result.size()), (result.size() == 1 ? 1 : 0) != 0);
        Cell kv = result.rawCells()[0];
        Assert.assertTrue((String)("Expected family [" + Bytes.toString((byte[])family) + "] " + "Got family [" + Bytes.toString((byte[])CellUtil.cloneFamily((Cell)kv)) + "]"), (boolean)this.equals(family, CellUtil.cloneFamily((Cell)kv)));
        Assert.assertTrue((String)("Expected qualifier [" + Bytes.toString((byte[])qualifier) + "] " + "Got qualifier [" + Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)kv)) + "]"), (boolean)this.equals(qualifier, CellUtil.cloneQualifier((Cell)kv)));
        Assert.assertTrue((String)("Expected ts [" + ts + "] " + "Got ts [" + kv.getTimestamp() + "]"), (ts == kv.getTimestamp() ? 1 : 0) != 0);
        Assert.assertTrue((String)("Expected value [" + Bytes.toString((byte[])value) + "] " + "Got value [" + Bytes.toString((byte[])CellUtil.cloneValue((Cell)kv)) + "]"), (boolean)this.equals(value, CellUtil.cloneValue((Cell)kv)));
    }

    private void assertEmptyResult(Result result) throws Exception {
        Assert.assertTrue((String)("expected an empty result but result contains " + result.size() + " keys"), (boolean)result.isEmpty());
    }

    private void assertNullResult(Result result) throws Exception {
        Assert.assertTrue((String)"expected null result but received a non-null result", (result == null ? 1 : 0) != 0);
    }

    private Result getSingleScanResult(HTable ht, Scan scan) throws IOException {
        ResultScanner scanner = ht.getScanner(scan);
        Result result = scanner.next();
        scanner.close();
        return result;
    }

    private byte[][] makeNAscii(byte[] base, int n) {
        if (n > 256) {
            return this.makeNBig(base, n);
        }
        byte[][] ret = new byte[n][];
        for (int i = 0; i < n; ++i) {
            byte[] tail = Bytes.toBytes((String)Integer.toString(i));
            ret[i] = Bytes.add((byte[])base, (byte[])tail);
        }
        return ret;
    }

    private byte[][] makeN(byte[] base, int n) {
        if (n > 256) {
            return this.makeNBig(base, n);
        }
        byte[][] ret = new byte[n][];
        for (int i = 0; i < n; ++i) {
            ret[i] = Bytes.add((byte[])base, (byte[])new byte[]{(byte)i});
        }
        return ret;
    }

    private byte[][] makeNBig(byte[] base, int n) {
        byte[][] ret = new byte[n][];
        for (int i = 0; i < n; ++i) {
            int byteA = i % 256;
            int byteB = i >> 8;
            ret[i] = Bytes.add((byte[])base, (byte[])new byte[]{(byte)byteB, (byte)byteA});
        }
        return ret;
    }

    private long[] makeStamps(int n) {
        long[] stamps = new long[n];
        for (int i = 0; i < n; ++i) {
            stamps[i] = i + 1;
        }
        return stamps;
    }

    private boolean equals(byte[] left, byte[] right) {
        if (left == null && right == null) {
            return true;
        }
        if (left == null && right.length == 0) {
            return true;
        }
        if (right == null && left.length == 0) {
            return true;
        }
        return Bytes.equals((byte[])left, (byte[])right);
    }

    @Test
    public void testDuplicateVersions() throws Exception {
        byte[] TABLE = Bytes.toBytes((String)"testDuplicateVersions");
        long[] STAMPS = this.makeStamps(20);
        byte[][] VALUES = this.makeNAscii(VALUE, 20);
        HTable ht = TEST_UTIL.createTable(TABLE, FAMILY, 10);
        Put put = new Put(ROW);
        put.add(FAMILY, QUALIFIER, STAMPS[1], VALUES[1]);
        put.add(FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
        put.add(FAMILY, QUALIFIER, STAMPS[4], VALUES[4]);
        put.add(FAMILY, QUALIFIER, STAMPS[5], VALUES[5]);
        ht.put(put);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[1], VALUES[1]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[4], VALUES[4]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[5], VALUES[5]);
        this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[1], VALUES[1]);
        this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
        this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[4], VALUES[4]);
        this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[5], VALUES[5]);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[0]);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[3]);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[6]);
        this.scanVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[0]);
        this.scanVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[3]);
        this.scanVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[6]);
        Get get = new Get(ROW);
        get.addColumn(FAMILY, QUALIFIER);
        get.setMaxVersions(2);
        Result result = ht.get(get);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[4], STAMPS[5]}, new byte[][]{VALUES[4], VALUES[5]}, 0, 1);
        Scan scan = new Scan(ROW);
        scan.addColumn(FAMILY, QUALIFIER);
        scan.setMaxVersions(2);
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[4], STAMPS[5]}, new byte[][]{VALUES[4], VALUES[5]}, 0, 1);
        TEST_UTIL.flush();
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[1], VALUES[1]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[4], VALUES[4]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[5], VALUES[5]);
        this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[1], VALUES[1]);
        this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
        this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[4], VALUES[4]);
        this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[5], VALUES[5]);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[0]);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[3]);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[6]);
        this.scanVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[0]);
        this.scanVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[3]);
        this.scanVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[6]);
        get = new Get(ROW);
        get.addColumn(FAMILY, QUALIFIER);
        get.setMaxVersions(2);
        result = ht.get(get);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[4], STAMPS[5]}, new byte[][]{VALUES[4], VALUES[5]}, 0, 1);
        scan = new Scan(ROW);
        scan.addColumn(FAMILY, QUALIFIER);
        scan.setMaxVersions(2);
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[4], STAMPS[5]}, new byte[][]{VALUES[4], VALUES[5]}, 0, 1);
        put = new Put(ROW);
        put.add(FAMILY, QUALIFIER, STAMPS[3], VALUES[3]);
        put.add(FAMILY, QUALIFIER, STAMPS[4], VALUES[14]);
        put.add(FAMILY, QUALIFIER, STAMPS[6], VALUES[6]);
        put.add(FAMILY, QUALIFIER, STAMPS[7], VALUES[7]);
        put.add(FAMILY, QUALIFIER, STAMPS[8], VALUES[8]);
        ht.put(put);
        get = new Get(ROW);
        get.addColumn(FAMILY, QUALIFIER);
        get.setMaxVersions(7);
        result = ht.get(get);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[2], STAMPS[3], STAMPS[4], STAMPS[5], STAMPS[6], STAMPS[7], STAMPS[8]}, new byte[][]{VALUES[2], VALUES[3], VALUES[14], VALUES[5], VALUES[6], VALUES[7], VALUES[8]}, 0, 6);
        scan = new Scan(ROW);
        scan.addColumn(FAMILY, QUALIFIER);
        scan.setMaxVersions(7);
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[2], STAMPS[3], STAMPS[4], STAMPS[5], STAMPS[6], STAMPS[7], STAMPS[8]}, new byte[][]{VALUES[2], VALUES[3], VALUES[14], VALUES[5], VALUES[6], VALUES[7], VALUES[8]}, 0, 6);
        get = new Get(ROW);
        get.setMaxVersions(7);
        result = ht.get(get);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[2], STAMPS[3], STAMPS[4], STAMPS[5], STAMPS[6], STAMPS[7], STAMPS[8]}, new byte[][]{VALUES[2], VALUES[3], VALUES[14], VALUES[5], VALUES[6], VALUES[7], VALUES[8]}, 0, 6);
        scan = new Scan(ROW);
        scan.setMaxVersions(7);
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[2], STAMPS[3], STAMPS[4], STAMPS[5], STAMPS[6], STAMPS[7], STAMPS[8]}, new byte[][]{VALUES[2], VALUES[3], VALUES[14], VALUES[5], VALUES[6], VALUES[7], VALUES[8]}, 0, 6);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[1], VALUES[1]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[4], VALUES[14]);
        this.getVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[7], VALUES[7]);
        this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[1], VALUES[1]);
        this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[2], VALUES[2]);
        this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[4], VALUES[14]);
        this.scanVersionAndVerify(ht, ROW, FAMILY, QUALIFIER, STAMPS[7], VALUES[7]);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[0]);
        this.getVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[9]);
        this.scanVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[0]);
        this.scanVersionAndVerifyMissing(ht, ROW, FAMILY, QUALIFIER, STAMPS[9]);
        TEST_UTIL.flush();
        put = new Put(ROW);
        put.add(FAMILY, QUALIFIER, STAMPS[9], VALUES[9]);
        put.add(FAMILY, QUALIFIER, STAMPS[11], VALUES[11]);
        put.add(FAMILY, QUALIFIER, STAMPS[13], VALUES[13]);
        put.add(FAMILY, QUALIFIER, STAMPS[15], VALUES[15]);
        ht.put(put);
        get = new Get(ROW);
        get.addColumn(FAMILY, QUALIFIER);
        get.setMaxVersions(Integer.MAX_VALUE);
        result = ht.get(get);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[3], STAMPS[4], STAMPS[5], STAMPS[6], STAMPS[7], STAMPS[8], STAMPS[9], STAMPS[11], STAMPS[13], STAMPS[15]}, new byte[][]{VALUES[3], VALUES[14], VALUES[5], VALUES[6], VALUES[7], VALUES[8], VALUES[9], VALUES[11], VALUES[13], VALUES[15]}, 0, 9);
        scan = new Scan(ROW);
        scan.addColumn(FAMILY, QUALIFIER);
        scan.setMaxVersions(Integer.MAX_VALUE);
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[3], STAMPS[4], STAMPS[5], STAMPS[6], STAMPS[7], STAMPS[8], STAMPS[9], STAMPS[11], STAMPS[13], STAMPS[15]}, new byte[][]{VALUES[3], VALUES[14], VALUES[5], VALUES[6], VALUES[7], VALUES[8], VALUES[9], VALUES[11], VALUES[13], VALUES[15]}, 0, 9);
        Delete delete = new Delete(ROW);
        delete.deleteColumn(FAMILY, QUALIFIER, STAMPS[11]);
        delete.deleteColumn(FAMILY, QUALIFIER, STAMPS[7]);
        ht.delete(delete);
        get = new Get(ROW);
        get.addColumn(FAMILY, QUALIFIER);
        get.setMaxVersions(Integer.MAX_VALUE);
        result = ht.get(get);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[1], STAMPS[2], STAMPS[3], STAMPS[4], STAMPS[5], STAMPS[6], STAMPS[8], STAMPS[9], STAMPS[13], STAMPS[15]}, new byte[][]{VALUES[1], VALUES[2], VALUES[3], VALUES[14], VALUES[5], VALUES[6], VALUES[8], VALUES[9], VALUES[13], VALUES[15]}, 0, 9);
        scan = new Scan(ROW);
        scan.addColumn(FAMILY, QUALIFIER);
        scan.setMaxVersions(Integer.MAX_VALUE);
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{STAMPS[1], STAMPS[2], STAMPS[3], STAMPS[4], STAMPS[5], STAMPS[6], STAMPS[8], STAMPS[9], STAMPS[13], STAMPS[15]}, new byte[][]{VALUES[1], VALUES[2], VALUES[3], VALUES[14], VALUES[5], VALUES[6], VALUES[8], VALUES[9], VALUES[13], VALUES[15]}, 0, 9);
    }

    @Test
    public void testUpdates() throws Exception {
        byte[] TABLE = Bytes.toBytes((String)"testUpdates");
        HTable hTable = TEST_UTIL.createTable(TABLE, FAMILY, 10);
        byte[] row = Bytes.toBytes((String)"row1");
        byte[] qualifier = Bytes.toBytes((String)"myCol");
        Put put = new Put(row);
        put.add(FAMILY, qualifier, 1L, Bytes.toBytes((String)"AAA"));
        hTable.put(put);
        put = new Put(row);
        put.add(FAMILY, qualifier, 2L, Bytes.toBytes((String)"BBB"));
        hTable.put(put);
        put = new Put(row);
        put.add(FAMILY, qualifier, 3L, Bytes.toBytes((String)"EEE"));
        hTable.put(put);
        Get get = new Get(row);
        get.addColumn(FAMILY, qualifier);
        get.setMaxVersions();
        Result result = hTable.get(get);
        NavigableMap navigableMap = (NavigableMap)((NavigableMap)result.getMap().get(FAMILY)).get(qualifier);
        Assert.assertEquals((Object)"AAA", (Object)Bytes.toString((byte[])((byte[])navigableMap.get(1L))));
        Assert.assertEquals((Object)"BBB", (Object)Bytes.toString((byte[])((byte[])navigableMap.get(2L))));
        put = new Put(row);
        put.add(FAMILY, qualifier, 1L, Bytes.toBytes((String)"CCC"));
        hTable.put(put);
        put = new Put(row);
        put.add(FAMILY, qualifier, 2L, Bytes.toBytes((String)"DDD"));
        hTable.put(put);
        result = hTable.get(get);
        navigableMap = (NavigableMap)((NavigableMap)result.getMap().get(FAMILY)).get(qualifier);
        Assert.assertEquals((Object)"CCC", (Object)Bytes.toString((byte[])((byte[])navigableMap.get(1L))));
        Assert.assertEquals((Object)"DDD", (Object)Bytes.toString((byte[])((byte[])navigableMap.get(2L))));
    }

    @Test
    public void testUpdatesWithMajorCompaction() throws Exception {
        String tableName = "testUpdatesWithMajorCompaction";
        byte[] TABLE = Bytes.toBytes((String)tableName);
        HTable hTable = TEST_UTIL.createTable(TABLE, FAMILY, 10);
        HBaseAdmin admin = new HBaseAdmin(TEST_UTIL.getConfiguration());
        byte[] row = Bytes.toBytes((String)"row2");
        byte[] qualifier = Bytes.toBytes((String)"myCol");
        Put put = new Put(row);
        put.add(FAMILY, qualifier, 1L, Bytes.toBytes((String)"AAA"));
        hTable.put(put);
        put = new Put(row);
        put.add(FAMILY, qualifier, 2L, Bytes.toBytes((String)"BBB"));
        hTable.put(put);
        put = new Put(row);
        put.add(FAMILY, qualifier, 3L, Bytes.toBytes((String)"EEE"));
        hTable.put(put);
        Get get = new Get(row);
        get.addColumn(FAMILY, qualifier);
        get.setMaxVersions();
        Result result = hTable.get(get);
        NavigableMap navigableMap = (NavigableMap)((NavigableMap)result.getMap().get(FAMILY)).get(qualifier);
        Assert.assertEquals((Object)"AAA", (Object)Bytes.toString((byte[])((byte[])navigableMap.get(1L))));
        Assert.assertEquals((Object)"BBB", (Object)Bytes.toString((byte[])((byte[])navigableMap.get(2L))));
        admin.flush(tableName);
        admin.majorCompact(tableName);
        Thread.sleep(6000L);
        put = new Put(row);
        put.add(FAMILY, qualifier, 1L, Bytes.toBytes((String)"CCC"));
        hTable.put(put);
        put = new Put(row);
        put.add(FAMILY, qualifier, 2L, Bytes.toBytes((String)"DDD"));
        hTable.put(put);
        admin.flush(tableName);
        admin.majorCompact(tableName);
        Thread.sleep(6000L);
        result = hTable.get(get);
        navigableMap = (NavigableMap)((NavigableMap)result.getMap().get(FAMILY)).get(qualifier);
        Assert.assertEquals((Object)"CCC", (Object)Bytes.toString((byte[])((byte[])navigableMap.get(1L))));
        Assert.assertEquals((Object)"DDD", (Object)Bytes.toString((byte[])((byte[])navigableMap.get(2L))));
    }

    @Test
    public void testMajorCompactionBetweenTwoUpdates() throws Exception {
        String tableName = "testMajorCompactionBetweenTwoUpdates";
        byte[] TABLE = Bytes.toBytes((String)tableName);
        HTable hTable = TEST_UTIL.createTable(TABLE, FAMILY, 10);
        HBaseAdmin admin = new HBaseAdmin(TEST_UTIL.getConfiguration());
        byte[] row = Bytes.toBytes((String)"row3");
        byte[] qualifier = Bytes.toBytes((String)"myCol");
        Put put = new Put(row);
        put.add(FAMILY, qualifier, 1L, Bytes.toBytes((String)"AAA"));
        hTable.put(put);
        put = new Put(row);
        put.add(FAMILY, qualifier, 2L, Bytes.toBytes((String)"BBB"));
        hTable.put(put);
        put = new Put(row);
        put.add(FAMILY, qualifier, 3L, Bytes.toBytes((String)"EEE"));
        hTable.put(put);
        Get get = new Get(row);
        get.addColumn(FAMILY, qualifier);
        get.setMaxVersions();
        Result result = hTable.get(get);
        NavigableMap navigableMap = (NavigableMap)((NavigableMap)result.getMap().get(FAMILY)).get(qualifier);
        Assert.assertEquals((Object)"AAA", (Object)Bytes.toString((byte[])((byte[])navigableMap.get(1L))));
        Assert.assertEquals((Object)"BBB", (Object)Bytes.toString((byte[])((byte[])navigableMap.get(2L))));
        admin.flush(tableName);
        admin.majorCompact(tableName);
        Thread.sleep(6000L);
        put = new Put(row);
        put.add(FAMILY, qualifier, 1L, Bytes.toBytes((String)"CCC"));
        hTable.put(put);
        admin.flush(tableName);
        admin.majorCompact(tableName);
        Thread.sleep(6000L);
        put = new Put(row);
        put.add(FAMILY, qualifier, 2L, Bytes.toBytes((String)"DDD"));
        hTable.put(put);
        admin.flush(tableName);
        admin.majorCompact(tableName);
        Thread.sleep(6000L);
        result = hTable.get(get);
        navigableMap = (NavigableMap)((NavigableMap)result.getMap().get(FAMILY)).get(qualifier);
        Assert.assertEquals((Object)"CCC", (Object)Bytes.toString((byte[])((byte[])navigableMap.get(1L))));
        Assert.assertEquals((Object)"DDD", (Object)Bytes.toString((byte[])((byte[])navigableMap.get(2L))));
    }

    @Test
    public void testGet_EmptyTable() throws IOException {
        HTable table = TEST_UTIL.createTable(Bytes.toBytes((String)"testGet_EmptyTable"), FAMILY);
        Get get = new Get(ROW);
        get.addFamily(FAMILY);
        Result r = table.get(get);
        Assert.assertTrue((boolean)r.isEmpty());
    }

    @Test
    public void testGet_NullQualifier() throws IOException {
        HTable table = TEST_UTIL.createTable(Bytes.toBytes((String)"testGet_NullQualifier"), FAMILY);
        Put put = new Put(ROW);
        put.add(FAMILY, QUALIFIER, VALUE);
        table.put(put);
        put = new Put(ROW);
        put.add(FAMILY, null, VALUE);
        table.put(put);
        this.LOG.info((Object)"Row put");
        Get get = new Get(ROW);
        get.addColumn(FAMILY, null);
        Result r = table.get(get);
        Assert.assertEquals((long)1L, (long)r.size());
        get = new Get(ROW);
        get.addFamily(FAMILY);
        r = table.get(get);
        Assert.assertEquals((long)2L, (long)r.size());
    }

    @Test
    public void testGet_NonExistentRow() throws IOException {
        HTable table = TEST_UTIL.createTable(Bytes.toBytes((String)"testGet_NonExistentRow"), FAMILY);
        Put put = new Put(ROW);
        put.add(FAMILY, QUALIFIER, VALUE);
        table.put(put);
        this.LOG.info((Object)"Row put");
        Get get = new Get(ROW);
        get.addFamily(FAMILY);
        Result r = table.get(get);
        Assert.assertFalse((boolean)r.isEmpty());
        System.out.println("Row retrieved successfully");
        byte[] missingrow = Bytes.toBytes((String)"missingrow");
        get = new Get(missingrow);
        get.addFamily(FAMILY);
        r = table.get(get);
        Assert.assertTrue((boolean)r.isEmpty());
        this.LOG.info((Object)"Row missing as it should be");
    }

    @Test
    public void testPut() throws IOException {
        byte[] CONTENTS_FAMILY = Bytes.toBytes((String)"contents");
        byte[] SMALL_FAMILY = Bytes.toBytes((String)"smallfam");
        byte[] row1 = Bytes.toBytes((String)"row1");
        byte[] row2 = Bytes.toBytes((String)"row2");
        byte[] value = Bytes.toBytes((String)"abcd");
        HTable table = TEST_UTIL.createTable(Bytes.toBytes((String)"testPut"), (byte[][])new byte[][]{CONTENTS_FAMILY, SMALL_FAMILY});
        Put put = new Put(row1);
        put.add(CONTENTS_FAMILY, null, value);
        table.put(put);
        put = new Put(row2);
        put.add(CONTENTS_FAMILY, null, value);
        Assert.assertEquals((long)put.size(), (long)1L);
        Assert.assertEquals((long)((List)put.getFamilyCellMap().get(CONTENTS_FAMILY)).size(), (long)1L);
        KeyValue kv = (KeyValue)((List)put.getFamilyCellMap().get(CONTENTS_FAMILY)).get(0);
        Assert.assertTrue((boolean)Bytes.equals((byte[])kv.getFamily(), (byte[])CONTENTS_FAMILY));
        Assert.assertTrue((boolean)Bytes.equals((byte[])kv.getQualifier(), (byte[])new byte[0]));
        Assert.assertTrue((boolean)Bytes.equals((byte[])kv.getValue(), (byte[])value));
        table.put(put);
        Scan scan = new Scan();
        scan.addColumn(CONTENTS_FAMILY, null);
        ResultScanner scanner = table.getScanner(scan);
        for (Result r : scanner) {
            for (Cell key : r.rawCells()) {
                System.out.println(Bytes.toString((byte[])r.getRow()) + ": " + key.toString());
            }
        }
    }

    @Test
    public void testPutNoCF() throws IOException {
        byte[] BAD_FAM = Bytes.toBytes((String)"BAD_CF");
        byte[] VAL = Bytes.toBytes((int)100);
        HTable table = TEST_UTIL.createTable(Bytes.toBytes((String)"testPutNoCF"), (byte[][])new byte[][]{FAMILY});
        boolean caughtNSCFE = false;
        try {
            Put p = new Put(ROW);
            p.add(BAD_FAM, QUALIFIER, VAL);
            table.put(p);
        }
        catch (RetriesExhaustedWithDetailsException e) {
            caughtNSCFE = e.getCause(0) instanceof NoSuchColumnFamilyException;
        }
        Assert.assertTrue((String)"Should throw NoSuchColumnFamilyException", (boolean)caughtNSCFE);
    }

    @Test
    public void testRowsPut() throws IOException {
        byte[] CONTENTS_FAMILY = Bytes.toBytes((String)"contents");
        byte[] SMALL_FAMILY = Bytes.toBytes((String)"smallfam");
        int NB_BATCH_ROWS = 10;
        byte[] value = Bytes.toBytes((String)"abcd");
        HTable table = TEST_UTIL.createTable(Bytes.toBytes((String)"testRowsPut"), (byte[][])new byte[][]{CONTENTS_FAMILY, SMALL_FAMILY});
        ArrayList<Put> rowsUpdate = new ArrayList<Put>();
        for (int i = 0; i < 10; ++i) {
            byte[] row = Bytes.toBytes((String)("row" + i));
            Put put = new Put(row);
            put.setDurability(Durability.SKIP_WAL);
            put.add(CONTENTS_FAMILY, null, value);
            rowsUpdate.add(put);
        }
        table.put(rowsUpdate);
        Scan scan = new Scan();
        scan.addFamily(CONTENTS_FAMILY);
        ResultScanner scanner = table.getScanner(scan);
        int nbRows = 0;
        for (Result row : scanner) {
            ++nbRows;
        }
        Assert.assertEquals((long)10L, (long)nbRows);
    }

    @Test
    public void testRowsPutBufferedOneFlush() throws IOException {
        byte[] CONTENTS_FAMILY = Bytes.toBytes((String)"contents");
        byte[] SMALL_FAMILY = Bytes.toBytes((String)"smallfam");
        byte[] value = Bytes.toBytes((String)"abcd");
        int NB_BATCH_ROWS = 10;
        HTable table = TEST_UTIL.createTable(Bytes.toBytes((String)"testRowsPutBufferedOneFlush"), (byte[][])new byte[][]{CONTENTS_FAMILY, SMALL_FAMILY});
        table.setAutoFlush(false, true);
        ArrayList<Put> rowsUpdate = new ArrayList<Put>();
        for (int i = 0; i < 100; ++i) {
            byte[] row = Bytes.toBytes((String)("row" + i));
            Put put = new Put(row);
            put.setDurability(Durability.SKIP_WAL);
            put.add(CONTENTS_FAMILY, null, value);
            rowsUpdate.add(put);
        }
        table.put(rowsUpdate);
        Scan scan = new Scan();
        scan.addFamily(CONTENTS_FAMILY);
        ResultScanner scanner = table.getScanner(scan);
        int nbRows = 0;
        for (Result row : scanner) {
            ++nbRows;
        }
        Assert.assertEquals((long)0L, (long)nbRows);
        scanner.close();
        table.flushCommits();
        scan = new Scan();
        scan.addFamily(CONTENTS_FAMILY);
        scanner = table.getScanner(scan);
        nbRows = 0;
        for (Result row : scanner) {
            ++nbRows;
        }
        Assert.assertEquals((long)100L, (long)nbRows);
    }

    @Test
    public void testRowsPutBufferedManyManyFlushes() throws IOException {
        byte[] CONTENTS_FAMILY = Bytes.toBytes((String)"contents");
        byte[] SMALL_FAMILY = Bytes.toBytes((String)"smallfam");
        byte[] value = Bytes.toBytes((String)"abcd");
        int NB_BATCH_ROWS = 10;
        HTable table = TEST_UTIL.createTable(Bytes.toBytes((String)"testRowsPutBufferedManyManyFlushes"), (byte[][])new byte[][]{CONTENTS_FAMILY, SMALL_FAMILY});
        table.setAutoFlush(false, true);
        table.setWriteBufferSize(10L);
        ArrayList<Put> rowsUpdate = new ArrayList<Put>();
        for (int i = 0; i < 100; ++i) {
            byte[] row = Bytes.toBytes((String)("row" + i));
            Put put = new Put(row);
            put.setDurability(Durability.SKIP_WAL);
            put.add(CONTENTS_FAMILY, null, value);
            rowsUpdate.add(put);
        }
        table.put(rowsUpdate);
        table.flushCommits();
        Scan scan = new Scan();
        scan.addFamily(CONTENTS_FAMILY);
        ResultScanner scanner = table.getScanner(scan);
        int nbRows = 0;
        for (Result row : scanner) {
            ++nbRows;
        }
        Assert.assertEquals((long)100L, (long)nbRows);
    }

    @Test
    public void testAddKeyValue() throws IOException {
        byte[] CONTENTS_FAMILY = Bytes.toBytes((String)"contents");
        byte[] value = Bytes.toBytes((String)"abcd");
        byte[] row1 = Bytes.toBytes((String)"row1");
        byte[] row2 = Bytes.toBytes((String)"row2");
        byte[] qualifier = Bytes.toBytes((String)"qf1");
        Put put = new Put(row1);
        KeyValue kv = new KeyValue(row1, CONTENTS_FAMILY, qualifier, value);
        boolean ok = true;
        try {
            put.add((Cell)kv);
        }
        catch (IOException e) {
            ok = false;
        }
        Assert.assertEquals((Object)true, (Object)ok);
        kv = new KeyValue(row2, CONTENTS_FAMILY, qualifier, value);
        ok = false;
        try {
            put.add((Cell)kv);
        }
        catch (IOException e) {
            ok = true;
        }
        Assert.assertEquals((Object)true, (Object)ok);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHBase737() throws IOException {
        int i;
        Result r;
        byte[] FAM1 = Bytes.toBytes((String)"fam1");
        byte[] FAM2 = Bytes.toBytes((String)"fam2");
        HTable table = TEST_UTIL.createTable(Bytes.toBytes((String)"testHBase737"), (byte[][])new byte[][]{FAM1, FAM2});
        Put put = new Put(ROW);
        put.add(FAM1, Bytes.toBytes((String)"letters"), Bytes.toBytes((String)"abcdefg"));
        table.put(put);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException i2) {
            // empty catch block
        }
        put = new Put(ROW);
        put.add(FAM1, Bytes.toBytes((String)"numbers"), Bytes.toBytes((String)"123456"));
        table.put(put);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException i3) {
            // empty catch block
        }
        put = new Put(ROW);
        put.add(FAM2, Bytes.toBytes((String)"letters"), Bytes.toBytes((String)"hijklmnop"));
        table.put(put);
        long[] times = new long[3];
        Scan scan = new Scan();
        scan.addFamily(FAM1);
        scan.addFamily(FAM2);
        ResultScanner s = table.getScanner(scan);
        try {
            int index = 0;
            r = null;
            while ((r = s.next()) != null) {
                for (Cell key : r.rawCells()) {
                    times[index++] = key.getTimestamp();
                }
            }
        }
        finally {
            s.close();
        }
        for (i = 0; i < times.length - 1; ++i) {
            for (int j = i + 1; j < times.length; ++j) {
                Assert.assertTrue((times[j] > times[i] ? 1 : 0) != 0);
            }
        }
        TEST_UTIL.flush();
        for (i = 0; i < times.length; ++i) {
            times[i] = 0L;
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException i4) {
            // empty catch block
        }
        scan = new Scan();
        scan.addFamily(FAM1);
        scan.addFamily(FAM2);
        s = table.getScanner(scan);
        try {
            int index = 0;
            r = null;
            while ((r = s.next()) != null) {
                for (Cell key : r.rawCells()) {
                    times[index++] = key.getTimestamp();
                }
            }
        }
        finally {
            s.close();
        }
        for (int i5 = 0; i5 < times.length - 1; ++i5) {
            for (int j = i5 + 1; j < times.length; ++j) {
                Assert.assertTrue((times[j] > times[i5] ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void testListTables() throws IOException, InterruptedException {
        byte[] t1 = Bytes.toBytes((String)"testListTables1");
        byte[] t2 = Bytes.toBytes((String)"testListTables2");
        byte[] t3 = Bytes.toBytes((String)"testListTables3");
        byte[][] tables = new byte[][]{t1, t2, t3};
        for (int i = 0; i < tables.length; ++i) {
            TEST_UTIL.createTable(tables[i], FAMILY);
        }
        HBaseAdmin admin = new HBaseAdmin(TEST_UTIL.getConfiguration());
        HTableDescriptor[] ts = admin.listTables();
        HashSet result = new HashSet(ts.length);
        Collections.addAll(result, ts);
        int size = result.size();
        Assert.assertTrue((size >= tables.length ? 1 : 0) != 0);
        for (int i = 0; i < tables.length && i < size; ++i) {
            boolean found = false;
            for (int j = 0; j < ts.length; ++j) {
                if (!Bytes.equals((byte[])ts[j].getTableName().getName(), (byte[])tables[i])) continue;
                found = true;
                break;
            }
            Assert.assertTrue((String)("Not found: " + Bytes.toString((byte[])tables[i])), (boolean)found);
        }
    }

    HTable createUnmangedHConnectionHTable(byte[] tableName) throws IOException {
        TEST_UTIL.createTable(tableName, HConstants.CATALOG_FAMILY);
        HConnection conn = HConnectionManager.createConnection((Configuration)TEST_UTIL.getConfiguration());
        return (HTable)conn.getTable(tableName);
    }

    @Test
    public void testUnmanagedHConnection() throws IOException {
        byte[] tableName = Bytes.toBytes((String)"testUnmanagedHConnection");
        HTable t = this.createUnmangedHConnectionHTable(tableName);
        HBaseAdmin ha = new HBaseAdmin(t.getConnection());
        Assert.assertTrue((boolean)ha.tableExists(tableName));
        Assert.assertTrue((boolean)t.get(new Get(ROW)).isEmpty());
    }

    @Test
    public void testUnmanagedHConnectionReconnect() throws Exception {
        byte[] tableName = Bytes.toBytes((String)"testUnmanagedHConnectionReconnect");
        HTable t = this.createUnmangedHConnectionHTable(tableName);
        HConnection conn = t.getConnection();
        HBaseAdmin ha = new HBaseAdmin(conn);
        Assert.assertTrue((boolean)ha.tableExists(tableName));
        Assert.assertTrue((boolean)t.get(new Get(ROW)).isEmpty());
        MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
        cluster.stopMaster(0, false);
        cluster.waitOnMaster(0);
        cluster.startMaster();
        Assert.assertTrue((boolean)cluster.waitForActiveAndReadyMaster());
        HBaseAdmin newAdmin = new HBaseAdmin(conn);
        Assert.assertTrue((boolean)newAdmin.tableExists(tableName));
        assert (newAdmin.getClusterStatus().getServersSize() == SLAVES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMiscHTableStuff() throws IOException {
        byte[] tableAname = Bytes.toBytes((String)"testMiscHTableStuffA");
        byte[] tableBname = Bytes.toBytes((String)"testMiscHTableStuffB");
        byte[] attrName = Bytes.toBytes((String)"TESTATTR");
        byte[] attrValue = Bytes.toBytes((String)"somevalue");
        byte[] value = Bytes.toBytes((String)"value");
        HTable a = TEST_UTIL.createTable(tableAname, HConstants.CATALOG_FAMILY);
        HTable b = TEST_UTIL.createTable(tableBname, HConstants.CATALOG_FAMILY);
        Put put = new Put(ROW);
        put.add(HConstants.CATALOG_FAMILY, null, value);
        a.put(put);
        HTable newA = new HTable(TEST_UTIL.getConfiguration(), tableAname);
        Scan scan = new Scan();
        scan.addFamily(HConstants.CATALOG_FAMILY);
        ResultScanner s = newA.getScanner(scan);
        try {
            for (Result r : s) {
                put = new Put(r.getRow());
                put.setDurability(Durability.SKIP_WAL);
                for (Cell kv : r.rawCells()) {
                    put.add(kv);
                }
                b.put(put);
            }
        }
        finally {
            s.close();
        }
        HTable anotherA = new HTable(TEST_UTIL.getConfiguration(), tableAname);
        Get get = new Get(ROW);
        get.addFamily(HConstants.CATALOG_FAMILY);
        anotherA.get(get);
        HBaseAdmin admin = new HBaseAdmin(TEST_UTIL.getConfiguration());
        HTableDescriptor desc = new HTableDescriptor(a.getTableDescriptor());
        admin.disableTable(tableAname);
        desc.setValue(attrName, attrValue);
        for (HColumnDescriptor c : desc.getFamilies()) {
            c.setValue(attrName, attrValue);
        }
        admin.modifyTable(tableAname, desc);
        admin.enableTable(tableAname);
        desc = a.getTableDescriptor();
        Assert.assertTrue((String)"wrong table descriptor returned", (Bytes.compareTo((byte[])desc.getTableName().getName(), (byte[])tableAname) == 0 ? 1 : 0) != 0);
        value = desc.getValue(attrName);
        Assert.assertFalse((String)"missing HTD attribute value", (value == null ? 1 : 0) != 0);
        Assert.assertFalse((String)"HTD attribute value is incorrect", (Bytes.compareTo((byte[])value, (byte[])attrValue) != 0 ? 1 : 0) != 0);
        for (HColumnDescriptor c : desc.getFamilies()) {
            value = c.getValue(attrName);
            Assert.assertFalse((String)"missing HCD attribute value", (value == null ? 1 : 0) != 0);
            Assert.assertFalse((String)"HCD attribute value is incorrect", (Bytes.compareTo((byte[])value, (byte[])attrValue) != 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testGetClosestRowBefore() throws IOException, InterruptedException {
        byte[] tableAname = Bytes.toBytes((String)"testGetClosestRowBefore");
        byte[] firstRow = Bytes.toBytes((String)"row111");
        byte[] secondRow = Bytes.toBytes((String)"row222");
        byte[] thirdRow = Bytes.toBytes((String)"row333");
        byte[] forthRow = Bytes.toBytes((String)"row444");
        byte[] beforeFirstRow = Bytes.toBytes((String)"row");
        byte[] beforeSecondRow = Bytes.toBytes((String)"row22");
        byte[] beforeThirdRow = Bytes.toBytes((String)"row33");
        byte[] beforeForthRow = Bytes.toBytes((String)"row44");
        HTable table = TEST_UTIL.createTable(tableAname, (byte[][])new byte[][]{HConstants.CATALOG_FAMILY, Bytes.toBytes((String)"info2")}, 1, 1024);
        table.setAutoFlush(true);
        String regionName = ((HRegionInfo)table.getRegionLocations().firstKey()).getEncodedName();
        HRegion region = TEST_UTIL.getRSForFirstRegionInTable(tableAname).getFromOnlineRegions(regionName);
        Put put1 = new Put(firstRow);
        Put put2 = new Put(secondRow);
        Put put3 = new Put(thirdRow);
        Put put4 = new Put(forthRow);
        byte[] one = new byte[]{1};
        byte[] two = new byte[]{2};
        byte[] three = new byte[]{3};
        byte[] four = new byte[]{4};
        put1.add(HConstants.CATALOG_FAMILY, null, one);
        put2.add(HConstants.CATALOG_FAMILY, null, two);
        put3.add(HConstants.CATALOG_FAMILY, null, three);
        put4.add(HConstants.CATALOG_FAMILY, null, four);
        table.put(put1);
        table.put(put2);
        table.put(put3);
        table.put(put4);
        region.flushcache();
        Result result = null;
        result = table.getRowOrBefore(beforeFirstRow, HConstants.CATALOG_FAMILY);
        Assert.assertTrue((result == null ? 1 : 0) != 0);
        result = table.getRowOrBefore(firstRow, HConstants.CATALOG_FAMILY);
        Assert.assertTrue((boolean)result.containsColumn(HConstants.CATALOG_FAMILY, null));
        Assert.assertTrue((boolean)Bytes.equals((byte[])result.getRow(), (byte[])firstRow));
        Assert.assertTrue((boolean)Bytes.equals((byte[])result.getValue(HConstants.CATALOG_FAMILY, null), (byte[])one));
        result = table.getRowOrBefore(beforeSecondRow, HConstants.CATALOG_FAMILY);
        Assert.assertTrue((boolean)result.containsColumn(HConstants.CATALOG_FAMILY, null));
        Assert.assertTrue((boolean)Bytes.equals((byte[])result.getRow(), (byte[])firstRow));
        Assert.assertTrue((boolean)Bytes.equals((byte[])result.getValue(HConstants.CATALOG_FAMILY, null), (byte[])one));
        result = table.getRowOrBefore(secondRow, HConstants.CATALOG_FAMILY);
        Assert.assertTrue((boolean)result.containsColumn(HConstants.CATALOG_FAMILY, null));
        Assert.assertTrue((boolean)Bytes.equals((byte[])result.getRow(), (byte[])secondRow));
        Assert.assertTrue((boolean)Bytes.equals((byte[])result.getValue(HConstants.CATALOG_FAMILY, null), (byte[])two));
        result = table.getRowOrBefore(beforeThirdRow, HConstants.CATALOG_FAMILY);
        Assert.assertTrue((boolean)result.containsColumn(HConstants.CATALOG_FAMILY, null));
        Assert.assertTrue((boolean)Bytes.equals((byte[])result.getRow(), (byte[])secondRow));
        Assert.assertTrue((boolean)Bytes.equals((byte[])result.getValue(HConstants.CATALOG_FAMILY, null), (byte[])two));
        result = table.getRowOrBefore(thirdRow, HConstants.CATALOG_FAMILY);
        Assert.assertTrue((boolean)result.containsColumn(HConstants.CATALOG_FAMILY, null));
        Assert.assertTrue((boolean)Bytes.equals((byte[])result.getRow(), (byte[])thirdRow));
        Assert.assertTrue((boolean)Bytes.equals((byte[])result.getValue(HConstants.CATALOG_FAMILY, null), (byte[])three));
        result = table.getRowOrBefore(beforeForthRow, HConstants.CATALOG_FAMILY);
        Assert.assertTrue((boolean)result.containsColumn(HConstants.CATALOG_FAMILY, null));
        Assert.assertTrue((boolean)Bytes.equals((byte[])result.getRow(), (byte[])thirdRow));
        Assert.assertTrue((boolean)Bytes.equals((byte[])result.getValue(HConstants.CATALOG_FAMILY, null), (byte[])three));
        result = table.getRowOrBefore(forthRow, HConstants.CATALOG_FAMILY);
        Assert.assertTrue((boolean)result.containsColumn(HConstants.CATALOG_FAMILY, null));
        Assert.assertTrue((boolean)Bytes.equals((byte[])result.getRow(), (byte[])forthRow));
        Assert.assertTrue((boolean)Bytes.equals((byte[])result.getValue(HConstants.CATALOG_FAMILY, null), (byte[])four));
        result = table.getRowOrBefore(Bytes.add((byte[])forthRow, (byte[])one), HConstants.CATALOG_FAMILY);
        Assert.assertTrue((boolean)result.containsColumn(HConstants.CATALOG_FAMILY, null));
        Assert.assertTrue((boolean)Bytes.equals((byte[])result.getRow(), (byte[])forthRow));
        Assert.assertTrue((boolean)Bytes.equals((byte[])result.getValue(HConstants.CATALOG_FAMILY, null), (byte[])four));
    }

    @Test
    public void testScanVariableReuse() throws Exception {
        Scan scan = new Scan();
        scan.addFamily(FAMILY);
        scan.addColumn(FAMILY, ROW);
        Assert.assertTrue((((NavigableSet)scan.getFamilyMap().get(FAMILY)).size() == 1 ? 1 : 0) != 0);
        scan = new Scan();
        scan.addFamily(FAMILY);
        Assert.assertTrue((scan.getFamilyMap().get(FAMILY) == null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)scan.getFamilyMap().containsKey(FAMILY));
    }

    @Test
    public void testMultiRowMutation() throws Exception {
        this.LOG.info((Object)"Starting testMultiRowMutation");
        byte[] TABLENAME = Bytes.toBytes((String)"testMultiRowMutation");
        byte[] ROW1 = Bytes.toBytes((String)"testRow1");
        HTable t = TEST_UTIL.createTable(TABLENAME, FAMILY);
        Put p = new Put(ROW);
        p.add(FAMILY, QUALIFIER, VALUE);
        ClientProtos.MutationProto m1 = ProtobufUtil.toMutation((ClientProtos.MutationProto.MutationType)ClientProtos.MutationProto.MutationType.PUT, (Mutation)p);
        p = new Put(ROW1);
        p.add(FAMILY, QUALIFIER, VALUE);
        ClientProtos.MutationProto m2 = ProtobufUtil.toMutation((ClientProtos.MutationProto.MutationType)ClientProtos.MutationProto.MutationType.PUT, (Mutation)p);
        MultiRowMutationProtos.MutateRowsRequest.Builder mrmBuilder = MultiRowMutationProtos.MutateRowsRequest.newBuilder();
        mrmBuilder.addMutationRequest(m1);
        mrmBuilder.addMutationRequest(m2);
        MultiRowMutationProtos.MutateRowsRequest mrm = mrmBuilder.build();
        CoprocessorRpcChannel channel = t.coprocessorService(ROW);
        MultiRowMutationProtos.MultiRowMutationService.BlockingInterface service = MultiRowMutationProtos.MultiRowMutationService.newBlockingStub((BlockingRpcChannel)channel);
        service.mutateRows(null, mrm);
        Get g = new Get(ROW);
        Result r = t.get(g);
        Assert.assertEquals((long)0L, (long)Bytes.compareTo((byte[])VALUE, (byte[])r.getValue(FAMILY, QUALIFIER)));
        g = new Get(ROW1);
        r = t.get(g);
        Assert.assertEquals((long)0L, (long)Bytes.compareTo((byte[])VALUE, (byte[])r.getValue(FAMILY, QUALIFIER)));
    }

    @Test
    public void testRowMutation() throws Exception {
        this.LOG.info((Object)"Starting testRowMutation");
        byte[] TABLENAME = Bytes.toBytes((String)"testRowMutation");
        HTable t = TEST_UTIL.createTable(TABLENAME, FAMILY);
        byte[][] QUALIFIERS = new byte[][]{Bytes.toBytes((String)"a"), Bytes.toBytes((String)"b")};
        RowMutations arm = new RowMutations(ROW);
        Put p = new Put(ROW);
        p.add(FAMILY, QUALIFIERS[0], VALUE);
        arm.add(p);
        t.mutateRow(arm);
        Get g = new Get(ROW);
        Result r = t.get(g);
        Assert.assertEquals((long)0L, (long)Bytes.compareTo((byte[])VALUE, (byte[])r.getValue(FAMILY, QUALIFIERS[0])));
        arm = new RowMutations(ROW);
        p = new Put(ROW);
        p.add(FAMILY, QUALIFIERS[1], VALUE);
        arm.add(p);
        Delete d = new Delete(ROW);
        d.deleteColumns(FAMILY, QUALIFIERS[0]);
        arm.add(d);
        t.mutateRow(arm);
        r = t.get(g);
        Assert.assertEquals((long)0L, (long)Bytes.compareTo((byte[])VALUE, (byte[])r.getValue(FAMILY, QUALIFIERS[1])));
        Assert.assertNull((Object)r.getValue(FAMILY, QUALIFIERS[0]));
        try {
            arm = new RowMutations(ROW);
            p = new Put(ROW);
            p.add(new byte[]{98, 111, 103, 117, 115}, QUALIFIERS[0], VALUE);
            arm.add(p);
            t.mutateRow(arm);
            Assert.fail((String)"Expected NoSuchColumnFamilyException");
        }
        catch (NoSuchColumnFamilyException e) {
            // empty catch block
        }
    }

    @Test
    public void testAppend() throws Exception {
        this.LOG.info((Object)"Starting testAppend");
        byte[] TABLENAME = Bytes.toBytes((String)"testAppend");
        HTable t = TEST_UTIL.createTable(TABLENAME, FAMILY);
        byte[] v1 = Bytes.toBytes((String)"42");
        byte[] v2 = Bytes.toBytes((String)"23");
        byte[][] QUALIFIERS = new byte[][]{Bytes.toBytes((String)"b"), Bytes.toBytes((String)"a"), Bytes.toBytes((String)"c")};
        Append a = new Append(ROW);
        a.add(FAMILY, QUALIFIERS[0], v1);
        a.add(FAMILY, QUALIFIERS[1], v2);
        a.setReturnResults(false);
        this.assertNullResult(t.append(a));
        a = new Append(ROW);
        a.add(FAMILY, QUALIFIERS[0], v2);
        a.add(FAMILY, QUALIFIERS[1], v1);
        a.add(FAMILY, QUALIFIERS[2], v2);
        Result r = t.append(a);
        Assert.assertEquals((long)0L, (long)Bytes.compareTo((byte[])Bytes.add((byte[])v1, (byte[])v2), (byte[])r.getValue(FAMILY, QUALIFIERS[0])));
        Assert.assertEquals((long)0L, (long)Bytes.compareTo((byte[])Bytes.add((byte[])v2, (byte[])v1), (byte[])r.getValue(FAMILY, QUALIFIERS[1])));
        Assert.assertEquals((long)0L, (long)Bytes.compareTo((byte[])v2, (byte[])r.getValue(FAMILY, QUALIFIERS[2])));
        Assert.assertEquals((long)r.getColumnLatest(FAMILY, QUALIFIERS[0]).getTimestamp(), (long)r.getColumnLatest(FAMILY, QUALIFIERS[2]).getTimestamp());
    }

    @Test
    public void testIncrementWithDeletes() throws Exception {
        this.LOG.info((Object)"Starting testIncrementWithDeletes");
        TableName TABLENAME = TableName.valueOf((String)"testIncrementWithDeletes");
        HTable ht = TEST_UTIL.createTable(TABLENAME, FAMILY);
        byte[] COLUMN = Bytes.toBytes((String)"column");
        ht.incrementColumnValue(ROW, FAMILY, COLUMN, 5L);
        TEST_UTIL.flush(TABLENAME);
        Delete del = new Delete(ROW);
        ht.delete(del);
        ht.incrementColumnValue(ROW, FAMILY, COLUMN, 5L);
        Get get = new Get(ROW);
        Result r = ht.get(get);
        Assert.assertEquals((long)1L, (long)r.size());
        Assert.assertEquals((long)5L, (long)Bytes.toLong((byte[])r.getValue(FAMILY, COLUMN)));
    }

    @Test
    public void testIncrementingInvalidValue() throws Exception {
        this.LOG.info((Object)"Starting testIncrementingInvalidValue");
        byte[] TABLENAME = Bytes.toBytes((String)"testIncrementingInvalidValue");
        HTable ht = TEST_UTIL.createTable(TABLENAME, FAMILY);
        byte[] COLUMN = Bytes.toBytes((String)"column");
        Put p = new Put(ROW);
        p.add(FAMILY, COLUMN, Bytes.toBytes((int)5));
        ht.put(p);
        try {
            ht.incrementColumnValue(ROW, FAMILY, COLUMN, 5L);
            Assert.fail((String)"Should have thrown DoNotRetryIOException");
        }
        catch (DoNotRetryIOException iox) {
            // empty catch block
        }
        Increment inc = new Increment(ROW);
        inc.addColumn(FAMILY, COLUMN, 5L);
        try {
            ht.increment(inc);
            Assert.fail((String)"Should have thrown DoNotRetryIOException");
        }
        catch (DoNotRetryIOException iox) {
            // empty catch block
        }
    }

    @Test
    public void testIncrementInvalidArguments() throws Exception {
        this.LOG.info((Object)"Starting testIncrementInvalidArguments");
        byte[] TABLENAME = Bytes.toBytes((String)"testIncrementInvalidArguments");
        HTable ht = TEST_UTIL.createTable(TABLENAME, FAMILY);
        byte[] COLUMN = Bytes.toBytes((String)"column");
        try {
            ht.incrementColumnValue(null, FAMILY, COLUMN, 5L);
            Assert.fail((String)"Should have thrown IOException");
        }
        catch (IOException iox) {
            // empty catch block
        }
        try {
            ht.incrementColumnValue(ROW, null, COLUMN, 5L);
            Assert.fail((String)"Should have thrown IOException");
        }
        catch (IOException iox) {
            // empty catch block
        }
        try {
            ht.incrementColumnValue(ROW, FAMILY, null, 5L);
            Assert.fail((String)"Should have thrown IOException");
        }
        catch (IOException iox) {
            // empty catch block
        }
        try {
            Increment incNoRow = new Increment((byte[])null);
            incNoRow.addColumn(FAMILY, COLUMN, 5L);
            Assert.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException iax) {
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        try {
            Increment incNoFamily = new Increment(ROW);
            incNoFamily.addColumn(null, COLUMN, 5L);
            Assert.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException iax) {
            // empty catch block
        }
        try {
            Increment incNoQualifier = new Increment(ROW);
            incNoQualifier.addColumn(FAMILY, null, 5L);
            Assert.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException iax) {
            // empty catch block
        }
    }

    @Test
    public void testIncrementOutOfOrder() throws Exception {
        this.LOG.info((Object)"Starting testIncrementOutOfOrder");
        byte[] TABLENAME = Bytes.toBytes((String)"testIncrementOutOfOrder");
        HTable ht = TEST_UTIL.createTable(TABLENAME, FAMILY);
        byte[][] QUALIFIERS = new byte[][]{Bytes.toBytes((String)"B"), Bytes.toBytes((String)"A"), Bytes.toBytes((String)"C")};
        Increment inc = new Increment(ROW);
        for (int i = 0; i < QUALIFIERS.length; ++i) {
            inc.addColumn(FAMILY, QUALIFIERS[i], 1L);
        }
        ht.increment(inc);
        Result r = ht.get(new Get(ROW));
        Cell[] kvs = r.rawCells();
        Assert.assertEquals((long)3L, (long)kvs.length);
        this.assertIncrementKey(kvs[0], ROW, FAMILY, QUALIFIERS[1], 1L);
        this.assertIncrementKey(kvs[1], ROW, FAMILY, QUALIFIERS[0], 1L);
        this.assertIncrementKey(kvs[2], ROW, FAMILY, QUALIFIERS[2], 1L);
        inc = new Increment(ROW);
        for (int i = 0; i < QUALIFIERS.length; ++i) {
            inc.addColumn(FAMILY, QUALIFIERS[i], 1L);
        }
        ht.increment(inc);
        r = ht.get(new Get(ROW));
        kvs = r.rawCells();
        Assert.assertEquals((long)3L, (long)kvs.length);
        this.assertIncrementKey(kvs[0], ROW, FAMILY, QUALIFIERS[1], 2L);
        this.assertIncrementKey(kvs[1], ROW, FAMILY, QUALIFIERS[0], 2L);
        this.assertIncrementKey(kvs[2], ROW, FAMILY, QUALIFIERS[2], 2L);
    }

    @Test
    public void testIncrementOnSameColumn() throws Exception {
        this.LOG.info((Object)"Starting testIncrementOnSameColumn");
        byte[] TABLENAME = Bytes.toBytes((String)"testIncrementOnSameColumn");
        HTable ht = TEST_UTIL.createTable(TABLENAME, FAMILY);
        byte[][] QUALIFIERS = new byte[][]{Bytes.toBytes((String)"A"), Bytes.toBytes((String)"B"), Bytes.toBytes((String)"C")};
        Increment inc = new Increment(ROW);
        for (int i = 0; i < QUALIFIERS.length; ++i) {
            inc.addColumn(FAMILY, QUALIFIERS[i], 1L);
            inc.addColumn(FAMILY, QUALIFIERS[i], 1L);
        }
        ht.increment(inc);
        Result r = ht.get(new Get(ROW));
        Cell[] kvs = r.rawCells();
        Assert.assertEquals((long)3L, (long)kvs.length);
        this.assertIncrementKey(kvs[0], ROW, FAMILY, QUALIFIERS[0], 1L);
        this.assertIncrementKey(kvs[1], ROW, FAMILY, QUALIFIERS[1], 1L);
        this.assertIncrementKey(kvs[2], ROW, FAMILY, QUALIFIERS[2], 1L);
        inc = new Increment(ROW);
        for (int i = 0; i < QUALIFIERS.length; ++i) {
            inc.addColumn(FAMILY, QUALIFIERS[i], 1L);
            inc.addColumn(FAMILY, QUALIFIERS[i], 1L);
        }
        ht.increment(inc);
        r = ht.get(new Get(ROW));
        kvs = r.rawCells();
        Assert.assertEquals((long)3L, (long)kvs.length);
        this.assertIncrementKey(kvs[0], ROW, FAMILY, QUALIFIERS[0], 2L);
        this.assertIncrementKey(kvs[1], ROW, FAMILY, QUALIFIERS[1], 2L);
        this.assertIncrementKey(kvs[2], ROW, FAMILY, QUALIFIERS[2], 2L);
        ht.close();
    }

    @Test
    public void testIncrement() throws Exception {
        int i;
        this.LOG.info((Object)"Starting testIncrement");
        byte[] TABLENAME = Bytes.toBytes((String)"testIncrement");
        HTable ht = TEST_UTIL.createTable(TABLENAME, FAMILY);
        byte[][] ROWS = new byte[][]{Bytes.toBytes((String)"a"), Bytes.toBytes((String)"b"), Bytes.toBytes((String)"c"), Bytes.toBytes((String)"d"), Bytes.toBytes((String)"e"), Bytes.toBytes((String)"f"), Bytes.toBytes((String)"g"), Bytes.toBytes((String)"h"), Bytes.toBytes((String)"i")};
        byte[][] QUALIFIERS = new byte[][]{Bytes.toBytes((String)"a"), Bytes.toBytes((String)"b"), Bytes.toBytes((String)"c"), Bytes.toBytes((String)"d"), Bytes.toBytes((String)"e"), Bytes.toBytes((String)"f"), Bytes.toBytes((String)"g"), Bytes.toBytes((String)"h"), Bytes.toBytes((String)"i")};
        ht.incrementColumnValue(ROW, FAMILY, QUALIFIERS[0], 1L);
        ht.incrementColumnValue(ROW, FAMILY, QUALIFIERS[1], 2L);
        ht.incrementColumnValue(ROW, FAMILY, QUALIFIERS[2], 3L);
        ht.incrementColumnValue(ROW, FAMILY, QUALIFIERS[3], 4L);
        Increment inc = new Increment(ROW);
        inc.addColumn(FAMILY, QUALIFIERS[1], 1L);
        inc.addColumn(FAMILY, QUALIFIERS[3], 1L);
        inc.addColumn(FAMILY, QUALIFIERS[4], 1L);
        ht.increment(inc);
        Result r = ht.get(new Get(ROW));
        Cell[] kvs = r.rawCells();
        Assert.assertEquals((long)5L, (long)kvs.length);
        this.assertIncrementKey(kvs[0], ROW, FAMILY, QUALIFIERS[0], 1L);
        this.assertIncrementKey(kvs[1], ROW, FAMILY, QUALIFIERS[1], 3L);
        this.assertIncrementKey(kvs[2], ROW, FAMILY, QUALIFIERS[2], 3L);
        this.assertIncrementKey(kvs[3], ROW, FAMILY, QUALIFIERS[3], 5L);
        this.assertIncrementKey(kvs[4], ROW, FAMILY, QUALIFIERS[4], 1L);
        inc = new Increment(ROWS[0]);
        for (i = 0; i < QUALIFIERS.length; ++i) {
            inc.addColumn(FAMILY, QUALIFIERS[i], (long)(i + 1));
        }
        ht.increment(inc);
        r = ht.get(new Get(ROWS[0]));
        kvs = r.rawCells();
        Assert.assertEquals((long)QUALIFIERS.length, (long)kvs.length);
        for (i = 0; i < QUALIFIERS.length; ++i) {
            this.assertIncrementKey(kvs[i], ROWS[0], FAMILY, QUALIFIERS[i], i + 1);
        }
        inc = new Increment(ROWS[0]);
        for (i = 0; i < QUALIFIERS.length; ++i) {
            inc.addColumn(FAMILY, QUALIFIERS[i], (long)(i + 1));
        }
        ht.increment(inc);
        r = ht.get(new Get(ROWS[0]));
        kvs = r.rawCells();
        Assert.assertEquals((long)QUALIFIERS.length, (long)kvs.length);
        for (i = 0; i < QUALIFIERS.length; ++i) {
            this.assertIncrementKey(kvs[i], ROWS[0], FAMILY, QUALIFIERS[i], 2 * (i + 1));
        }
    }

    @Test
    public void testClientPoolRoundRobin() throws IOException {
        byte[] tableName = Bytes.toBytes((String)"testClientPoolRoundRobin");
        int poolSize = 3;
        int numVersions = poolSize * 2;
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.set("hbase.client.ipc.pool.type", "round-robin");
        conf.setInt("hbase.client.ipc.pool.size", poolSize);
        HTable table = TEST_UTIL.createTable(tableName, (byte[][])new byte[][]{FAMILY}, conf, Integer.MAX_VALUE);
        long ts = EnvironmentEdgeManager.currentTimeMillis();
        Get get = new Get(ROW);
        get.addColumn(FAMILY, QUALIFIER);
        get.setMaxVersions();
        for (int versions = 1; versions <= numVersions; ++versions) {
            Put put = new Put(ROW);
            put.add(FAMILY, QUALIFIER, ts + (long)versions, VALUE);
            table.put(put);
            Result result = table.get(get);
            NavigableMap navigableMap = (NavigableMap)((NavigableMap)result.getMap().get(FAMILY)).get(QUALIFIER);
            Assert.assertEquals((String)("The number of versions of '" + FAMILY + ":" + QUALIFIER + " did not match " + versions), (long)versions, (long)navigableMap.size());
            for (Map.Entry entry : navigableMap.entrySet()) {
                Assert.assertTrue((String)("The value at time " + entry.getKey() + " did not match what was put"), (boolean)Bytes.equals((byte[])VALUE, (byte[])((byte[])entry.getValue())));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ignore(value="Flakey: HBASE-8989")
    @Test
    public void testClientPoolThreadLocal() throws IOException {
        byte[] tableName = Bytes.toBytes((String)"testClientPoolThreadLocal");
        int poolSize = Integer.MAX_VALUE;
        int numVersions = 3;
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.set("hbase.client.ipc.pool.type", "thread-local");
        conf.setInt("hbase.client.ipc.pool.size", poolSize);
        final HTable table = TEST_UTIL.createTable(tableName, (byte[][])new byte[][]{FAMILY}, conf, 3);
        final long ts = EnvironmentEdgeManager.currentTimeMillis();
        final Get get = new Get(ROW);
        get.addColumn(FAMILY, QUALIFIER);
        get.setMaxVersions();
        for (int versions = 1; versions <= numVersions; ++versions) {
            Put put = new Put(ROW);
            put.add(FAMILY, QUALIFIER, ts + (long)versions, VALUE);
            table.put(put);
            Result result = table.get(get);
            NavigableMap navigableMap = (NavigableMap)((NavigableMap)result.getMap().get(FAMILY)).get(QUALIFIER);
            Assert.assertEquals((String)("The number of versions of '" + FAMILY + ":" + QUALIFIER + " did not match " + versions + "; " + put.toString() + ", " + get.toString()), (long)versions, (long)navigableMap.size());
            for (Map.Entry entry : navigableMap.entrySet()) {
                Assert.assertTrue((String)("The value at time " + entry.getKey() + " did not match what was put"), (boolean)Bytes.equals((byte[])VALUE, (byte[])((byte[])entry.getValue())));
            }
        }
        final Object waitLock = new Object();
        ExecutorService executorService = Executors.newFixedThreadPool(numVersions);
        final AtomicReference<Object> error = new AtomicReference<Object>(null);
        int versions = numVersions;
        while (versions < numVersions * 2) {
            final int versionsCopy = versions++;
            executorService.submit(new Callable<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void call() {
                    try {
                        Put put = new Put(ROW);
                        put.add(FAMILY, QUALIFIER, ts + (long)versionsCopy, VALUE);
                        table.put(put);
                        Result result = table.get(get);
                        NavigableMap navigableMap = (NavigableMap)((NavigableMap)result.getMap().get(FAMILY)).get(QUALIFIER);
                        Assert.assertEquals((String)("The number of versions of '" + Bytes.toString((byte[])FAMILY) + ":" + Bytes.toString((byte[])QUALIFIER) + " did not match " + versionsCopy), (long)versionsCopy, (long)navigableMap.size());
                        for (Map.Entry entry : navigableMap.entrySet()) {
                            Assert.assertTrue((String)("The value at time " + entry.getKey() + " did not match what was put"), (boolean)Bytes.equals((byte[])VALUE, (byte[])((byte[])entry.getValue())));
                        }
                        Object object = waitLock;
                        synchronized (object) {
                            waitLock.wait();
                        }
                    }
                    catch (Exception e) {
                    }
                    catch (AssertionError e) {
                        error.set(e);
                        TestFromClientSide.this.LOG.error((Object)e);
                    }
                    return null;
                }
            });
        }
        Object object = waitLock;
        synchronized (object) {
            waitLock.notifyAll();
        }
        executorService.shutdownNow();
        Assert.assertNull(error.get());
    }

    @Test
    public void testCheckAndPut() throws IOException {
        byte[] anotherrow = Bytes.toBytes((String)"anotherrow");
        byte[] value2 = Bytes.toBytes((String)"abcd");
        HTable table = TEST_UTIL.createTable(Bytes.toBytes((String)"testCheckAndPut"), (byte[][])new byte[][]{FAMILY});
        Put put1 = new Put(ROW);
        put1.add(FAMILY, QUALIFIER, VALUE);
        boolean ok = table.checkAndPut(ROW, FAMILY, QUALIFIER, VALUE, put1);
        Assert.assertEquals((Object)ok, (Object)false);
        ok = table.checkAndPut(ROW, FAMILY, QUALIFIER, null, put1);
        Assert.assertEquals((Object)ok, (Object)true);
        ok = table.checkAndPut(ROW, FAMILY, QUALIFIER, null, put1);
        Assert.assertEquals((Object)ok, (Object)false);
        Put put2 = new Put(ROW);
        put2.add(FAMILY, QUALIFIER, value2);
        ok = table.checkAndPut(ROW, FAMILY, QUALIFIER, VALUE, put2);
        Assert.assertEquals((Object)ok, (Object)true);
        Put put3 = new Put(anotherrow);
        put3.add(FAMILY, QUALIFIER, VALUE);
        try {
            ok = table.checkAndPut(ROW, FAMILY, QUALIFIER, value2, put3);
            Assert.fail((String)"trying to check and modify different rows should have failed.");
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    @Test
    public void testScanMetrics() throws Exception {
        byte[] TABLENAME = Bytes.toBytes((String)"testScanMetrics");
        Configuration conf = TEST_UTIL.getConfiguration();
        TEST_UTIL.createTable(TABLENAME, FAMILY);
        HTable ht = new HTable(conf, TABLENAME);
        int numOfRegions = TEST_UTIL.createMultiRegions(ht, FAMILY);
        Put put1 = new Put(Bytes.toBytes((String)"z1"));
        put1.add(FAMILY, QUALIFIER, VALUE);
        Put put2 = new Put(Bytes.toBytes((String)"z2"));
        put2.add(FAMILY, QUALIFIER, VALUE);
        Put put3 = new Put(Bytes.toBytes((String)"z3"));
        put3.add(FAMILY, QUALIFIER, VALUE);
        ht.put(Arrays.asList(put1, put2, put3));
        Scan scan1 = new Scan();
        int numRecords = 0;
        for (Result result : ht.getScanner(scan1)) {
            ++numRecords;
        }
        this.LOG.info((Object)("test data has " + numRecords + " records."));
        Assert.assertEquals(null, (Object)scan1.getAttribute("scan.attributes.metrics.data"));
        Scan scan = new Scan();
        scan.setAttribute("scan.attributes.metrics.enable", Bytes.toBytes((boolean)Boolean.TRUE));
        scan.setCaching(numRecords + 1);
        ResultScanner scanner = ht.getScanner(scan);
        for (Result result : scanner.next(numRecords - 1)) {
        }
        scanner.close();
        Assert.assertNotNull((Object)scan.getAttribute("scan.attributes.metrics.data"));
        scan = new Scan();
        scan.setAttribute("scan.attributes.metrics.enable", Bytes.toBytes((boolean)Boolean.TRUE));
        scan.setCaching(1);
        scanner = ht.getScanner(scan);
        for (Result result : scanner.next(numRecords - 1)) {
        }
        scanner.close();
        ScanMetrics scanMetrics = this.getScanMetrics(scan);
        Assert.assertEquals((String)"Did not access all the regions in the table", (long)numOfRegions, (long)scanMetrics.countOfRegions.get());
        Scan scanWithoutClose = new Scan();
        scanWithoutClose.setCaching(1);
        scanWithoutClose.setAttribute("scan.attributes.metrics.enable", Bytes.toBytes((boolean)Boolean.TRUE));
        ResultScanner scannerWithoutClose = ht.getScanner(scanWithoutClose);
        for (Result result : scannerWithoutClose.next(numRecords + 1)) {
        }
        ScanMetrics scanMetricsWithoutClose = this.getScanMetrics(scanWithoutClose);
        Assert.assertEquals((String)"Did not access all the regions in the table", (long)numOfRegions, (long)scanMetricsWithoutClose.countOfRegions.get());
        Scan scanWithClose = new Scan();
        scanWithClose.setCaching(numRecords);
        scanWithClose.setAttribute("scan.attributes.metrics.enable", Bytes.toBytes((boolean)Boolean.TRUE));
        ResultScanner scannerWithClose = ht.getScanner(scanWithClose);
        for (Result result : scannerWithClose.next(numRecords + 1)) {
        }
        scannerWithClose.close();
        ScanMetrics scanMetricsWithClose = this.getScanMetrics(scanWithClose);
        Assert.assertEquals((String)"Did not access all the regions in the table", (long)numOfRegions, (long)scanMetricsWithClose.countOfRegions.get());
    }

    private ScanMetrics getScanMetrics(Scan scan) throws Exception {
        byte[] serializedMetrics = scan.getAttribute("scan.attributes.metrics.data");
        Assert.assertTrue((String)"Serialized metrics were not found.", (serializedMetrics != null ? 1 : 0) != 0);
        ScanMetrics scanMetrics = ProtobufUtil.toScanMetrics((byte[])serializedMetrics);
        return scanMetrics;
    }

    @Test
    public void testCacheOnWriteEvictOnClose() throws Exception {
        byte[] tableName = Bytes.toBytes((String)"testCOWEOCfromClient");
        byte[] data = Bytes.toBytes((String)"data");
        HTable table = TEST_UTIL.createTable(tableName, (byte[][])new byte[][]{FAMILY});
        String regionName = ((HRegionInfo)table.getRegionLocations().firstKey()).getEncodedName();
        HRegion region = TEST_UTIL.getRSForFirstRegionInTable(tableName).getFromOnlineRegions(regionName);
        Store store = (Store)region.getStores().values().iterator().next();
        CacheConfig cacheConf = store.getCacheConfig();
        cacheConf.setCacheDataOnWrite(true);
        cacheConf.setEvictOnClose(true);
        BlockCache cache = cacheConf.getBlockCache();
        long startBlockCount = cache.getBlockCount();
        long startBlockHits = cache.getStats().getHitCount();
        long startBlockMiss = cache.getStats().getMissCount();
        for (int i = 0; i < 5; ++i) {
            Thread.sleep(100L);
            if (startBlockCount == cache.getBlockCount() && startBlockHits == cache.getStats().getHitCount() && startBlockMiss == cache.getStats().getMissCount()) continue;
            startBlockCount = cache.getBlockCount();
            startBlockHits = cache.getStats().getHitCount();
            startBlockMiss = cache.getStats().getMissCount();
            i = -1;
        }
        Put put = new Put(ROW);
        put.add(FAMILY, QUALIFIER, data);
        table.put(put);
        Assert.assertTrue((boolean)Bytes.equals((byte[])table.get(new Get(ROW)).value(), (byte[])data));
        Assert.assertEquals((long)startBlockCount, (long)cache.getBlockCount());
        Assert.assertEquals((long)startBlockHits, (long)cache.getStats().getHitCount());
        Assert.assertEquals((long)startBlockMiss, (long)cache.getStats().getMissCount());
        System.out.println("Flushing cache");
        region.flushcache();
        long expectedBlockCount = startBlockCount + 1L;
        long expectedBlockHits = startBlockHits;
        long expectedBlockMiss = startBlockMiss;
        Assert.assertEquals((long)expectedBlockCount, (long)cache.getBlockCount());
        Assert.assertEquals((long)expectedBlockHits, (long)cache.getStats().getHitCount());
        Assert.assertEquals((long)expectedBlockMiss, (long)cache.getStats().getMissCount());
        Assert.assertTrue((boolean)Bytes.equals((byte[])table.get(new Get(ROW)).value(), (byte[])data));
        Assert.assertEquals((long)expectedBlockCount, (long)cache.getBlockCount());
        Assert.assertEquals((long)(++expectedBlockHits), (long)cache.getStats().getHitCount());
        Assert.assertEquals((long)expectedBlockMiss, (long)cache.getStats().getMissCount());
        byte[] QUALIFIER2 = Bytes.add((byte[])QUALIFIER, (byte[])QUALIFIER);
        byte[] data2 = Bytes.add((byte[])data, (byte[])data);
        put = new Put(ROW);
        put.add(FAMILY, QUALIFIER2, data2);
        table.put(put);
        Result r = table.get(new Get(ROW));
        Assert.assertTrue((boolean)Bytes.equals((byte[])r.getValue(FAMILY, QUALIFIER), (byte[])data));
        Assert.assertTrue((boolean)Bytes.equals((byte[])r.getValue(FAMILY, QUALIFIER2), (byte[])data2));
        Assert.assertEquals((long)expectedBlockCount, (long)cache.getBlockCount());
        Assert.assertEquals((long)(++expectedBlockHits), (long)cache.getStats().getHitCount());
        Assert.assertEquals((long)expectedBlockMiss, (long)cache.getStats().getMissCount());
        System.out.println("Flushing cache");
        region.flushcache();
        Assert.assertEquals((long)(++expectedBlockCount), (long)cache.getBlockCount());
        Assert.assertEquals((long)expectedBlockHits, (long)cache.getStats().getHitCount());
        Assert.assertEquals((long)expectedBlockMiss, (long)cache.getStats().getMissCount());
        System.out.println("Compacting");
        Assert.assertEquals((long)2L, (long)store.getStorefilesCount());
        store.triggerMajorCompaction();
        region.compactStores();
        this.waitForStoreFileCount(store, 1, 10000);
        Assert.assertEquals((long)1L, (long)store.getStorefilesCount());
        Assert.assertEquals((long)(expectedBlockCount -= 2L), (long)cache.getBlockCount());
        Assert.assertEquals((long)expectedBlockMiss, (long)cache.getStats().getMissCount());
        Assert.assertEquals((long)(expectedBlockHits += 2L), (long)cache.getStats().getHitCount());
        r = table.get(new Get(ROW));
        Assert.assertTrue((boolean)Bytes.equals((byte[])r.getValue(FAMILY, QUALIFIER), (byte[])data));
        Assert.assertTrue((boolean)Bytes.equals((byte[])r.getValue(FAMILY, QUALIFIER2), (byte[])data2));
        Assert.assertEquals((long)(++expectedBlockCount), (long)cache.getBlockCount());
        Assert.assertEquals((long)expectedBlockHits, (long)cache.getStats().getHitCount());
        Assert.assertEquals((long)(++expectedBlockMiss), (long)cache.getStats().getMissCount());
    }

    private void waitForStoreFileCount(Store store, int count, int timeout) throws InterruptedException {
        long start = System.currentTimeMillis();
        while (start + (long)timeout > System.currentTimeMillis() && store.getStorefilesCount() != count) {
            Thread.sleep(100L);
        }
        System.out.println("start=" + start + ", now=" + System.currentTimeMillis() + ", cur=" + store.getStorefilesCount());
        Assert.assertEquals((long)count, (long)store.getStorefilesCount());
    }

    @Test
    public void testNonCachedGetRegionLocation() throws Exception {
        String tableName = "testNonCachedGetRegionLocation";
        byte[] TABLE = Bytes.toBytes((String)tableName);
        byte[] family1 = Bytes.toBytes((String)"f1");
        byte[] family2 = Bytes.toBytes((String)"f2");
        HTable table = TEST_UTIL.createTable(TABLE, (byte[][])new byte[][]{family1, family2}, 10);
        HBaseAdmin admin = new HBaseAdmin(TEST_UTIL.getConfiguration());
        NavigableMap regionsMap = table.getRegionLocations();
        Assert.assertEquals((long)1L, (long)regionsMap.size());
        HRegionInfo regionInfo = (HRegionInfo)regionsMap.keySet().iterator().next();
        ServerName addrBefore = (ServerName)regionsMap.get(regionInfo);
        HRegionLocation addrCache = table.getRegionLocation(regionInfo.getStartKey(), false);
        HRegionLocation addrNoCache = table.getRegionLocation(regionInfo.getStartKey(), true);
        Assert.assertEquals((long)addrBefore.getPort(), (long)addrCache.getPort());
        Assert.assertEquals((long)addrBefore.getPort(), (long)addrNoCache.getPort());
        ServerName addrAfter = null;
        for (int i = 0; i < SLAVES; ++i) {
            HRegionServer regionServer = TEST_UTIL.getHBaseCluster().getRegionServer(i);
            ServerName addr = regionServer.getServerName();
            if (addr.getPort() == addrBefore.getPort()) continue;
            admin.move(regionInfo.getEncodedNameAsBytes(), Bytes.toBytes((String)addr.toString()));
            Thread.sleep(5000L);
            addrAfter = addr;
            break;
        }
        addrCache = table.getRegionLocation(regionInfo.getStartKey(), false);
        addrNoCache = table.getRegionLocation(regionInfo.getStartKey(), true);
        Assert.assertNotNull(addrAfter);
        Assert.assertTrue((addrAfter.getPort() != addrCache.getPort() ? 1 : 0) != 0);
        Assert.assertEquals((long)addrAfter.getPort(), (long)addrNoCache.getPort());
    }

    @Test
    public void testGetRegionsInRange() throws Exception {
        byte[] startKey = Bytes.toBytes((String)"ddc");
        byte[] endKey = Bytes.toBytes((String)"mmm");
        byte[] TABLE = Bytes.toBytes((String)"testGetRegionsInRange");
        HTable table = TEST_UTIL.createTable(TABLE, (byte[][])new byte[][]{FAMILY}, 10);
        int numOfRegions = TEST_UTIL.createMultiRegions(table, FAMILY);
        Assert.assertEquals((long)25L, (long)numOfRegions);
        List regionsList = table.getRegionsInRange(startKey, endKey);
        Assert.assertEquals((long)10L, (long)regionsList.size());
        startKey = Bytes.toBytes((String)"fff");
        regionsList = table.getRegionsInRange(startKey, endKey);
        Assert.assertEquals((long)7L, (long)regionsList.size());
        endKey = Bytes.toBytes((String)"nnn");
        regionsList = table.getRegionsInRange(startKey, endKey);
        Assert.assertEquals((long)8L, (long)regionsList.size());
        regionsList = table.getRegionsInRange(HConstants.EMPTY_START_ROW, endKey);
        Assert.assertEquals((long)13L, (long)regionsList.size());
        regionsList = table.getRegionsInRange(startKey, HConstants.EMPTY_END_ROW);
        Assert.assertEquals((long)20L, (long)regionsList.size());
        regionsList = table.getRegionsInRange(HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW);
        Assert.assertEquals((long)25L, (long)regionsList.size());
        endKey = Bytes.toBytes((String)"yyz");
        regionsList = table.getRegionsInRange(startKey, endKey);
        Assert.assertEquals((long)20L, (long)regionsList.size());
        startKey = Bytes.toBytes((String)"aac");
        regionsList = table.getRegionsInRange(startKey, endKey);
        Assert.assertEquals((long)25L, (long)regionsList.size());
        startKey = endKey = Bytes.toBytes((String)"ccc");
        regionsList = table.getRegionsInRange(startKey, endKey);
        Assert.assertEquals((long)1L, (long)regionsList.size());
    }

    @Test
    public void testJira6912() throws Exception {
        byte[] TABLE = Bytes.toBytes((String)"testJira6912");
        HTable foo = TEST_UTIL.createTable(TABLE, (byte[][])new byte[][]{FAMILY}, 10);
        ArrayList<Put> puts = new ArrayList<Put>();
        for (int i = 0; i != 100; ++i) {
            Put put = new Put(Bytes.toBytes((int)i));
            put.add(FAMILY, FAMILY, Bytes.toBytes((int)i));
            puts.add(put);
        }
        foo.put(puts);
        TEST_UTIL.flush();
        Scan scan = new Scan();
        scan.setStartRow(Bytes.toBytes((int)1));
        scan.setStopRow(Bytes.toBytes((int)3));
        scan.addColumn(FAMILY, FAMILY);
        scan.setFilter((Filter)new RowFilter(CompareFilter.CompareOp.NOT_EQUAL, (ByteArrayComparable)new BinaryComparator(Bytes.toBytes((int)1))));
        ResultScanner scanner = foo.getScanner(scan);
        Result[] bar = scanner.next(100);
        Assert.assertEquals((long)1L, (long)bar.length);
    }

    @Test
    public void testScan_NullQualifier() throws IOException {
        HTable table = TEST_UTIL.createTable(Bytes.toBytes((String)"testScan_NullQualifier"), FAMILY);
        Put put = new Put(ROW);
        put.add(FAMILY, QUALIFIER, VALUE);
        table.put(put);
        put = new Put(ROW);
        put.add(FAMILY, null, VALUE);
        table.put(put);
        this.LOG.info((Object)"Row put");
        Scan scan = new Scan();
        scan.addColumn(FAMILY, null);
        ResultScanner scanner = table.getScanner(scan);
        Result[] bar = scanner.next(100);
        Assert.assertEquals((long)1L, (long)bar.length);
        Assert.assertEquals((long)1L, (long)bar[0].size());
        scan = new Scan();
        scan.addFamily(FAMILY);
        scanner = table.getScanner(scan);
        bar = scanner.next(100);
        Assert.assertEquals((long)1L, (long)bar.length);
        Assert.assertEquals((long)2L, (long)bar[0].size());
    }

    @Test
    public void testNegativeTimestamp() throws IOException {
        Delete delete;
        Put put;
        HTable table = TEST_UTIL.createTable(Bytes.toBytes((String)"testNegativeTimestamp"), FAMILY);
        try {
            put = new Put(ROW, -1L);
            put.add(FAMILY, QUALIFIER, VALUE);
            table.put(put);
            Assert.fail((String)"Negative timestamps should not have been allowed");
        }
        catch (IllegalArgumentException ex) {
            Assert.assertTrue((boolean)ex.getMessage().contains("negative"));
        }
        try {
            put = new Put(ROW);
            put.add(FAMILY, QUALIFIER, -1L, VALUE);
            table.put(put);
            Assert.fail((String)"Negative timestamps should not have been allowed");
        }
        catch (IllegalArgumentException ex) {
            Assert.assertTrue((boolean)ex.getMessage().contains("negative"));
        }
        try {
            delete = new Delete(ROW, -1L);
            table.delete(delete);
            Assert.fail((String)"Negative timestamps should not have been allowed");
        }
        catch (IllegalArgumentException ex) {
            Assert.assertTrue((boolean)ex.getMessage().contains("negative"));
        }
        try {
            delete = new Delete(ROW);
            delete.deleteFamily(FAMILY, -1L);
            table.delete(delete);
            Assert.fail((String)"Negative timestamps should not have been allowed");
        }
        catch (IllegalArgumentException ex) {
            Assert.assertTrue((boolean)ex.getMessage().contains("negative"));
        }
        try {
            Scan scan = new Scan();
            scan.setTimeRange(-1L, 1L);
            table.getScanner(scan);
            Assert.fail((String)"Negative timestamps should not have been allowed");
        }
        catch (IllegalArgumentException ex) {
            Assert.assertTrue((boolean)ex.getMessage().contains("negative"));
        }
        try {
            new KeyValue(Bytes.toBytes((int)42), Bytes.toBytes((int)42), Bytes.toBytes((int)42), -1L, Bytes.toBytes((int)42));
        }
        catch (IllegalArgumentException ex) {
            Assert.fail((String)"KeyValue SHOULD allow negative timestamps");
        }
        table.close();
    }

    @Test
    public void testIllegalTableDescriptor() throws Exception {
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((String)"testIllegalTableDescriptor"));
        HColumnDescriptor hcd = new HColumnDescriptor(FAMILY);
        this.checkTableIsIllegal(htd);
        htd.addFamily(hcd);
        this.checkTableIsLegal(htd);
        htd.setMaxFileSize(1024L);
        this.checkTableIsIllegal(htd);
        htd.setMaxFileSize(0L);
        this.checkTableIsIllegal(htd);
        htd.setMaxFileSize(0x40000000L);
        this.checkTableIsLegal(htd);
        htd.setMemStoreFlushSize(1024L);
        this.checkTableIsIllegal(htd);
        htd.setMemStoreFlushSize(0L);
        this.checkTableIsIllegal(htd);
        htd.setMemStoreFlushSize(0x8000000L);
        this.checkTableIsLegal(htd);
        htd.setRegionSplitPolicyClassName("nonexisting.foo.class");
        this.checkTableIsIllegal(htd);
        htd.setRegionSplitPolicyClassName(null);
        this.checkTableIsLegal(htd);
        hcd.setBlocksize(0);
        this.checkTableIsIllegal(htd);
        hcd.setBlocksize(0x8000000);
        this.checkTableIsIllegal(htd);
        hcd.setBlocksize(1024);
        this.checkTableIsLegal(htd);
        hcd.setTimeToLive(0);
        this.checkTableIsIllegal(htd);
        hcd.setTimeToLive(-1);
        this.checkTableIsIllegal(htd);
        hcd.setTimeToLive(1);
        this.checkTableIsLegal(htd);
        hcd.setMinVersions(-1);
        this.checkTableIsIllegal(htd);
        hcd.setMinVersions(3);
        try {
            hcd.setMaxVersions(2);
            Assert.fail();
        }
        catch (IllegalArgumentException ex) {
            hcd.setMaxVersions(10);
        }
        this.checkTableIsLegal(htd);
        hcd.setScope(-1);
        this.checkTableIsIllegal(htd);
        hcd.setScope(0);
        this.checkTableIsLegal(htd);
        htd.setMemStoreFlushSize(0L);
        htd.setConfiguration("hbase.table.sanity.checks", Boolean.FALSE.toString());
        this.checkTableIsLegal(htd);
    }

    private void checkTableIsLegal(HTableDescriptor htd) throws IOException {
        HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
        admin.createTable(htd);
        Assert.assertTrue((boolean)admin.tableExists(htd.getTableName()));
        admin.disableTable(htd.getTableName());
        admin.deleteTable(htd.getTableName());
    }

    private void checkTableIsIllegal(HTableDescriptor htd) throws IOException {
        HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
        try {
            admin.createTable(htd);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertFalse((boolean)admin.tableExists(htd.getTableName()));
    }

    @Test
    public void testRawScanRespectsVersions() throws Exception {
        byte[] TABLE = Bytes.toBytes((String)"testRawScan");
        HTable table = TEST_UTIL.createTable(TABLE, (byte[][])new byte[][]{FAMILY});
        byte[] row = Bytes.toBytes((String)"row");
        Put p = new Put(row);
        p.add(FAMILY, QUALIFIER, 10L, VALUE);
        table.put(p);
        table.flushCommits();
        p = new Put(row);
        p.add(FAMILY, QUALIFIER, 11L, ArrayUtils.add((byte[])VALUE, (byte)2));
        table.put(p);
        table.flushCommits();
        p = new Put(row);
        p.add(FAMILY, QUALIFIER, 12L, ArrayUtils.add((byte[])VALUE, (byte)3));
        table.put(p);
        table.flushCommits();
        p = new Put(row);
        p.add(FAMILY, QUALIFIER, 13L, ArrayUtils.add((byte[])VALUE, (byte)4));
        table.put(p);
        table.flushCommits();
        int versions = 4;
        Scan s = new Scan(row);
        s.setMaxVersions();
        s.setRaw(true);
        ResultScanner scanner = table.getScanner(s);
        int count = 0;
        for (Result r : scanner) {
            Assert.assertEquals((String)"Found an unexpected number of results for the row!", (long)versions, (long)r.listCells().size());
            ++count;
        }
        Assert.assertEquals((String)"Found more than a single row when raw scanning the table with a single row!", (long)1L, (long)count);
        scanner.close();
        versions = 2;
        s.setMaxVersions(versions);
        scanner = table.getScanner(s);
        count = 0;
        for (Result r : scanner) {
            Assert.assertEquals((String)"Found an unexpected number of results for the row!", (long)versions, (long)r.listCells().size());
            ++count;
        }
        Assert.assertEquals((String)"Found more than a single row when raw scanning the table with a single row!", (long)1L, (long)count);
        scanner.close();
        versions = 3;
        s.setMaxVersions(versions);
        scanner = table.getScanner(s);
        count = 0;
        for (Result r : scanner) {
            Assert.assertEquals((String)"Found an unexpected number of results for the row!", (long)versions, (long)r.listCells().size());
            ++count;
        }
        Assert.assertEquals((String)"Found more than a single row when raw scanning the table with a single row!", (long)1L, (long)count);
        scanner.close();
        table.close();
        TEST_UTIL.deleteTable(TABLE);
    }

    @Test
    public void testSmallScan() throws Exception {
        byte[] TABLE = Bytes.toBytes((String)"testSmallScan");
        HTable table = TEST_UTIL.createTable(TABLE, FAMILY);
        int insertNum = 10;
        for (int i = 0; i < 10; ++i) {
            Put put = new Put(Bytes.toBytes((String)("row" + String.format("%03d", i))));
            put.add(FAMILY, QUALIFIER, VALUE);
            table.put(put);
        }
        ResultScanner scanner = table.getScanner(new Scan());
        int count = 0;
        for (Result r : scanner) {
            Assert.assertTrue((!r.isEmpty() ? 1 : 0) != 0);
            ++count;
        }
        Assert.assertEquals((long)insertNum, (long)count);
        Scan scan = new Scan(HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW);
        scan.setSmall(true);
        scan.setCaching(2);
        scanner = table.getScanner(scan);
        count = 0;
        for (Result r : scanner) {
            Assert.assertTrue((!r.isEmpty() ? 1 : 0) != 0);
            ++count;
        }
        Assert.assertEquals((long)insertNum, (long)count);
    }

    @Test
    public void testSuperSimpleWithReverseScan() throws Exception {
        byte[] TABLE = Bytes.toBytes((String)"testSuperSimpleWithReverseScan");
        HTable ht = TEST_UTIL.createTable(TABLE, FAMILY);
        Put put = new Put(Bytes.toBytes((String)"0-b11111-0000000000000000000"));
        put.add(FAMILY, QUALIFIER, VALUE);
        ht.put(put);
        put = new Put(Bytes.toBytes((String)"0-b11111-0000000000000000002"));
        put.add(FAMILY, QUALIFIER, VALUE);
        ht.put(put);
        put = new Put(Bytes.toBytes((String)"0-b11111-0000000000000000004"));
        put.add(FAMILY, QUALIFIER, VALUE);
        ht.put(put);
        put = new Put(Bytes.toBytes((String)"0-b11111-0000000000000000006"));
        put.add(FAMILY, QUALIFIER, VALUE);
        ht.put(put);
        put = new Put(Bytes.toBytes((String)"0-b11111-0000000000000000008"));
        put.add(FAMILY, QUALIFIER, VALUE);
        ht.put(put);
        put = new Put(Bytes.toBytes((String)"0-b22222-0000000000000000001"));
        put.add(FAMILY, QUALIFIER, VALUE);
        ht.put(put);
        put = new Put(Bytes.toBytes((String)"0-b22222-0000000000000000003"));
        put.add(FAMILY, QUALIFIER, VALUE);
        ht.put(put);
        put = new Put(Bytes.toBytes((String)"0-b22222-0000000000000000005"));
        put.add(FAMILY, QUALIFIER, VALUE);
        ht.put(put);
        put = new Put(Bytes.toBytes((String)"0-b22222-0000000000000000007"));
        put.add(FAMILY, QUALIFIER, VALUE);
        ht.put(put);
        put = new Put(Bytes.toBytes((String)"0-b22222-0000000000000000009"));
        put.add(FAMILY, QUALIFIER, VALUE);
        ht.put(put);
        ht.flushCommits();
        Scan scan = new Scan(Bytes.toBytes((String)"0-b11111-9223372036854775807"), Bytes.toBytes((String)"0-b11111-0000000000000000000"));
        scan.setReversed(true);
        ResultScanner scanner = ht.getScanner(scan);
        Result result = scanner.next();
        Assert.assertTrue((boolean)Bytes.equals((byte[])result.getRow(), (byte[])Bytes.toBytes((String)"0-b11111-0000000000000000008")));
        scanner.close();
        ht.close();
    }

    @Test
    public void testFiltersWithReverseScan() throws Exception {
        byte[] TABLE = Bytes.toBytes((String)"testFiltersWithReverseScan");
        HTable ht = TEST_UTIL.createTable(TABLE, FAMILY);
        byte[][] ROWS = this.makeN(ROW, 10);
        byte[][] QUALIFIERS = new byte[][]{Bytes.toBytes((String)"col0-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col1-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col2-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col3-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col4-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col5-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col6-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col7-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col8-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col9-<d2v1>-<d3v2>")};
        for (int i = 0; i < 10; ++i) {
            Put put = new Put(ROWS[i]);
            put.add(FAMILY, QUALIFIERS[i], VALUE);
            ht.put(put);
        }
        Scan scan = new Scan();
        scan.setReversed(true);
        scan.addFamily(FAMILY);
        QualifierFilter filter = new QualifierFilter(CompareFilter.CompareOp.EQUAL, (ByteArrayComparable)new RegexStringComparator("col[1-5]"));
        scan.setFilter((Filter)filter);
        ResultScanner scanner = ht.getScanner(scan);
        int expectedIndex = 5;
        for (Result result : scanner) {
            Assert.assertEquals((long)result.size(), (long)1L);
            Assert.assertTrue((boolean)Bytes.equals((byte[])result.raw()[0].getRow(), (byte[])ROWS[expectedIndex]));
            Assert.assertTrue((boolean)Bytes.equals((byte[])result.raw()[0].getQualifier(), (byte[])QUALIFIERS[expectedIndex]));
            --expectedIndex;
        }
        Assert.assertEquals((long)expectedIndex, (long)0L);
        scanner.close();
        ht.close();
    }

    @Test
    public void testKeyOnlyFilterWithReverseScan() throws Exception {
        byte[] TABLE = Bytes.toBytes((String)"testKeyOnlyFilterWithReverseScan");
        HTable ht = TEST_UTIL.createTable(TABLE, FAMILY);
        byte[][] ROWS = this.makeN(ROW, 10);
        byte[][] QUALIFIERS = new byte[][]{Bytes.toBytes((String)"col0-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col1-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col2-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col3-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col4-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col5-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col6-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col7-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col8-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col9-<d2v1>-<d3v2>")};
        for (int i = 0; i < 10; ++i) {
            Put put = new Put(ROWS[i]);
            put.add(FAMILY, QUALIFIERS[i], VALUE);
            ht.put(put);
        }
        Scan scan = new Scan();
        scan.setReversed(true);
        scan.addFamily(FAMILY);
        KeyOnlyFilter filter = new KeyOnlyFilter(true);
        scan.setFilter((Filter)filter);
        ResultScanner scanner = ht.getScanner(scan);
        int count = 0;
        for (Result result : ht.getScanner(scan)) {
            Assert.assertEquals((long)result.size(), (long)1L);
            Assert.assertEquals((long)result.raw()[0].getValueLength(), (long)4L);
            Assert.assertEquals((long)Bytes.toInt((byte[])result.raw()[0].getValue()), (long)VALUE.length);
            ++count;
        }
        Assert.assertEquals((long)count, (long)10L);
        scanner.close();
        ht.close();
    }

    @Test
    public void testSimpleMissingWithReverseScan() throws Exception {
        byte[] TABLE = Bytes.toBytes((String)"testSimpleMissingWithReverseScan");
        HTable ht = TEST_UTIL.createTable(TABLE, FAMILY);
        byte[][] ROWS = this.makeN(ROW, 4);
        Scan scan = new Scan();
        scan.setReversed(true);
        Result result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
        scan = new Scan(ROWS[0]);
        scan.setReversed(true);
        result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
        scan = new Scan(ROWS[0], ROWS[1]);
        scan.setReversed(true);
        result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
        scan = new Scan();
        scan.setReversed(true);
        scan.addFamily(FAMILY);
        result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
        scan = new Scan();
        scan.setReversed(true);
        scan.addColumn(FAMILY, QUALIFIER);
        result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
        Put put = new Put(ROWS[2]);
        put.add(FAMILY, QUALIFIER, VALUE);
        ht.put(put);
        scan = new Scan();
        scan.setReversed(true);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[2], FAMILY, QUALIFIER, VALUE);
        scan = new Scan(ROWS[3], ROWS[0]);
        scan.setReversed(true);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[2], FAMILY, QUALIFIER, VALUE);
        scan = new Scan(ROWS[2], ROWS[1]);
        scan.setReversed(true);
        result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROWS[2], FAMILY, QUALIFIER, VALUE);
        scan = new Scan(ROWS[1]);
        scan.setReversed(true);
        result = this.getSingleScanResult(ht, scan);
        this.assertNullResult(result);
        ht.close();
    }

    @Test
    public void testNullWithReverseScan() throws Exception {
        byte[] TABLE = Bytes.toBytes((String)"testNullWithReverseScan");
        HTable ht = TEST_UTIL.createTable(TABLE, FAMILY);
        Put put = new Put(ROW);
        put.add(FAMILY, null, VALUE);
        ht.put(put);
        this.scanTestNull(ht, ROW, FAMILY, VALUE, true);
        Delete delete = new Delete(ROW);
        delete.deleteColumns(FAMILY, null);
        ht.delete(delete);
        byte[] TABLE2 = Bytes.toBytes((String)"testNull2WithReverseScan");
        ht = TEST_UTIL.createTable(TABLE2, FAMILY);
        put = new Put(ROW);
        put.add(FAMILY, HConstants.EMPTY_BYTE_ARRAY, VALUE);
        ht.put(put);
        this.scanTestNull(ht, ROW, FAMILY, VALUE, true);
        TEST_UTIL.flush();
        this.scanTestNull(ht, ROW, FAMILY, VALUE, true);
        delete = new Delete(ROW);
        delete.deleteColumns(FAMILY, HConstants.EMPTY_BYTE_ARRAY);
        ht.delete(delete);
        put = new Put(ROW);
        put.add(FAMILY, QUALIFIER, null);
        ht.put(put);
        Scan scan = new Scan();
        scan.setReversed(true);
        scan.addColumn(FAMILY, QUALIFIER);
        Result result = this.getSingleScanResult(ht, scan);
        this.assertSingleResult(result, ROW, FAMILY, QUALIFIER, null);
        ht.close();
    }

    @Test
    public void testDeletesWithReverseScan() throws Exception {
        byte[] TABLE = Bytes.toBytes((String)"testDeletesWithReverseScan");
        byte[][] ROWS = this.makeNAscii(ROW, 6);
        byte[][] FAMILIES = this.makeNAscii(FAMILY, 3);
        byte[][] VALUES = this.makeN(VALUE, 5);
        long[] ts = new long[]{1000L, 2000L, 3000L, 4000L, 5000L};
        HTable ht = TEST_UTIL.createTable(TABLE, FAMILIES, TEST_UTIL.getConfiguration(), 3);
        Put put = new Put(ROW);
        put.add(FAMILIES[0], QUALIFIER, ts[0], VALUES[0]);
        put.add(FAMILIES[0], QUALIFIER, ts[1], VALUES[1]);
        ht.put(put);
        Delete delete = new Delete(ROW);
        delete.deleteFamily(FAMILIES[0], ts[0]);
        ht.delete(delete);
        Scan scan = new Scan(ROW);
        scan.setReversed(true);
        scan.addFamily(FAMILIES[0]);
        scan.setMaxVersions(Integer.MAX_VALUE);
        Result result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROW, FAMILIES[0], QUALIFIER, new long[]{ts[1]}, new byte[][]{VALUES[1]}, 0, 0);
        put = new Put(ROW);
        put.add(FAMILIES[0], QUALIFIER, ts[4], VALUES[4]);
        put.add(FAMILIES[0], QUALIFIER, ts[2], VALUES[2]);
        put.add(FAMILIES[0], QUALIFIER, ts[3], VALUES[3]);
        put.add(FAMILIES[0], null, ts[4], VALUES[4]);
        put.add(FAMILIES[0], null, ts[2], VALUES[2]);
        put.add(FAMILIES[0], null, ts[3], VALUES[3]);
        ht.put(put);
        delete = new Delete(ROW);
        delete.deleteColumn(FAMILIES[0], QUALIFIER);
        ht.delete(delete);
        scan = new Scan(ROW);
        scan.setReversed(true);
        scan.addColumn(FAMILIES[0], QUALIFIER);
        scan.setMaxVersions(Integer.MAX_VALUE);
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROW, FAMILIES[0], QUALIFIER, new long[]{ts[1], ts[2], ts[3]}, new byte[][]{VALUES[1], VALUES[2], VALUES[3]}, 0, 2);
        delete = new Delete(ROW);
        delete.deleteColumn(FAMILIES[0], null);
        ht.delete(delete);
        delete = new Delete(ROW);
        delete.deleteColumns(FAMILIES[0], null);
        ht.delete(delete);
        put = new Put(ROW);
        put.add(FAMILIES[0], QUALIFIER, ts[0], VALUES[0]);
        put.add(FAMILIES[0], QUALIFIER, ts[4], VALUES[4]);
        ht.put(put);
        scan = new Scan(ROW);
        scan.setReversed(true);
        scan.addFamily(FAMILIES[0]);
        scan.setMaxVersions(Integer.MAX_VALUE);
        result = this.getSingleScanResult(ht, scan);
        this.assertNResult(result, ROW, FAMILIES[0], QUALIFIER, new long[]{ts[1], ts[2], ts[3]}, new byte[][]{VALUES[1], VALUES[2], VALUES[3]}, 0, 2);
        put = new Put(ROWS[0]);
        put.add(FAMILIES[1], QUALIFIER, ts[0], VALUES[0]);
        put.add(FAMILIES[1], QUALIFIER, ts[1], VALUES[1]);
        put.add(FAMILIES[2], QUALIFIER, ts[2], VALUES[2]);
        put.add(FAMILIES[2], QUALIFIER, ts[3], VALUES[3]);
        ht.put(put);
        put = new Put(ROWS[1]);
        put.add(FAMILIES[1], QUALIFIER, ts[0], VALUES[0]);
        put.add(FAMILIES[1], QUALIFIER, ts[1], VALUES[1]);
        put.add(FAMILIES[2], QUALIFIER, ts[2], VALUES[2]);
        put.add(FAMILIES[2], QUALIFIER, ts[3], VALUES[3]);
        ht.put(put);
        put = new Put(ROWS[2]);
        put.add(FAMILIES[1], QUALIFIER, ts[0], VALUES[0]);
        put.add(FAMILIES[1], QUALIFIER, ts[1], VALUES[1]);
        put.add(FAMILIES[2], QUALIFIER, ts[2], VALUES[2]);
        put.add(FAMILIES[2], QUALIFIER, ts[3], VALUES[3]);
        ht.put(put);
        delete = new Delete(ROWS[0]);
        delete.deleteFamily(FAMILIES[2]);
        ht.delete(delete);
        delete = new Delete(ROWS[1]);
        delete.deleteColumns(FAMILIES[1], QUALIFIER);
        ht.delete(delete);
        delete = new Delete(ROWS[2]);
        delete.deleteColumn(FAMILIES[1], QUALIFIER);
        delete.deleteColumn(FAMILIES[1], QUALIFIER);
        delete.deleteColumn(FAMILIES[2], QUALIFIER);
        ht.delete(delete);
        scan = new Scan(ROWS[0]);
        scan.setReversed(true);
        scan.addFamily(FAMILIES[1]);
        scan.addFamily(FAMILIES[2]);
        scan.setMaxVersions(Integer.MAX_VALUE);
        result = this.getSingleScanResult(ht, scan);
        Assert.assertTrue((String)("Expected 2 keys but received " + result.size()), (result.size() == 2 ? 1 : 0) != 0);
        this.assertNResult(result, ROWS[0], FAMILIES[1], QUALIFIER, new long[]{ts[0], ts[1]}, new byte[][]{VALUES[0], VALUES[1]}, 0, 1);
        scan = new Scan(ROWS[1]);
        scan.setReversed(true);
        scan.addFamily(FAMILIES[1]);
        scan.addFamily(FAMILIES[2]);
        scan.setMaxVersions(Integer.MAX_VALUE);
        result = this.getSingleScanResult(ht, scan);
        Assert.assertTrue((String)("Expected 2 keys but received " + result.size()), (result.size() == 2 ? 1 : 0) != 0);
        scan = new Scan(ROWS[2]);
        scan.setReversed(true);
        scan.addFamily(FAMILIES[1]);
        scan.addFamily(FAMILIES[2]);
        scan.setMaxVersions(Integer.MAX_VALUE);
        result = this.getSingleScanResult(ht, scan);
        Assert.assertEquals((long)1L, (long)result.size());
        this.assertNResult(result, ROWS[2], FAMILIES[2], QUALIFIER, new long[]{ts[2]}, new byte[][]{VALUES[2]}, 0, 0);
        delete = new Delete(ROWS[3]);
        delete.deleteFamily(FAMILIES[1]);
        ht.delete(delete);
        put = new Put(ROWS[3]);
        put.add(FAMILIES[2], QUALIFIER, VALUES[0]);
        ht.put(put);
        put = new Put(ROWS[4]);
        put.add(FAMILIES[1], QUALIFIER, VALUES[1]);
        put.add(FAMILIES[2], QUALIFIER, VALUES[2]);
        ht.put(put);
        scan = new Scan(ROWS[4]);
        scan.setReversed(true);
        scan.addFamily(FAMILIES[1]);
        scan.addFamily(FAMILIES[2]);
        scan.setMaxVersions(Integer.MAX_VALUE);
        ResultScanner scanner = ht.getScanner(scan);
        result = scanner.next();
        Assert.assertTrue((String)("Expected 2 keys but received " + result.size()), (result.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Bytes.equals((byte[])result.raw()[0].getRow(), (byte[])ROWS[4]));
        Assert.assertTrue((boolean)Bytes.equals((byte[])result.raw()[1].getRow(), (byte[])ROWS[4]));
        Assert.assertTrue((boolean)Bytes.equals((byte[])result.raw()[0].getValue(), (byte[])VALUES[1]));
        Assert.assertTrue((boolean)Bytes.equals((byte[])result.raw()[1].getValue(), (byte[])VALUES[2]));
        result = scanner.next();
        Assert.assertTrue((String)("Expected 1 key but received " + result.size()), (result.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Bytes.equals((byte[])result.raw()[0].getRow(), (byte[])ROWS[3]));
        Assert.assertTrue((boolean)Bytes.equals((byte[])result.raw()[0].getValue(), (byte[])VALUES[0]));
        scanner.close();
        ht.close();
    }

    @Test
    public void testReversedScanUnderMultiRegions() throws Exception {
        byte[] TABLE = Bytes.toBytes((String)"testReversedScanUnderMultiRegions");
        byte[] maxByteArray = ReversedClientScanner.MAX_BYTE_ARRAY;
        byte[][] splitRows = new byte[][]{Bytes.toBytes((String)"005"), Bytes.add((byte[])Bytes.toBytes((String)"005"), (byte[])Bytes.multiple((byte[])maxByteArray, (int)16)), Bytes.toBytes((String)"006"), Bytes.add((byte[])Bytes.toBytes((String)"006"), (byte[])Bytes.multiple((byte[])maxByteArray, (int)8)), Bytes.toBytes((String)"007"), Bytes.add((byte[])Bytes.toBytes((String)"007"), (byte[])Bytes.multiple((byte[])maxByteArray, (int)4)), Bytes.toBytes((String)"008"), Bytes.multiple((byte[])maxByteArray, (int)2)};
        HTable table = TEST_UTIL.createTable(TABLE, FAMILY, (byte[][])splitRows);
        TEST_UTIL.waitUntilAllRegionsAssigned(table.getName());
        Assert.assertEquals((long)(splitRows.length + 1), (long)table.getRegionLocations().size());
        int insertNum = splitRows.length;
        for (int i = 0; i < insertNum; ++i) {
            Put put = new Put(splitRows[i]);
            put.add(FAMILY, QUALIFIER, VALUE);
            table.put(put);
        }
        ResultScanner scanner = table.getScanner(new Scan());
        int count = 0;
        for (Result r : scanner) {
            Assert.assertTrue((!r.isEmpty() ? 1 : 0) != 0);
            ++count;
        }
        Assert.assertEquals((long)insertNum, (long)count);
        Scan scan = new Scan();
        scan.setReversed(true);
        scanner = table.getScanner(scan);
        count = 0;
        byte[] lastRow = null;
        for (Result r : scanner) {
            Assert.assertTrue((!r.isEmpty() ? 1 : 0) != 0);
            ++count;
            byte[] thisRow = r.getRow();
            if (lastRow != null) {
                Assert.assertTrue((String)("Error scan order, last row= " + Bytes.toString((byte[])lastRow) + ",this row=" + Bytes.toString((byte[])thisRow)), (Bytes.compareTo((byte[])thisRow, (byte[])lastRow) < 0 ? 1 : 0) != 0);
            }
            lastRow = thisRow;
        }
        Assert.assertEquals((long)insertNum, (long)count);
        table.close();
    }

    @Test
    public void testSmallReversedScanUnderMultiRegions() throws Exception {
        byte[] TABLE = Bytes.toBytes((String)"testSmallReversedScanUnderMultiRegions");
        byte[][] splitRows = new byte[][]{Bytes.toBytes((String)"000"), Bytes.toBytes((String)"002"), Bytes.toBytes((String)"004"), Bytes.toBytes((String)"006"), Bytes.toBytes((String)"008"), Bytes.toBytes((String)"010")};
        HTable table = TEST_UTIL.createTable(TABLE, FAMILY, (byte[][])splitRows);
        TEST_UTIL.waitUntilAllRegionsAssigned(table.getName());
        Assert.assertEquals((long)(splitRows.length + 1), (long)table.getRegionLocations().size());
        for (byte[] splitRow : splitRows) {
            Put put = new Put(splitRow);
            put.add(FAMILY, QUALIFIER, VALUE);
            table.put(put);
            byte[] nextRow = Bytes.copy((byte[])splitRow);
            int n = nextRow.length - 1;
            nextRow[n] = (byte)(nextRow[n] + 1);
            put = new Put(nextRow);
            put.add(FAMILY, QUALIFIER, VALUE);
            table.put(put);
        }
        ResultScanner scanner = table.getScanner(new Scan());
        int count = 0;
        for (Result r : scanner) {
            Assert.assertTrue((!r.isEmpty() ? 1 : 0) != 0);
            ++count;
        }
        Assert.assertEquals((long)12L, (long)count);
        this.reverseScanTest(table, false);
        this.reverseScanTest(table, true);
        table.close();
    }

    private void reverseScanTest(HTable table, boolean small) throws IOException {
        byte[] thisRow;
        Scan scan = new Scan();
        scan.setReversed(true);
        ResultScanner scanner = table.getScanner(scan);
        int count = 0;
        byte[] lastRow = null;
        for (Result r : scanner) {
            Assert.assertTrue((!r.isEmpty() ? 1 : 0) != 0);
            ++count;
            thisRow = r.getRow();
            if (lastRow != null) {
                Assert.assertTrue((String)("Error scan order, last row= " + Bytes.toString((byte[])lastRow) + ",this row=" + Bytes.toString((byte[])thisRow)), (Bytes.compareTo((byte[])thisRow, (byte[])lastRow) < 0 ? 1 : 0) != 0);
            }
            lastRow = thisRow;
        }
        Assert.assertEquals((long)12L, (long)count);
        scan = new Scan();
        scan.setSmall(small);
        scan.setReversed(true);
        scan.setStartRow(Bytes.toBytes((String)"002"));
        scanner = table.getScanner(scan);
        count = 0;
        lastRow = null;
        for (Result r : scanner) {
            Assert.assertTrue((!r.isEmpty() ? 1 : 0) != 0);
            ++count;
            thisRow = r.getRow();
            if (lastRow != null) {
                Assert.assertTrue((String)("Error scan order, last row= " + Bytes.toString((byte[])lastRow) + ",this row=" + Bytes.toString((byte[])thisRow)), (Bytes.compareTo((byte[])thisRow, (byte[])lastRow) < 0 ? 1 : 0) != 0);
            }
            lastRow = thisRow;
        }
        Assert.assertEquals((long)3L, (long)count);
        scan = new Scan();
        scan.setSmall(small);
        scan.setReversed(true);
        scan.setStartRow(Bytes.toBytes((String)"002"));
        scan.setStopRow(Bytes.toBytes((String)"000"));
        scanner = table.getScanner(scan);
        count = 0;
        lastRow = null;
        for (Result r : scanner) {
            Assert.assertTrue((!r.isEmpty() ? 1 : 0) != 0);
            ++count;
            thisRow = r.getRow();
            if (lastRow != null) {
                Assert.assertTrue((String)("Error scan order, last row= " + Bytes.toString((byte[])lastRow) + ",this row=" + Bytes.toString((byte[])thisRow)), (Bytes.compareTo((byte[])thisRow, (byte[])lastRow) < 0 ? 1 : 0) != 0);
            }
            lastRow = thisRow;
        }
        Assert.assertEquals((long)2L, (long)count);
        scan = new Scan();
        scan.setSmall(small);
        scan.setReversed(true);
        scan.setStartRow(Bytes.toBytes((String)"001"));
        scanner = table.getScanner(scan);
        count = 0;
        lastRow = null;
        for (Result r : scanner) {
            Assert.assertTrue((!r.isEmpty() ? 1 : 0) != 0);
            ++count;
            thisRow = r.getRow();
            if (lastRow != null) {
                Assert.assertTrue((String)("Error scan order, last row= " + Bytes.toString((byte[])lastRow) + ",this row=" + Bytes.toString((byte[])thisRow)), (Bytes.compareTo((byte[])thisRow, (byte[])lastRow) < 0 ? 1 : 0) != 0);
            }
            lastRow = thisRow;
        }
        Assert.assertEquals((long)2L, (long)count);
        scan = new Scan();
        scan.setSmall(small);
        scan.setReversed(true);
        scan.setStartRow(Bytes.toBytes((String)"000"));
        scanner = table.getScanner(scan);
        count = 0;
        lastRow = null;
        for (Result r : scanner) {
            Assert.assertTrue((!r.isEmpty() ? 1 : 0) != 0);
            ++count;
            thisRow = r.getRow();
            if (lastRow != null) {
                Assert.assertTrue((String)("Error scan order, last row= " + Bytes.toString((byte[])lastRow) + ",this row=" + Bytes.toString((byte[])thisRow)), (Bytes.compareTo((byte[])thisRow, (byte[])lastRow) < 0 ? 1 : 0) != 0);
            }
            lastRow = thisRow;
        }
        Assert.assertEquals((long)1L, (long)count);
        scan = new Scan();
        scan.setSmall(small);
        scan.setReversed(true);
        scan.setStartRow(Bytes.toBytes((String)"006"));
        scan.setStopRow(Bytes.toBytes((String)"002"));
        scanner = table.getScanner(scan);
        count = 0;
        lastRow = null;
        for (Result r : scanner) {
            Assert.assertTrue((!r.isEmpty() ? 1 : 0) != 0);
            ++count;
            thisRow = r.getRow();
            if (lastRow != null) {
                Assert.assertTrue((String)("Error scan order, last row= " + Bytes.toString((byte[])lastRow) + ",this row=" + Bytes.toString((byte[])thisRow)), (Bytes.compareTo((byte[])thisRow, (byte[])lastRow) < 0 ? 1 : 0) != 0);
            }
            lastRow = thisRow;
        }
        Assert.assertEquals((long)4L, (long)count);
    }
}

