/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.rmnode;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.server.api.protocolrecords.NodeHeartbeatResponse;
import org.apache.hadoop.yarn.server.api.records.NodeHealthStatus;
import org.apache.hadoop.yarn.server.resourcemanager.ClusterMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.NodesListManagerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.NodesListManagerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeCleanAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeCleanContainerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeReconnectEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeStatusEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.UpdatedContainerInfo;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeUpdateSchedulerEvent;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.state.InvalidStateTransitonException;
import org.apache.hadoop.yarn.state.MultipleArcTransition;
import org.apache.hadoop.yarn.state.SingleArcTransition;
import org.apache.hadoop.yarn.state.StateMachine;
import org.apache.hadoop.yarn.state.StateMachineFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class RMNodeImpl
implements RMNode,
EventHandler<RMNodeEvent> {
    private static final Log LOG = LogFactory.getLog(RMNodeImpl.class);
    private static final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    private final ReentrantReadWriteLock.ReadLock readLock;
    private final ReentrantReadWriteLock.WriteLock writeLock;
    private final ConcurrentLinkedQueue<UpdatedContainerInfo> nodeUpdateQueue;
    private volatile boolean nextHeartBeat = true;
    private final NodeId nodeId;
    private final RMContext context;
    private final String hostName;
    private final int commandPort;
    private final int httpPort;
    private final String nodeAddress;
    private final String httpAddress;
    private final Resource totalCapability;
    private final Node node;
    private String healthReport;
    private long lastHealthReportTime;
    private final Map<ContainerId, ContainerStatus> justLaunchedContainers = new HashMap<ContainerId, ContainerStatus>();
    private final Set<ContainerId> containersToClean = new TreeSet<ContainerId>((Comparator<ContainerId>)new BuilderUtils.ContainerIdComparator());
    private final List<ApplicationId> finishedApplications = new ArrayList<ApplicationId>();
    private NodeHeartbeatResponse latestNodeHeartBeatResponse = (NodeHeartbeatResponse)recordFactory.newRecordInstance(NodeHeartbeatResponse.class);
    private static final StateMachineFactory<RMNodeImpl, NodeState, RMNodeEventType, RMNodeEvent> stateMachineFactory = new StateMachineFactory((Enum)NodeState.NEW).addTransition((Enum)NodeState.NEW, (Enum)NodeState.RUNNING, (Enum)RMNodeEventType.STARTED, (SingleArcTransition)new AddNodeTransition()).addTransition((Enum)NodeState.RUNNING, EnumSet.of(NodeState.RUNNING, NodeState.UNHEALTHY), (Enum)RMNodeEventType.STATUS_UPDATE, (MultipleArcTransition)new StatusUpdateWhenHealthyTransition()).addTransition((Enum)NodeState.RUNNING, (Enum)NodeState.DECOMMISSIONED, (Enum)RMNodeEventType.DECOMMISSION, (SingleArcTransition)new DeactivateNodeTransition(NodeState.DECOMMISSIONED)).addTransition((Enum)NodeState.RUNNING, (Enum)NodeState.LOST, (Enum)RMNodeEventType.EXPIRE, (SingleArcTransition)new DeactivateNodeTransition(NodeState.LOST)).addTransition((Enum)NodeState.RUNNING, (Enum)NodeState.REBOOTED, (Enum)RMNodeEventType.REBOOTING, (SingleArcTransition)new DeactivateNodeTransition(NodeState.REBOOTED)).addTransition((Enum)NodeState.RUNNING, (Enum)NodeState.RUNNING, (Enum)RMNodeEventType.CLEANUP_APP, (SingleArcTransition)new CleanUpAppTransition()).addTransition((Enum)NodeState.RUNNING, (Enum)NodeState.RUNNING, (Enum)RMNodeEventType.CLEANUP_CONTAINER, (SingleArcTransition)new CleanUpContainerTransition()).addTransition((Enum)NodeState.RUNNING, (Enum)NodeState.RUNNING, (Enum)RMNodeEventType.RECONNECTED, (SingleArcTransition)new ReconnectNodeTransition()).addTransition((Enum)NodeState.UNHEALTHY, EnumSet.of(NodeState.UNHEALTHY, NodeState.RUNNING), (Enum)RMNodeEventType.STATUS_UPDATE, (MultipleArcTransition)new StatusUpdateWhenUnHealthyTransition()).addTransition((Enum)NodeState.UNHEALTHY, (Enum)NodeState.DECOMMISSIONED, (Enum)RMNodeEventType.DECOMMISSION, (SingleArcTransition)new DeactivateNodeTransition(NodeState.DECOMMISSIONED)).addTransition((Enum)NodeState.UNHEALTHY, (Enum)NodeState.LOST, (Enum)RMNodeEventType.EXPIRE, (SingleArcTransition)new DeactivateNodeTransition(NodeState.LOST)).addTransition((Enum)NodeState.UNHEALTHY, (Enum)NodeState.REBOOTED, (Enum)RMNodeEventType.REBOOTING, (SingleArcTransition)new DeactivateNodeTransition(NodeState.REBOOTED)).addTransition((Enum)NodeState.UNHEALTHY, (Enum)NodeState.UNHEALTHY, (Enum)RMNodeEventType.RECONNECTED, (SingleArcTransition)new ReconnectNodeTransition()).addTransition((Enum)NodeState.UNHEALTHY, (Enum)NodeState.UNHEALTHY, (Enum)RMNodeEventType.CLEANUP_APP, (SingleArcTransition)new CleanUpAppTransition()).addTransition((Enum)NodeState.UNHEALTHY, (Enum)NodeState.UNHEALTHY, (Enum)RMNodeEventType.CLEANUP_CONTAINER, (SingleArcTransition)new CleanUpContainerTransition()).installTopology();
    private final StateMachine<NodeState, RMNodeEventType, RMNodeEvent> stateMachine;

    public RMNodeImpl(NodeId nodeId, RMContext context, String hostName, int cmPort, int httpPort, Node node, Resource capability) {
        this.nodeId = nodeId;
        this.context = context;
        this.hostName = hostName;
        this.commandPort = cmPort;
        this.httpPort = httpPort;
        this.totalCapability = capability;
        this.nodeAddress = hostName + ":" + cmPort;
        this.httpAddress = hostName + ":" + httpPort;
        this.node = node;
        this.healthReport = "Healthy";
        this.lastHealthReportTime = System.currentTimeMillis();
        this.latestNodeHeartBeatResponse.setResponseId(0);
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
        this.stateMachine = stateMachineFactory.make((Object)this);
        this.nodeUpdateQueue = new ConcurrentLinkedQueue();
    }

    public String toString() {
        return this.nodeId.toString();
    }

    @Override
    public String getHostName() {
        return this.hostName;
    }

    @Override
    public int getCommandPort() {
        return this.commandPort;
    }

    @Override
    public int getHttpPort() {
        return this.httpPort;
    }

    @Override
    public NodeId getNodeID() {
        return this.nodeId;
    }

    @Override
    public String getNodeAddress() {
        return this.nodeAddress;
    }

    @Override
    public String getHttpAddress() {
        return this.httpAddress;
    }

    @Override
    public Resource getTotalCapability() {
        return this.totalCapability;
    }

    @Override
    public String getRackName() {
        return this.node.getNetworkLocation();
    }

    @Override
    public Node getNode() {
        return this.node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getHealthReport() {
        this.readLock.lock();
        try {
            String string = this.healthReport;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHealthReport(String healthReport) {
        this.writeLock.lock();
        try {
            this.healthReport = healthReport;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLastHealthReportTime(long lastHealthReportTime) {
        this.writeLock.lock();
        try {
            this.lastHealthReportTime = lastHealthReportTime;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLastHealthReportTime() {
        this.readLock.lock();
        try {
            long l = this.lastHealthReportTime;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NodeState getState() {
        this.readLock.lock();
        try {
            NodeState nodeState = (NodeState)this.stateMachine.getCurrentState();
            return nodeState;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ApplicationId> getAppsToCleanup() {
        this.readLock.lock();
        try {
            ArrayList<ApplicationId> arrayList = new ArrayList<ApplicationId>(this.finishedApplications);
            return arrayList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ContainerId> getContainersToCleanUp() {
        this.readLock.lock();
        try {
            ArrayList<ContainerId> arrayList = new ArrayList<ContainerId>(this.containersToClean);
            return arrayList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateNodeHeartbeatResponseForCleanup(NodeHeartbeatResponse response) {
        this.writeLock.lock();
        try {
            response.addAllContainersToCleanup(new ArrayList<ContainerId>(this.containersToClean));
            response.addAllApplicationsToCleanup(this.finishedApplications);
            this.containersToClean.clear();
            this.finishedApplications.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NodeHeartbeatResponse getLastNodeHeartBeatResponse() {
        this.readLock.lock();
        try {
            NodeHeartbeatResponse nodeHeartbeatResponse = this.latestNodeHeartBeatResponse;
            return nodeHeartbeatResponse;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(RMNodeEvent event) {
        LOG.debug((Object)("Processing " + event.getNodeId() + " of type " + event.getType()));
        try {
            this.writeLock.lock();
            NodeState oldState = this.getState();
            try {
                this.stateMachine.doTransition(event.getType(), (Object)event);
            }
            catch (InvalidStateTransitonException e) {
                LOG.error((Object)"Can't handle this event at current state", (Throwable)e);
                LOG.error((Object)("Invalid event " + event.getType() + " on Node  " + this.nodeId));
            }
            if (oldState != this.getState()) {
                LOG.info((Object)(this.nodeId + " Node Transitioned from " + oldState + " to " + this.getState()));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void updateMetricsForRejoinedNode(NodeState previousNodeState) {
        ClusterMetrics metrics = ClusterMetrics.getMetrics();
        metrics.incrNumActiveNodes();
        switch (previousNodeState) {
            case LOST: {
                metrics.decrNumLostNMs();
                break;
            }
            case REBOOTED: {
                metrics.decrNumRebootedNMs();
                break;
            }
            case DECOMMISSIONED: {
                metrics.decrDecommisionedNMs();
                break;
            }
            case UNHEALTHY: {
                metrics.decrNumUnhealthyNMs();
            }
        }
    }

    private void updateMetricsForDeactivatedNode(NodeState initialState, NodeState finalState) {
        ClusterMetrics metrics = ClusterMetrics.getMetrics();
        switch (initialState) {
            case RUNNING: {
                metrics.decrNumActiveNodes();
                break;
            }
            case UNHEALTHY: {
                metrics.decrNumUnhealthyNMs();
            }
        }
        switch (finalState) {
            case DECOMMISSIONED: {
                metrics.incrDecommisionedNMs();
                break;
            }
            case LOST: {
                metrics.incrNumLostNMs();
                break;
            }
            case REBOOTED: {
                metrics.incrNumRebootedNMs();
                break;
            }
            case UNHEALTHY: {
                metrics.incrNumUnhealthyNMs();
            }
        }
    }

    @Override
    public List<UpdatedContainerInfo> pullContainerUpdates() {
        ArrayList<UpdatedContainerInfo> latestContainerInfoList = new ArrayList<UpdatedContainerInfo>();
        while (this.nodeUpdateQueue.peek() != null) {
            latestContainerInfoList.add(this.nodeUpdateQueue.poll());
        }
        this.nextHeartBeat = true;
        return latestContainerInfoList;
    }

    @VisibleForTesting
    public void setNextHeartBeat(boolean nextHeartBeat) {
        this.nextHeartBeat = nextHeartBeat;
    }

    @VisibleForTesting
    public int getQueueSize() {
        return this.nodeUpdateQueue.size();
    }

    public static class StatusUpdateWhenUnHealthyTransition
    implements MultipleArcTransition<RMNodeImpl, RMNodeEvent, NodeState> {
        public NodeState transition(RMNodeImpl rmNode, RMNodeEvent event) {
            RMNodeStatusEvent statusEvent = (RMNodeStatusEvent)event;
            rmNode.latestNodeHeartBeatResponse = statusEvent.getLatestResponse();
            NodeHealthStatus remoteNodeHealthStatus = statusEvent.getNodeHealthStatus();
            rmNode.setHealthReport(remoteNodeHealthStatus.getHealthReport());
            rmNode.setLastHealthReportTime(remoteNodeHealthStatus.getLastHealthReportTime());
            if (remoteNodeHealthStatus.getIsNodeHealthy()) {
                rmNode.context.getDispatcher().getEventHandler().handle((Event)new NodeAddedSchedulerEvent(rmNode));
                rmNode.context.getDispatcher().getEventHandler().handle((Event)new NodesListManagerEvent(NodesListManagerEventType.NODE_USABLE, rmNode));
                rmNode.updateMetricsForRejoinedNode(NodeState.UNHEALTHY);
                return NodeState.RUNNING;
            }
            return NodeState.UNHEALTHY;
        }
    }

    public static class StatusUpdateWhenHealthyTransition
    implements MultipleArcTransition<RMNodeImpl, RMNodeEvent, NodeState> {
        public NodeState transition(RMNodeImpl rmNode, RMNodeEvent event) {
            RMNodeStatusEvent statusEvent = (RMNodeStatusEvent)event;
            rmNode.latestNodeHeartBeatResponse = statusEvent.getLatestResponse();
            NodeHealthStatus remoteNodeHealthStatus = statusEvent.getNodeHealthStatus();
            rmNode.setHealthReport(remoteNodeHealthStatus.getHealthReport());
            rmNode.setLastHealthReportTime(remoteNodeHealthStatus.getLastHealthReportTime());
            if (!remoteNodeHealthStatus.getIsNodeHealthy()) {
                LOG.info((Object)("Node " + rmNode.nodeId + " reported UNHEALTHY with details: " + remoteNodeHealthStatus.getHealthReport()));
                rmNode.nodeUpdateQueue.clear();
                rmNode.context.getDispatcher().getEventHandler().handle((Event)new NodeRemovedSchedulerEvent(rmNode));
                rmNode.context.getDispatcher().getEventHandler().handle((Event)new NodesListManagerEvent(NodesListManagerEventType.NODE_UNUSABLE, rmNode));
                rmNode.updateMetricsForDeactivatedNode(rmNode.getState(), NodeState.UNHEALTHY);
                return NodeState.UNHEALTHY;
            }
            ArrayList<ContainerStatus> newlyLaunchedContainers = new ArrayList<ContainerStatus>();
            ArrayList<ContainerStatus> completedContainers = new ArrayList<ContainerStatus>();
            for (ContainerStatus remoteContainer : statusEvent.getContainers()) {
                ContainerId containerId = remoteContainer.getContainerId();
                if (rmNode.containersToClean.contains(containerId)) {
                    LOG.info((Object)("Container " + containerId + " already scheduled for " + "cleanup, no further processing"));
                    continue;
                }
                if (rmNode.finishedApplications.contains(containerId.getApplicationAttemptId().getApplicationId())) {
                    LOG.info((Object)("Container " + containerId + " belongs to an application that is already killed," + " no further processing"));
                    continue;
                }
                if (remoteContainer.getState() == ContainerState.RUNNING) {
                    if (rmNode.justLaunchedContainers.containsKey(containerId)) continue;
                    rmNode.justLaunchedContainers.put(containerId, remoteContainer);
                    newlyLaunchedContainers.add(remoteContainer);
                    continue;
                }
                rmNode.justLaunchedContainers.remove(containerId);
                completedContainers.add(remoteContainer);
            }
            if (newlyLaunchedContainers.size() != 0 || completedContainers.size() != 0) {
                rmNode.nodeUpdateQueue.add(new UpdatedContainerInfo(newlyLaunchedContainers, completedContainers));
            }
            if (rmNode.nextHeartBeat) {
                rmNode.nextHeartBeat = false;
                rmNode.context.getDispatcher().getEventHandler().handle((Event)new NodeUpdateSchedulerEvent(rmNode));
            }
            if (UserGroupInformation.isSecurityEnabled()) {
                rmNode.context.getDelegationTokenRenewer().updateKeepAliveApplications(statusEvent.getKeepAliveAppIds());
            }
            return NodeState.RUNNING;
        }
    }

    public static class DeactivateNodeTransition
    implements SingleArcTransition<RMNodeImpl, RMNodeEvent> {
        private final NodeState finalState;

        public DeactivateNodeTransition(NodeState finalState) {
            this.finalState = finalState;
        }

        public void transition(RMNodeImpl rmNode, RMNodeEvent event) {
            rmNode.nodeUpdateQueue.clear();
            NodeState initialState = rmNode.getState();
            if (!initialState.equals((Object)NodeState.UNHEALTHY)) {
                rmNode.context.getDispatcher().getEventHandler().handle((Event)new NodeRemovedSchedulerEvent(rmNode));
            }
            rmNode.context.getDispatcher().getEventHandler().handle((Event)new NodesListManagerEvent(NodesListManagerEventType.NODE_UNUSABLE, rmNode));
            rmNode.context.getRMNodes().remove(rmNode.nodeId);
            LOG.info((Object)("Deactivating Node " + rmNode.nodeId + " as it is now " + this.finalState));
            rmNode.context.getInactiveRMNodes().put(rmNode.nodeId.getHost(), rmNode);
            rmNode.updateMetricsForDeactivatedNode(initialState, this.finalState);
        }
    }

    public static class CleanUpContainerTransition
    implements SingleArcTransition<RMNodeImpl, RMNodeEvent> {
        public void transition(RMNodeImpl rmNode, RMNodeEvent event) {
            rmNode.containersToClean.add(((RMNodeCleanContainerEvent)event).getContainerId());
        }
    }

    public static class CleanUpAppTransition
    implements SingleArcTransition<RMNodeImpl, RMNodeEvent> {
        public void transition(RMNodeImpl rmNode, RMNodeEvent event) {
            rmNode.finishedApplications.add(((RMNodeCleanAppEvent)event).getAppId());
        }
    }

    public static class ReconnectNodeTransition
    implements SingleArcTransition<RMNodeImpl, RMNodeEvent> {
        public void transition(RMNodeImpl rmNode, RMNodeEvent event) {
            rmNode.nodeUpdateQueue.clear();
            rmNode.context.getDispatcher().getEventHandler().handle((Event)new NodeRemovedSchedulerEvent(rmNode));
            RMNode newNode = ((RMNodeReconnectEvent)event).getReconnectedNode();
            if (rmNode.getTotalCapability().equals((Object)newNode.getTotalCapability()) && rmNode.getHttpPort() == newNode.getHttpPort()) {
                rmNode.getLastNodeHeartBeatResponse().setResponseId(0);
                if (rmNode.getState() != NodeState.UNHEALTHY) {
                    rmNode.context.getDispatcher().getEventHandler().handle((Event)new NodeAddedSchedulerEvent(rmNode));
                }
            } else {
                switch (rmNode.getState()) {
                    case RUNNING: {
                        ClusterMetrics.getMetrics().decrNumActiveNodes();
                        break;
                    }
                    case UNHEALTHY: {
                        ClusterMetrics.getMetrics().decrNumUnhealthyNMs();
                    }
                }
                rmNode.context.getRMNodes().put(newNode.getNodeID(), newNode);
                rmNode.context.getDispatcher().getEventHandler().handle((Event)new RMNodeEvent(newNode.getNodeID(), RMNodeEventType.STARTED));
            }
        }
    }

    public static class AddNodeTransition
    implements SingleArcTransition<RMNodeImpl, RMNodeEvent> {
        public void transition(RMNodeImpl rmNode, RMNodeEvent event) {
            rmNode.context.getDispatcher().getEventHandler().handle((Event)new NodeAddedSchedulerEvent(rmNode));
            String host = rmNode.nodeId.getHost();
            if (rmNode.context.getInactiveRMNodes().containsKey(host)) {
                RMNode previouRMNode = (RMNode)rmNode.context.getInactiveRMNodes().get(host);
                rmNode.context.getInactiveRMNodes().remove(host);
                rmNode.updateMetricsForRejoinedNode(previouRMNode.getState());
            } else {
                ClusterMetrics.getMetrics().incrNumActiveNodes();
            }
        }
    }
}

