/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.monitor;

import com.google.common.annotations.VisibleForTesting;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.SchedulingEditPolicy;

public class SchedulingMonitor
extends AbstractService {
    private final SchedulingEditPolicy scheduleEditPolicy;
    private static final Log LOG = LogFactory.getLog(SchedulingMonitor.class);
    private Thread checkerThread;
    private volatile boolean stopped;
    private long monitorInterval;

    public SchedulingMonitor(SchedulingEditPolicy scheduleEditPolicy) {
        super("SchedulingMonitor (" + scheduleEditPolicy.getPolicyName() + ")");
        this.scheduleEditPolicy = scheduleEditPolicy;
        this.monitorInterval = scheduleEditPolicy.getMonitoringInterval();
    }

    public long getMonitorInterval() {
        return this.monitorInterval;
    }

    public void serviceInit(Configuration conf) throws Exception {
        super.serviceInit(conf);
    }

    public void serviceStart() throws Exception {
        assert (!this.stopped) : "starting when already stopped";
        this.checkerThread = new Thread(new PreemptionChecker());
        this.checkerThread.setName(this.getName());
        this.checkerThread.start();
        super.serviceStart();
    }

    public void serviceStop() throws Exception {
        this.stopped = true;
        if (this.checkerThread != null) {
            this.checkerThread.interrupt();
        }
        super.serviceStop();
    }

    @VisibleForTesting
    public void invokePolicy() {
        this.scheduleEditPolicy.editSchedule();
    }

    private class PreemptionChecker
    implements Runnable {
        private PreemptionChecker() {
        }

        @Override
        public void run() {
            while (!SchedulingMonitor.this.stopped && !Thread.currentThread().isInterrupted()) {
                SchedulingMonitor.this.invokePolicy();
                try {
                    Thread.sleep(SchedulingMonitor.this.monitorInterval);
                }
                catch (InterruptedException e) {
                    LOG.info((Object)(SchedulingMonitor.this.getName() + " thread interrupted"));
                    break;
                }
            }
        }
    }
}

