/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.schema.comparators;

import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByteArrayComparator
implements Comparator<byte[]> {
    public static final Comparator<byte[]> INSTANCE = new ByteArrayComparator();

    @Override
    public int compare(byte[] b1, byte[] b2) {
        if (b1 == null) {
            return b2 == null ? 0 : -1;
        }
        if (b2 == null) {
            return 1;
        }
        if (b1.length == b2.length) {
            for (int ii = 0; ii < b1.length; ++ii) {
                if (b1[ii] > b2[ii]) {
                    return 1;
                }
                if (b1[ii] >= b2[ii]) continue;
                return -1;
            }
            return 0;
        }
        int minLength = Math.min(b1.length, b2.length);
        for (int ii = 0; ii < minLength; ++ii) {
            if (b1[ii] > b2[ii]) {
                return 1;
            }
            if (b1[ii] >= b2[ii]) continue;
            return -1;
        }
        if (b1.length == minLength) {
            return -1;
        }
        if (b2.length == minLength) {
            return 1;
        }
        return 0;
    }
}

