/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.search.controls.pagedSearch;

import java.nio.ByteBuffer;
import org.apache.directory.shared.asn1.AbstractAsn1Object;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.ldap.util.StringTools;

public class PagedSearchControlCodec
extends AbstractAsn1Object {
    private int size;
    private byte[] cookie;
    private int pscSeqLength;

    public int computeLength() {
        int sizeLength = 2 + Value.getNbBytes(this.size);
        int cookieLength = 0;
        cookieLength = this.cookie != null ? 1 + TLV.getNbBytes(this.cookie.length) + this.cookie.length : 2;
        this.pscSeqLength = sizeLength + cookieLength;
        return 1 + TLV.getNbBytes(this.pscSeqLength) + this.pscSeqLength;
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        ByteBuffer bb = ByteBuffer.allocate(this.computeLength());
        bb.put((byte)48);
        bb.put(TLV.getBytes(this.pscSeqLength));
        Value.encode(bb, this.size);
        Value.encode(bb, this.cookie);
        return bb;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    Paged Search Control\n");
        sb.append("        size   : '").append(this.size).append("'\n");
        sb.append("        cookie   : '").append(StringTools.dumpBytes(this.cookie)).append("'\n");
        return sb.toString();
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public byte[] getCookie() {
        return this.cookie;
    }

    public void setCookie(byte[] cookie) {
        this.cookie = cookie;
    }
}

