/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.schema;

import javax.naming.NamingException;
import org.apache.directory.server.schema.registries.AttributeTypeRegistry;
import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.entry.client.ClientStringValue;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.schema.Normalizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DnNormalizer
implements Normalizer {
    private static final long serialVersionUID = 1L;
    public static final DnNormalizer INSTANCE = new DnNormalizer();
    private AttributeTypeRegistry attrRegistry;

    public DnNormalizer(AttributeTypeRegistry attrRegistry) {
        this.attrRegistry = attrRegistry;
    }

    public DnNormalizer() {
    }

    public void setRegistries(Registries registries) {
        this.attrRegistry = registries.getAttributeTypeRegistry();
    }

    @Override
    public Value<?> normalize(Value<?> value) throws NamingException {
        LdapDN dn = null;
        String dnStr = value.getString();
        dn = new LdapDN(dnStr);
        dn.normalize(this.attrRegistry.getNormalizerMapping());
        return new ClientStringValue(dn.getNormName());
    }

    @Override
    public String normalize(String value) throws NamingException {
        LdapDN dn = null;
        dn = new LdapDN(value);
        dn.normalize(this.attrRegistry.getNormalizerMapping());
        return dn.getNormName();
    }

    public String normalize(LdapDN value) throws NamingException {
        LdapDN dn = null;
        dn = new LdapDN(value);
        dn.normalize(this.attrRegistry.getNormalizerMapping());
        return dn.getNormName();
    }
}

