/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.handlers;

import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.ldap.LdapSession;
import org.apache.directory.server.ldap.handlers.LdapRequestHandler;
import org.apache.directory.shared.ldap.message.InternalLdapResult;
import org.apache.directory.shared.ldap.message.InternalModifyRequest;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifyHandler
extends LdapRequestHandler<InternalModifyRequest> {
    private static final Logger LOG = LoggerFactory.getLogger(ModifyHandler.class);

    @Override
    public void handle(LdapSession session, InternalModifyRequest req) {
        LOG.debug("Handling request : {}", req);
        InternalLdapResult result = req.getResultResponse().getLdapResult();
        try {
            CoreSession coreSession = session.getCoreSession();
            coreSession.modify(req);
            result.setResultCode(ResultCodeEnum.SUCCESS);
            session.getIoSession().write(req.getResultResponse());
        }
        catch (Exception e) {
            this.handleException(session, req, e);
        }
    }
}

