/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.io.encoder;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.directory.server.kerberos.shared.messages.value.EncryptionTypeInfoEntry;
import org.apache.directory.shared.asn1.der.ASN1OutputStream;
import org.apache.directory.shared.asn1.der.DERInteger;
import org.apache.directory.shared.asn1.der.DEROctetString;
import org.apache.directory.shared.asn1.der.DERSequence;
import org.apache.directory.shared.asn1.der.DERTaggedObject;

public class EncryptionTypeInfoEncoder {
    public static byte[] encode(EncryptionTypeInfoEntry[] entries) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ASN1OutputStream aos = new ASN1OutputStream(baos);
        aos.writeObject(EncryptionTypeInfoEncoder.encodeSequence(entries));
        aos.close();
        return baos.toByteArray();
    }

    protected static DERSequence encodeSequence(EncryptionTypeInfoEntry[] entries) {
        DERSequence sequence = new DERSequence();
        for (int ii = 0; ii < entries.length; ++ii) {
            sequence.add(EncryptionTypeInfoEncoder.encode(entries[ii]));
        }
        return sequence;
    }

    protected static DERSequence encode(EncryptionTypeInfoEntry entry) {
        DERSequence sequence = new DERSequence();
        sequence.add(new DERTaggedObject(0, DERInteger.valueOf(entry.getEncryptionType().getOrdinal())));
        if (entry.getSalt() != null) {
            sequence.add(new DERTaggedObject(1, new DEROctetString(entry.getSalt())));
        }
        return sequence;
    }
}

