/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.schema;

import java.util.Set;
import javax.naming.NamingException;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.core.schema.AbstractSchemaChangeHandler;
import org.apache.directory.server.core.schema.PartitionSchemaLoader;
import org.apache.directory.server.core.schema.SchemaPartitionDao;
import org.apache.directory.server.schema.bootstrap.Schema;
import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.server.schema.registries.SyntaxRegistry;
import org.apache.directory.shared.ldap.exception.LdapInvalidNameException;
import org.apache.directory.shared.ldap.exception.LdapOperationNotSupportedException;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.name.Rdn;
import org.apache.directory.shared.ldap.schema.Syntax;

public class MetaSyntaxHandler
extends AbstractSchemaChangeHandler {
    private final SchemaPartitionDao dao;
    private final SyntaxRegistry syntaxRegistry;

    public MetaSyntaxHandler(Registries targetRegistries, PartitionSchemaLoader loader, SchemaPartitionDao dao) throws Exception {
        super(targetRegistries, loader);
        this.dao = dao;
        this.syntaxRegistry = targetRegistries.getSyntaxRegistry();
    }

    protected boolean modify(LdapDN name, ServerEntry entry, ServerEntry targetEntry, boolean cascade) throws Exception {
        String oid = this.getOid(entry);
        Schema schema = this.getSchema(name);
        Syntax syntax = this.factory.getSyntax(targetEntry, this.targetRegistries, schema.getSchemaName());
        if (!schema.isDisabled()) {
            this.syntaxRegistry.unregister(oid);
            this.syntaxRegistry.register(syntax);
            return true;
        }
        return false;
    }

    public void add(LdapDN name, ServerEntry entry) throws Exception {
        LdapDN parentDn = (LdapDN)name.clone();
        parentDn.remove(parentDn.size() - 1);
        this.checkNewParent(parentDn);
        this.checkOidIsUnique(entry);
        String schemaName = this.getSchemaName(name);
        Syntax syntax = this.factory.getSyntax(entry, this.targetRegistries, schemaName);
        this.add(syntax);
    }

    public void delete(LdapDN name, ServerEntry entry, boolean cascade) throws Exception {
        String oid = this.getOid(entry);
        Set<ServerEntry> dependees = this.dao.listSyntaxDependents(oid);
        if (dependees != null && dependees.size() > 0) {
            throw new LdapOperationNotSupportedException("The syntax with OID " + oid + " cannot be deleted until all entities" + " using this syntax have also been deleted.  The following dependees exist: " + this.getOids(dependees), ResultCodeEnum.UNWILLING_TO_PERFORM);
        }
        String schemaName = this.getSchemaName(name);
        Syntax syntax = this.factory.getSyntax(entry, this.targetRegistries, schemaName);
        this.delete(syntax, cascade);
    }

    public void delete(Syntax syntax, boolean cascade) throws Exception {
        Schema schema = this.loader.getSchema(syntax.getSchema());
        if (!schema.isDisabled()) {
            this.syntaxRegistry.unregister(syntax.getOid());
        }
        this.unregisterOids(syntax.getOid());
    }

    public void rename(LdapDN name, ServerEntry entry, Rdn newRdn, boolean cascade) throws Exception {
        String oldOid = this.getOid(entry);
        Set<ServerEntry> dependees = this.dao.listSyntaxDependents(oldOid);
        if (dependees != null && dependees.size() > 0) {
            throw new LdapOperationNotSupportedException("The syntax with OID " + oldOid + " cannot be deleted until all entities" + " using this syntax have also been deleted.  The following dependees exist: " + this.getOids(dependees), ResultCodeEnum.UNWILLING_TO_PERFORM);
        }
        Schema schema = this.getSchema(name);
        ServerEntry targetEntry = (ServerEntry)entry.clone();
        String newOid = (String)newRdn.getValue();
        this.checkOidIsUnique(newOid);
        targetEntry.put("m-oid", newOid);
        Syntax syntax = this.factory.getSyntax(targetEntry, this.targetRegistries, schema.getSchemaName());
        if (!schema.isDisabled()) {
            this.syntaxRegistry.unregister(oldOid);
            this.syntaxRegistry.register(syntax);
        } else {
            this.registerOids(syntax);
        }
        this.unregisterOids(oldOid);
    }

    public void move(LdapDN oriChildName, LdapDN newParentName, Rdn newRn, boolean deleteOldRn, ServerEntry entry, boolean cascade) throws Exception {
        this.checkNewParent(newParentName);
        String oldOid = this.getOid(entry);
        Set<ServerEntry> dependees = this.dao.listSyntaxDependents(oldOid);
        if (dependees != null && dependees.size() > 0) {
            throw new LdapOperationNotSupportedException("The syntax with OID " + oldOid + " cannot be deleted until all entities" + " using this syntax have also been deleted.  The following dependees exist: " + this.getOids(dependees), ResultCodeEnum.UNWILLING_TO_PERFORM);
        }
        Schema oldSchema = this.getSchema(oriChildName);
        Schema newSchema = this.getSchema(newParentName);
        ServerEntry targetEntry = (ServerEntry)entry.clone();
        String newOid = (String)newRn.getValue();
        this.checkOidIsUnique(newOid);
        targetEntry.put("m-oid", newOid);
        Syntax syntax = this.factory.getSyntax(targetEntry, this.targetRegistries, newSchema.getSchemaName());
        if (!oldSchema.isDisabled()) {
            this.syntaxRegistry.unregister(oldOid);
        }
        this.unregisterOids(oldOid);
        if (!newSchema.isDisabled()) {
            this.syntaxRegistry.register(syntax);
        } else {
            this.registerOids(syntax);
        }
    }

    public void replace(LdapDN oriChildName, LdapDN newParentName, ServerEntry entry, boolean cascade) throws Exception {
        this.checkNewParent(newParentName);
        String oid = this.getOid(entry);
        Set<ServerEntry> dependees = this.dao.listSyntaxDependents(oid);
        if (dependees != null && dependees.size() > 0) {
            throw new LdapOperationNotSupportedException("The syntax with OID " + oid + " cannot be deleted until all entities" + " using this syntax have also been deleted.  The following dependees exist: " + this.getOids(dependees), ResultCodeEnum.UNWILLING_TO_PERFORM);
        }
        Schema oldSchema = this.getSchema(oriChildName);
        Schema newSchema = this.getSchema(newParentName);
        Syntax syntax = this.factory.getSyntax(entry, this.targetRegistries, newSchema.getSchemaName());
        if (!oldSchema.isDisabled()) {
            this.syntaxRegistry.unregister(oid);
        }
        if (!newSchema.isDisabled()) {
            this.syntaxRegistry.register(syntax);
        }
    }

    private void checkNewParent(LdapDN newParent) throws NamingException {
        if (newParent.size() != 3) {
            throw new LdapInvalidNameException("The parent dn of a syntax should be at most 3 name components in length.", ResultCodeEnum.NAMING_VIOLATION);
        }
        Rdn rdn = newParent.getRdn();
        if (!this.targetRegistries.getOidRegistry().getOid(rdn.getNormType()).equals("2.5.4.11")) {
            throw new LdapInvalidNameException("The parent entry of a syntax should be an organizationalUnit.", ResultCodeEnum.NAMING_VIOLATION);
        }
        if (!((String)rdn.getValue()).equalsIgnoreCase("syntaxes")) {
            throw new LdapInvalidNameException("The parent entry of a syntax should have a relative name of ou=syntaxes.", ResultCodeEnum.NAMING_VIOLATION);
        }
    }

    public void add(Syntax syntax) throws Exception {
        Schema schema = this.loader.getSchema(syntax.getSchema());
        if (!schema.isDisabled()) {
            this.syntaxRegistry.register(syntax);
        } else {
            this.registerOids(syntax);
        }
    }
}

