/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.schema;

import java.util.Set;
import javax.naming.NamingException;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.core.schema.AbstractSchemaChangeHandler;
import org.apache.directory.server.core.schema.PartitionSchemaLoader;
import org.apache.directory.server.core.schema.SchemaPartitionDao;
import org.apache.directory.server.schema.bootstrap.Schema;
import org.apache.directory.server.schema.registries.AttributeTypeRegistry;
import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.shared.ldap.exception.LdapInvalidNameException;
import org.apache.directory.shared.ldap.exception.LdapOperationNotSupportedException;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.name.Rdn;
import org.apache.directory.shared.ldap.schema.AttributeType;

public class MetaAttributeTypeHandler
extends AbstractSchemaChangeHandler {
    private final SchemaPartitionDao dao;
    private final AttributeTypeRegistry attributeTypeRegistry;

    public MetaAttributeTypeHandler(Registries targetRegistries, PartitionSchemaLoader loader, SchemaPartitionDao dao) throws Exception {
        super(targetRegistries, loader);
        this.dao = dao;
        this.attributeTypeRegistry = targetRegistries.getAttributeTypeRegistry();
    }

    protected boolean modify(LdapDN name, ServerEntry entry, ServerEntry targetEntry, boolean cascade) throws Exception {
        String oid = this.getOid(entry);
        Schema schema = this.getSchema(name);
        AttributeType at = this.factory.getAttributeType(targetEntry, this.targetRegistries, schema.getSchemaName());
        if (!schema.isDisabled()) {
            this.attributeTypeRegistry.unregister(oid);
            this.attributeTypeRegistry.register(at);
            return true;
        }
        return false;
    }

    public void add(AttributeType at) throws Exception {
        Schema schema = this.dao.getSchema(at.getSchema());
        if (!schema.isDisabled()) {
            this.attributeTypeRegistry.register(at);
        } else {
            this.registerOids(at);
        }
    }

    public void add(LdapDN name, ServerEntry entry) throws Exception {
        LdapDN parentDn = (LdapDN)name.clone();
        parentDn.remove(parentDn.size() - 1);
        this.checkNewParent(parentDn);
        this.checkOidIsUnique(entry);
        Schema schema = this.getSchema(name);
        AttributeType at = this.factory.getAttributeType(entry, this.targetRegistries, schema.getSchemaName());
        this.add(at);
    }

    public void delete(LdapDN name, ServerEntry entry, boolean cascade) throws Exception {
        String schemaName = this.getSchemaName(name);
        AttributeType at = this.factory.getAttributeType(entry, this.targetRegistries, schemaName);
        Set<ServerEntry> dependees = this.dao.listAttributeTypeDependents(at);
        if (dependees != null && dependees.size() > 0) {
            throw new LdapOperationNotSupportedException("The attributeType with OID " + at.getOid() + " cannot be deleted until all entities" + " using this attributeType have also been deleted.  The following dependees exist: " + this.getOids(dependees), ResultCodeEnum.UNWILLING_TO_PERFORM);
        }
        this.delete(at, cascade);
    }

    public void delete(AttributeType at, boolean cascade) throws Exception {
        Schema schema = this.loader.getSchema(at.getSchema());
        if (!schema.isDisabled()) {
            this.attributeTypeRegistry.unregister(at.getOid());
        }
        this.unregisterOids(at.getOid());
    }

    public void rename(LdapDN name, ServerEntry entry, Rdn newRdn, boolean cascade) throws Exception {
        Schema schema = this.getSchema(name);
        AttributeType oldAt = this.factory.getAttributeType(entry, this.targetRegistries, schema.getSchemaName());
        Set<ServerEntry> dependees = this.dao.listAttributeTypeDependents(oldAt);
        if (dependees != null && dependees.size() > 0) {
            throw new LdapOperationNotSupportedException("The attributeType with OID " + oldAt.getOid() + " cannot be deleted until all entities" + " using this attributeType have also been deleted.  The following dependees exist: " + this.getOids(dependees), ResultCodeEnum.UNWILLING_TO_PERFORM);
        }
        ServerEntry targetEntry = (ServerEntry)entry.clone();
        String newOid = (String)newRdn.getValue();
        this.checkOidIsUnique(newOid);
        targetEntry.put("m-oid", newOid);
        AttributeType at = this.factory.getAttributeType(targetEntry, this.targetRegistries, schema.getSchemaName());
        if (!schema.isDisabled()) {
            this.attributeTypeRegistry.unregister(oldAt.getOid());
            this.attributeTypeRegistry.register(at);
        } else {
            this.registerOids(at);
        }
        this.unregisterOids(oldAt.getOid());
    }

    public void move(LdapDN oriChildName, LdapDN newParentName, Rdn newRn, boolean deleteOldRn, ServerEntry entry, boolean cascade) throws Exception {
        this.checkNewParent(newParentName);
        Schema oldSchema = this.getSchema(oriChildName);
        AttributeType oldAt = this.factory.getAttributeType(entry, this.targetRegistries, oldSchema.getSchemaName());
        Set<ServerEntry> dependees = this.dao.listAttributeTypeDependents(oldAt);
        if (dependees != null && dependees.size() > 0) {
            throw new LdapOperationNotSupportedException("The attributeType with OID " + oldAt.getOid() + " cannot be deleted until all entities" + " using this attributeType have also been deleted.  The following dependees exist: " + this.getOids(dependees), ResultCodeEnum.UNWILLING_TO_PERFORM);
        }
        Schema newSchema = this.getSchema(newParentName);
        ServerEntry targetEntry = (ServerEntry)entry.clone();
        String newOid = (String)newRn.getValue();
        targetEntry.put("m-oid", newOid);
        this.checkOidIsUnique(newOid);
        AttributeType at = this.factory.getAttributeType(targetEntry, this.targetRegistries, newSchema.getSchemaName());
        if (!oldSchema.isDisabled()) {
            this.attributeTypeRegistry.unregister(oldAt.getOid());
        }
        this.unregisterOids(oldAt.getOid());
        if (!newSchema.isDisabled()) {
            this.attributeTypeRegistry.register(at);
        } else {
            this.registerOids(at);
        }
    }

    public void replace(LdapDN oriChildName, LdapDN newParentName, ServerEntry entry, boolean cascade) throws Exception {
        this.checkNewParent(newParentName);
        Schema oldSchema = this.getSchema(oriChildName);
        AttributeType oldAt = this.factory.getAttributeType(entry, this.targetRegistries, oldSchema.getSchemaName());
        Set<ServerEntry> dependees = this.dao.listAttributeTypeDependents(oldAt);
        if (dependees != null && dependees.size() > 0) {
            throw new LdapOperationNotSupportedException("The attributeType with OID " + oldAt.getOid() + " cannot be deleted until all entities" + " using this attributeType have also been deleted.  The following dependees exist: " + this.getOids(dependees), ResultCodeEnum.UNWILLING_TO_PERFORM);
        }
        Schema newSchema = this.getSchema(newParentName);
        AttributeType at = this.factory.getAttributeType(entry, this.targetRegistries, newSchema.getSchemaName());
        if (!oldSchema.isDisabled()) {
            this.attributeTypeRegistry.unregister(oldAt.getOid());
        }
        if (!newSchema.isDisabled()) {
            this.attributeTypeRegistry.register(at);
        }
    }

    private void checkNewParent(LdapDN newParent) throws NamingException {
        if (newParent.size() != 3) {
            throw new LdapInvalidNameException("The parent dn of a attributeType should be at most 3 name components in length.", ResultCodeEnum.NAMING_VIOLATION);
        }
        Rdn rdn = newParent.getRdn();
        if (!this.targetRegistries.getOidRegistry().getOid(rdn.getNormType()).equals("2.5.4.11")) {
            throw new LdapInvalidNameException("The parent entry of a attributeType should be an organizationalUnit.", ResultCodeEnum.NAMING_VIOLATION);
        }
        if (!((String)rdn.getValue()).equalsIgnoreCase("attributeTypes")) {
            throw new LdapInvalidNameException("The parent entry of a attributeType should have a relative name of ou=attributeTypes.", ResultCodeEnum.NAMING_VIOLATION);
        }
    }
}

