/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.ldap.client.api.message;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.directory.ldap.client.api.message.AbandonableRequest;
import org.apache.directory.ldap.client.api.message.AbstractRequest;
import org.apache.directory.ldap.client.api.message.RequestWithResponse;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Modification;
import org.apache.directory.shared.ldap.entry.ModificationOperation;
import org.apache.directory.shared.ldap.entry.client.ClientModification;
import org.apache.directory.shared.ldap.entry.client.DefaultClientAttribute;
import org.apache.directory.shared.ldap.name.DN;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifyRequest
extends AbstractRequest
implements RequestWithResponse,
AbandonableRequest {
    private DN dn;
    private List<Modification> mods = new ArrayList<Modification>();

    public ModifyRequest(DN dn) {
        this.dn = dn;
    }

    public void add(String attributeName, String ... attributeValue) {
        this.addModification(ModificationOperation.ADD_ATTRIBUTE, attributeName, attributeValue);
    }

    public void add(String attributeName, byte[] ... attributeValue) {
        this.addModification(ModificationOperation.ADD_ATTRIBUTE, attributeName, attributeValue);
    }

    public void add(EntryAttribute attr) {
        this.addModification(attr, ModificationOperation.ADD_ATTRIBUTE);
    }

    public void replace(String attributeName, String ... attributeValue) {
        this.addModification(ModificationOperation.REPLACE_ATTRIBUTE, attributeName, attributeValue);
    }

    public void replace(String attributeName, byte[] ... attributeValue) {
        this.addModification(ModificationOperation.REPLACE_ATTRIBUTE, attributeName, attributeValue);
    }

    public void replace(EntryAttribute attr) {
        this.addModification(attr, ModificationOperation.REPLACE_ATTRIBUTE);
    }

    public void remove(String attributeName, String ... attributeValue) {
        this.addModification(ModificationOperation.REMOVE_ATTRIBUTE, attributeName, attributeValue);
    }

    public void remove(String attributeName, byte[] ... attributeValue) {
        this.addModification(ModificationOperation.REMOVE_ATTRIBUTE, attributeName, attributeValue);
    }

    public void remove(EntryAttribute attr) {
        this.addModification(attr, ModificationOperation.REMOVE_ATTRIBUTE);
    }

    private void addModification(ModificationOperation modOp, String attributeName, String ... attributeValue) {
        DefaultClientAttribute attr = new DefaultClientAttribute(attributeName, attributeValue);
        this.addModification((EntryAttribute)attr, modOp);
    }

    private void addModification(ModificationOperation modOp, String attributeName, byte[] ... attributeValue) {
        DefaultClientAttribute attr = new DefaultClientAttribute(attributeName, attributeValue);
        this.addModification((EntryAttribute)attr, modOp);
    }

    public void addModification(EntryAttribute attr, ModificationOperation modOp) {
        this.mods.add((Modification)new ClientModification(modOp, attr));
    }

    public void addModification(Modification ... modifications) {
        this.mods.addAll(Arrays.asList(modifications));
    }

    public DN getDn() {
        return this.dn;
    }

    public List<Modification> getMods() {
        return this.mods;
    }
}

